/*
 * Decompiled with CFR 0.152.
 */
package hfalk.db;

import hfalk.db.DBHotSpotItem;
import hfalk.util.Utility;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Vector;

public class DBHotSpotGroup
extends Observable
implements Observer {
    protected String id = "HotSpotGroup";
    protected String version = "1.0";
    protected String name;
    protected String description;
    protected Vector hotSpotItemList = new Vector();
    protected String fileName;
    protected String fileDescription;

    public DBHotSpotGroup() {
        this.setChanged();
        this.notifyObservers("DBHotSpotGroup");
    }

    public String fileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        if (this.fileName == null) {
            this.fileName = new String();
        }
        if (!this.fileName.equals(string)) {
            this.fileName = string;
        }
        this.setChanged();
        this.notifyObservers(this.fileName);
    }

    public String fileDescription() {
        return this.fileDescription;
    }

    public void setFileDescription(String string) {
        if (this.fileDescription == null) {
            this.fileDescription = new String();
        }
        if (!this.fileDescription.equals(string)) {
            this.fileDescription = string;
        }
        this.setChanged();
        this.notifyObservers(this.fileDescription);
    }

    public void add(DBHotSpotItem dBHotSpotItem) {
        dBHotSpotItem.addObserver(this);
        this.hotSpotItemList.addElement(dBHotSpotItem);
        this.setChanged();
        this.notifyObservers(dBHotSpotItem);
    }

    public void remove(String string) {
        int n = 0;
        while (n < this.hotSpotItemList.size()) {
            DBHotSpotItem dBHotSpotItem = (DBHotSpotItem)this.hotSpotItemList.elementAt(n);
            if (dBHotSpotItem.name().equals(string)) {
                ((DBHotSpotItem)this.hotSpotItemList.elementAt(n)).deleteObserver(this);
                this.hotSpotItemList.removeElementAt(n);
            }
            ++n;
        }
        this.setChanged();
        this.notifyObservers();
    }

    public synchronized void removeAllElements() {
        int n = 0;
        while (n < this.hotSpotItemList.size()) {
            ((DBHotSpotItem)this.hotSpotItemList.elementAt(n)).deleteObserver(this);
            this.hotSpotItemList.removeElementAt(n);
            ++n;
        }
        this.setChanged();
        this.notifyObservers();
    }

    public int size() {
        return this.hotSpotItemList.size();
    }

    public Vector items() {
        return this.hotSpotItemList;
    }

    public DBHotSpotItem itemAt(int n) {
        return (DBHotSpotItem)this.hotSpotItemList.elementAt(n);
    }

    public DBHotSpotItem item(String string) {
        int n = 0;
        while (n < this.hotSpotItemList.size()) {
            DBHotSpotItem dBHotSpotItem = (DBHotSpotItem)this.hotSpotItemList.elementAt(n);
            if (dBHotSpotItem.name().equals(string)) {
                return (DBHotSpotItem)this.hotSpotItemList.elementAt(n);
            }
            ++n;
        }
        return null;
    }

    public String name() {
        return this.name;
    }

    public void setName(String string) {
        if (this.name == null) {
            this.name = new String();
        }
        if (!this.name.equals(string)) {
            this.name = string;
        }
        this.setChanged();
        this.notifyObservers(this.name);
    }

    public String description() {
        return this.description;
    }

    public void setDescription(String string) {
        if (this.description == null) {
            this.description = new String();
        }
        if (!this.description.equals(string)) {
            this.description = string;
        }
        this.setChanged();
        this.notifyObservers(this.description);
    }

    public int load() {
        int n;
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(String.valueOf(this.fileName.substring(0, this.fileName.length() - 4)) + ".DBHotSpotGroup");
            properties.load(fileInputStream);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("FileNotFoundException: Could Not Find File!");
            return 1;
        }
        catch (IOException iOException) {
            System.out.println("IOException: Could Not Load!");
            return 2;
        }
        this.id = properties.getProperty("HotSpotGroup.Id");
        if (!this.id.equals("HotSpotGroup")) {
            return 3;
        }
        this.version = properties.getProperty("HotSpotGroup.Version");
        if (!this.version.equals("1.0")) {
            return 4;
        }
        this.name = new String(properties.getProperty("HotSpotGroup.Name"));
        this.description = new String(properties.getProperty("HotSpotGroup.Description"));
        try {
            n = Integer.parseInt(properties.getProperty("HotSpotGroup.HotSpotItem.Count"));
        }
        catch (NumberFormatException numberFormatException) {
            return 5;
        }
        int n2 = 0;
        while (n2 < n) {
            int n3;
            String string = "HotSpotGroup.HotSpotItem.Name." + String.valueOf(n2 + 1);
            String string2 = new String(properties.getProperty(string));
            string = "HotSpotGroup.HotSpotItem.Type." + String.valueOf(n2 + 1);
            String string3 = new String(properties.getProperty(string));
            string = "HotSpotGroup.HotSpotItem.Patch." + String.valueOf(n2 + 1);
            try {
                n3 = Integer.parseInt(properties.getProperty(string));
            }
            catch (NumberFormatException numberFormatException) {
                n3 = 0;
            }
            string = "HotSpotGroup.HotSpotItem.Description." + String.valueOf(n2 + 1);
            String string4 = new String(properties.getProperty(string));
            string = "HotSpotGroup.HotSpotItem.Visible." + String.valueOf(n2 + 1);
            boolean bl = properties.getProperty(string).equals("true");
            string = "HotSpotGroup.HotSpotItem.Value." + String.valueOf(n2 + 1);
            int[] nArray = Utility.stringToIntArray(properties.getProperty(string));
            DBHotSpotItem dBHotSpotItem = new DBHotSpotItem(string3, n3, string2, nArray, string4, bl);
            this.add(dBHotSpotItem);
            ++n2;
        }
        this.setChanged();
        this.notifyObservers("Load");
        return 0;
    }

    public boolean save() {
        Properties properties = new Properties();
        ((Hashtable)properties).put("HotSpotGroup.Id", "HotSpotGroup");
        ((Hashtable)properties).put("HotSpotGroup.Version", "1.0");
        if (this.name == null || this.description == null || this.hotSpotItemList == null) {
            return false;
        }
        ((Hashtable)properties).put("HotSpotGroup.Name", this.name);
        ((Hashtable)properties).put("HotSpotGroup.Description", this.description);
        if (this.hotSpotItemList.size() != 0) {
            ((Hashtable)properties).put("HotSpotGroup.HotSpotItem.Count", String.valueOf(this.hotSpotItemList.size()));
            int n = 0;
            while (n < this.hotSpotItemList.size()) {
                DBHotSpotItem dBHotSpotItem = (DBHotSpotItem)this.hotSpotItemList.elementAt(n);
                String string = "HotSpotGroup.HotSpotItem.Name." + String.valueOf(n + 1);
                ((Hashtable)properties).put(string, dBHotSpotItem.name());
                string = "HotSpotGroup.HotSpotItem.Type." + String.valueOf(n + 1);
                ((Hashtable)properties).put(string, dBHotSpotItem.type());
                string = "HotSpotGroup.HotSpotItem.Patch." + String.valueOf(n + 1);
                ((Hashtable)properties).put(string, String.valueOf(dBHotSpotItem.patch()));
                string = "HotSpotGroup.HotSpotItem.Description." + String.valueOf(n + 1);
                ((Hashtable)properties).put(string, dBHotSpotItem.description());
                string = "HotSpotGroup.HotSpotItem.Visible." + String.valueOf(n + 1);
                if (dBHotSpotItem.isVisible()) {
                    ((Hashtable)properties).put(string, "true");
                } else {
                    ((Hashtable)properties).put(string, "false");
                }
                string = "HotSpotGroup.HotSpotItem.Value." + String.valueOf(n + 1);
                ((Hashtable)properties).put(string, Utility.intArrayToString(dBHotSpotItem.value()));
                ++n;
            }
        } else {
            ((Hashtable)properties).put("HotSpotGroup.HotSpotItem.Count", String.valueOf(0));
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(String.valueOf(this.fileName.substring(0, this.fileName.length() - 4)) + ".DBHotSpotGroup");
            properties.save(fileOutputStream, this.fileDescription);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("IOException: Could not Save!");
        }
        return true;
    }

    public DBHotSpotItem select(int n, int n2) {
        Enumeration enumeration = this.items().elements();
        while (enumeration.hasMoreElements()) {
            DBHotSpotItem dBHotSpotItem = (DBHotSpotItem)enumeration.nextElement();
            if (!dBHotSpotItem.isOnBorder(n, n2)) continue;
            return dBHotSpotItem;
        }
        return null;
    }

    public DBHotSpotItem getSelected() {
        Enumeration enumeration = this.items().elements();
        while (enumeration.hasMoreElements()) {
            DBHotSpotItem dBHotSpotItem = (DBHotSpotItem)enumeration.nextElement();
            if (!dBHotSpotItem.isSelected()) continue;
            return dBHotSpotItem;
        }
        return null;
    }

    public boolean doNameExist(String string) {
        Enumeration enumeration = this.items().elements();
        while (enumeration.hasMoreElements()) {
            DBHotSpotItem dBHotSpotItem = (DBHotSpotItem)enumeration.nextElement();
            if (!dBHotSpotItem.name().toUpperCase().equals(string.toUpperCase())) continue;
            return false;
        }
        return true;
    }

    public void update(Observable observable, Object object) {
        this.setChanged();
        this.notifyObservers("Item");
    }
}

