/*
 * Decompiled with CFR 0.152.
 */
package hfalk;

import com.sun.java.swing.JFrame;
import com.sun.java.swing.JMenu;
import com.sun.java.swing.JMenuBar;
import com.sun.java.swing.JMenuItem;
import com.sun.java.swing.JOptionPane;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JViewport;
import hfalk.db.DBHotEditManager;
import hfalk.db.DBHotSpotGroup;
import hfalk.db.DBHotSpotItem;
import hfalk.hotedit.JDeleteAreaToolAction;
import hfalk.hotedit.JEditHotSpot;
import hfalk.hotedit.JEditHotSpotInfoAction;
import hfalk.hotedit.JEditImageNameAction;
import hfalk.hotedit.JHotEditSettingsAction;
import hfalk.hotedit.JHotSpotCanvas;
import hfalk.hotedit.JImageInfoToolAction;
import hfalk.hotedit.JSaveHTMLAction;
import hfalk.hotedit.JShowHTMLAction;
import hfalk.hotedit.JShowHideAreaAction;
import hfalk.hotedit.JShowImageDescriptionAction;
import hfalk.hotedit.PrintReport00;
import hfalk.hotedit.PrintReport01;
import hfalk.hotedit.PrintReport02;
import hfalk.jfc.JProductInfoAction;
import hfalk.util.ImageFormat;
import hfalk.util.Service;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class JHotEdit
extends JFrame
implements ActionListener,
KeyListener {
    public JMenuBar mainMenu = new JMenuBar();
    private JMenu fileMenu;
    private JMenuItem openFile;
    private JMenuItem saveFile;
    private JMenuItem quitFile;
    private JMenuItem markTool;
    private JMenuItem markPOLYTool;
    private JMenuItem markRECTTool;
    private JMenuItem markCIRCLETool;
    private JMenuItem endmarkTool;
    private JMenuItem deleteAreaTool;
    private JMenuItem hotSpotInfoEdit;
    private JMenuItem nameEdit;
    private JMenuItem descriptionEdit;
    private JMenuItem settingsEdit;
    private JMenuItem settingsHTML;
    private JMenuItem generateHTML;
    private JMenuItem showHTML;
    private JMenuItem showhideAreaTool;
    private JMenuItem printImage;
    private JMenuItem printInformation;
    private JMenuItem printHotSpot;
    private JMenuItem imageInfoTool;
    private JMenuItem prodHelp;
    public Image img;
    public JHotSpotCanvas iCan;
    String helpId;
    public DBHotSpotItem currentItem;
    public DBHotSpotGroup hotSpotGroup;
    public JPanel n;
    JPanel s;
    public JScrollPane scrollPane;
    public JViewport vp;
    private ResourceBundle resource;

    public JHotEdit() {
        Locale locale;
        try {
            locale = new Locale(DBHotEditManager.instance().getLanguage(), DBHotEditManager.instance().getCountry());
            this.resource = ResourceBundle.getBundle("hfalk.JHotEditL", locale);
        }
        catch (MissingResourceException missingResourceException) {
            JOptionPane.showMessageDialog((Component)((Object)this), (Object)missingResourceException.getMessage(), (String)"INFORMATION_MESSAGE", (int)1);
            return;
        }
        ((Frame)((Object)this)).setTitle(String.valueOf(this.resource.getString("JHotEdit_Title")) + " " + this.resource.getString("JHotEdit_Version"));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().setBackground(Color.lightGray);
        locale = new JPanel((LayoutManager)new BorderLayout());
        this.scrollPane = new JScrollPane(20, 30);
        ((Container)((Object)locale)).add((Component)this.scrollPane, "Center");
        this.getContentPane().add("Center", (Component)((Object)locale));
        this.getContentPane().addKeyListener(this);
        this.iCan = null;
        this.img = null;
        this.hotSpotGroup = null;
        Dimension dimension = DBHotEditManager.instance().getWindowPositionDimension("HotEditManager");
        Point point = DBHotEditManager.instance().getWindowPositionLocation("HotEditManager");
        if (dimension.width == 0 && dimension.height == 0) {
            ((Component)((Object)this)).setSize(600, 400);
            this.move();
        } else {
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            if (dimension.width > dimension2.width || dimension.height > dimension2.height) {
                ((Component)((Object)this)).setSize(600, 400);
                this.move();
            } else {
                ((Component)((Object)this)).setLocation(point);
                ((Component)((Object)this)).setSize(dimension);
            }
        }
        DBHotEditManager.instance().state = 0;
        this.createMainMenu();
        this.refreshFileMenu();
        this.enableMenu();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        String string = actionEvent.getActionCommand();
        if (string.equals(this.resource.getString("JHotEdit_MenuFileOpen"))) {
            bl = this.openFileFunc(null);
        }
        if (string.equals(this.resource.getString("JHotEdit_MenuFileSave"))) {
            bl = this.saveFileFunc();
        }
        if (string.equals(this.resource.getString("JHotEdit_MenuFileQuit"))) {
            this.quitFileFunc();
        }
        if (string.equals(this.resource.getString("JHotEdit_MenuEditStartMarkPOLY"))) {
            bl = this.markToolFunc("POLY");
        }
        if (string.equals(this.resource.getString("JHotEdit_MenuEditStartMarkRECT"))) {
            bl = this.markToolFunc("RECT");
        }
        if (string.equals(this.resource.getString("JHotEdit_MenuEditStartMarkCIRCLE"))) {
            bl = this.markToolFunc("CIRCLE");
        }
        if (string.equals(this.resource.getString("JHotEdit_MenuEditEndMark"))) {
            bl = this.endmarkToolFunc();
        }
        if (string.equals("1")) {
            bl = this.openFileFunc(DBHotEditManager.instance().itemLastGroupAt(0));
        }
        if (string.equals("2")) {
            bl = this.openFileFunc(DBHotEditManager.instance().itemLastGroupAt(1));
        }
        if (string.equals("3")) {
            bl = this.openFileFunc(DBHotEditManager.instance().itemLastGroupAt(2));
        }
        if (string.equals("4")) {
            bl = this.openFileFunc(DBHotEditManager.instance().itemLastGroupAt(3));
        }
        if (string.equals("5")) {
            bl = this.openFileFunc(DBHotEditManager.instance().itemLastGroupAt(4));
        }
        this.enableMenu();
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        switch (windowEvent.getID()) {
            case 201: {
                this.quitFileFunc();
                return;
            }
        }
        super.processWindowEvent(windowEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 114: {
                this.quitFileFunc();
                return;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void move() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        if (((Component)((Object)this)).getSize().width > dimension.width) {
            ((Component)((Object)this)).setLocation(8, 8);
            return;
        }
        ((Component)((Object)this)).setLocation((dimension.width - ((Component)((Object)this)).getSize().width) / 2, (dimension.height - ((Component)((Object)this)).getSize().height) / 2);
    }

    private void createMainMenu() {
        this.fileMenu = new JMenu(this.resource.getString("JHotEdit_MenuFile"));
        this.openFile = new JMenuItem(this.resource.getString("JHotEdit_MenuFileOpen"));
        this.openFile.addActionListener((ActionListener)this);
        this.fileMenu.add(this.openFile);
        this.saveFile = new JMenuItem(this.resource.getString("JHotEdit_MenuFileSave"));
        this.saveFile.addActionListener((ActionListener)this);
        this.fileMenu.add(this.saveFile);
        this.fileMenu.addSeparator();
        this.quitFile = new JMenuItem(this.resource.getString("JHotEdit_MenuFileQuit"));
        this.quitFile.addActionListener((ActionListener)this);
        this.fileMenu.add(this.quitFile);
        this.mainMenu.add(this.fileMenu);
        JMenu jMenu = new JMenu(this.resource.getString("JHotEdit_MenuEdit"));
        JMenu jMenu2 = new JMenu(this.resource.getString("JHotEdit_MenuEditStartMark"));
        this.markPOLYTool = new JMenuItem(this.resource.getString("JHotEdit_MenuEditStartMarkPOLY"));
        this.markPOLYTool.addActionListener((ActionListener)this);
        jMenu2.add(this.markPOLYTool);
        this.markRECTTool = new JMenuItem(this.resource.getString("JHotEdit_MenuEditStartMarkRECT"));
        this.markRECTTool.addActionListener((ActionListener)this);
        jMenu2.add(this.markRECTTool);
        this.markCIRCLETool = new JMenuItem(this.resource.getString("JHotEdit_MenuEditStartMarkCIRCLE"));
        this.markCIRCLETool.addActionListener((ActionListener)this);
        jMenu2.add(this.markCIRCLETool);
        jMenu.add((JMenuItem)jMenu2);
        this.endmarkTool = new JMenuItem(this.resource.getString("JHotEdit_MenuEditEndMark"));
        this.endmarkTool.addActionListener((ActionListener)this);
        jMenu.add(this.endmarkTool);
        this.deleteAreaTool = new JMenuItem(this.resource.getString("JHotEdit_MenuEditAreaDelete"));
        JDeleteAreaToolAction jDeleteAreaToolAction = new JDeleteAreaToolAction(this);
        this.deleteAreaTool.addActionListener((ActionListener)((Object)jDeleteAreaToolAction));
        jMenu.add(this.deleteAreaTool);
        jMenu.addSeparator();
        this.hotSpotInfoEdit = new JMenuItem(this.resource.getString("JHotEdit_MenuEditHotSpotInfo"));
        JEditHotSpotInfoAction jEditHotSpotInfoAction = new JEditHotSpotInfoAction(this, false);
        this.hotSpotInfoEdit.addActionListener((ActionListener)((Object)jEditHotSpotInfoAction));
        jMenu.add(this.hotSpotInfoEdit);
        jMenu.addSeparator();
        this.nameEdit = new JMenuItem(this.resource.getString("JHotEdit_MenuEditImageName"));
        JEditImageNameAction jEditImageNameAction = new JEditImageNameAction(this);
        this.nameEdit.addActionListener((ActionListener)((Object)jEditImageNameAction));
        jMenu.add(this.nameEdit);
        this.descriptionEdit = new JMenuItem(this.resource.getString("JHotEdit_MenuEditImageDescription"));
        JShowImageDescriptionAction jShowImageDescriptionAction = new JShowImageDescriptionAction(this);
        this.descriptionEdit.addActionListener((ActionListener)((Object)jShowImageDescriptionAction));
        jMenu.add(this.descriptionEdit);
        jMenu.addSeparator();
        this.settingsEdit = new JMenuItem(this.resource.getString("JHotEdit_MenuEditSettings"));
        JHotEditSettingsAction jHotEditSettingsAction = new JHotEditSettingsAction(this);
        this.settingsEdit.addActionListener((ActionListener)((Object)jHotEditSettingsAction));
        jMenu.add(this.settingsEdit);
        this.mainMenu.add(jMenu);
        JMenu jMenu3 = new JMenu(this.resource.getString("JHotEdit_MenuTool"));
        JMenu jMenu4 = new JMenu(this.resource.getString("JHotEdit_MenuToolHTML"));
        jMenu3.add((JMenuItem)jMenu4);
        this.showHTML = new JMenuItem(this.resource.getString("JHotEdit_MenuToolHTMLShow"));
        JShowHTMLAction jShowHTMLAction = new JShowHTMLAction(this);
        this.showHTML.addActionListener((ActionListener)((Object)jShowHTMLAction));
        jMenu4.add(this.showHTML);
        this.generateHTML = new JMenuItem(this.resource.getString("JHotEdit_MenuToolHTMLGenerate"));
        JSaveHTMLAction jSaveHTMLAction = new JSaveHTMLAction(this);
        this.generateHTML.addActionListener((ActionListener)((Object)jSaveHTMLAction));
        jMenu4.add(this.generateHTML);
        jMenu3.addSeparator();
        this.showhideAreaTool = new JMenuItem(this.resource.getString("JHotEdit_MenuToolAreaHide"));
        JShowHideAreaAction jShowHideAreaAction = new JShowHideAreaAction(this);
        this.showhideAreaTool.addActionListener((ActionListener)((Object)jShowHideAreaAction));
        jMenu3.add(this.showhideAreaTool);
        jMenu3.addSeparator();
        JMenu jMenu5 = new JMenu(this.resource.getString("JHotEdit_MenuToolPrint"));
        jMenu3.add((JMenuItem)jMenu5);
        this.printImage = new JMenuItem(this.resource.getString("JHotEdit_MenuToolPrintImage"));
        PrintReport00 printReport00 = new PrintReport00(this);
        this.printImage.addActionListener((ActionListener)((Object)printReport00));
        jMenu5.add(this.printImage);
        this.printInformation = new JMenuItem(this.resource.getString("JHotEdit_MenuToolPrintInformation"));
        PrintReport01 printReport01 = new PrintReport01(this);
        this.printInformation.addActionListener((ActionListener)((Object)printReport01));
        jMenu5.add(this.printInformation);
        this.printHotSpot = new JMenuItem(this.resource.getString("JHotEdit_MenuToolPrintHotSpot"));
        PrintReport02 printReport02 = new PrintReport02(this);
        this.printHotSpot.addActionListener((ActionListener)((Object)printReport02));
        jMenu5.add(this.printHotSpot);
        jMenu3.addSeparator();
        this.imageInfoTool = new JMenuItem(this.resource.getString("JHotEdit_MenuToolImageInfo"));
        JImageInfoToolAction jImageInfoToolAction = new JImageInfoToolAction(this);
        this.imageInfoTool.addActionListener((ActionListener)((Object)jImageInfoToolAction));
        jMenu3.add(this.imageInfoTool);
        this.mainMenu.add(jMenu3);
        JMenu jMenu6 = new JMenu(this.resource.getString("JHotEdit_MenuHelp"));
        this.prodHelp = new JMenuItem(this.resource.getString("JHotEdit_MenuHelpProductInfo"));
        JProductInfoAction jProductInfoAction = new JProductInfoAction(this);
        jProductInfoAction.setTitle(DBHotEditManager.instance().common("Common_ProductInfoTitle"));
        jProductInfoAction.setText(this.resource.getString("JHotEdit_Title"), this.resource.getString("JHotEdit_SubTitle"));
        this.prodHelp.addActionListener((ActionListener)((Object)jProductInfoAction));
        jMenu6.add(this.prodHelp);
        this.mainMenu.add(jMenu6);
        this.setJMenuBar(this.mainMenu);
    }

    public boolean openFileFunc(String string) {
        String string2 = new String();
        if (string == null) {
            FileDialog fileDialog = new FileDialog((Frame)((Object)this), this.resource.getString("JHotEdit_OpenImageFile"), 0);
            fileDialog.setFile(String.valueOf(this.resource.getString("JHotEdit_Gif")) + Service.pathSeparator() + this.resource.getString("JHotEdit_Jpg"));
            fileDialog.show();
            String string3 = fileDialog.getFile();
            if (string3 == null) {
                return false;
            }
            string2 = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
            if (!new File(fileDialog.getDirectory(), fileDialog.getFile()).exists()) {
                JOptionPane.showMessageDialog((Component)((Object)this), (Object)DBHotEditManager.instance().common("Common_FileNotExist"), (String)this.resource.getString("JHotEdit_Title"), (int)1);
                return false;
            }
            ImageFormat imageFormat = new ImageFormat();
            if (!imageFormat.isGIF(string2) && !imageFormat.isJPG(string2)) {
                JOptionPane.showMessageDialog((Component)((Object)this), (Object)DBHotEditManager.instance().common("Common_NotValidFormat"), (String)this.resource.getString("JHotEdit_Title"), (int)1);
                return false;
            }
            this.img = Toolkit.getDefaultToolkit().getImage(string2);
            if (this.iCan != null) {
                this.scrollPane.getViewport().remove((Component)((Object)this.iCan));
            }
            this.iCan = null;
            this.iCan = new JHotSpotCanvas(this, this.img);
            this.vp = this.scrollPane.getViewport();
            this.vp.add((Component)((Object)this.iCan));
            this.vp.setBackingStoreEnabled(true);
            this.scrollPane.invalidate();
            this.scrollPane.validate();
            ((Container)((Object)this)).doLayout();
            if (this.hotSpotGroup != null) {
                this.hotSpotGroup.deleteObservers();
                this.hotSpotGroup.removeAllElements();
                this.hotSpotGroup = null;
            }
            this.hotSpotGroup = new DBHotSpotGroup();
            if (!new File(fileDialog.getDirectory(), String.valueOf(fileDialog.getFile().substring(0, string3.length() - 4)) + ".DBHotSpotGroup").exists()) {
                this.hotSpotGroup.setFileName(string2);
                this.hotSpotGroup.setFileDescription(this.resource.getString("JHotEdit_DBHotSpotGroup"));
                this.hotSpotGroup.setName(DBHotEditManager.instance().common("Common_StrUntitled"));
                this.hotSpotGroup.setDescription(DBHotEditManager.instance().common("Common_StrDefault"));
            } else {
                this.hotSpotGroup.setFileName(string2);
                this.hotSpotGroup.load();
                this.enableMenu();
                ((Component)((Object)this.iCan)).repaint();
            }
            ((Container)((Object)this)).doLayout();
        } else {
            string2 = string;
            if (string2.lastIndexOf(Service.fileSeparator()) == -1) {
                string2 = String.valueOf(Service.currentDirectory()) + Service.fileSeparator() + string2;
            }
            if (!new File(string2.substring(0, string2.lastIndexOf(Service.fileSeparator())), string2.substring(string2.lastIndexOf(Service.fileSeparator()) + 1, string2.length())).exists()) {
                JOptionPane.showMessageDialog((Component)((Object)this), (Object)DBHotEditManager.instance().common("Common_FileNotExist"), (String)this.resource.getString("JHotEdit_Title"), (int)1);
                return false;
            }
            ImageFormat imageFormat = new ImageFormat();
            if (!imageFormat.isGIF(string2) && !imageFormat.isJPG(string2)) {
                JOptionPane.showMessageDialog((Component)((Object)this), (Object)DBHotEditManager.instance().common("Common_NotValidFormat"), (String)this.resource.getString("JHotEdit_Title"), (int)1);
                return false;
            }
            this.img = Toolkit.getDefaultToolkit().getImage(string2);
            if (this.iCan != null) {
                this.scrollPane.getViewport().remove((Component)((Object)this.iCan));
                this.iCan = null;
            }
            this.iCan = new JHotSpotCanvas(this, this.img);
            this.vp = this.scrollPane.getViewport();
            this.vp.add((Component)((Object)this.iCan));
            this.vp.setBackingStoreEnabled(true);
            this.scrollPane.invalidate();
            this.scrollPane.validate();
            ((Container)((Object)this)).doLayout();
            if (this.hotSpotGroup != null) {
                this.hotSpotGroup.deleteObservers();
                this.hotSpotGroup.removeAllElements();
                this.hotSpotGroup = null;
            }
            this.hotSpotGroup = new DBHotSpotGroup();
            if (!new File(string2.substring(0, string2.lastIndexOf(Service.fileSeparator())), String.valueOf(string2.substring(string2.lastIndexOf(Service.fileSeparator()) + 1, string2.length() - 4)) + ".DBHotSpotGroup").exists()) {
                this.hotSpotGroup.setFileName(string2);
                this.hotSpotGroup.setFileDescription(this.resource.getString("JHotEdit_DBHotSpotGroup"));
                this.hotSpotGroup.setName(DBHotEditManager.instance().common("Common_StrUntitled"));
                this.hotSpotGroup.setDescription(DBHotEditManager.instance().common("Common_StrDefault"));
            } else {
                this.hotSpotGroup.setFileName(string2);
                this.hotSpotGroup.load();
                this.enableMenu();
                ((Component)((Object)this.iCan)).repaint();
            }
            ((Container)((Object)this)).doLayout();
        }
        DBHotEditManager.instance().addLastGroup(string2);
        this.refreshFileMenu();
        return true;
    }

    private boolean saveFileFunc() {
        this.hotSpotGroup.save();
        return true;
    }

    private boolean quitFileFunc() {
        Point point = ((Component)((Object)this)).getLocation();
        Dimension dimension = ((Component)((Object)this)).getSize();
        DBHotEditManager.instance().setWindowPosition("HotEditManager", point, dimension);
        ((Component)((Object)this)).setVisible(false);
        DBHotEditManager.instance().save();
        System.exit(0);
        return true;
    }

    public boolean markToolFunc(String string) {
        DBHotEditManager.instance().state = 16;
        this.currentItem = null;
        this.currentItem = new DBHotSpotItem();
        this.currentItem.setType(string);
        this.currentItem.setVisible(true);
        this.iCan.clearHotSpot();
        return true;
    }

    public boolean endmarkToolFunc() {
        DBHotEditManager.instance().state = 0;
        ((Frame)((Object)this)).setTitle(String.valueOf(this.resource.getString("JHotEdit_Title")) + " " + this.resource.getString("JHotEdit_Version"));
        if (this.currentItem.value() == null) {
            this.enableMenu();
            return false;
        }
        if (this.currentItem.type().equals("POLY") && this.currentItem.value().length < 6) {
            JOptionPane.showMessageDialog((Component)((Object)this), (Object)this.resource.getString("JHotEdit_ToFewPointsForHotspot"), (String)this.resource.getString("JHotEdit_Title"), (int)1);
            this.currentItem = null;
            this.iCan.clearHotSpot();
            this.enableMenu();
            ((Component)((Object)this.iCan)).repaint();
            return false;
        }
        if (this.currentItem.type().equals("RECT") && this.currentItem.value().length < 4) {
            JOptionPane.showMessageDialog((Component)((Object)this), (Object)this.resource.getString("JHotEdit_ToFewPointsForHotspot"), (String)this.resource.getString("JHotEdit_Title"), (int)1);
            this.currentItem = null;
            this.iCan.clearHotSpot();
            this.enableMenu();
            ((Component)((Object)this.iCan)).repaint();
            return false;
        }
        if (this.currentItem.type().equals("CIRCLE") && this.currentItem.value().length < 4) {
            JOptionPane.showMessageDialog((Component)((Object)this), (Object)this.resource.getString("JHotEdit_ToFewPointsForHotspot"), (String)this.resource.getString("JHotEdit_Title"), (int)1);
            this.currentItem = null;
            this.iCan.clearHotSpot();
            this.enableMenu();
            ((Component)((Object)this.iCan)).repaint();
            return false;
        }
        this.currentItem.setSelected(true);
        this.iCan.showHotSpot(this.currentItem);
        JEditHotSpot jEditHotSpot = new JEditHotSpot(this, this.resource.getString("JHotEdit_AddHotSpotTitle"), true, this.currentItem);
        jEditHotSpot.setVisible(true);
        ((Component)((Object)this.iCan)).repaint();
        this.enableMenu();
        return true;
    }

    public void enableMenu() {
        if (this.hotSpotGroup == null) {
            this.saveFile.setEnabled(false);
            this.hotSpotInfoEdit.setEnabled(false);
            this.markPOLYTool.setEnabled(false);
            this.markRECTTool.setEnabled(false);
            this.markCIRCLETool.setEnabled(false);
            this.endmarkTool.setEnabled(false);
            this.showhideAreaTool.setEnabled(false);
            this.nameEdit.setEnabled(false);
            this.descriptionEdit.setEnabled(false);
            this.deleteAreaTool.setEnabled(false);
            this.imageInfoTool.setEnabled(false);
            this.showHTML.setEnabled(false);
            this.generateHTML.setEnabled(false);
            this.printImage.setEnabled(false);
            this.printInformation.setEnabled(false);
            this.printHotSpot.setEnabled(false);
            return;
        }
        this.saveFile.setEnabled(true);
        this.markPOLYTool.setEnabled(true);
        this.markRECTTool.setEnabled(true);
        this.markCIRCLETool.setEnabled(true);
        this.endmarkTool.setEnabled(false);
        this.nameEdit.setEnabled(true);
        this.descriptionEdit.setEnabled(true);
        this.imageInfoTool.setEnabled(true);
        this.printImage.setEnabled(true);
        this.printInformation.setEnabled(true);
        this.printHotSpot.setEnabled(true);
        if (this.hotSpotGroup.size() > 0) {
            this.showHTML.setEnabled(true);
            this.generateHTML.setEnabled(true);
            this.showhideAreaTool.setEnabled(true);
            this.deleteAreaTool.setEnabled(true);
            this.hotSpotInfoEdit.setEnabled(true);
        } else {
            this.showHTML.setEnabled(false);
            this.generateHTML.setEnabled(false);
            this.showhideAreaTool.setEnabled(false);
            this.deleteAreaTool.setEnabled(false);
            this.hotSpotInfoEdit.setEnabled(false);
            this.printHotSpot.setEnabled(false);
        }
        if (DBHotEditManager.instance().state == 2) {
            this.markPOLYTool.setEnabled(false);
            this.markRECTTool.setEnabled(false);
            this.markCIRCLETool.setEnabled(false);
            this.endmarkTool.setEnabled(true);
            this.openFile.setEnabled(false);
            return;
        }
        this.markPOLYTool.setEnabled(true);
        this.markRECTTool.setEnabled(true);
        this.markCIRCLETool.setEnabled(true);
        this.endmarkTool.setEnabled(false);
        this.openFile.setEnabled(true);
    }

    public void refreshFileMenu() {
        int n = 4;
        if (DBHotEditManager.instance().sizeLastGroup() == 0) {
            return;
        }
        if (this.fileMenu.getItemCount() >= n) {
            this.fileMenu.removeAll();
            this.openFile = new JMenuItem(this.resource.getString("JHotEdit_MenuFileOpen"));
            this.openFile.addActionListener((ActionListener)this);
            this.fileMenu.add(this.openFile);
            this.saveFile = new JMenuItem(this.resource.getString("JHotEdit_MenuFileSave"));
            this.saveFile.addActionListener((ActionListener)this);
            this.fileMenu.add(this.saveFile);
            this.fileMenu.addSeparator();
            int n2 = 0;
            while (n2 < DBHotEditManager.instance().sizeLastGroup()) {
                JMenuItem jMenuItem = new JMenuItem(String.valueOf(String.valueOf(this.fileMenu.getItemCount() - n + 2)) + " " + DBHotEditManager.instance().itemLastGroupAt(n2));
                jMenuItem.setActionCommand(String.valueOf(this.fileMenu.getItemCount() - n + 2));
                jMenuItem.addActionListener((ActionListener)this);
                this.fileMenu.add(jMenuItem);
                ++n2;
            }
            this.fileMenu.addSeparator();
            this.quitFile = new JMenuItem(this.resource.getString("JHotEdit_MenuFileQuit"));
            this.quitFile.addActionListener((ActionListener)this);
            this.fileMenu.add(this.quitFile);
        }
        this.enableMenu();
    }
}

