/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.Canvas;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.net.URL;

class SplashImage
extends Canvas {
    private Image image;
    private boolean loaded;
    private Font emergencyFont;

    SplashImage(String string) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            URL uRL = ClassLoader.getSystemResource(string);
            this.image = toolkit.getImage(uRL);
            this.prepareImage(this.image, this);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0xC0) != 0) {
            SplashImage splashImage = this;
            synchronized (splashImage) {
                this.image = null;
                this.loaded = true;
                this.notify();
            }
            return false;
        }
        boolean bl = false;
        int n6 = 0;
        int n7 = 0;
        if ((n & 1) != 0) {
            n6 = n4;
            bl = true;
        }
        if ((n & 2) != 0) {
            n7 = n5;
            bl = true;
        }
        if (bl) {
            this.setSize(n6, n7);
        }
        if ((n & 0x20) != 0) {
            SplashImage splashImage = this;
            synchronized (splashImage) {
                this.loaded = true;
                Graphics graphics = this.getGraphics();
                try {
                    this.paint(graphics);
                    this.getToolkit().sync();
                    this.notify();
                }
                finally {
                    Object var14_13 = null;
                    graphics.dispose();
                }
            }
        }
        return true;
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        Container container = this.getParent();
        Insets insets = container.getInsets();
        container.setSize(n + insets.left + insets.right, n2 + insets.top + insets.bottom);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        if (this.image != null && this.loaded) {
            this.getSize();
            graphics.drawImage(this.image, 0, 0, null);
            return;
        }
        if (this.image == null && this.loaded) {
            if (this.emergencyFont == null) {
                this.emergencyFont = new Font("SansSerif", 1, 30);
            }
            graphics.setFont(this.emergencyFont);
            graphics.drawString("Launching Browser...", 35, 175);
        }
    }

    synchronized void waitTillLoaded() {
        while (!this.loaded) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
    }

    boolean isOk() {
        return this.loaded && this.image != null;
    }
}

