/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava.ui;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;
import java.util.Vector;
import sunw.hotjava.misc.HJBProperties;

public class MultiLineLabel
extends Canvas {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    protected String label = "";
    protected Vector initialLineFonts = new Vector();
    protected Vector lineFonts = new Vector();
    protected int[] lineWidths;
    protected int numberOfLines;
    protected int marginWidth;
    protected int marginHeight;
    protected int lineHeight;
    protected int lineAscent;
    protected int maxWidth;
    protected int alignment = 0;
    protected boolean measured = false;
    private HJBProperties properties = HJBProperties.getHJBProperties("hjbrowser");

    public MultiLineLabel(String string, int n, int n2, int n3) {
        if (string != null && string.length() > 0) {
            this.parseIntoLines(string);
        }
        this.label = string;
        this.marginWidth = n;
        this.marginHeight = n2;
        this.alignment = n3;
    }

    public MultiLineLabel(String string, int n, int n2, int n3, Font font) {
        this(string, n, n2, n3);
        this.setFont(font);
    }

    public MultiLineLabel(String string, int n, int n2) {
        this(string, n, n2, 0);
    }

    public MultiLineLabel(String string, int n) {
        this(string, 10, 10, n);
    }

    public MultiLineLabel(String string) {
        this(string, 10, 10, 0);
    }

    public MultiLineLabel(String string, Font font) {
        this(string, 10, 10, 0);
        this.setFont(font);
    }

    public MultiLineLabel() {
        this("");
    }

    public void setLabel(String string) {
        this.label = string;
        this.parseIntoLines(string);
        this.measured = false;
        this.parseIntoLines(string);
        this.repaint();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.measured = false;
        this.parseIntoLines(this.label);
        this.repaint();
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaint();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.repaint();
    }

    public int getAlignment() {
        return this.alignment;
    }

    public int getMarginWidth() {
        return this.marginWidth;
    }

    public int getMarginHeight() {
        return this.marginHeight;
    }

    public void setAlignment(int n) {
        this.alignment = n;
        this.repaint();
    }

    public void setMarginWidth(int n) {
        this.marginWidth = n;
        this.repaint();
    }

    public void setMarginHeight(int n) {
        this.marginHeight = n;
        this.repaint();
    }

    public Dimension preferredSize() {
        if (!this.measured) {
            this.measure();
        }
        return new Dimension(this.maxWidth + 2 * this.marginWidth, this.numberOfLines * this.lineHeight + 2 * this.marginHeight);
    }

    public Dimension minimumSize() {
        this.measure();
        return new Dimension(this.maxWidth, this.numberOfLines * this.lineHeight);
    }

    public void update(Graphics graphics) {
        graphics.setColor(this.getForeground());
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.size();
        if (!this.measured) {
            this.measure();
        }
        int n = this.lineAscent + (dimension.height - this.numberOfLines * this.lineHeight) / 2;
        int n2 = 0;
        while (n2 < this.lineFonts.size()) {
            int n3;
            LineFont lineFont = (LineFont)this.lineFonts.elementAt(n2);
            String string = lineFont.line;
            if (string == null) {
                string = "";
            }
            graphics.setFont(lineFont.font);
            switch (this.alignment) {
                case 0: {
                    n3 = Math.min(this.marginWidth, Math.max((dimension.width - this.maxWidth) / 2, 0));
                    break;
                }
                default: {
                    n3 = (dimension.width - this.lineWidths[n2]) / 2;
                    break;
                }
                case 2: {
                    n3 = Math.max(dimension.width - this.marginWidth - this.lineWidths[n2], (dimension.width + this.marginWidth) / 2 - this.lineWidths[n2]);
                }
            }
            graphics.drawString(string, n3, n);
            ++n2;
            n += this.lineHeight;
        }
    }

    protected void parseIntoLines(String string) {
        if (string == null) {
            return;
        }
        if (string.indexOf(10) < 0) {
            string = String.valueOf(string) + "\n";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        this.numberOfLines = stringTokenizer.countTokens();
        if (super.getFont() == null) {
            super.setFont(new Font("Dialog", 0, 12));
        }
        Font font = super.getFont();
        this.initialLineFonts.removeAllElements();
        this.lineWidths = new int[this.numberOfLines];
        int n = 0;
        while (n < this.numberOfLines) {
            Font font2 = font;
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("<font")) {
                String string3 = string2.substring(5, string2.indexOf(">"));
                String string4 = "";
                int n2 = -1;
                int n3 = -1;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ";");
                while (stringTokenizer2.hasMoreTokens()) {
                    String string5;
                    String string6 = stringTokenizer2.nextToken();
                    int n4 = 0;
                    n4 = string6.indexOf("=");
                    if (n4 <= 0) continue;
                    if (string6.trim().startsWith("name")) {
                        string5 = string6.substring(n4 + 1).trim();
                        string4 = this.substitute_entities(string5);
                    }
                    if (string6.trim().startsWith("size")) {
                        string5 = string6.substring(n4 + 1).trim();
                        n2 = Integer.parseInt(this.substitute_entities(string5));
                    }
                    if (!string6.trim().startsWith("style")) continue;
                    string5 = string6.substring(n4 + 1).trim();
                    String string7 = this.substitute_entities(string5);
                    n3 = string7.equalsIgnoreCase("bold") ? 1 : (string7.equalsIgnoreCase("italic") ? 2 : 0);
                }
                if (string4.length() == 0) {
                    string4 = font.getName();
                }
                if (n2 == -1) {
                    n2 = font.getSize();
                }
                if (n3 == -1) {
                    n3 = font.getStyle();
                }
                string2 = string2.substring(string2.indexOf(">") + 1);
                font2 = new Font(string4, n3, n2);
            }
            this.initialLineFonts.addElement(new LineFont(string2, font2));
            ++n;
        }
    }

    private String substitute_entities(String string) {
        int n = 0;
        int n2 = 0;
        while (string != null && (n = string.indexOf(38)) >= 0) {
            n2 = string.indexOf(59, n);
            if (n2 < 0) {
                n2 = string.length();
            }
            String string2 = string.substring(n + 1, n2);
            String string3 = string.substring(0, n);
            String string4 = "";
            string4 = n2 == string.length() ? string.substring(n2) : string.substring(n2 + 1);
            String string5 = this.properties.getProperty(string2, "0");
            string = String.valueOf(string3) + string5 + string4;
        }
        return string;
    }

    protected void measure() {
        Font font;
        String string;
        LineFont lineFont;
        int n;
        FontMetrics fontMetrics;
        Container container = this.getParent();
        int n2 = -1;
        if (container != null) {
            n2 = container.getSize().width - 2 * this.marginWidth;
        }
        if ((fontMetrics = this.getToolkit().getFontMetrics(this.getFont())) == null) {
            return;
        }
        this.lineFonts.removeAllElements();
        this.lineHeight = fontMetrics.getHeight();
        this.lineAscent = fontMetrics.getAscent();
        this.maxWidth = 0;
        Vector<Integer> vector = new Vector<Integer>();
        if (n2 > 0) {
            n = 0;
            while (n < this.initialLineFonts.size()) {
                lineFont = (LineFont)this.initialLineFonts.elementAt(n);
                string = lineFont.line;
                font = lineFont.font;
                fontMetrics = this.getToolkit().getFontMetrics(font);
                int n3 = 0;
                int n4 = 0;
                while (n4 < string.length()) {
                    int n5 = 0;
                    while (n5 < n2 && n4 < string.length()) {
                        n5 += fontMetrics.charWidth(string.charAt(n4++));
                    }
                    int n6 = n4;
                    if (n4 > 1 && n4 < string.length() && string.charAt(n4) != ' ') {
                        while (n4 > 1 && string.charAt(n4) != ' ') {
                            --n4;
                        }
                    }
                    if (n3 >= n4) {
                        n4 = n6;
                    }
                    vector.addElement(new Integer(n5));
                    this.lineFonts.addElement(new LineFont(string.substring(n3, n4), font));
                    if (n4 <= 0 || n4 >= string.length() || string.charAt(n4) == ' ') {
                        // empty if block
                    }
                    n3 = ++n4;
                }
                ++n;
            }
        } else {
            n = 0;
            while (n < this.initialLineFonts.size()) {
                lineFont = (LineFont)this.initialLineFonts.elementAt(n);
                string = lineFont.line;
                font = lineFont.font;
                fontMetrics = this.getToolkit().getFontMetrics(font);
                vector.addElement(new Integer(fontMetrics.stringWidth(string)));
                this.lineFonts.addElement(new LineFont(string, font));
                ++n;
            }
        }
        this.numberOfLines = vector.size();
        this.lineWidths = new int[this.numberOfLines];
        n = 0;
        while (n < vector.size()) {
            this.lineWidths[n] = (Integer)vector.elementAt(n);
            if (this.lineWidths[n] > this.maxWidth) {
                this.maxWidth = this.lineWidths[n];
            }
            ++n;
        }
        this.measured = true;
    }

    public class LineFont {
        public String line;
        public Font font;

        public LineFont(String string, Font font) {
            MultiLineLabel.this = MultiLineLabel.this;
            this.line = string;
            this.font = font;
        }
    }
}

