/*
 * Decompiled with CFR 0.152.
 */
package sunw.hotjava;

import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.text.MessageFormat;
import sunw.hotjava.HJFrame;
import sunw.hotjava.HJWindowManager;
import sunw.hotjava.bean.CookieJarInterface;
import sunw.hotjava.bean.URLPoolEvent;
import sunw.hotjava.bean.URLPoolListener;
import sunw.hotjava.bean.URLPooler;
import sunw.hotjava.misc.HJBProperties;
import sunw.hotjava.misc.HttpCookie;
import sunw.hotjava.ui.CheckboxDialog;
import sunw.hotjava.ui.HotList;
import sunw.hotjava.ui.HotListEvent;
import sunw.hotjava.ui.HotListListener;

public class PeriodicSaveManager
implements URLPoolListener,
Runnable,
VetoableChangeListener,
HotListListener {
    private static PeriodicSaveManager psm = null;
    private static boolean poolChanged;
    private static boolean cookiesChanged;
    private static boolean hotlistChanged;
    private static URLPooler urlpool;
    private static CookieJarInterface cookieList;
    private static HotList hotlist;
    private static final String poolClass = "sunw.hotjava.bean.URLPool";
    private static final String cookieClass = "sunw.hotjava.bean.CookieJar";
    private static String poolPath;
    private static String cookiePath;
    private static HJBProperties properties;
    private static final int ACCEPT = 0;
    private static final int REJECT = 1;
    private static int saveDelay;

    public static PeriodicSaveManager getPeriodicSaveManager() {
        if (psm == null) {
            psm = new PeriodicSaveManager();
        }
        return psm;
    }

    private PeriodicSaveManager() {
        properties = HJBProperties.getHJBProperties("hjbrowser");
        saveDelay = Integer.valueOf(properties.getProperty("urlpool.autosave", "120"));
        urlpool = HJWindowManager.getHJWindowManager().getURLPoolManager();
        int n = properties.getInteger("urlpool.expires", 14);
        urlpool.setURLExpirationAmt(n);
        urlpool.addURLPoolListener(this);
        urlpool.createURLPoolFromFile(this.getURLPoolPath());
        cookieList = HJWindowManager.getHJWindowManager().getCookiesManager();
        cookieList.addVetoableChangeListener(this);
        cookieList.loadCookieJarFromFile(this.getCookiePath());
        hotlist = HotList.getHotList();
        hotlist.addHotListListener(this);
    }

    private String getURLPoolPath() {
        if (poolPath == null) {
            poolPath = System.getProperty("user.home");
            if (poolPath != null && !poolPath.endsWith(File.separator)) {
                poolPath = String.valueOf(poolPath) + File.separator;
            }
            poolPath = String.valueOf(poolPath) + ".hotjava" + File.separator + "urlpool";
        }
        return poolPath;
    }

    private String getCookiePath() {
        if (cookiePath == null) {
            cookiePath = System.getProperty("user.home");
            if (cookiePath != null && !cookiePath.endsWith(File.separator)) {
                cookiePath = String.valueOf(cookiePath) + File.separator;
            }
            cookiePath = String.valueOf(cookiePath) + ".hotjava" + File.separator + "cookies";
        }
        return cookiePath;
    }

    public void urlPoolChanged(URLPoolEvent uRLPoolEvent) {
        poolChanged = true;
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
        String string;
        HJFrame hJFrame = HJWindowManager.getHJWindowManager().getLastFocusHolder();
        if (hJFrame != null && "notify".equals(string = properties.getProperty("hotjava.cookie.acceptpolicy")) && propertyChangeEvent.getNewValue() != null) {
            CheckboxDialog checkboxDialog = new CheckboxDialog((Frame)hJFrame, "cookiedialog", properties, true);
            checkboxDialog.setPrompt(this.cookiePrompt((HttpCookie)propertyChangeEvent.getNewValue()));
            checkboxDialog.show();
            if (checkboxDialog.getCheckboxAnswer()) {
                properties.put("hotjava.cookie.acceptpolicy", "all");
            }
            if (checkboxDialog.getAnswer() == 1) {
                throw new PropertyVetoException("", propertyChangeEvent);
            }
        }
        cookiesChanged = true;
    }

    private String cookiePrompt(HttpCookie httpCookie) {
        Object[] objectArray = new String[]{httpCookie.getDomain(), httpCookie.getDomain(), httpCookie.getNameValue()};
        StringBuffer stringBuffer = new StringBuffer(MessageFormat.format(properties.getProperty("confirm.cookiedialog.prompt", "A cookie will be set.\n"), objectArray));
        if (httpCookie != null && httpCookie.getExpirationDate() != null) {
            String string = httpCookie.getExpirationDate().toString();
            Object[] objectArray2 = new String[]{string};
            stringBuffer.append("\n");
            stringBuffer.append(MessageFormat.format(properties.getProperty("confirm.cookiedialog.prompt1"), objectArray2));
        }
        stringBuffer.append("\n");
        stringBuffer.append(properties.getProperty("confirm.cookiedialog.prompt2", "Do you want to accept it?\n"));
        return stringBuffer.toString();
    }

    public void hotlistChanged(HotListEvent hotListEvent) {
        hotlistChanged = true;
    }

    public void prepareToExit() {
        urlpool.removeURLPoolListener(this);
        cookieList.removeVetoableChangeListener(this);
        if (poolChanged) {
            urlpool.saveURLPoolToFile(this.getURLPoolPath());
            poolChanged = false;
        }
        if (cookiesChanged) {
            cookieList.saveCookieJarToFile(this.getCookiePath());
            cookiesChanged = false;
        }
        if (properties.isChanged()) {
            properties.save();
            properties.setChanged(false);
        }
        if (hotlistChanged) {
            hotlist.exportHTMLFile();
            hotlistChanged = false;
        }
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(saveDelay * 1000);
            }
            catch (Exception exception) {}
            if (poolChanged) {
                urlpool.saveURLPoolToFile(this.getURLPoolPath());
                poolChanged = false;
            }
            if (cookiesChanged) {
                cookieList.saveCookieJarToFile(this.getCookiePath());
                cookiesChanged = false;
            }
            if (properties.isChanged()) {
                properties.save();
                properties.setChanged(false);
            }
            if (!hotlistChanged) continue;
            hotlist.exportHTMLFile();
            hotlistChanged = false;
        }
    }

    static {
        poolPath = null;
        cookiePath = null;
    }
}

