#!/bin/sh
spitshell=cat
package=IRC

echo "Extracting $package/src/version.c..."

if test -r version.c.last
then
   generation=`sed -n 's/^char \*generation = \"\(.*\)\";/\1/p' < version.c.last`
   if test ! "$generation" ; then generation=0; fi
else
   generation=0
fi

generation=`expr $generation + 1`

uname=`uname -a`

creation=`date | \
awk '{if (NF == 6) \
         { print $1 " "  $2 " " $3 " "  $6 " at " $4 " " $5 } \
else \
         { print $1 " "  $2 " " $3 " " $7 " at " $4 " " $5 " " $6 }}'`

$spitshell >version.c <<!SUB!THIS!
/*
 *   IRC - Internet Relay Chat, src/version.c
 *   Copyright (C) 1990 Chelsea Ashley Dyerman
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * This file is generated by version.c.SH. Any changes made will go away.
 */

#include "struct.h"
#include "patchlevel.h"

char *generation = "$generation";
char *creation = "$creation";
char *version = PATCHLEVEL;

char *infotext[] =
    {
	"$package --",
        "Based on the original code written by Jarkko Oikarinen",
        "Copyright 1988, 1989, 1990, 1991 University of Oulu, Computing Center",
        "",
        "This program is free software; you can redistribute it and/or",
        "modify it under the terms of the GNU General Public License as",
        "published by the Free Software Foundation; either version 1, or",
        "(at your option) any later version.",
        "",
        "The following people have contributed to this release of hybrid",
        "in nick alphabetical order:",
        "",
        "cbongo              Chris A. Bongaarts  cab@tc.umn.edu",
        "comstud             Chris Behrens       cbehrens@concentric.net",
        "Dianora             Diane Bruce         db@db.net",
	"johan               Johannes Erdfelt    jerdfelt@eng.mindspring.net",
        "orabidoo            Roger Espel Llima   espel@unix.bigots.org",
        "Rodder              Jon Lusky           lusky@vol.com",
        "Shadowfax           Michael Pearce      mpearce@varner.com",
        "ThemBones           Brian Kraemer       kraemer@u.washington.edu",
        "Wohali              Joan Touzet         jolo@cadence.com",
        "",
        "",
        "Developers and Contributors for previous versions:",
        "",
	"Chris Portman       Keith Fralick       Sam Noble",
        "Taner Halicioglu    Chris Behrens       Darren Reed",
        "Markku Savela       Greg Lindahl        Jarkko Oikarinen",
        "Armin Gruner        Matthew Green       Chuck Kane",
        "Matt Lyle           Vesa Ruokonen       Nicolas PIOCH",
        "Stellan Klebom      Dan Goodwin         Mike Bolotski",
        "Ian Frechette       Markku Jarvinen     Kimmo Suominen",
        "Jeff Trim           Vijay Subramaniam   Karl Kleinpaste",
        "Bill Wisner         Tom Davis           Hugo Calendar",
        "Tom Hopkins         Stephen van den Berg",
        "Bo Adler            Michael Sandrof     Jon Solomon",
        "Jan Peterson        Helen Rose          Paul Graham",
        "",
        "Thanks also goes to those persons not mentioned here who have added",
        "their advice, opinions, and code to IRC.",
        "Thanks also to those who provide the kind sys admins who let me and",
        "others continue to develop IRC.",
	"Ported to OS/2 by Roger \'Nighthawk\' Haskins <nth.tech@iname.com>",
	"Compiled on [$uname]",
	0,
    };
!SUB!THIS!
