/************************************************************************
 *   IRC - Internet Relay Chat, ircd/s_err.c
 *   Copyright (C) 1992 Darren Reed
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: s_err.h,v 1.4 1998/02/22 18:48:24 db Exp $
 *
 */

#ifdef CUSTOM_ERR
static	Numeric	local_replies[] = {
/* 000 */	0, (char *)NULL,
/* 001 */	RPL_WELCOME, ":Welcome to WebbNet IRC %s",
/* 002 */	RPL_YOURHOST, ":Your host is %s, running version %s",
/* 003 */	RPL_CREATED, ":This server was designed and built on %s",
/* 004 */	RPL_MYINFO, "%s %s oiwszcrkfydn biklmnopstv",
		0, (char *)NULL
};

static	Numeric	numeric_errors[] = {
/* 401 */	ERR_NOSUCHNICK, "%s :is not on IRC (No such nick/channel)",
/* 402 */	ERR_NOSUCHSERVER, "%s :doesn't exist (No such server)",
/* 403 */	ERR_NOSUCHCHANNEL, "%s :doesn't exist (No such channel)",
/* 404 */	ERR_CANNOTSENDTOCHAN, "%s :Cannot send to channel (it's desynched or moderated)",
/* 405 */	ERR_TOOMANYCHANNELS, "%s :You have joined too many channels",
/* 406 */	ERR_WASNOSUCHNICK, "%s :is not on IRC (There was no such nickname)",
/* 407 */	ERR_TOOMANYTARGETS,
		"%s :Duplicate recipients. No message delivered",
/* 408 */	0, (char *)NULL,
/* 409 */	ERR_NOORIGIN, ":No origin specified",
/* 410 */	0, (char *)NULL,
/* 411 */	ERR_NORECIPIENT, ":No recipient given (%s)",
/* 412 */	ERR_NOTEXTTOSEND, ":No text to send",
/* 413 */	ERR_NOTOPLEVEL, "%s :No toplevel domain specified",
/* 414 */	ERR_WILDTOPLEVEL, "%s :Wildcard in toplevel Domain",
/* 415 */	0, (char *)NULL,
/* 416 */	0, (char *)NULL,
/* 417 */	0, (char *)NULL,
/* 418 */	0, (char *)NULL,
/* 419 */	0, (char *)NULL,
/* 420 */	0, (char *)NULL,
/* 421 */	ERR_UNKNOWNCOMMAND, "%s :Unknown command",
/* 422 */	ERR_NOMOTD, ":MOTD File is missing",
/* 422 */	ERR_NOADMININFO,
		"%s :No administrative info available",
/* 422 */	ERR_FILEERROR, ":File error doing %s on %s",
		0, (char *)NULL, 0, (char *)NULL, 0, (char *)NULL,
		0, (char *)NULL, 0, (char *)NULL, 0, (char *)NULL,
/* 431 */	ERR_NONICKNAMEGIVEN, ":No nickname given",
/* 432 */	ERR_ERRONEUSNICKNAME, "%s :Erroneus Nickname",
/* 433 */	ERR_NICKNAMEINUSE, "%s :Sorry, that Nickname is already in use - try another one.",
/* 434 */	0, (char *)NULL,
/* 435 */	0, (char *)NULL,
/* 436 */       ERR_NICKCOLLISION, "%s :NICK COLLISION - Nickname collision KILL",
		0, (char *)NULL, 0, (char *)NULL,
		0, (char *)NULL, 0, (char *)NULL,
		ERR_USERNOTINCHANNEL, "%s %s :isn't on that channel",
		ERR_NOTONCHANNEL, "%s :You're not on that channel",
/* 443 */	ERR_USERONCHANNEL, "%s %s :is already on the channel",
/* 444 */	ERR_NOLOGIN, "%s :User not logged in",
/* 445 */	ERR_SUMMONDISABLED, ":SUMMON has been removed",
/* 446 */	ERR_USERSDISABLED, ":USERS has been removed",
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
/* 451 */	ERR_NOTREGISTERED, ":You have not registered",
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
/* 461 */	ERR_NEEDMOREPARAMS, "%s :Not enough parameters",
/* 462 */	ERR_ALREADYREGISTRED, ":You may not reregister",
/* 463 */	ERR_NOPERMFORHOST, ":Your host isn't among the privileged.",
/* 464 */	ERR_PASSWDMISMATCH, ":BZZZT!! Wrong password, luser! Are you sure you know what you're doing??",
/* 465 */	ERR_YOUREBANNEDCREEP, ":You are BANNED from this server- %s",
/* 466 */	ERR_YOUWILLBEBANNED, (char *)NULL,
/* 467 */	ERR_KEYSET, "%s :Channel key already set. Pay attention dimwit.",
		0, (char *)NULL, 0, (char *)NULL, 0, (char *)NULL,
/* 471 */	ERR_CHANNELISFULL, "%s :Cannot join channel - channel is full (+l)",
/* 472 */	ERR_UNKNOWNMODE  , "%c :is unknown mode char to me",
/* 473 */	ERR_INVITEONLYCHAN, "%s :Cannot join channel - is invite-only (+i)",
/* 474 */	ERR_BANNEDFROMCHAN, "%s :Cannot join channel - you are banned (+b) pinhead",
/* 475 */	ERR_BADCHANNELKEY, "%s :Cannot join channel - password required (+k)",
/* 476 */	ERR_BADCHANMASK, "%s :Bad Channel Mask",
		0, (char *)NULL, 0, (char *)NULL, 0, (char *)NULL,
		0, (char *)NULL,
/* 481 */	ERR_NOPRIVILEGES,
		":UHHH, I don't THINK so, homez... you ain't got what it takes. (IRC Operator)",
/* 482 */	ERR_CHANOPRIVSNEEDED, "%s :You can't do that thing, when you don't have that swing (You're not channel operator)",
/* 483 */	ERR_CANTKILLSERVER, ":Don't be an idiot -  you can't kill a SERVER, fool.",
/* 484 */	0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
/* 491 */	ERR_NOOPERHOST, ":Sorry, you just don't have what it takes to be an IRC Operator here.",
/* 492 */	0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
/* 501 */	ERR_UMODEUNKNOWNFLAG, ":Unknown MODE flag - you smokin' something?",
/* 502 */	ERR_USERSDONTMATCH, ":You can't change user modes for other users, silly - check that nickname again.",
/* 503 */	ERR_GHOSTEDCLIENT, ":Message could not be delivered to %s",
/* LAST */	ERR_LAST_ERR_MSG, ":Last Error Message",
		0, (char *)NULL
};

static	Numeric	numeric_replies[] = {
/* 300 */	RPL_NONE, (char *)NULL,
/* 301 */	RPL_AWAY, "%s :%s",
/* 302 */	RPL_USERHOST, ":",
/* 303 */	RPL_ISON, ":",
/* 304 */	RPL_TEXT, (char *)NULL,
/* 305 */	RPL_UNAWAY, ":OK, you're not /away anymore. Did you have fun?",
/* 306 */	RPL_NOWAWAY, ":OK, you're /away now. Hurry back!",
		0, (char *)NULL, 0, (char *)NULL, 0, (char *)NULL,
		0, (char *)NULL,
/* 311 */	RPL_WHOISUSER, "%s %s %s * :%s",
/* 312 */	RPL_WHOISSERVER, "%s %s :%s",
/* 313 */	RPL_WHOISOPERATOR, "%s :is an IRC Janitor (IRC Operator)",
/* 314 */	RPL_WHOWASUSER, "%s %s %s * :%s",
/* 315 */	RPL_ENDOFWHO, "%s :End of /WHO list.",
/* 316 */	RPL_WHOISCHANOP, (char *)NULL,
/* 317 */	RPL_WHOISIDLE, "%s %ld %ld :seconds idle, signon time",
/* 318 */	RPL_ENDOFWHOIS, "%s :End of /WHOIS list.",
/* 319 */	RPL_WHOISCHANNELS, "%s :%s",
		0, (char *)NULL,
/* 321 */	RPL_LISTSTART, "Channel :Users  Name",
/* 322 */	RPL_LIST, "%s %d :%s",
/* 323 */	RPL_LISTEND, ":End of /LIST",
/* 324 */	RPL_CHANNELMODEIS, "%s %s %s",
		0, (char *)NULL, 0, (char *)NULL, 0, (char *)NULL,
		0, (char *)NULL, 
/* 329 */	RPL_CREATIONTIME, "%s %lu",
		0, (char *)NULL, 
/* 331 */	RPL_NOTOPIC, "%s :No topic is set.",
/* 332 */	RPL_TOPIC, "%s :%s",
#ifdef TOPIC_INFO
/* 333 */       RPL_TOPICWHOTIME, "%s %s %lu",
#else
                0, (char *)NULL,
#endif
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
/* 341 */	RPL_INVITING, "%s %s",
/* 342 */	RPL_SUMMONING, "%s :User summoned to irc",
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
/* 351 */	RPL_VERSION, "%s.%s %s :%s",
/* 352 */	RPL_WHOREPLY, "%s %s %s %s %s %s :%d %s",
/* 353 */	RPL_NAMREPLY, "%s",
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
		0, (char *)NULL,
/* 361 */	RPL_KILLDONE, (char *)NULL,
/* 362 */	RPL_CLOSING, "%s :Closed. Status = %d",
/* 363 */	RPL_CLOSEEND, "%d: Connections Closed",
/* 364 */	RPL_LINKS, "%s %s :%d %s",
/* 365 */	RPL_ENDOFLINKS, "%s :End of /LINKS list.",
/* 366 */	RPL_ENDOFNAMES, "%s :End of /NAMES list.",
#ifdef BAN_INFO
/* 367 */       RPL_BANLIST, "%s %s %s %lu",
#else
/* 367 */	RPL_BANLIST, "%s %s",
#endif
/* 368 */	RPL_ENDOFBANLIST, "%s :End of Channel Ban List",
/* 369 */	RPL_ENDOFWHOWAS, "%s :End of WHOWAS",
		0, (char *)NULL,
/* 371 */	RPL_INFO, ":%s",
/* 372 */	RPL_MOTD, ":- %s",
/* 373 */	RPL_INFOSTART, ":Server INFO",
/* 374 */	RPL_ENDOFINFO, ":End of /INFO list.",
/* 375 */	RPL_MOTDSTART, ":- %s Message of the Day - ",
/* 376 */	RPL_ENDOFMOTD, ":End of /MOTD command.",
		0, (char *)NULL,
		0, (char *)NULL, 0, (char *)NULL,
		0, (char *)NULL,
/* 381 */	RPL_YOUREOPER, ":You are now GOD!! Have a good day!!",
/* 382 */	RPL_REHASHING, "%s :it slices, dices, and even reloads config files!  Rehashing config file, mang.",
/* 383 */	0, (char *)NULL,
/* 384 */	RPL_MYPORTIS, "%d :Port to local server is\r\n",
/* 385 */	RPL_NOTOPERANYMORE, (char *)NULL,
		0, (char *)NULL, 0, (char *)NULL, 0, (char *)NULL,
		0, (char *)NULL, 0, (char *)NULL,
/* 391 */	RPL_TIME, "%s :%s",
#ifdef	ENABLE_USERS
/* 392 */	RPL_USERSSTART, ":UserID   Terminal  Host",
/* 393 */	RPL_USERS, ":%-8s %-9s %-8s",
/* 394 */	RPL_ENDOFUSERS, ":End of Users",
/* 395 */	RPL_NOUSERS, ":Nobody logged in.",
#else
		0, (char *)NULL, 0, (char *)NULL, 0, (char *)NULL,
		0, (char *)NULL,
#endif
		0, (char *)NULL, 0, (char *)NULL, 0, (char *)NULL,
		0, (char *)NULL,
/* 200 */	RPL_TRACELINK, "Link %s%s %s %s",
/* 201 */	RPL_TRACECONNECTING, "Try. %d %s",
/* 202 */	RPL_TRACEHANDSHAKE, "H.S. %d %s",
/* 203 */	RPL_TRACEUNKNOWN, "???? %d %s %d",
/* 204 */	RPL_TRACEOPERATOR, "Oper %d %s",
/* 205 */	RPL_TRACEUSER, "User %d %s",
/* 206 */	RPL_TRACESERVER, "Serv %d %dS %dC %s %s!%s@%s",
/* 207 */	0, (char *)NULL,
/* 208 */	RPL_TRACENEWTYPE, "<newtype> 0 %s",
/* 209 */	RPL_TRACECLASS, "Class %d %d",
		0, (char *)NULL,
/* 211 */	RPL_STATSLINKINFO, (char *)NULL,
/* 212 */	RPL_STATSCOMMANDS, "%s %u %u",
/* 213 */	RPL_STATSCLINE, "%c %s * %s %d %d",
/* 214 */	RPL_STATSNLINE, "%c %s * %s %d %d",
/* 215 */	RPL_STATSILINE, "%c %s * %s %d %d",
#ifdef K_COMMENT_ONLY
/* 216 */	RPL_STATSKLINE, "%c %s * %s %s",
#else
/* 216 */	RPL_STATSKLINE, "%c %s %s %s %d %d",
#endif
/* 217 */	RPL_STATSQLINE, "%c %s * %s %d %d",
/* 218 */	RPL_STATSYLINE, "%c %d %d %d %d %ld",
/* 219 */	RPL_ENDOFSTATS, "%c :End of /STATS report",
		0, (char *)NULL,
/* 221 */	RPL_UMODEIS, "%s",
/* 222 */	RPL_STATSBLINE, "%c %s * %s %d %d",
/* 223 */	RPL_STATSELINE, "%c %s * %s %d %d",
/* 224 */	RPL_STATSFLINE, "%c %s * %s %d %d",
/* 225 */	RPL_STATSDLINE, "%c %s %s",
		0, (char *)NULL, 0, (char *)NULL,
		0, (char *)NULL, 0, (char *)NULL, 0, (char *)NULL,
/* 231 */	0, (char *)NULL,
/* 232 */	0, (char *)NULL,
/* 233 */	0, (char *)NULL,
/* 234 */	RPL_SERVLIST, (char *)NULL,
/* 235 */	RPL_SERVLISTEND, (char *)NULL,
		0, (char *)NULL, 0, (char *)NULL, 0, (char *)NULL,
		0, (char *)NULL, 0, (char *)NULL,
/* 241 */	RPL_STATSLLINE, "%c %s * %s %d %d",
/* 242 */	RPL_STATSUPTIME, ":Server Up %d days, %d:%02d:%02d",
/* 243 */	RPL_STATSOLINE, "%c %s * %s %d %d",
/* 244 */	RPL_STATSHLINE, "%c %s * %s %d %d", 
/* 245 */	RPL_STATSSLINE, "%c %s * %s %d %d", 
		0, (char *)NULL, 0, (char *)NULL, 0, (char *)NULL,
		0, (char *)NULL,
#ifdef HIGHEST_CONNECTION
/* 250 */       RPL_STATSCONN,
                    ":Highest number of connections so far: %d (%d clients)",
#else
                0, (char *)NULL,
#endif
/* 251 */	RPL_LUSERCLIENT,
		":There are %d users plus %d invisible on %d servers",
/* 252 */	RPL_LUSEROP, "%d :IRC Gods (Operators) online",
/* 253 */	RPL_LUSERUNKNOWN, "%d :unknown connection(s)",
/* 254 */	RPL_LUSERCHANNELS, "%d :channels formed",
/* 255 */	RPL_LUSERME, ":I have %d clients and %d servers",
/* 256 */	RPL_ADMINME, ":Administrative info concerning %s",
/* 257 */	RPL_ADMINLOC1, ":%s",
/* 258 */	RPL_ADMINLOC2, ":%s",
/* 259 */	RPL_ADMINEMAIL, ":%s",
		0, (char *)NULL,
/* 261 */	RPL_TRACELOG, "File %s %d",
/* 262 */	RPL_ENDOFTRACE, "%s :End of TRACE",
/* 263 */       RPL_LOAD2HI, ":Hold your horses... the server load is temporarily too heavy. Try again later, ok?",
		0, (char *)NULL,
/* 265 */	RPL_LOCALUSERS, ":Current local  users: %d  Max: %d",
/* 266 */	RPL_GLOBALUSERS, ":Current global users: %d  Max: %d"
		};
#endif /* CUSTOM_ERR */

