/* REXX */

/*
 *  File    :  ts_start.cmd
 *  Purpose :  Automate the tunnel connection process
 *
 *
 *  Modification History:
 *
 *  --Date--- --By-- --Reason------------------------------------------------
 *  1997.06.12     TAB   Created script
 *
 */


/* ----- */

app = 'TS_CON'

SAY app 'v1.00  1997.06.17'
SAY


/* load the REXX utility package */

CALL RXFuncAdd SysSleep, RexxUtil, SysSleep


/* InJoy search REMed out for performance */

/*
IF \ isrun('in-joy') THEN DO
   rc = status(app, 'ERROR', 'InJoy must be running to start the tunnel')
   EXIT 2
END
*/


/* --- */

IF isrun('ts') THEN DO

   /* just reconnect the existing tunnel */

   rc = status(app, 'INFO', 'Using cached information')
   rc = status(app, 'INFO', 'Reconnecting')
   '@settun /F'

   rc = status(app, 'INFO', 'Complete')
   '@setjoy /C'
   rc = SysSleep(5)

END
ELSE DO

   /* setup the tunnel routes */

   CALL ts_init
   CALL ts_dns
   CALL ts_route1
   CALL ts_sniff
   CALL ts_launch
   CALL ts_route3
   CALL ts_tune
   IF exist('ts_aux') THEN DO
      rc = status(app, 'INFO', 'Running external applications')
      CALL ts_aux
   END

   rc = status(app, 'INFO', 'Complete')
   '@setjoy /C'
   rc = SysSleep(60)

END


RETURN 0
