/* TONLINE.CMD, Version 1.2 */
/* Internet Access via T-Online */
/* Copyright (c) 1995 1&1 Telekommunikation GmbH */

/*********************************************************************
/
/  Note:  The sample script ANNEX.CMD has served as a
/  -----  template for the development of TONLINE.CMD.
/
*********************************************************************/

parse arg interface  /* sl0 */

call RxFuncAdd "SysLoadFuncs", "RexxUtil", "SysLoadFuncs"
call SysLoadFuncs

null      = "0"x   /* String terminator */
newline   = "0A"x  /* Line feed */
paragraph = newline || newline

cr   = "0D"x    /* Carriage return */
crlf = "0D0A"x  /* Carriage return, Line feed */

/*********************************************************************
/  Retrieve any information required for dialing
*********************************************************************/

parse upper source . . this_cmd

c_drive = filespec( "drive", this_cmd )
c_path  = filespec( "path",  this_cmd )
telekom = c_drive || c_path

dxjdial = telekom || "DXJDIAL.INI"
crypt   = telekom || "CRYPT.EXE"
regfile = telekom || "REGISTER.OK"
price   = telekom || "PRICE.MIN"

tcpetc = value( "ETC", , "OS2ENVIRONMENT")

if tcpetc = "" then do
   message =,
      "Die Umgebungsvariable ETC, die den Pfad zur Datei "||,
      "TCPOS2.INI weist, existiert nicht. Diese Variable "||,
      "wird bei Installation der IBM Internet Connection "||,
      "definiert, indem eine entsprechende SET Anweisung "||,
      "in die Datei CONFIG.SYS eingefgt wird. "paragraph

   call FatalError
end

tcpos2 = tcpetc"\TCPOS2.INI"

if stream( tcpos2, "command", "query exists") = "" then do
   message =,
      "Die Datei "tcpos2" existiert nicht. Prfen Sie, "   ||,
      "ob die Umgebungsvariable ETC richtig gesetzt ist. " ||,
      "Der Wert dieser Variablen weist den Pfad zur Datei "||,
      "TCPOS2.INI. "paragraph

   call FatalError
end

gate = SysIni( tcpos2, "CONNECTION", "CURRENT_CONNECTION")
gate = left( gate, 7 )

if \(gate = "DxJ2400" | gate = "DxJfast") then do
   message =,
      "Sie haben einen anderen als einen T-Online Zugang " ||,
      "benutzt. Das Skript TONLINE.CMD kann nur fr einen "||,
      "T-Online Zugang korrekt ausgefhrt werden. "paragraph

   call FatalError
end

say "tcpos2: "|| tcpos2
say "gate: "  || gate

call ReadDxJDial  /* Get parameters from DXJDIAL.INI */

if gate = "DxJ2400" then do
   initstring = modem_init_0
   dialstring = dial_prefix || default_node
end

if gate = "DxJfast" then do
   initstring = modem_init_1
   dialstring = dial_prefix || fast_node
end

kennung     = left( account,   12 )
teilnehmer  = left( user_no,   12 )
mitbenutzer = left( co_user_no, 4 )
passwort    = left( password,   8 )

/*********************************************************************
/  Dial into T-Online and enter the Internet Gateway
*********************************************************************/

say ''
say 'Internet Access via T-Online'

/* Flush any stuff left over from previous COM activity */
call flush_receive

dial_in_loop:

say 'Dialing ...'
call send initstring || cr     
call waitfor 'OK'
call flush_receive 'echo'
call send dialstring || cr
call waitfor 'CONNECT', 40 
if RC = 1
   then
   do
      say 'Wahlwiederholung in 40 Sekunden'
      call flush_receive
      call send 'ath' || cr
      call waitfor 'OK' ; call flush_receive 'echo'
      SIGNAL dial_in_loop
   end

/* T-Online login procedure: select vt100 line discicpline */
call flush_receive 'echo'
zeit = Time('S')
do until Time('S') > zeit+1
end

call send '.' || cr
call flush_receive 'echo'

/* T-Online login procedure: enter identification data */
call waitfor 'kennung:', 30 
if RC = 1 then SIGNAL Failure
call flush_receive 'echo'

call send kennung 
call waitfor 'L120', 5
/* in case Anschlu is teilnehmerfreizgig, we must enter Teilnehmer */
if RC = 1 then call send teilnehmer

call waitfor 'Mitbenutzer', 5
if RC = 1 then SIGNAL Failure
call flush_receive 'echo'

call send mitbenutzer
call waitfor '1', 5 
if RC = 1 then SIGNAL Failure
call flush_receive 'echo'

call send passwort
call waitfor 'L200', 10 
if RC = 1 then
do
/* Keine Telekom-Seite; Container-Seite? */
        if lastpos("34561",waitfor_buffer)=0 then
/* Nein */
                SIGNAL Failure
end
call flush_receive 'echo'

control_c   = "03"x
regpage     = control_c || "190144200#"
gatewaypage = control_c || "190144100#"

/* Check if registration is necessary */
if stream( regfile, 'command', 'query exists') = '' then
do
   call send regpage
   call waitfor 'Absenden'

   zeit = Time('S')
   do until Time('S') > zeit+1
   end

   call flush_receive 'echo'

   call send '19'
   call waitfor 'beendet', 10
   if RC=1 then SIGNAL FailureER

   call flush_receive 'echo'
end

/* T-Online login procedure: enter X.29 gateway */
call send gatewaypage
call waitfor 'ER-Verb.'

call waitfor 'SH'
parse var waitfor_buffer minuteprice 'J' .
minuteprice = left( minuteprice, 13 )
say 'Kosten:'minuteprice

minutepriceold = linein( price, 1, 1 )
minutepriceold = left( minutepriceold, 13 )
call stream price, "C", "Close"

if minutepriceold \= minuteprice then
do
   title = "T-Online Gebhreninformation"
   message = newline                                           ||,
      "Fr das Internet betrgt der Zeittakt"minuteprice". "   ||,
      newline || newline                                       ||,
      "Hinzu kommt der T-Online Zeittakt von 0,02 DM/Min. "    ||,
      "An Werktagen von 8-18 Uhr erhht sich der T-Online "    ||,
      "Zeittakt um 0,04 DM/Min. "                              ||,
      newline || newline                                       ||,
      "Soll dieser Hinweis beim nchsten Login wieder gezeigt "||,
      "werden? Falls Sie die Frage mit NEIN beantworten, so "  ||,
      "bekommen Sie diese Information erst wieder bei einer "  ||,
      "Tarifnderung angezeigt. "                              ||,
      newline || newline

   buttons = "YesNoCancel"
   infosym = "Information"
   action  = RxMessageBox( message, title, buttons, infosym )

   if action = 2 /* Cancel */ then exit 1

   if action = 6 /* Yes */ then do
      call lineout price, "0", 1
      call stream  price, "C", "Close"
   end
   if action = 7 /* No */ then do
      call lineout price, minuteprice, 1
      call stream  price, "C", "Close"
   end
end

call send '19'
call waitfor 'STATUS ', 10
if RC=1 then SIGNAL FailureER

call waitfor crlf
parse var waitfor_buffer a ' ' challenge '0d0a'x
if a \= 'OK' then do
  say 'Fehler: ' a
  exit 1
end

/* Send Identification String */
crypt 'Encode'  challenge '| RXQUEUE'
parse pull response

call send "OS2 4 "|| response || cr

call waitfor crlf
parse var waitfor_buffer a '0d0a'x
if a \= 'OK' then do
  say 'Fehler: ' a
  exit 1
end

do forever
  call waitfor crlf
  parse var waitfor_buffer a ' ' b '0d0a'x

  if a = '.' || '0d0a'x then leave
  call SysIni tcpos2, gate, a, b || '0'x
end

do forever
  call waitfor crlf
  parse var waitfor_buffer a ' ' b '0d0a'x

  if a = '.' || '0d0a'x then leave

  select
    when a = 'MSG' then 
       do 
       title = 'T-Online Hinweis'
       message = b
       call InfoMessage
       end
    when a = 'DOREG'   then 'del' regfile
    when a = 'DONTREG' then call lineout regfile
    otherwise  /* Ignore */
  end
end

call send 'OK' || cr

parse value SysIni( tcpos2, gate, 'YOURIP' ) with yourip  '0'x
parse value SysIni( tcpos2, gate, 'DESTIP' ) with destip  '0'x
parse value SysIni( tcpos2, gate, 'NETMASK') with netmask '0'x

'ifconfig sl0' yourip destip 'netmask' netmask
'route add default' destip '1'

say "Connected to T-Online Internet Access"
say "Eigene Adresse = "yourip", Gateway-Rechner = "destip

exit 0  /* Success */

/* Failure */
Failure:
title = 'T-Online Hinweis'
message =,
'Bei der Eingabe der Zugangsdaten ist ein Fehler aufgetreten',
'Bitte berprfen Sie Ihre Zugangsdaten im T-Online Dialer Setup'
call InfoMessage
exit 1

/* FailureER */
FailureER:
title='T-Online Hinweis'
message =,
'Der Verbindungsaufbau zum externen Rechner ist derzeit nicht',
'mglich. Bitte versuchen Sie es spter noch einmal.'
call InfoMessage
exit 1

/*********************************************************************
/
/  The routine 'send' sends a character string off to the modem.
/
*********************************************************************/

send:
   parse arg sendstring

   call slip_com_output interface , sendstring
return

/*********************************************************************
/
/  The routine 'waitfor' waits for the passed string to show up
/  in the COM input.  All input from the time this function is
/  called until the string shows up in the input is accumulated
/  in the 'waitfor_buffer' variable.
/
/  If timeout is specified, it says how long to wait
/  if data stops showing up on the COM port (in seconds).
/
*********************************************************************/

waitfor:

   parse arg waitstring, timeout

   if timeout = "" then  /* if no delay specified */
      timeout = 5000     /* then wait for L O N G */

   if remain_buffer = "REMAIN_BUFFER" then
      remain_buffer = ""

   waitfor_buffer = ""
   curpos = 1

   elapsed_time = time("E")  /* Reset */

   done = -1
   do while done = -1

      if remain_buffer \= "" then do
         line = remain_buffer
         remain_buffer = ""
      end
      else  /* Get next input characters */
         line = slip_com_input( interface, , 10 )

      /* Search expected string in received input
      */
      waitfor_buffer = waitfor_buffer || line
      index = pos( waitstring, waitfor_buffer )
      if index > 0 then do
         beyond = index + length( waitstring )
         remain_buffer  = substr( waitfor_buffer, beyond )
         waitfor_buffer = delstr( waitfor_buffer, beyond )
         done = 0  /* found expected string */
      end

      /* Echo input (but nothing beyond expected string)
      */
      call charout , substr( waitfor_buffer, curpos )
      curpos = length( waitfor_buffer ) + 1

      if (done \= 0) & (time("E") > timeout) then
         done = 1  /* timed out */
   end

   timeout = 0
   rc = done
return  done

/*********************************************************************
/
/  The routine 'flush_receive' flushes any pending characters
/  to be read from the COM port. It reads everything it can until
/  nothing new shows up for 100ms, at which point it returns.
/
/  The optional echo argument says to echo flushed information,
/  if a value is passed for this argument.
/
*********************************************************************/

flush_receive:

   parse arg echo

   /* If echoing the flush take care of waitfor remaining buffer
   */
   if (echo \= "") & (length( remain_buffer ) > 0) then do
      call charout , remain_buffer
      remain_buffer = ""
   end

   /* Eat anything left in the modem or COM buffers.
      Stop when nothing new appears for 100ms.
   */
   do until line = ""
      line = slip_com_input( interface, , 100 )
      if echo \= "" then call charout , line
   end

return

/*********************************************************************
/
/  The procedure 'ReadDxJDial' reads the file DXJDIAL.INI and
/  transforms the settings made in that file into values of
/  globally accessible variables.
/
/  DXJDIAL.INI is assumed to reside in the Telekom directory
/  which is a subdirectory of the base directory where the IBM
/  Internet Connection is installed.
/
*********************************************************************/

ReadDxJDial:

   procedure expose,
      account password user_no co_user_no,
      comport_no modem_init_0 modem_init_1,
      dial_prefix default_node fast_node,
      dxjdial crypt regfile

   /* Preserve compatibility with v1.0 INI file format
   */
   exchange_0 = ""
   exchange_1 = ""

   /* Read the contents of the INI file
   */
   do while lines( dxjdial ) > 0
      parse value linein( dxjdial ) with keyword "=" value
      value = strip( value )  /* Strip leading/trailing blanks */
      select
         when keyword = "Account"     then account      = value
         when keyword = "UserNo"      then user_no      = value
         when keyword = "CoUserNo"    then co_user_no   = value
         when keyword = "Password"    then password     = value
         when keyword = "ComPortNo"   then comport_no   = value
         when keyword = "ModemInit_0" then modem_init_0 = value
         when keyword = "ModemInit_1" then modem_init_1 = value
         when keyword = "DialPrefix"  then dial_prefix  = value
         when keyword = "DefaultNode" then default_node = value
         when keyword = "FastNode"    then fast_node    = value
         when keyword = "Exchange_0"  then exchange_0   = value
         when keyword = "Exchange_1"  then exchange_1   = value
         otherwise  /* Ignore */
      end
   end
   call stream dxjdial, "C", "Close"

   /* Decode the encoded password
   */
   if password <> "" then do
      crypt "Decode" password "| RXQUEUE"
      parse pull password
      password = x2c( password )
   end

   /* Prefix telephone numbers with exchange codes
   */
   default_node = exchange_0 || default_node
   fast_node    = exchange_1 || fast_node

return

/*********************************************************************
/
/  The procedure 'InfoMessage' displays a message box and offers
/  the buttons 'Ok' and 'Abbruch'.  While 'Ok' continues REXX
/  command file execution, 'Abbruch' terminates it.
/
*********************************************************************/

InfoMessage:

   buttons = "OkCancel"
   infosym = "Information"
   action  = RxMessageBox( message, title, buttons, infosym )
   if action = 2 /* Cancel */ then exit 1
   
return

/*********************************************************************
/
/  The routine 'FatalError' displays a message box and offers
/  the button 'OK' which aborts REXX command file execution.
/
*********************************************************************/

FatalError:

   buttons = "Ok"
   infosym = "Error"
   call RxMessageBox message, title, buttons, infosym
   exit 1  /* Failure */
   
return
