/* LOADVR.CMD, Version 1.2 */
/* Internet Access via T-Online */
/* Copyright (c) 1995 1&1 Telekommunikation GmbH */

call RxFuncAdd "SysOS2Ver",       "RexxUtil", "SysOS2Ver"
call RxFuncAdd "RxMessageBox",    "RexxUtil", "RxMessageBox"
call RxFuncAdd "SysTempFileName", "RexxUtil", "SysTempFileName"
call RxFuncAdd "SysDriveInfo",    "RexxUtil", "SysDriveInfo"

newline   = "0A"x  /* Line feed */
paragraph = newline || newline
title     = "T-Online Installation"

copyright = "Version 1.2"newline ||,
   "Copyright (c) 1995 1&1 Telekommunikation GmbH"paragraph

error_header = "Fehler! " ||,
   "Die Installation mu vorzeitig abgebrochen werden."paragraph

/*********************************************************************
/   At least OS/2 Warp Version 3.0 is required
*********************************************************************/

os2_version = SysOS2Ver()
parse var os2_version . '.' os2_version

if os2_version < 30 then do
   message = copyright                                       ||,
      "Die Installation kann mit Ihrer aktuellen OS/2 "      ||,
      "Version leider nicht durchgefhrt werden. Sie setzen "||,
      "eine OS/2 Version ein, die lter ist als OS/2 Warp "  ||,
      "Version 3.0. "                                        ||,
      paragraph
   
   call FatalError
end

/*********************************************************************
/  Determine source directory and boot drive
*********************************************************************/

parse upper source . . this_cmd

diskette = strip( ,
   filespec( "drive", this_cmd ) ||,
   filespec( "path",  this_cmd ),,
   "trailing", "\" )

address cmd "@ECHO OFF"
address cmd diskette"\BOOTDRV.EXE /NUMBER"

letter = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
root   = substr( letter, rc, 1 ) || ":"

/*********************************************************************
/  Welcome customer with an introductory message
*********************************************************************/

message = copyright                                      ||,
   "Sie beginnen nun mit der Installation des Internet " ||,
   "Zugangs ber T-Online. Dabei werden zunchst 2 "     ||,
   "Dateien aus dem Verzeichnis" diskette "auf die "     ||,
   "Festplatte" root "kopiert. "                         ||,
   paragraph                                             ||,
   "Obwohl diese Dateien nur zeitweise bentigt werden, "||,
   "kann der Kopiervorgang bis zu einer Minute dauern. " ||,
   "Warten Sie also nach dem Quittieren dieser Meldung, "||,
   "bis Ihnen der Start der eigentlichen Installation "  ||,
   "durch eine weitere Meldung mitgeteilt wird. "        ||,
   paragraph

call InfoMessage

/*********************************************************************
/  Find or create temporary directory
*********************************************************************/

temp_dir_created = 0
temp_dir = value( "TMP",,"OS2ENVIRONMENT" )

if temp_dir = "" then
   temp_dir = value( "TEMP",,"OS2ENVIRONMENT" )

if temp_dir = "" then do
   temp_dir = SysTempFileName( root"\TEMP????" )

   if temp_dir <> "" then do
      address cmd "MKDIR" temp_dir

      if rc = 0
      then temp_dir_created = 1
      else temp_dir = ""
   end
end

if temp_dir = "" |,
   \DirectoryExists( temp_dir )
then do
   message = error_header                                  ||,
      "Ein geeignetes Verzeichnis fr die nur zeitweise "  ||,
      "bentigten Dateien konnte weder gefunden noch auf " ||,
      "Ihrem Bootlaufwerk" root "neu eingerichtet werden. "||,
      paragraph                                            ||,
      "Erzeugen Sie ein solches Verzeichnis, und setzen "  ||,
      "Sie die Umgebungsvariable TEMP in der CONFIG.SYS "  ||,
      "auf dieses Verzeichnis. Wiederholen Sie dann die "  ||,
      "Installation noch einmal. "                         ||,
      paragraph
   
   call FatalError
end

/*********************************************************************
/  Check for sufficient free space
*********************************************************************/

drive_info = SysDriveInfo( root )
parse var drive_info . bytes_available .

mega_required  = 2
bytes_required = mega_required * 1048576

if bytes_available < bytes_required then do
   message = error_header                                ||,
      "Auf dem Laufwerk" root "ist nicht mehr gengend " ||,
      "freier Platz verfgbar. Die zeitweise bentigten "||,
      "Dateien beanspruchen rund" mega_required "MB. "   ||,
      paragraph
   
   call FatalError
end

/*********************************************************************
/  Perform the main installation tasks
*********************************************************************/

call CopyTempFile diskette"\UNZIP.EXE"
call CopyTempFile diskette"\VRINST.ZIP"

address cmd temp_dir"\UNZIP -qq" temp_dir"\VRINST -d" temp_dir

address cmd "DEL" temp_dir"\VRINST.ZIP"

address cmd "SET BEGINLIBPATH="temp_dir
address cmd temp_dir"\VRINST" diskette root
address cmd "SET BEGINLIBPATH="

address cmd "DEL" temp_dir"\VRINST.EXE"
address cmd "DEL" temp_dir"\VROBJ.DLL"
address cmd "DEL" temp_dir"\UNZIP.EXE"

if temp_dir_created = 1 then
   address cmd "RMDIR" temp_dir

exit

/*********************************************************************
/
/  The procedure 'DirectoryExists' returns 1 if the specified
/  directory exists, 0 otherwise. A pathname with a trailing
/  backslash is accepted.
/
*********************************************************************/

DirectoryExists: procedure

   parse arg dir

   if length( dir ) > 3 then
      dir = strip( dir, "trailing", "\" )
   /* else root directory */

   current_dir = directory()
   checked_dir = directory( dir )
   current_dir = directory( current_dir )

return checked_dir <> ""

/*********************************************************************
/
/  The routine 'CopyTempFile' copies the passed file into the
/  directory specified by the global variable 'tem_dir'. If an
/  errors occurs, a message is displayed and REXX command file
/  execution is aborted.
/
*********************************************************************/

CopyTempFile:

   parse arg file

   address cmd "COPY" file temp_dir" >NUL"

   if rc <> 0 then do
      message = error_header                                ||,
         "Die Datei" file "konnte nicht in das Verzeichnis "||,
         temp_dir "kopiert werden. "                        ||,
         paragraph                                          ||,
         "Stellen Sie sicher, da sich die genannte Datei " ||,
         "nicht im Zugriff anderer Anwendungen befindet. "  ||,
         paragraph
   
      call FatalError
   end

return

/*********************************************************************
/
/  The routine 'InfoMessage' displays a message box and offers
/  the buttons 'OK' and 'Abbruch'.  While 'OK' continues REXX
/  command file execution, 'Abbruch' terminates it.
/
*********************************************************************/

InfoMessage:

   buttons = "OkCancel"
   infosym = "Information"
   action  = RxMessageBox( message, title, buttons, infosym )
   if action = 2 /* Cancel */ then exit
   
return

/*********************************************************************
/
/  The routine 'FatalError' displays a message box and offers
/  the button 'OK' which aborts REXX command file execution.
/
*********************************************************************/

FatalError:

   buttons = "Ok"
   infosym = "Error"
   call RxMessageBox message, title, buttons, infosym
   exit  /* Abort */
   
return
