/***************************************************************************
 * PIPE.CMD 
 * Stand: 28.9.2000
 *
 * Aenderungen: 28.09.2000  - Tobias.Grimm@gmx.de (Neue Kommandos)
 *              
****************************************************************************/
call RxFuncAdd 'SysSleep','RexxUtil','SysSleep'
call RxFuncAdd 'SysLoadFuncs','RexxUtil','SysLoadFuncs'
call SysLoadFuncs

/******************************************************************************/
/*                                                                            */
/*      there are some commands which can be send to 'isdnPm' over            */
/*      a named PIPE ("\PIPE\ISDNPM30\CPIPE                                   */
/*                                                                            */
/*      'CMD=AUTH UID=User Pwd=password': Authentificate connection           */
/*                                        must be the first command after     */
/*                                        connection                          */
/*                                                                            */
/*      'CMD=VERSION'                   : query for Version                   */
/*      'CMD=CHANNELS'                  : query numer of channels             */
/*      'CMD=USERLIST                   : query users (only outgoing)         */
/*                                                                            */
/*      'CMD=CONNECT NAME="onnx"'       : connect to 'connx'                  */
/*      'CMD=CALLBYCALL' CONN="xxx"'    : connect to xxx                      */
/*      'CMD=DISCONNECT NAME="connx"'   : disconnect 'connx'                  */
/*      'CMD=DISCONNECT CHANNEL=n'      : disconnect channel n (1,2...)       */
/*      'CMD=DISCONNECT CHANNEL=0'      : disconnect all channels             */
/*      'CMD=STATUSLOW  CHANNEL=n'      : query status of ISDN-Channel n      */
/*      'CMD=STATUSHIGH CHANNEL=n'      : query status of IP-Channel   n      */
/*                                                                            */
/*      'CMD=AUTOMODE'                  : query AUTODIALMODE                  */
/*      'CMD=AUTOMODE LEVEL=0'          : set AUTODIALMODE OFF                */
/*      'CMD=AUTOMODE LEVEL=1'          : set AUTODIALMODE ON                 */
/*      'CMD=MULTIMODE                  : query MULTILINKMODE                 */
/*      'CMD=MULTIMODE LEVEL=0'         : set MULTILINKMODE OFF               */
/*      'CMD=MULTIMODE LEVEL=1'         : set MULTILINKMODE ON                */
/*                                                                            */
/*      'CMD=UPDATE'                    : update all connections from file    */
/*                                                                            */
/*      'CMD=EXIT'                      : disconnect from PIPE                */
/*                                                                            */
/*      'CMD=SHUTDOWN'                  : shutdown Isdnpm (with returncode 1) */
/*      'CMD=RESTART VAL=n'             : shutdown Isdnpm (with returncode 2) */
/*                                        the parameter VAL is not used yet   */
/*                                                                            */
/*      all unknown commands return 'RC=1'                                    */
/*                                                                            */
/*      Version is returned with :                                            */
/*                                                                            */
/*          'RC=0 VERSION="xxxxxxxxx"'                                        */
/*                                                                            */
/*      Channels are returned with :                                          */
/*                                                                            */
/*          'RC=0 CHANNELS=n'                                                 */
/*                                                                            */
/*      Userlist is returned with :                                           */
/*          'RC=0  CN="Name" CI="Info" ON="Number" CN=........'               */
/*                                                                            */
/*      Autodialmode is returned with :                                       */
/*                                                                            */
/*          'RC=0 AUTOMODE=n'                                                 */
/*                                                                            */
/*      Multilinkmode is returned with :                                      */
/*                                                                            */
/*          'RC=0 MULTIMODE=n'                                                */
/*                                                                            */
/*      Channelstatus is returned with :                                      */
/*                                                                            */
/*          'RC=0 STATUS=s NAME="name" MSG="msg" ERR="err"      ...           */
/*          ...     TxB=transbytes RxB=recbytes ....                          */
/*          ...     TxP=transpaket RxP=recpaket ....                          */
/*          ...     TxR=transrate  RxR=recrate  ....                          */
/*          ...     TT=connectiontime                                         */
/*                  IPA="ipaddress"                                           */
/*                                                                            */
/*          Stat 's'  : 0 means DOWN                                          */
/*          Stat 's'  : 1 means CONNECTED (isdn)                              */
/*          Stat 's'  : 2 means OPEN (ip)                                     */
/*          Stat 's'  : 3 means connection established                        */
/*                                                                            */
/******************************************************************************/

CRLF='0d0a'x



PIPE = "\PIPE\ISDNPM30\CPIPE"

    say SendCommandAndWait("cmd=auth uid=PipeUser pwd=PipePW"||CRLF)

    cbc = 'CMD=CALLBYCALL CONN="'
    cbc = cbc || ' \n'
    cbc = cbc || ' Name : c1\n'
    cbc = cbc || ' Cpn  : 076129876543\n'
    cbc = cbc || ' Profile  : PPP_SYNC\n'
    cbc = cbc || ' Userid   : xxxx\n'
    cbc = cbc || ' Password : xxxxxxxx\n'
    cbc = cbc || ' \n"'

    say SendCommandAndWAit(cbc||CRLF)


    count = 0
    do while count < 1
        say SendCommandAndWAit("CMD=STATUSHIGH CHANNEL=1"||CRLF)
        say SendCommandAndWAit("CMD=STATUSLOW  CHANNEL=1"||CRLF)
        count = count + 1
    end

    say SendCommandAndWAit("CMD=EXIT"||CRLF)

exit 0
/**************************************************************************/
/* send a command to the PIPE and wait for an answer                      */
/**************************************************************************/
SendCommandAndWait:
parse arg Command

    say Command

    rc = SysWaitNamedPipe(PIPE,5000)
    if( rc = 0 )then do

        rc = charout(PIPE,Command)
        cnt = 0
        do while cnt == 0
          cnt = chars(PIPE)
        end
        in = LineIn(PIPE)
        return in
    end
    else
        return "TIMEOUT"

