/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.border.EtchedBorder;

public class Channel
extends JPanel {
    private int _rxMax0;
    private int _txMax0;
    private int _rxMax1;
    private int _txMax1;
    private static Icon[][] _icons = null;
    private JPanel linePanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JProgressBar pbRxProgress0;
    private JProgressBar pbTxProgress0;
    private JLabel lbRxRate0;
    private JLabel lbTxRate0;
    private JLabel lbRxBytes0;
    private JLabel lbTxBytes0;
    private JLabel lbTime0;
    private JButton btnHangup;
    private JPanel ipPanel;
    private JLabel jLabel9;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JProgressBar pbRxProgress1;
    private JProgressBar pbTxProgress1;
    private JLabel lbRxRate1;
    private JLabel lbTxRate1;
    private JLabel lbRxBytes1;
    private JLabel lbTxBytes1;
    private JLabel lbIP;

    public Channel(ActionListener actionListener) {
        this.initComponents();
        this.btnHangup.addActionListener(actionListener);
        this._rxMax0 = 0;
        this._txMax0 = 0;
        this._rxMax1 = 0;
        this._txMax1 = 0;
        if (_icons == null) {
            _icons = new Icon[3][3];
            Channel._icons[0][0] = new ImageIcon(this.getClass().getResource("images/red_red.gif"));
            Channel._icons[0][1] = new ImageIcon(this.getClass().getResource("images/red_yellow.gif"));
            Channel._icons[0][2] = new ImageIcon(this.getClass().getResource("images/red_green.gif"));
            Channel._icons[1][0] = new ImageIcon(this.getClass().getResource("images/yellow_red.gif"));
            Channel._icons[1][1] = new ImageIcon(this.getClass().getResource("images/yellow_yellow.gif"));
            Channel._icons[1][2] = new ImageIcon(this.getClass().getResource("images/yellow_green.gif"));
            Channel._icons[2][0] = new ImageIcon(this.getClass().getResource("images/green_red.gif"));
            Channel._icons[2][1] = new ImageIcon(this.getClass().getResource("images/green_yellow.gif"));
            Channel._icons[2][2] = new ImageIcon(this.getClass().getResource("images/green_green.gif"));
        }
    }

    public void setStatus(Status status, Status status2) {
        DecimalFormat decimalFormat = new DecimalFormat("###,###,###,###");
        JTabbedPane jTabbedPane = (JTabbedPane)this.getRootPane().getContentPane().getComponent(0);
        int n = jTabbedPane.indexOfComponent(this);
        String string = status.getName();
        if (string.equals("")) {
            string = "Channel " + String.valueOf(n);
        }
        jTabbedPane.setTitleAt(n, string);
        int n2 = 0;
        int n3 = 0;
        if (status.isDown()) {
            n3 = 0;
            this.btnHangup.setEnabled(false);
        } else {
            this.btnHangup.setEnabled(true);
        }
        if (status.isConnected() || status.isOpen()) {
            n3 = 1;
        }
        if (status.isEstablished()) {
            n3 = 2;
        }
        if (status2.isDown()) {
            n2 = 0;
        }
        if (status2.isConnected() || status2.isOpen()) {
            n2 = 1;
        }
        if (status2.isEstablished()) {
            n2 = 2;
        }
        jTabbedPane.setIconAt(n, _icons[n3][n2]);
        this.linePanel.setToolTipText("Message: " + status.getMessage() + " Error: " + status.getError());
        this.lbTime0.setText(this.formatSeconds(String.valueOf(status.getTime())));
        this.lbRxRate0.setText(decimalFormat.format(status.getRXRate()));
        this.lbTxRate0.setText(decimalFormat.format(status.getTXRate()));
        this.lbRxBytes0.setText(decimalFormat.format(status.getRXBytes()));
        this.lbTxBytes0.setText(decimalFormat.format(status.getTXBytes()));
        if (status.getRXRate() > this._rxMax0) {
            this._rxMax0 = status.getRXRate();
            this.pbRxProgress0.setMaximum(this._rxMax0);
        }
        this.pbRxProgress0.setValue(status.getRXRate());
        if (status.getTXRate() > this._txMax0) {
            this._txMax0 = status.getTXRate();
            this.pbTxProgress0.setMaximum(this._txMax0);
        }
        this.pbTxProgress0.setValue(status.getTXRate());
        if (status2.getAddress().getHostAddress().equals("127.0.0.1")) {
            this.lbIP.setText(null);
        } else {
            this.lbIP.setText(status2.getAddress().getHostAddress());
        }
        this.lbRxRate1.setText(decimalFormat.format(status2.getRXRate()));
        this.lbTxRate1.setText(decimalFormat.format(status2.getTXRate()));
        this.lbRxBytes1.setText(decimalFormat.format(status2.getRXBytes()));
        this.lbTxBytes1.setText(decimalFormat.format(status2.getTXBytes()));
        if (status2.getRXRate() > this._rxMax1) {
            this._rxMax1 = status2.getRXRate();
            this.pbRxProgress1.setMaximum(this._rxMax1);
        }
        this.pbRxProgress1.setValue(status2.getRXRate());
        if (status2.getTXRate() > this._txMax1) {
            this._txMax1 = status2.getTXRate();
            this.pbTxProgress1.setMaximum(this._txMax1);
        }
        this.pbTxProgress1.setValue(status2.getTXRate());
    }

    private String formatSeconds(String string) {
        DecimalFormat decimalFormat = new DecimalFormat("##00");
        int n = Integer.parseInt(string);
        int n2 = n / 3600;
        int n3 = (n %= 3600) / 60;
        return decimalFormat.format(n2) + ':' + decimalFormat.format(n3) + ':' + decimalFormat.format(n %= 60);
    }

    private void initComponents() {
        this.linePanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.pbRxProgress0 = new JProgressBar();
        this.pbTxProgress0 = new JProgressBar();
        this.lbRxRate0 = new JLabel();
        this.lbTxRate0 = new JLabel();
        this.lbRxBytes0 = new JLabel();
        this.lbTxBytes0 = new JLabel();
        this.lbTime0 = new JLabel();
        this.btnHangup = new JButton();
        this.ipPanel = new JPanel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.pbRxProgress1 = new JProgressBar();
        this.pbTxProgress1 = new JProgressBar();
        this.lbRxRate1 = new JLabel();
        this.lbTxRate1 = new JLabel();
        this.lbRxBytes1 = new JLabel();
        this.lbTxBytes1 = new JLabel();
        this.lbIP = new JLabel();
        this.setLayout(new GridLayout(2, 1, 5, 0));
        this.setPreferredSize(new Dimension(413, 70));
        this.setMinimumSize(new Dimension(640, 480));
        this.setBackground(Color.lightGray);
        this.setFont(new Font("Dialog", 0, 10));
        this.linePanel.setLayout(new GridBagLayout());
        this.linePanel.setPreferredSize(new Dimension(413, 34));
        this.linePanel.setBorder(new EtchedBorder());
        this.jLabel1.setPreferredSize(new Dimension(45, 10));
        this.jLabel1.setMinimumSize(new Dimension(45, 10));
        this.jLabel1.setText("Line");
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setFont(new Font("Dialog", 1, 12));
        this.jLabel1.setMaximumSize(new Dimension(45, 10));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 1, 5);
        this.linePanel.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setPreferredSize(new Dimension(20, 10));
        this.jLabel2.setMinimumSize(new Dimension(20, 10));
        this.jLabel2.setText("Rx:");
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setFont(new Font("Dialog", 0, 10));
        this.jLabel2.setMaximumSize(new Dimension(20, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 1, 5);
        gridBagConstraints.anchor = 17;
        this.linePanel.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setPreferredSize(new Dimension(20, 10));
        this.jLabel3.setMinimumSize(new Dimension(20, 10));
        this.jLabel3.setText("Tx:");
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setFont(new Font("Dialog", 0, 10));
        this.jLabel3.setMaximumSize(new Dimension(20, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(1, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        this.linePanel.add((Component)this.jLabel3, gridBagConstraints);
        this.pbRxProgress0.setMinimumSize(new Dimension(100, 10));
        this.pbRxProgress0.setMaximum(0);
        this.pbRxProgress0.setMaximumSize(new Dimension(Short.MAX_VALUE, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 1, 5);
        gridBagConstraints.anchor = 17;
        this.linePanel.add((Component)this.pbRxProgress0, gridBagConstraints);
        this.pbTxProgress0.setMinimumSize(new Dimension(100, 10));
        this.pbTxProgress0.setMaximum(0);
        this.pbTxProgress0.setMaximumSize(new Dimension(Short.MAX_VALUE, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(1, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        this.linePanel.add((Component)this.pbTxProgress0, gridBagConstraints);
        this.lbRxRate0.setPreferredSize(new Dimension(34, 10));
        this.lbRxRate0.setMinimumSize(new Dimension(34, 10));
        this.lbRxRate0.setText("9,99 k");
        this.lbRxRate0.setFont(new Font("Dialog", 0, 10));
        this.lbRxRate0.setMaximumSize(new Dimension(34, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 1, 5);
        gridBagConstraints.anchor = 17;
        this.linePanel.add((Component)this.lbRxRate0, gridBagConstraints);
        this.lbTxRate0.setPreferredSize(new Dimension(34, 10));
        this.lbTxRate0.setMinimumSize(new Dimension(34, 10));
        this.lbTxRate0.setText("9,99 k");
        this.lbTxRate0.setFont(new Font("Dialog", 0, 10));
        this.lbTxRate0.setMaximumSize(new Dimension(34, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(1, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        this.linePanel.add((Component)this.lbTxRate0, gridBagConstraints);
        this.lbRxBytes0.setPreferredSize(new Dimension(100, 10));
        this.lbRxBytes0.setMinimumSize(new Dimension(70, 10));
        this.lbRxBytes0.setText("99.999,99 MB");
        this.lbRxBytes0.setFont(new Font("Dialog", 0, 10));
        this.lbRxBytes0.setMaximumSize(new Dimension(100, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 1, 5);
        gridBagConstraints.anchor = 17;
        this.linePanel.add((Component)this.lbRxBytes0, gridBagConstraints);
        this.lbTxBytes0.setPreferredSize(new Dimension(100, 10));
        this.lbTxBytes0.setMinimumSize(new Dimension(70, 10));
        this.lbTxBytes0.setText("99.999,99 MB");
        this.lbTxBytes0.setFont(new Font("Dialog", 0, 10));
        this.lbTxBytes0.setMaximumSize(new Dimension(100, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(1, 5, 0, 5);
        gridBagConstraints.anchor = 17;
        this.linePanel.add((Component)this.lbTxBytes0, gridBagConstraints);
        this.lbTime0.setPreferredSize(new Dimension(45, 10));
        this.lbTime0.setMinimumSize(new Dimension(45, 10));
        this.lbTime0.setText("99:99:99");
        this.lbTime0.setHorizontalAlignment(0);
        this.lbTime0.setFont(new Font("Dialog", 0, 10));
        this.lbTime0.setMaximumSize(new Dimension(45, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(1, 0, 0, 5);
        this.linePanel.add((Component)this.lbTime0, gridBagConstraints);
        this.btnHangup.setPreferredSize(new Dimension(95, 25));
        this.btnHangup.setToolTipText("Hangup this line");
        this.btnHangup.setLabel("Hangup");
        this.btnHangup.setMaximumSize(new Dimension(95, 25));
        this.btnHangup.setFont(new Font("Dialog", 0, 10));
        this.btnHangup.setMargin(new Insets(0, 0, 0, 0));
        this.btnHangup.setMinimumSize(new Dimension(95, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        this.linePanel.add((Component)this.btnHangup, gridBagConstraints);
        this.add(this.linePanel);
        this.ipPanel.setLayout(new GridBagLayout());
        this.ipPanel.setPreferredSize(new Dimension(413, 34));
        this.ipPanel.setBorder(new EtchedBorder());
        this.jLabel9.setPreferredSize(new Dimension(45, 10));
        this.jLabel9.setMinimumSize(new Dimension(45, 10));
        this.jLabel9.setText("IP");
        this.jLabel9.setHorizontalAlignment(0);
        this.jLabel9.setFont(new Font("Dialog", 1, 12));
        this.jLabel9.setMaximumSize(new Dimension(45, 10));
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(0, 0, 1, 5);
        this.ipPanel.add((Component)this.jLabel9, gridBagConstraints2);
        this.jLabel10.setPreferredSize(new Dimension(20, 10));
        this.jLabel10.setMinimumSize(new Dimension(20, 10));
        this.jLabel10.setText("Rx:");
        this.jLabel10.setHorizontalAlignment(4);
        this.jLabel10.setFont(new Font("Dialog", 0, 10));
        this.jLabel10.setMaximumSize(new Dimension(20, 10));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(0, 5, 1, 5);
        gridBagConstraints2.anchor = 17;
        this.ipPanel.add((Component)this.jLabel10, gridBagConstraints2);
        this.jLabel11.setPreferredSize(new Dimension(20, 10));
        this.jLabel11.setMinimumSize(new Dimension(20, 10));
        this.jLabel11.setText("Tx:");
        this.jLabel11.setHorizontalAlignment(4);
        this.jLabel11.setFont(new Font("Dialog", 0, 10));
        this.jLabel11.setMaximumSize(new Dimension(20, 10));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(1, 5, 0, 5);
        gridBagConstraints2.anchor = 17;
        this.ipPanel.add((Component)this.jLabel11, gridBagConstraints2);
        this.pbRxProgress1.setMinimumSize(new Dimension(100, 10));
        this.pbRxProgress1.setMaximum(0);
        this.pbRxProgress1.setMaximumSize(new Dimension(Short.MAX_VALUE, 10));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(0, 5, 1, 5);
        gridBagConstraints2.anchor = 17;
        this.ipPanel.add((Component)this.pbRxProgress1, gridBagConstraints2);
        this.pbTxProgress1.setMinimumSize(new Dimension(100, 10));
        this.pbTxProgress1.setMaximum(0);
        this.pbTxProgress1.setMaximumSize(new Dimension(Short.MAX_VALUE, 10));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(1, 5, 0, 5);
        gridBagConstraints2.anchor = 17;
        this.ipPanel.add((Component)this.pbTxProgress1, gridBagConstraints2);
        this.lbRxRate1.setPreferredSize(new Dimension(34, 10));
        this.lbRxRate1.setMinimumSize(new Dimension(34, 10));
        this.lbRxRate1.setText("9,99 k");
        this.lbRxRate1.setFont(new Font("Dialog", 0, 10));
        this.lbRxRate1.setMaximumSize(new Dimension(34, 10));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(0, 5, 1, 5);
        gridBagConstraints2.anchor = 17;
        this.ipPanel.add((Component)this.lbRxRate1, gridBagConstraints2);
        this.lbTxRate1.setPreferredSize(new Dimension(34, 10));
        this.lbTxRate1.setMinimumSize(new Dimension(34, 10));
        this.lbTxRate1.setText("9,99 k");
        this.lbTxRate1.setFont(new Font("Dialog", 0, 10));
        this.lbTxRate1.setMaximumSize(new Dimension(34, 10));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 3;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(1, 5, 0, 5);
        gridBagConstraints2.anchor = 17;
        this.ipPanel.add((Component)this.lbTxRate1, gridBagConstraints2);
        this.lbRxBytes1.setPreferredSize(new Dimension(100, 10));
        this.lbRxBytes1.setMinimumSize(new Dimension(70, 10));
        this.lbRxBytes1.setText("99.999,99 MB");
        this.lbRxBytes1.setFont(new Font("Dialog", 0, 10));
        this.lbRxBytes1.setMaximumSize(new Dimension(100, 10));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(0, 5, 1, 5);
        gridBagConstraints2.anchor = 17;
        this.ipPanel.add((Component)this.lbRxBytes1, gridBagConstraints2);
        this.lbTxBytes1.setPreferredSize(new Dimension(100, 10));
        this.lbTxBytes1.setMinimumSize(new Dimension(70, 10));
        this.lbTxBytes1.setText("99.999,99 MB");
        this.lbTxBytes1.setFont(new Font("Dialog", 0, 10));
        this.lbTxBytes1.setMaximumSize(new Dimension(100, 10));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 4;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(1, 5, 0, 5);
        gridBagConstraints2.anchor = 17;
        this.ipPanel.add((Component)this.lbTxBytes1, gridBagConstraints2);
        this.lbIP.setPreferredSize(new Dimension(95, 25));
        this.lbIP.setMinimumSize(new Dimension(95, 25));
        this.lbIP.setText("255.255.255.255");
        this.lbIP.setHorizontalAlignment(0);
        this.lbIP.setFont(new Font("Dialog", 0, 10));
        this.lbIP.setMaximumSize(new Dimension(95, 25));
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridheight = 2;
        gridBagConstraints2.insets = new Insets(0, 5, 0, 0);
        gridBagConstraints2.anchor = 17;
        this.ipPanel.add((Component)this.lbIP, gridBagConstraints2);
        this.add(this.ipPanel);
    }
}

