/*
 * Copyright (c) 1994 Frank Behrens
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*  $Log: rcpos2.c,v $
 * Revision 1.1  1994/09/09  00:00:00  frank
 * Initial revision
 *                                                       */

static const char rcsid[] = "$Id: rcpos2.c,v 1.1 1994/09/09 00:00:00 frank Rel $";


#include "rcpos2.h"
#include <sys/types.h>
#include <netdb.h>
#include <pwd.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <os2.h>

static
char    *h_errlist[] = {
        "Error 0",
        "Unknown host",                         /* 1 HOST_NOT_FOUND */
        "Host name lookup failure",             /* 2 TRY_AGAIN */
        "Unknown server error",                 /* 3 NO_RECOVERY */
        "No address associated with name",      /* 4 NO_ADDRESS */
        };

static
int     h_nerr = { sizeof(h_errlist)/sizeof(h_errlist[0]) };




struct passwd *getpwuid (int uid)

{
static struct passwd pw;
char *user;

memset (&pw, 0, sizeof (pw));

user = getenv ("USER");

pw.pw_name   = user ? strdup (user) : "os2user";
pw.pw_passwd = strdup ("");

return &pw;

}


int setuid (uid_t uid)

{
return 0;
}

int seteuid (uid_t uid)

{
return 0;
}


void convert_pathdelim (char *path, int to_dos)

{
while (*path)
   {
   if (to_dos)
      { if (*path == '/') *path = '\\'; }
   else
      { if (*path == '\\') *path = '/'; }
   path++;
   }
}


void alarmhandler (void)

{
exit (0);
}


void herror (char *msg)

{
if (msg)
   fprintf (stderr, "%s: ", msg);

fprintf (stderr, "%s\n", h_errno < h_nerr ?
         h_errlist[h_errno] : "Unknown error");

}
