/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import net.ibm.malamut.newsmail.Basis;
import net.ibm.malamut.newsmail.BasisConstants;
import net.ibm.malamut.newsmail.BasisShellInterface;
import net.ibm.malamut.newsmail.ConnectionData;
import net.ibm.malamut.newsmail.ErrorTools;
import net.ibm.malamut.newsmail.GroupEntry;
import net.ibm.malamut.newsmail.NNTPServer;
import net.ibm.malamut.newsmail.OptionsData;
import net.ibm.malamut.newsmail.POPServer;
import net.ibm.malamut.newsmail.SMTPServer;
import net.ibm.malamut.newsmail.Tools;
import net.ibm.malamut.newsmail.WindowData;
import net.ibm.malamut.newsmail.connections.NNTPControlConnection;
import net.ibm.malamut.newsmail.database.PopUserBase;
import net.ibm.malamut.newsmail.gateways.Gateway;
import net.ibm.malamut.newsmail.netcall.GatewayServer;
import net.ibm.malamut.newsmail.ui.AddServerListener;
import net.ibm.malamut.newsmail.ui.AdminPOPUserPanel;
import net.ibm.malamut.newsmail.ui.CleanUpChoicePanel;
import net.ibm.malamut.newsmail.ui.CommProgressWindow;
import net.ibm.malamut.newsmail.ui.CommThread;
import net.ibm.malamut.newsmail.ui.EditDomainListener;
import net.ibm.malamut.newsmail.ui.EditServerListener;
import net.ibm.malamut.newsmail.ui.ExitAdapter;
import net.ibm.malamut.newsmail.ui.GroupsListener;
import net.ibm.malamut.newsmail.ui.LabeledField;
import net.ibm.malamut.newsmail.ui.OptionsPanel;
import net.ibm.malamut.newsmail.ui.ProgressBarPanel;
import net.ibm.malamut.newsmail.ui.ServerPanel;
import net.ibm.malamut.newsmail.ui.ShellButtonListener;
import net.ibm.malamut.newsmail.ui.SortedListModel;
import net.ibm.malamut.newsmail.ui.WindowDataDefaultInterface;
import net.ibm.malamut.newsmail.ui.WindowDataDialog;
import net.ibm.malamut.newsmail.ui.WindowDataFrame;
import net.ibm.malamut.newsmail.ui.WindowDataInterface;
import net.ibm.malamut.newsmail.version.CommonConstants;

public final class Shell
extends JPanel
implements BasisConstants,
WindowDataInterface {
    private static int progressGranularity = 10;
    private JFrame frame;
    private BasisShellInterface basis = null;
    private CommThread commThread = new CommThread();
    private ServerPanel newsPanel;
    private ServerPanel popPanel;
    private ServerPanel smtpPanel;
    private ServerPanel gatewayPanel;
    private NNTPServer nntpServer;
    private SMTPServer smtpServer;
    private POPServer popServer;
    private boolean startupNNTP = false;
    private boolean startupPOP = false;
    private boolean startupSMTP = false;
    private boolean startupGate = false;
    private GatewayServer gatewayServer = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void addGroupsToNode(TreeNode treeNode, BufferedReader bufferedReader, ProgressBarPanel progressBarPanel, int n) {
        int n2 = Shell.progressGranularity();
        int n3 = 0;
        progressBarPanel.setArea(0, n);
        progressBarPanel.setText("Analyzing newsgroup list...");
        try {
            String string = bufferedReader.readLine();
            progressBarPanel.setValue(1);
            while (string != null) {
                int n4 = string.indexOf(" ");
                if (n4 != -1) {
                    Object object;
                    String string2 = string.substring(0, n4);
                    TreeNode treeNode2 = treeNode;
                    while ((n4 = string2.indexOf(".")) != -1) {
                        TreeNode treeNode3;
                        object = string2.substring(0, n4) + ".*";
                        string2 = string2.substring(n4 + 1);
                        Enumeration<? extends TreeNode> enumeration = treeNode2.children();
                        boolean bl = false;
                        while (enumeration.hasMoreElements()) {
                            treeNode3 = enumeration.nextElement();
                            if (!((String)object).equals(treeNode3.toString())) continue;
                            bl = true;
                            treeNode2 = treeNode3;
                        }
                        if (bl) continue;
                        treeNode3 = new DefaultMutableTreeNode(object);
                        ((DefaultMutableTreeNode)treeNode2).add((MutableTreeNode)treeNode3);
                        treeNode2 = treeNode3;
                    }
                    object = new GroupEntry(string2, string.charAt(string.length() - 1) == 'y');
                    ((DefaultMutableTreeNode)treeNode2).add(new DefaultMutableTreeNode(string2));
                }
                string = bufferedReader.readLine();
                if (++n3 % n2 != 0) continue;
                progressBarPanel.setValue(n3);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("This can't happen: IOException while reading from a StreamReader.");
        }
        catch (OutOfMemoryError outOfMemoryError) {
            ((DefaultMutableTreeNode)treeNode).removeAllChildren();
            ((DefaultMutableTreeNode)treeNode).setUserObject("Out of Memory");
            Tools.memoryFullAlert("While scanning newgroup list");
        }
        catch (ClassCastException classCastException) {
            throw new RuntimeException("This can't happen: ClassCastException while building TreeList.");
        }
        Tools.memoryAlert("After scanning newsgroup list");
    }

    public final void addServer(int n) throws RemoteException {
        JDialog jDialog = null;
        ServerPanel serverPanel = null;
        WindowData windowData = null;
        switch (n) {
            case 1: {
                windowData = this.basis.getWindowData("ADDNNTPSERVER");
                jDialog = new WindowDataDialog((Frame)this.frame, "Add newsserver", windowData, new WindowDataDefaultInterface());
                serverPanel = this.newsPanel;
                break;
            }
            case 2: {
                windowData = this.basis.getWindowData("ADDPOPSERVER");
                jDialog = new WindowDataDialog((Frame)this.frame, "Add POP Server", windowData, new WindowDataDefaultInterface());
                serverPanel = this.popPanel;
                break;
            }
            case 3: {
                windowData = this.basis.getWindowData("ADDSMTPSERVER");
                jDialog = new WindowDataDialog((Frame)this.frame, "Add SMTP Server", windowData, new WindowDataDefaultInterface());
                serverPanel = this.smtpPanel;
                break;
            }
            case 4: {
                windowData = this.basis.getWindowData("ADDGATEWAY");
                jDialog = new WindowDataDialog((Frame)this.frame, "Add Gateway", windowData, new WindowDataDefaultInterface());
                serverPanel = this.gatewayPanel;
                break;
            }
        }
        AddServerListener addServerListener = new AddServerListener();
        jDialog.setDefaultCloseOperation(2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        ((JComponent)jDialog.getContentPane()).setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JTextField jTextField = new JTextField(20);
        JTextField jTextField2 = new JTextField(20);
        if (n == 4) {
            jPanel.add(new LabeledField("Title", jTextField));
        } else {
            jPanel.add(this.getTitlePanel(jTextField, jTextField2));
        }
        jPanel.add(Box.createVerticalStrut(8));
        JButton jButton = new JButton("Ok");
        JTextField jTextField3 = null;
        JRadioButton jRadioButton = null;
        if (n == 4) {
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(BorderFactory.createTitledBorder("gateway type"));
            jPanel2.setLayout(new BoxLayout(jPanel2, 1));
            jTextField3 = new JTextField(20);
            jRadioButton = new JRadioButton("ZConnect / Janus");
            jRadioButton.addActionListener(addServerListener);
            JRadioButton jRadioButton2 = new JRadioButton("Other:");
            jRadioButton2.addActionListener(addServerListener);
            jRadioButton2.setAlignmentY(0.5f);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(jRadioButton);
            buttonGroup.add(jRadioButton2);
            jRadioButton.setSelected(true);
            jTextField3.setEnabled(false);
            JPanel jPanel3 = new JPanel();
            jPanel3.setLayout(new BoxLayout(jPanel3, 0));
            jPanel3.setAlignmentX(0.0f);
            jRadioButton.setAlignmentX(0.0f);
            jPanel3.add(jRadioButton2);
            jPanel3.add(Box.createHorizontalStrut(4));
            jTextField3.setAlignmentY(0.5f);
            jPanel3.add(jTextField3);
            jPanel2.add(jRadioButton);
            jPanel2.add(Box.createVerticalStrut(4));
            jPanel2.add(jPanel3);
            jPanel.add(jPanel2);
            jPanel.add(Box.createVerticalStrut(8));
        }
        jPanel.add(Shell.getOkCancelPanel(addServerListener, jButton));
        if (n == 4) {
            addServerListener.init(this, jDialog, jTextField, jTextField2, serverPanel, jTextField3, jRadioButton);
        } else {
            addServerListener.init(this, jDialog, jTextField, jTextField2, serverPanel);
        }
        jDialog.getContentPane().add("Center", jPanel);
        jDialog.getRootPane().setDefaultButton(jButton);
        if (windowData.size.width == 0) {
            jDialog.pack();
        }
        jDialog.show();
    }

    public final BasisShellInterface basis() {
        return this.basis;
    }

    public final void cleanUp() throws RemoteException {
        CleanUpChoicePanel cleanUpChoicePanel = new CleanUpChoicePanel(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void contactAllServers() throws RemoteException {
        String[] stringArray = this.basis.getNewsserverNames();
        int n = stringArray.length * 2;
        stringArray = this.basis.getPOPServerNames();
        int n2 = stringArray.length;
        CommProgressWindow commProgressWindow = new CommProgressWindow((Frame)this.frame, this.basis, true, n2 > 0 ? 2 : (n > 0 ? 1 : 3));
        stringArray = this.basis.getSMTPServerNames();
        n += stringArray.length;
        n += n2;
        stringArray = this.basis.getGatewayNames();
        commProgressWindow.all().setArea(0, (n += stringArray.length) + 1);
        commProgressWindow.all().setValue(1);
        commProgressWindow.connectionData().receiveInterruptsFor(0, this.basis);
        commProgressWindow.connectionData().receiveInterruptsFor(1, this.basis);
        if (commProgressWindow.connectionData().getAbort() > 0) {
            this.contactAllServers(3, commProgressWindow);
        }
        if (commProgressWindow.connectionData().getAbort() > 0) {
            this.contactAllServers(2, commProgressWindow);
        }
        if (commProgressWindow.connectionData().getAbort() > 0) {
            this.contactAllServers(4, commProgressWindow);
        }
        if (commProgressWindow.connectionData().getAbort() > 0) {
            this.contactAllServers(1, commProgressWindow);
        }
        commProgressWindow.all().setText("Finished!");
        commProgressWindow.all().setValue(n + 1);
        commProgressWindow.dispose();
        Shell.showStatusWindow(commProgressWindow.connectionData(), 0);
        try {
            this.basis.relax(true, true);
            return;
        }
        catch (IOException iOException) {
            Tools.log("Internal error: Unexpected error while saving to database:", iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void contactAllServers(int n, CommProgressWindow commProgressWindow) throws RemoteException {
        int n2 = 0;
        boolean bl = false;
        if (commProgressWindow == null) {
            bl = true;
            commProgressWindow = new CommProgressWindow((Frame)this.frame, this.basis, true, n);
            switch (n) {
                case 1: {
                    n2 = this.basis.getNewsserverNames().length * 2;
                    break;
                }
                case 2: {
                    n2 = this.basis.getPOPServerNames().length;
                    break;
                }
                case 3: {
                    n2 = this.basis.getSMTPServerNames().length;
                    break;
                }
                case 4: {
                    n2 = this.basis.getGatewayNames().length;
                    break;
                }
            }
            commProgressWindow.all().setArea(0, n2 + 1);
            commProgressWindow.all().setValue(1);
            commProgressWindow.connectionData().receiveInterruptsFor(0, this.basis);
            commProgressWindow.connectionData().receiveInterruptsFor(1, this.basis);
        }
        switch (n) {
            case 1: {
                if (commProgressWindow.connectionData().getAbort() > 0) {
                    this.basis.putNews(commProgressWindow);
                }
                if (commProgressWindow.connectionData().getAbort() <= 0) break;
                this.basis.getNews(commProgressWindow);
                break;
            }
            case 2: {
                if (commProgressWindow.connectionData().getAbort() <= 0) break;
                this.basis.getMails(commProgressWindow);
                break;
            }
            case 3: {
                if (commProgressWindow.connectionData().getAbort() <= 0) break;
                this.basis.putMails(commProgressWindow);
                break;
            }
            case 4: {
                if (commProgressWindow.connectionData().getAbort() <= 0) break;
                this.basis.contactGates(commProgressWindow);
                break;
            }
        }
        if (!bl) return;
        commProgressWindow.all().setValue(n2 + 1);
        commProgressWindow.all().setText("Finished.");
        commProgressWindow.dispose();
        Shell.showStatusWindow(commProgressWindow.connectionData(), n);
        try {
            this.basis.relax(true, true);
            return;
        }
        catch (IOException iOException) {
            Tools.log("Internal error: Unexpected error while saving to database:", iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void contactServer() throws RemoteException {
        int n;
        int n2;
        int[] nArray = this.newsPanel.getList().getSelectedIndices();
        int n3 = n2 = nArray.length;
        nArray = this.popPanel.getList().getSelectedIndices();
        int n4 = n = nArray.length;
        CommProgressWindow commProgressWindow = new CommProgressWindow((Frame)this.frame, this.basis, true, n > 0 ? 2 : (n2 > 0 ? 1 : 3));
        nArray = this.smtpPanel.getList().getSelectedIndices();
        int n5 = nArray.length;
        n2 += n5;
        n2 += n;
        nArray = this.gatewayPanel.getList().getSelectedIndices();
        int n6 = nArray.length;
        commProgressWindow.all().setArea(0, (n2 += n6) + 1);
        commProgressWindow.all().setValue(1);
        commProgressWindow.connectionData().receiveInterruptsFor(0, this.basis);
        commProgressWindow.connectionData().receiveInterruptsFor(1, this.basis);
        if (n5 > 0 && commProgressWindow.connectionData().getAbort() > 0) {
            this.contactServer(3, commProgressWindow);
        }
        if (n4 > 0 && commProgressWindow.connectionData().getAbort() > 0) {
            this.contactServer(2, commProgressWindow);
        }
        if (n6 > 0 && commProgressWindow.connectionData().getAbort() > 0) {
            this.contactServer(4, commProgressWindow);
        }
        if (n3 > 0 && commProgressWindow.connectionData().getAbort() > 0) {
            this.contactServer(1, commProgressWindow);
        }
        commProgressWindow.all().setText("Finished!");
        commProgressWindow.all().setValue(n2 + 1);
        commProgressWindow.dispose();
        Shell.showStatusWindow(commProgressWindow.connectionData(), 0);
        try {
            this.basis.relax(true, true);
            return;
        }
        catch (IOException iOException) {
            Tools.log("Internal error: Unexpected error while saving to database:", iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void contactServer(int n, CommProgressWindow commProgressWindow) throws RemoteException {
        JList jList = null;
        ServerPanel serverPanel = null;
        boolean bl = false;
        switch (n) {
            case 1: {
                serverPanel = this.newsPanel;
                break;
            }
            case 2: {
                serverPanel = this.popPanel;
                break;
            }
            case 3: {
                serverPanel = this.smtpPanel;
                break;
            }
            case 4: {
                serverPanel = this.gatewayPanel;
                break;
            }
        }
        jList = serverPanel.getList();
        Object[] objectArray = jList.getSelectedValues();
        if (objectArray.length == 0) {
            JOptionPane.showMessageDialog(this.frame, "No servers have been selected", "No Server Contacted", 1);
        } else {
            if (commProgressWindow == null) {
                bl = true;
                commProgressWindow = new CommProgressWindow((Frame)this.frame, this.basis, true, n);
                commProgressWindow.all().setArea(0, objectArray.length + 1);
                commProgressWindow.all().setValue(1);
                commProgressWindow.connectionData().receiveInterruptsFor(0, this.basis);
                commProgressWindow.connectionData().receiveInterruptsFor(1, this.basis);
            }
            switch (n) {
                case 1: {
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        commProgressWindow.all().setText("Talking to newsserver: " + (String)objectArray[n2]);
                        String string = this.basis.getNNTPServerForTitle((String)objectArray[n2]);
                        try {
                            if (commProgressWindow.connectionData().getAbort() > 0) {
                                this.basis.putNews(commProgressWindow, string);
                            }
                        }
                        catch (IOException iOException) {
                            Tools.log("Not all news could be send to '" + objectArray[n2] + "'. Reason:", iOException);
                        }
                        try {
                            if (commProgressWindow.connectionData().getAbort() > 0) {
                                this.basis.getNews(commProgressWindow, string);
                            }
                        }
                        catch (IOException iOException) {
                            Tools.log("Not all news could be retrieved from '" + objectArray[n2] + "'. Reason:", iOException);
                        }
                        commProgressWindow.all().increase();
                        ++n2;
                    }
                    break;
                }
                case 2: {
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        commProgressWindow.all().setText("Talking to pop server: " + (String)objectArray[n2]);
                        String string = this.basis.getPOPServerForTitle((String)objectArray[n2]);
                        try {
                            if (commProgressWindow.connectionData().getAbort() > 0) {
                                this.basis.getMails(commProgressWindow, string);
                            }
                        }
                        catch (IOException iOException) {
                            Tools.log("Not all mails could be retrieved from '" + objectArray[n2] + "'.", iOException);
                        }
                        commProgressWindow.all().increase();
                        ++n2;
                    }
                    break;
                }
                case 3: {
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        commProgressWindow.all().setText("Talking to smtp server: " + (String)objectArray[n2]);
                        String string = this.basis.getSMTPServerForTitle((String)objectArray[n2]);
                        if (commProgressWindow.connectionData().getAbort() > 0) {
                            this.basis.putMails(commProgressWindow, string);
                        }
                        commProgressWindow.all().increase();
                        ++n2;
                    }
                    break;
                }
                case 4: {
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        commProgressWindow.all().setText("Talking to gateway: " + (String)objectArray[n2]);
                        if (commProgressWindow.connectionData().getAbort() > 0) {
                            this.basis.contactGate(commProgressWindow, (String)objectArray[n2]);
                        }
                        commProgressWindow.all().increase();
                        ++n2;
                    }
                    break;
                }
            }
        }
        if (!bl) return;
        commProgressWindow.all().setValue(objectArray.length + 1);
        commProgressWindow.all().setText("Finished.");
        commProgressWindow.dispose();
        Shell.showStatusWindow(commProgressWindow.connectionData(), n);
        try {
            this.basis.relax(true, true);
            return;
        }
        catch (IOException iOException) {
            Tools.log("Unexpected error while saving to database:", iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void deleteServer(int n) throws RemoteException {
        JList jList = null;
        ServerPanel serverPanel = null;
        switch (n) {
            case 1: {
                serverPanel = this.newsPanel;
                break;
            }
            case 2: {
                serverPanel = this.popPanel;
                break;
            }
            case 3: {
                serverPanel = this.smtpPanel;
                break;
            }
            case 4: {
                serverPanel = this.gatewayPanel;
                break;
            }
        }
        jList = serverPanel.getList();
        Object[] objectArray = jList.getSelectedValues();
        if (objectArray.length == 0) {
            JOptionPane.showMessageDialog(this.frame, "No servers have been selected", "Nothing Deleted", 1);
            return;
        }
        int n2 = 0;
        if (objectArray.length == 1) {
            n2 = JOptionPane.showConfirmDialog(this.frame, "Delete the server '" + objectArray[0] + "'?", "Please Confirm", 1);
        } else {
            String[] stringArray = new String[objectArray.length + 1];
            stringArray[0] = "Delete these servers:";
            int n3 = 0;
            while (n3 < objectArray.length) {
                stringArray[n3 + 1] = "     " + objectArray[n3];
                ++n3;
            }
            n2 = JOptionPane.showConfirmDialog(this.frame, stringArray, "Please Confirm", 1);
        }
        if (n2 != 0) return;
        switch (n) {
            case 1: {
                int n4 = 0;
                while (n4 < objectArray.length) {
                    try {
                        this.basis.removeNewsserverByTitle((String)objectArray[n4]);
                    }
                    catch (IOException iOException) {
                        Shell.error("Severe Problem!", "A database error occurred", iOException);
                    }
                    ++n4;
                }
                break;
            }
            case 2: {
                int n5 = 0;
                while (n5 < objectArray.length) {
                    try {
                        this.basis.removePOPServerByTitle((String)objectArray[n5]);
                    }
                    catch (IOException iOException) {
                        Shell.error("Severe Problem!", "A database error occurred", iOException);
                    }
                    ++n5;
                }
                break;
            }
            case 3: {
                int n6 = 0;
                while (n6 < objectArray.length) {
                    try {
                        this.basis.removeSMTPServerByTitle((String)objectArray[n6]);
                    }
                    catch (IOException iOException) {
                        Shell.error("Severe Problem!", "A database error occurred", iOException);
                    }
                    ++n6;
                }
                break;
            }
            case 4: {
                int n7 = 0;
                while (n7 < objectArray.length) {
                    try {
                        this.basis.removeGateway((String)objectArray[n7]);
                    }
                    catch (IOException iOException) {
                        Shell.error("Severe Problem!", "A database error occurred", iOException);
                    }
                    ++n7;
                }
                break;
            }
        }
        serverPanel.updateList();
    }

    public final void editDomains() throws RemoteException {
        Object[] objectArray = this.smtpPanel.getList().getSelectedValues();
        if (objectArray.length != 1) {
            Shell.info("Invalid Selection", "Please select exactly one server before editing its domains!");
            return;
        }
        String string = this.basis.getSMTPServerForTitle((String)objectArray[0]);
        EditDomainListener editDomainListener = new EditDomainListener();
        WindowData windowData = this.basis.getWindowData("EDITDOMAINS");
        WindowDataDialog windowDataDialog = new WindowDataDialog((Frame)this.frame, "Domains to Serve", windowData, new WindowDataDefaultInterface());
        windowDataDialog.setDefaultCloseOperation(2);
        windowDataDialog.getContentPane().setLayout(new BoxLayout(windowDataDialog.getContentPane(), 1));
        windowDataDialog.getContentPane().add(Box.createVerticalStrut(4));
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton jRadioButton = new JRadioButton("All domains");
        jRadioButton.addActionListener(editDomainListener);
        jRadioButton.setAlignmentX(0.0f);
        buttonGroup.add(jRadioButton);
        windowDataDialog.getContentPane().add(jRadioButton);
        windowDataDialog.getContentPane().add(Box.createVerticalStrut(4));
        JRadioButton jRadioButton2 = new JRadioButton("Selected domains:");
        jRadioButton2.addActionListener(editDomainListener);
        jRadioButton2.setAlignmentX(0.0f);
        buttonGroup.add(jRadioButton2);
        windowDataDialog.getContentPane().add(jRadioButton2);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setAlignmentX(0.0f);
        jPanel.setBorder(BorderFactory.createTitledBorder("Selection"));
        JPanel jPanel2 = new JPanel(new BorderLayout(4, 4));
        Box box = Box.createVerticalBox();
        SortedListModel sortedListModel = new SortedListModel();
        Vector vector = this.basis.smtpserver().getDomains(string);
        if (vector != null) {
            sortedListModel.setContents(vector);
        }
        JList jList = new JList(sortedListModel.listModel());
        JScrollPane jScrollPane = new JScrollPane(jList);
        JTextField jTextField = new JTextField(20);
        box.add(Box.createVerticalGlue());
        JButton jButton = new JButton("Add");
        jButton.addActionListener(editDomainListener);
        jButton.setAlignmentX(0.5f);
        box.add(jButton);
        box.add(Box.createVerticalGlue());
        jButton = new JButton("Remove");
        jButton.addActionListener(editDomainListener);
        jButton.setAlignmentX(0.5f);
        box.add(jButton);
        box.add(Box.createVerticalGlue());
        jPanel2.add("Center", jScrollPane);
        jPanel2.add("West", box);
        jPanel2.add("South", new LabeledField("Domain to add", jTextField));
        jPanel.add("Center", jPanel2);
        windowDataDialog.getContentPane().add(jPanel);
        windowDataDialog.getContentPane().add(Box.createVerticalGlue());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.setAlignmentX(0.0f);
        jPanel3.add(Box.createHorizontalGlue());
        jPanel3.add(Box.createHorizontalGlue());
        jButton = new JButton("Ok");
        jButton.addActionListener(editDomainListener);
        jPanel3.add(jButton);
        jPanel3.add(Box.createHorizontalGlue());
        jButton = new JButton("Cancel");
        windowDataDialog.getRootPane().setDefaultButton(jButton);
        jButton.addActionListener(editDomainListener);
        jPanel3.add(jButton);
        jPanel3.add(Box.createHorizontalGlue());
        jPanel3.add(Box.createHorizontalGlue());
        windowDataDialog.getContentPane().add(jPanel3);
        if (vector == null) {
            jRadioButton.setSelected(true);
            Shell.enableTree(jPanel, false);
        } else {
            jRadioButton2.setSelected(true);
        }
        editDomainListener.init(windowDataDialog, jPanel, sortedListModel, jList, jTextField, this.basis.smtpserver(), string, jRadioButton);
        if (windowData.size.width == 0) {
            windowDataDialog.pack();
        }
        windowDataDialog.show();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void editGroups() throws RemoteException {
        Serializable serializable;
        Object object;
        Object object2;
        Object[] objectArray = this.newsPanel.getList().getSelectedValues();
        if (objectArray.length != 1) {
            Shell.info("Invalid Selection", "Please select exactly one server before editing its groups!");
            return;
        }
        String string = this.basis.getNNTPServerForTitle((String)objectArray[0]);
        WindowData windowData = this.basis.getWindowData("EDITGROUPS");
        WindowDataDialog windowDataDialog = new WindowDataDialog((Frame)this.frame, "Subscribed Groups", windowData, new WindowDataDefaultInterface());
        windowDataDialog.setDefaultCloseOperation(2);
        windowDataDialog.getContentPane().setLayout(new BoxLayout(windowDataDialog.getContentPane(), 0));
        windowDataDialog.getContentPane().add(Box.createHorizontalGlue());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Remote"));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder("Available Newsgroups"));
        jPanel4.setBorder(BorderFactory.createTitledBorder("Manual Selection"));
        JPanel jPanel5 = new JPanel(new BorderLayout());
        JTree jTree = null;
        try {
            object2 = this.basis.newsserver().readGroupList(string);
            if (object2 == null) {
                object = new Object[]{"No list available"};
                jTree = new JTree((Object[])object);
            } else {
                jTree = new JTree((TreeNode)object2);
            }
        }
        catch (IOException iOException) {
            object = new Object[]{"An error occurred"};
            jTree = new JTree((Object[])object);
            Shell.error("A Problem occurred", "Couldn't read newsgroup list", iOException);
        }
        jPanel5.add("Center", new JScrollPane(jTree));
        object2 = new JPanel();
        ((Container)object2).setLayout(new BoxLayout((Container)object2, 1));
        object = new JTextField(20);
        jPanel4.add("Center", (Component)object);
        SortedListModel sortedListModel = new SortedListModel();
        try {
            serializable = this.basis.newsserver().getActiveGroups(string);
            sortedListModel.setContents(serializable.keys());
        }
        catch (IOException iOException) {
            Shell.error("Database Error", "Couldn't read the active file for server '" + string + "'", iOException);
        }
        serializable = new JList(sortedListModel.listModel());
        GroupsListener groupsListener = new GroupsListener(this, windowDataDialog, string, jTree, (JList)serializable, (JTextField)object);
        ((Container)object2).add(Box.createVerticalGlue());
        JButton jButton = new JButton("Get");
        jButton.setAlignmentX(0.5f);
        jButton.addActionListener(groupsListener);
        ((Container)object2).add(jButton);
        ((Container)object2).add(Box.createVerticalGlue());
        jButton = new JButton("Update");
        jButton.setAlignmentX(0.5f);
        jButton.addActionListener(groupsListener);
        ((Container)object2).add(jButton);
        ((Container)object2).add(Box.createVerticalGlue());
        jPanel3.add("East", (Component)object2);
        jPanel3.add("Center", jPanel5);
        jPanel2.add("Center", jPanel3);
        jPanel2.add("South", jPanel4);
        jPanel.add("Center", jPanel2);
        windowDataDialog.getContentPane().add(jPanel);
        windowDataDialog.getContentPane().add(Box.createHorizontalGlue());
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel6.add(Box.createVerticalGlue());
        jButton = new JButton("Add -->");
        jButton.setAlignmentX(0.5f);
        jButton.addActionListener(groupsListener);
        jPanel6.add(jButton);
        jPanel6.add(Box.createVerticalGlue());
        jButton = new JButton("<-- Remove");
        jButton.setAlignmentX(0.5f);
        jButton.addActionListener(groupsListener);
        jPanel6.add(jButton);
        jPanel6.add(Box.createVerticalGlue());
        jPanel6.add(Box.createVerticalGlue());
        jPanel6.add(Box.createVerticalGlue());
        jButton = new JButton("Ok");
        jButton.setAlignmentX(0.5f);
        jButton.addActionListener(groupsListener);
        jPanel6.add(jButton);
        jPanel6.add(Box.createVerticalGlue());
        windowDataDialog.getRootPane().setDefaultButton(jButton);
        jButton = new JButton("Cancel");
        jButton.setAlignmentX(0.5f);
        jButton.addActionListener(groupsListener);
        jPanel6.add(jButton);
        jPanel6.add(Box.createVerticalGlue());
        windowDataDialog.getContentPane().add(jPanel6);
        windowDataDialog.getContentPane().add(Box.createHorizontalGlue());
        JPanel jPanel7 = new JPanel(new BorderLayout());
        jPanel7.setBorder(BorderFactory.createTitledBorder("Local"));
        JPanel jPanel8 = new JPanel(new BorderLayout());
        jPanel8.add("North", new JLabel("Subscribed Groups"));
        jPanel8.add("Center", new JScrollPane((Component)serializable));
        jButton = new JButton("Reset Article Counter");
        jButton.addActionListener(groupsListener);
        jPanel8.add("South", jButton);
        jPanel7.add("Center", jPanel8);
        windowDataDialog.getContentPane().add(jPanel7);
        windowDataDialog.getContentPane().add(Box.createHorizontalGlue());
        if (windowData.size.width == 0) {
            windowDataDialog.pack();
        }
        windowDataDialog.show();
    }

    public final void editServer(int n) throws RemoteException {
        WindowDataDialog windowDataDialog = null;
        ServerPanel serverPanel = null;
        WindowData windowData = null;
        switch (n) {
            case 1: {
                windowData = this.basis.getWindowData("EDITNNTPSERVER");
                windowDataDialog = new WindowDataDialog((Frame)this.frame, "Edit Newsserver", windowData, new WindowDataDefaultInterface());
                serverPanel = this.newsPanel;
                break;
            }
            case 2: {
                windowData = this.basis.getWindowData("EDITPOPSERVER");
                windowDataDialog = new WindowDataDialog((Frame)this.frame, "Edit POP Server", windowData, new WindowDataDefaultInterface());
                serverPanel = this.popPanel;
                break;
            }
            case 3: {
                windowData = this.basis.getWindowData("EDITSMTPSERVER");
                windowDataDialog = new WindowDataDialog((Frame)this.frame, "Edit SMTP Server", windowData, new WindowDataDefaultInterface());
                serverPanel = this.smtpPanel;
                break;
            }
            case 4: {
                windowData = this.basis.getWindowData("EDITGATEWAY");
                windowDataDialog = new WindowDataDialog((Frame)this.frame, "Edit Gateway", windowData, new WindowDataDefaultInterface());
                serverPanel = this.gatewayPanel;
                break;
            }
        }
        Object[] objectArray = serverPanel.getList().getSelectedValues();
        if (objectArray.length != 1) {
            Shell.info("Invalid Selection", "Please select exactly one server to edit!");
            return;
        }
        String string = (String)objectArray[0];
        String string2 = null;
        switch (n) {
            case 1: {
                string2 = this.basis.getNNTPServerForTitle(string);
                break;
            }
            case 2: {
                string2 = this.basis.getPOPServerForTitle(string);
                break;
            }
            case 3: {
                string2 = this.basis.getSMTPServerForTitle(string);
                break;
            }
            case 4: {
                string2 = string;
                break;
            }
        }
        EditServerListener editServerListener = new EditServerListener();
        windowDataDialog.setDefaultCloseOperation(2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        ((JComponent)windowDataDialog.getContentPane()).setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JTextField jTextField = new JTextField(20);
        jTextField.setText(string);
        if (n == 4) {
            jPanel.add(new LabeledField("Title", jTextField));
        } else {
            jPanel.add(this.getTitlePanel(jTextField, string2));
        }
        jPanel.add(Box.createVerticalStrut(8));
        JButton jButton = new JButton("Ok");
        jPanel.add(Shell.getOkCancelPanel(editServerListener, jButton));
        editServerListener.init(this, windowDataDialog, jTextField, string2, serverPanel);
        windowDataDialog.getContentPane().add("Center", jPanel);
        windowDataDialog.getRootPane().setDefaultButton(jButton);
        if (windowData.size.width == 0) {
            windowDataDialog.pack();
        }
        windowDataDialog.show();
    }

    public static final void enableTree(Component component, boolean bl) {
        Object object;
        component.setEnabled(bl);
        if (component instanceof Container) {
            object = ((Container)component).getComponents();
            int n = 0;
            while (n < ((Component[])object).length) {
                Shell.enableTree(object[n], bl);
                ++n;
            }
        }
        if (component instanceof JComponent && (object = ((JComponent)component).getBorder()) instanceof TitledBorder) {
            TitledBorder titledBorder = (TitledBorder)object;
            Color color = null;
            color = bl ? UIManager.getColor("textText") : UIManager.getColor("textInactiveText");
            titledBorder.setTitleColor(color);
            component.repaint();
        }
    }

    public static final void error(String string, String string2) {
        JOptionPane.showMessageDialog(null, string2, string, 0);
    }

    public static final void error(String string, String string2, Throwable throwable) {
        Object[] objectArray = new Object[]{" --- " + string2 + " ---", ErrorTools.redirect(throwable)};
        Tools.log(string2, throwable);
        JOptionPane.showMessageDialog(null, objectArray, string, 0);
    }

    public final JFrame frame() {
        return this.frame;
    }

    public final void gatewayAdmin() throws RemoteException {
        Object[] objectArray = this.gatewayPanel.getList().getSelectedValues();
        if (objectArray.length == 0) {
            objectArray = ((DefaultListModel)this.gatewayPanel.getList().getModel()).toArray();
        }
        if (objectArray.length == 0) {
            Shell.info("Gateway Administration", "Please create a gateway first.");
            return;
        }
        if (objectArray.length == 1) {
            Gateway gateway = this.basis.gates().object((String)objectArray[0]);
            if (gateway == null) {
                Shell.error("Database Error", "No appropriate code available for gateway '" + objectArray[0] + "'");
            } else {
                gateway.admin();
            }
        } else {
            Shell.info("Gateway Administration", "Please select exactly one gateway.");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void getGroupList(String string) throws IOException {
        CommProgressWindow commProgressWindow = new CommProgressWindow((Frame)this.frame, this.basis, false, 5);
        commProgressWindow.server().setText("Contacting server: " + string);
        if (!this.basis.newsserver().exists(string)) {
            throw new IllegalArgumentException("Unknown news server: '" + string + "'");
        }
        OptionsData optionsData = this.basis.getOptions();
        NNTPControlConnection nNTPControlConnection = new NNTPControlConnection(string, optionsData.timeout, optionsData.connectionTimeout);
        try {
            try {
                nNTPControlConnection.login();
                ++commProgressWindow.connectionData().contactedServers;
                File file = new File(this.basis.dataDir() + "nlist.temp");
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                int n = nNTPControlConnection.getList(commProgressWindow.server(), bufferedWriter);
                bufferedWriter.close();
                nNTPControlConnection.close();
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("*");
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                this.addGroupsToNode(defaultMutableTreeNode, bufferedReader, commProgressWindow.server(), n);
                bufferedReader.close();
                file.delete();
                this.basis.writeGroupList(string, defaultMutableTreeNode);
                Object var6_11 = null;
                commProgressWindow.server().setText("Finished.");
                commProgressWindow.server().setValue(1000);
                commProgressWindow.dispose();
                nNTPControlConnection.close();
                return;
            }
            catch (IOException iOException) {
                ++commProgressWindow.connectionData().errors;
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            commProgressWindow.server().setText("Finished.");
            commProgressWindow.server().setValue(1000);
            commProgressWindow.dispose();
            nNTPControlConnection.close();
            throw throwable;
        }
    }

    public static final JPanel getOkCancelPanel(ActionListener actionListener, JButton jButton) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentX(0.0f);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jButton);
        jButton.addActionListener(actionListener);
        jPanel.add(Box.createHorizontalGlue());
        JButton jButton2 = new JButton("Cancel");
        jPanel.add(jButton2);
        jButton2.addActionListener(actionListener);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(Box.createHorizontalGlue());
        return jPanel;
    }

    private final JPanel getTitlePanel(JTextField jTextField, String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentX(0.0f);
        jPanel.add(new LabeledField("Title", jTextField));
        jPanel.add(new JLabel("Server Name: " + string));
        return jPanel;
    }

    private final JPanel getTitlePanel(JTextField jTextField, JTextField jTextField2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentX(0.0f);
        jPanel.add(new LabeledField("Title", jTextField));
        jPanel.add(new LabeledField("Server Name", jTextField2));
        return jPanel;
    }

    public static final void info(String string, String string2) {
        new Thread(string2, string){
            private final /* synthetic */ String val$text;
            private final /* synthetic */ String val$title;

            public final void run() {
                JOptionPane.showMessageDialog(null, this.val$text, this.val$title, 1);
            }
            {
                this.val$text = string;
                this.val$title = string2;
                this.constructor$0();
            }

            public void constructor$0() {
            }
        }.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void main(String[] stringArray) {
        try {
            System.out.println("\nThis is " + CommonConstants.title);
            if (stringArray.length > 1) {
                Shell.usage();
            }
            Basis basis = null;
            basis = stringArray.length == 0 ? new Basis() : new Basis(stringArray[0]);
            WindowData windowData = basis.getWindowData("SHELL");
            if (windowData.data == null) {
                windowData.data = new Hashtable();
            }
            Tools.logPart("Initializing graphics...");
            Shell shell = new Shell(basis, windowData.data);
            Tools.log("done!\n");
            Tools.logPart("Starting servers...");
            if (shell.startupNNTP) {
                shell.startServer(1, false);
            }
            if (shell.startupSMTP) {
                shell.startServer(3, false);
            }
            if (shell.startupPOP) {
                shell.startServer(2, false);
            }
            if (shell.startupGate) {
                shell.startServer(4, false);
            }
            Tools.log("done!\n");
            shell.frame = new WindowDataFrame(CommonConstants.title, windowData, shell);
            shell.frame.addWindowListener(new ExitAdapter(shell));
            shell.frame.getContentPane().add("Center", shell);
            if (windowData.size.width == 0) {
                shell.frame.pack();
            }
            ((Component)shell.frame).setVisible(true);
            return;
        }
        catch (Throwable throwable) {
            Tools.log("An unexpected error occurred:", throwable);
            System.exit(2);
        }
    }

    public final void popUserAdmin() throws RemoteException {
        Object[] objectArray = this.popPanel.getList().getSelectedValues();
        if (objectArray.length == 0) {
            objectArray = ((DefaultListModel)this.popPanel.getList().getModel()).toArray();
        }
        if (objectArray.length == 0) {
            Shell.info("User Administration", "Please create a POP server first.");
            return;
        }
        WindowData windowData = this.basis.getWindowData("POPUSERADMIN");
        WindowDataDialog windowDataDialog = new WindowDataDialog((Frame)this.frame, "User Administration", windowData, new WindowDataDefaultInterface());
        windowDataDialog.setDefaultCloseOperation(2);
        String[] stringArray = new String[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            stringArray[n] = (String)objectArray[n];
            ++n;
        }
        PopUserBase popUserBase = this.basis.getUsersForPOPServers(stringArray);
        windowDataDialog.getContentPane().add(new AdminPOPUserPanel(this.basis, windowDataDialog, popUserBase, objectArray.length != 1));
        if (windowData.size.width == 0) {
            windowDataDialog.pack();
        }
        windowDataDialog.show();
    }

    public static final int progressGranularity() {
        return progressGranularity;
    }

    public static final boolean question(String string, String string2) {
        return JOptionPane.showConfirmDialog(null, string2, string, 0) == 0;
    }

    public final void setOptions() throws RemoteException {
        WindowData windowData = this.basis.getWindowData("OPTIONS");
        WindowDataDialog windowDataDialog = new WindowDataDialog((Frame)this.frame, "Options", windowData, new WindowDataDefaultInterface());
        windowDataDialog.setDefaultCloseOperation(2);
        OptionsPanel optionsPanel = new OptionsPanel(this, windowDataDialog);
        windowDataDialog.getContentPane().add(optionsPanel);
        windowDataDialog.pack();
        windowDataDialog.show();
    }

    public static final void showStatusWindow(ConnectionData connectionData, int n) {
        if (connectionData.contactedServers == 0 && connectionData.errors == 0) {
            Shell.info("Transmission Result", "No servers have been contacted.");
            return;
        }
        String string = connectionData.contactedServers + (connectionData.contactedServers == 1 ? " connection has" : " connections have") + " been established\n";
        switch (n) {
            case 0: 
            case 4: {
                string = string + connectionData.receivedArticles + (connectionData.receivedArticles == 1 ? " article has" : " articles have") + " been received\n" + connectionData.sentArticles + (connectionData.sentArticles == 1 ? " article has" : " articles have") + " been sent\n" + connectionData.receivedMails + (connectionData.receivedMails == 1 ? " mail has" : " mails have") + " been received\n" + connectionData.sentMails + (connectionData.sentMails == 1 ? " mail has" : " mails have") + " been sent";
                break;
            }
            case 1: {
                string = string + connectionData.receivedArticles + (connectionData.receivedArticles == 1 ? " article has" : " articles have") + " been received\n" + connectionData.sentArticles + (connectionData.sentArticles == 1 ? " article has" : " articles have") + " been sent";
                break;
            }
            case 2: {
                string = string + connectionData.receivedMails + (connectionData.receivedMails == 1 ? " mail has" : " mails have") + " been received";
                break;
            }
            case 3: {
                string = string + connectionData.sentMails + (connectionData.sentMails == 1 ? " mail has" : " mails have") + " been sent";
                break;
            }
        }
        if (connectionData.errors > 0) {
            string = string + "\n" + connectionData.errors + (connectionData.errors == 1 ? " error" : " errors") + " occurred during transmission!\n";
        }
        Shell.info("Transmission Result", string);
    }

    public final void shutdownServers() {
        Tools.logPart("Shutting down servers...");
        if (this.nntpServer != null) {
            this.nntpServer.shutdown();
        }
        if (this.popServer != null) {
            this.popServer.shutdown();
        }
        if (this.smtpServer != null) {
            this.smtpServer.shutdown();
        }
        if (this.gatewayServer != null) {
            this.gatewayServer.relax();
            this.gatewayServer = null;
        }
        Tools.log("done!");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void startServer(int n, boolean bl) {
        switch (n) {
            case 1: {
                try {
                    this.nntpServer = (NNTPServer)this.basis.startServer(n);
                    if (!bl) return;
                    Shell.info("Start Server", "NNTP Server is up and running!");
                    return;
                }
                catch (IOException iOException) {
                    Shell.error("StartServer", "NNTP Server could not be started.\nAnother server may already be running.");
                    return;
                }
            }
            case 2: {
                try {
                    this.popServer = (POPServer)this.basis.startServer(n);
                    if (!bl) return;
                    Shell.info("Start Server", "POP3 Server is up and running!");
                    return;
                }
                catch (IOException iOException) {
                    Shell.error("StartServer", "POP3 Server could not be started.\nAnother server may already be running.");
                    return;
                }
            }
            case 3: {
                try {
                    this.smtpServer = (SMTPServer)this.basis.startServer(n);
                    if (!bl) return;
                    Shell.info("Start Server", "SMTP Server is up and running!");
                    return;
                }
                catch (IOException iOException) {
                    Shell.error("StartServer", "SMTP Server could not be started.\nAnother server may already be running.");
                    return;
                }
            }
            case 4: {
                try {
                    this.gatewayServer = (GatewayServer)this.basis.startServer(n);
                    if (!bl) return;
                    Shell.info("Start Server", "Gateway Server is up and running!");
                    return;
                }
                catch (IOException iOException) {
                    Shell.error("StartServer", "Gateway Server could not be started.", iOException);
                    return;
                }
            }
        }
    }

    public final void startServerOnStartup(int n) {
        switch (n) {
            case 1: {
                this.startupNNTP = true;
                break;
            }
            case 3: {
                this.startupSMTP = true;
                break;
            }
            case 2: {
                this.startupPOP = true;
                break;
            }
            case 4: {
                this.startupGate = true;
                break;
            }
        }
    }

    public final void stopServer(int n) {
        switch (n) {
            case 1: {
                if (this.nntpServer == null) break;
                this.nntpServer.shutdown();
                Shell.info("NNTP Server Shutdown", "No new connections are accepted");
                break;
            }
            case 2: {
                if (this.popServer == null) break;
                this.popServer.shutdown();
                Shell.info("POP3 Server Shutdown", "No new connections are accepted");
                break;
            }
            case 3: {
                if (this.smtpServer == null) break;
                this.smtpServer.shutdown();
                Shell.info("SMTP Server Shutdown", "No new connections are accepted");
                break;
            }
            case 4: {
                if (this.gatewayServer == null) break;
                this.gatewayServer.relax();
                this.gatewayServer = null;
                Shell.info("Gateway Server Shutdown", "No new connections are accepted");
                break;
            }
        }
    }

    public static final void toDo() {
        Shell.toDo("");
    }

    public static final void toDo(String string) {
        Shell.error("Sorry for this!", "This isn't yet implemented:\n" + string, new Throwable());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void updateGroupList(String string) throws IOException {
        if (!this.basis.newsserver().exists(string)) {
            throw new IllegalArgumentException("Unknown news server: '" + string + "'");
        }
        Date date = this.basis.newsserver().getListDate(string);
        if (!this.basis.newsserver().hasGroupList(string)) {
            this.getGroupList(string);
            return;
        }
        CommProgressWindow commProgressWindow = new CommProgressWindow((Frame)this.frame, this.basis, false, 5);
        commProgressWindow.server().setText("Contacting server: " + string);
        OptionsData optionsData = this.basis.getOptions();
        NNTPControlConnection nNTPControlConnection = new NNTPControlConnection(string, optionsData.timeout, optionsData.connectionTimeout);
        try {
            try {
                nNTPControlConnection.login();
                ++commProgressWindow.connectionData().contactedServers;
                File file = new File(this.basis.dataDir() + "nlist.temp");
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                int n = nNTPControlConnection.updateList(commProgressWindow.server(), bufferedWriter, date);
                bufferedWriter.close();
                nNTPControlConnection.close();
                TreeNode treeNode = this.basis.newsserver().readGroupList(string);
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                this.addGroupsToNode(treeNode, bufferedReader, commProgressWindow.server(), n);
                bufferedReader.close();
                this.basis.writeGroupList(string, treeNode);
                Object var7_12 = null;
                commProgressWindow.server().setText("Finished.");
                commProgressWindow.server().setValue(50);
                commProgressWindow.dispose();
                return;
            }
            catch (IOException iOException) {
                ++commProgressWindow.connectionData().errors;
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            commProgressWindow.server().setText("Finished.");
            commProgressWindow.server().setValue(50);
            commProgressWindow.dispose();
            throw throwable;
        }
    }

    public static final void usage() {
        System.out.println();
        System.out.println("Kroni's news & mail tools");
        System.out.println();
        System.out.println("  As command line argument, provide:");
        System.out.println("-?         to get this text");
        System.out.println("filename   to use <filename> as the options file");
        System.out.println();
        System.exit(1);
    }

    public final Hashtable windowExtraData() {
        Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
        hashtable.put("NEWS", this.newsPanel.windowExtraData());
        hashtable.put("POP", this.popPanel.windowExtraData());
        hashtable.put("SMTP", this.smtpPanel.windowExtraData());
        hashtable.put("GATE", this.gatewayPanel.windowExtraData());
        return hashtable;
    }

    public Shell(Basis basis, Hashtable hashtable) throws RemoteException {
        this.basis = basis;
        this.setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.newsPanel = new ServerPanel(this, 1, (Hashtable)hashtable.get("NEWS"));
        this.popPanel = new ServerPanel(this, 2, (Hashtable)hashtable.get("POP"));
        this.smtpPanel = new ServerPanel(this, 3, (Hashtable)hashtable.get("SMTP"));
        this.gatewayPanel = new ServerPanel(this, 4, (Hashtable)hashtable.get("GATE"));
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.newsPanel, gridBagConstraints);
        jPanel.add(this.newsPanel);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.popPanel, gridBagConstraints);
        jPanel.add(this.popPanel);
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.smtpPanel, gridBagConstraints);
        jPanel.add(this.smtpPanel);
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(this.gatewayPanel, gridBagConstraints);
        jPanel.add(this.gatewayPanel);
        this.add("Center", jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder("general"));
        ShellButtonListener shellButtonListener = new ShellButtonListener(this);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(Box.createHorizontalStrut(3));
        box.add(Box.createHorizontalGlue());
        JButton jButton = new JButton("Contact");
        jButton.addActionListener(shellButtonListener);
        box.add(jButton);
        box.add(Box.createHorizontalStrut(3));
        box.add(Box.createHorizontalGlue());
        jButton = new JButton("Contact All");
        jButton.addActionListener(shellButtonListener);
        box.add(jButton);
        box.add(Box.createHorizontalStrut(3));
        box.add(Box.createHorizontalGlue());
        jButton = new JButton("Clean up...");
        jButton.addActionListener(shellButtonListener);
        box.add(jButton);
        box.add(Box.createHorizontalStrut(3));
        box.add(Box.createHorizontalGlue());
        jButton = new JButton("Options...");
        jButton.addActionListener(shellButtonListener);
        box.add(jButton);
        box.add(Box.createHorizontalStrut(3));
        box.add(Box.createHorizontalGlue());
        jButton = new JButton("Quit");
        jButton.addActionListener(shellButtonListener);
        box.add(jButton);
        box.add(Box.createHorizontalStrut(3));
        box.add(Box.createHorizontalGlue());
        box.add(Box.createHorizontalGlue());
        jPanel2.add("Center", box);
        this.add("South", jPanel2);
    }
}

