/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import net.ibm.malamut.newsmail.Tools;
import net.ibm.malamut.newsmail.ui.CommThreadBundle;
import net.ibm.malamut.newsmail.ui.Shell;

public final class ServerPanelButtonListener
implements ActionListener {
    private int serverType;
    private Shell shell;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = actionEvent.getActionCommand();
            if (string.equals("Add...")) {
                this.shell.addServer(this.serverType);
                return;
            }
            if (string.equals("Groups...")) {
                CommThreadBundle.getThread().editGroups(this.shell);
                return;
            }
            if (string.equals("Domains...")) {
                this.shell.editDomains();
                return;
            }
            if (string.equals("Users...")) {
                this.shell.popUserAdmin();
                return;
            }
            if (string.equals("Admin...")) {
                this.shell.gatewayAdmin();
                return;
            }
            if (string.equals("Edit...")) {
                this.shell.editServer(this.serverType);
                return;
            }
            if (string.equals("Delete")) {
                this.shell.deleteServer(this.serverType);
                return;
            }
            if (string.equals("Contact")) {
                CommThreadBundle.getThread().contactServer(this.shell, this.serverType, null);
                return;
            }
            if (string.equals("Contact All")) {
                CommThreadBundle.getThread().contactAllServers(this.shell, this.serverType, null);
                return;
            }
            if (!string.equals("Daemon active")) return;
            JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
            if (jCheckBox.isSelected()) {
                CommThreadBundle.getThread().startServer(this.shell, this.serverType);
                return;
            }
            CommThreadBundle.getThread().stopServer(this.shell, this.serverType);
            return;
        }
        catch (Throwable throwable) {
            Tools.log("Internal error in ServerPanelButtonListener.actionPerformed():", throwable);
        }
    }

    public ServerPanelButtonListener(Shell shell, int n) {
        this.serverType = n;
        this.shell = shell;
    }
}

