/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail.ui;

import java.awt.BorderLayout;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.ibm.malamut.newsmail.BasisConstants;
import net.ibm.malamut.newsmail.ui.ServerPanelButtonListener;
import net.ibm.malamut.newsmail.ui.Shell;
import net.ibm.malamut.newsmail.ui.SortedListModel;

public final class ServerPanel
extends JPanel
implements BasisConstants {
    private JList list;
    private JScrollPane listPane;
    private int type;
    private Shell shell;
    private JCheckBox daemonActive;

    public final JList getList() {
        return this.list;
    }

    public final int type() {
        return this.type;
    }

    public final void updateList() throws RemoteException {
        String[] stringArray = null;
        switch (this.type) {
            case 1: {
                stringArray = this.shell.basis().getNewsserverNames();
                break;
            }
            case 2: {
                stringArray = this.shell.basis().getPOPServerNames();
                break;
            }
            case 3: {
                stringArray = this.shell.basis().getSMTPServerNames();
                break;
            }
            case 4: {
                stringArray = this.shell.basis().getGatewayNames();
                break;
            }
        }
        SortedListModel sortedListModel = new SortedListModel((DefaultListModel)this.list.getModel());
        sortedListModel.setContents(stringArray);
    }

    public final Hashtable windowExtraData() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("ACTIVE", new Boolean(this.daemonActive.isSelected()));
        hashtable.put("SELECTED", this.list.getSelectedIndices());
        return hashtable;
    }

    public ServerPanel(Shell shell, int n, Hashtable hashtable) throws RemoteException {
        this.type = n;
        this.shell = shell;
        String[] stringArray = null;
        ServerPanelButtonListener serverPanelButtonListener = new ServerPanelButtonListener(shell, n);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BorderLayout(5, 8));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        String string = null;
        switch (this.type) {
            case 1: {
                string = "newsserver";
                stringArray = shell.basis().getNewsserverNames();
                break;
            }
            case 2: {
                string = "pop server";
                stringArray = shell.basis().getPOPServerNames();
                break;
            }
            case 3: {
                string = "smtp server";
                stringArray = shell.basis().getSMTPServerNames();
                break;
            }
            case 4: {
                string = "gateways";
                stringArray = shell.basis().getGatewayNames();
                break;
            }
        }
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        jPanel.add("Center", jPanel2);
        this.add("Center", jPanel);
        this.daemonActive = new JCheckBox("Daemon active");
        this.daemonActive.addActionListener(serverPanelButtonListener);
        Box box = Box.createHorizontalBox();
        box.add(this.daemonActive);
        box.add(Box.createHorizontalGlue());
        jPanel2.add("North", box);
        SortedListModel sortedListModel = new SortedListModel();
        sortedListModel.setContents(stringArray);
        this.list = new JList(sortedListModel.listModel());
        this.list.setSelectionMode(2);
        this.list.setVisibleRowCount(5);
        this.listPane = new JScrollPane(this.list);
        jPanel2.add("Center", this.listPane);
        Box box2 = Box.createVerticalBox();
        box2.add(Box.createVerticalStrut(3));
        box2.add(Box.createGlue());
        String string2 = null;
        switch (this.type) {
            case 1: {
                string2 = "Groups...";
                break;
            }
            case 3: {
                string2 = "Domains...";
                break;
            }
            case 2: {
                string2 = "Users...";
                break;
            }
            case 4: {
                string2 = "Admin...";
                break;
            }
        }
        JButton jButton = new JButton(string2);
        jButton.setAlignmentX(0.5f);
        jButton.addActionListener(serverPanelButtonListener);
        box2.add(jButton);
        box2.add(Box.createVerticalStrut(3));
        box2.add(Box.createGlue());
        jButton = new JButton("Add...");
        jButton.setAlignmentX(0.5f);
        jButton.addActionListener(serverPanelButtonListener);
        box2.add(jButton);
        box2.add(Box.createVerticalStrut(3));
        box2.add(Box.createGlue());
        jButton = new JButton("Edit...");
        jButton.setAlignmentX(0.5f);
        jButton.addActionListener(serverPanelButtonListener);
        box2.add(jButton);
        box2.add(Box.createVerticalStrut(3));
        box2.add(Box.createGlue());
        jButton = new JButton("Delete");
        jButton.addActionListener(serverPanelButtonListener);
        jButton.setAlignmentX(0.5f);
        box2.add(jButton);
        box2.add(Box.createVerticalStrut(3));
        box2.add(Box.createGlue());
        jPanel2.add("East", box2);
        box2 = Box.createHorizontalBox();
        box2.add(Box.createHorizontalStrut(3));
        box2.add(Box.createGlue());
        jButton = new JButton("Contact");
        jButton.addActionListener(serverPanelButtonListener);
        jButton.setAlignmentY(0.5f);
        box2.add(jButton);
        box2.add(Box.createHorizontalStrut(3));
        box2.add(Box.createGlue());
        jButton = new JButton("Contact All");
        jButton.addActionListener(serverPanelButtonListener);
        jButton.setAlignmentY(0.5f);
        box2.add(jButton);
        box2.add(Box.createHorizontalStrut(3));
        box2.add(Box.createGlue());
        jPanel2.add("South", box2);
        if (hashtable != null) {
            this.list.setSelectedIndices((int[])hashtable.get("SELECTED"));
            this.daemonActive.setSelected((Boolean)hashtable.get("ACTIVE"));
            if (this.daemonActive.isSelected()) {
                shell.startServerOnStartup(n);
            }
        }
    }
}

