/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail.ui;

import java.awt.Frame;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JDialog;
import net.ibm.malamut.newsmail.BasisShellInterface;
import net.ibm.malamut.newsmail.POPUserData;
import net.ibm.malamut.newsmail.WindowData;
import net.ibm.malamut.newsmail.database.PopUserBase;
import net.ibm.malamut.newsmail.ui.AddPOPUserPanel;
import net.ibm.malamut.newsmail.ui.GenericAdminUserPanel;
import net.ibm.malamut.newsmail.ui.Shell;
import net.ibm.malamut.newsmail.ui.WindowDataDefaultInterface;
import net.ibm.malamut.newsmail.ui.WindowDataDialog;

public final class AdminPOPUserPanel
extends GenericAdminUserPanel {
    private BasisShellInterface basis;
    private int currentUser;
    private PopUserBase users;

    public final void add() throws RemoteException {
        WindowData windowData = this.basis.getWindowData("ADDPOPUSER");
        WindowDataDialog windowDataDialog = new WindowDataDialog((Frame)this.dialog.getParent(), "Create a New User", windowData, new WindowDataDefaultInterface());
        JButton jButton = new JButton("Ok");
        windowDataDialog.getContentPane().add(new AddPOPUserPanel(this, windowDataDialog, jButton));
        if (windowData.size.width == 0) {
            windowDataDialog.pack();
        }
        windowDataDialog.show();
    }

    public final void add(String string, POPUserData pOPUserData) throws RemoteException {
        if (this.basis.popserver().existsUser(string)) {
            Shell.info("Add User", "This user already exists!");
            return;
        }
        String string2 = this.basis.getPOPPassword(string);
        if (!pOPUserData.localPass.equals(string2) && string2 != null) {
            Shell.info("Add User", "You entered the wrong local password for this user!");
        } else {
            this.users.addUser(string, pOPUserData);
            this.listModel.insertElement(string);
        }
    }

    public final void disposeDialog() {
        this.dialog.dispose();
    }

    public final void edit() throws RemoteException {
        int[] nArray = this.list.getSelectedIndices();
        if (nArray.length != 1) {
            Shell.info("Edit POP User", "Please select exactly one user to edit.");
            return;
        }
        this.currentUser = nArray[0];
        String string = (String)this.listModel.listModel().elementAt(this.currentUser);
        WindowData windowData = this.basis.getWindowData("EDITPOPUSER");
        WindowDataDialog windowDataDialog = new WindowDataDialog((Frame)this.dialog.getParent(), "Edit POP User", windowData, new WindowDataDefaultInterface());
        JButton jButton = new JButton("Ok");
        windowDataDialog.getContentPane().add(new AddPOPUserPanel(this, windowDataDialog, jButton, string, this.users));
        if (windowData.size.width == 0) {
            windowDataDialog.pack();
        }
        windowDataDialog.show();
    }

    public final void edit(String string, String string2, POPUserData pOPUserData) throws RemoteException {
        if (this.basis.popserver().existsUser(string2) && !string.equals(string2)) {
            Shell.info("Edit User", "This user already exists!");
            return;
        }
        if (!this.basis.popserver().existsUser(string)) {
            Shell.error("Internal Error", "Edit POP user: this user doesn't exist!", new Throwable());
            return;
        }
        this.basis.editPOPUser(string, string2, pOPUserData, this.users);
        this.listModel.replaceElementAt(string2, this.currentUser);
    }

    public final void remove() {
        int[] nArray = this.list.getSelectedIndices();
        int n = 0;
        while (n < nArray.length) {
            String string = (String)this.listModel.listModel().elementAt(nArray[n] - n);
            this.listModel.listModel().removeElementAt(nArray[n]);
            this.users.remove(string);
            ++n;
        }
    }

    public AdminPOPUserPanel(BasisShellInterface basisShellInterface, JDialog jDialog, PopUserBase popUserBase, boolean bl) {
        super(jDialog, popUserBase.usersAsHashtable(), bl);
        this.users = popUserBase;
        this.basis = basisShellInterface;
    }
}

