/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail.database;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import net.ibm.malamut.newsmail.Basis;
import net.ibm.malamut.newsmail.TidyUpData;
import net.ibm.malamut.newsmail.database.GenericDatabase;
import net.ibm.malamut.newsmail.database.PopMailboxBase;

public class PopmailBase
extends GenericDatabase {
    public void changeUserName(String string, String string2) {
        if (this.containsKey(string)) {
            this.put(string2, this.get(string));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean containsFile(long l) {
        Long l2 = new Long(l);
        this.sync.startRead();
        try {
            Enumeration enumeration = this.data.elements();
            while (true) {
                if (!enumeration.hasMoreElements()) {
                    break;
                }
                Object v = enumeration.nextElement();
                if (v instanceof Hashtable) {
                    if (!((Hashtable)v).containsKey(l2)) continue;
                    boolean bl = true;
                    Object var5_6 = null;
                    this.sync.endRead();
                    return bl;
                }
                this.error();
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.sync.endRead();
            throw throwable;
        }
        Object var5_7 = null;
        this.sync.endRead();
        return false;
    }

    public boolean containsUser(String string) {
        return this.containsKey(string);
    }

    public PopMailboxBase getMailbox(String string) {
        Object object = this.get(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Hashtable) {
            return new PopMailboxBase(this.basis, (Hashtable)object, "popMailbox-" + string, this.sync);
        }
        this.error();
        return null;
    }

    public void newMail(String string, long l) {
        Object object = this.get(string);
        if (!(object instanceof Hashtable) && object != null) {
            this.error();
            return;
        }
        Hashtable<Long, Date> hashtable = (Hashtable<Long, Date>)object;
        Date date = Calendar.getInstance().getTime();
        this.sync.startWrite();
        if (hashtable == null) {
            hashtable = new Hashtable<Long, Date>();
            this.data.put(string, hashtable);
        }
        hashtable.put(new Long(l), date);
        this.sync.endWrite();
    }

    public int numberOfMails() {
        int n = 0;
        this.sync.startRead();
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (v instanceof Hashtable) {
                n += ((Hashtable)v).size();
                continue;
            }
            this.error();
        }
        this.sync.endRead();
        return n;
    }

    public void removeMail(Long l) {
        this.sync.startRead();
        Enumeration enumeration = this.data.elements();
        while (enumeration.hasMoreElements()) {
            Object v = enumeration.nextElement();
            if (v instanceof Hashtable) {
                this.sync.startWrite();
                ((Hashtable)v).remove(l);
                this.sync.endWrite();
                continue;
            }
            this.error();
        }
        this.sync.endRead();
        this.basis.deleteUnneededEmail(l);
    }

    public int removeOrphanedUsers() {
        int n = 0;
        this.sync.startRead();
        Enumeration enumeration = this.data.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.basis.popserver().existsUser(string)) continue;
            this.removeUser(string);
            ++n;
        }
        this.sync.endRead();
        return n;
    }

    public boolean removeUser(String string) {
        PopMailboxBase popMailboxBase = this.getMailbox(string);
        this.remove(string);
        return popMailboxBase.size() != 0;
    }

    public void tidyUp(Hashtable hashtable, TidyUpData tidyUpData) {
        tidyUpData.errors += (long)this.removeOrphanedUsers();
        Object object = new Object();
        this.sync.startRead();
        Enumeration enumeration = this.data.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (!(k instanceof String)) {
                ++tidyUpData.errors;
                this.remove(k);
                this.error();
                continue;
            }
            Object v = this.data.get(k);
            if (!(v instanceof Hashtable)) {
                ++tidyUpData.errors;
                this.remove(k);
                this.error();
                continue;
            }
            Hashtable hashtable2 = (Hashtable)v;
            Enumeration enumeration2 = hashtable2.keys();
            while (enumeration2.hasMoreElements()) {
                k = enumeration2.nextElement();
                if (!(k instanceof Long)) {
                    ++tidyUpData.errors;
                    this.sync.startWrite();
                    hashtable2.remove(k);
                    this.sync.endWrite();
                    this.error();
                    continue;
                }
                Long l = (Long)k;
                if (this.basis.repository().exists(l)) {
                    hashtable.put(l, object);
                    continue;
                }
                this.sync.startWrite();
                hashtable2.remove(l);
                this.sync.endWrite();
                ++tidyUpData.unavailable;
            }
        }
        this.sync.endRead();
    }

    public PopmailBase(Basis basis, String string, boolean bl) throws IOException {
        super(basis, string, bl);
    }
}

