/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail.connections;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Vector;
import net.ibm.malamut.newsmail.Basis;
import net.ibm.malamut.newsmail.MailDataReader;
import net.ibm.malamut.newsmail.OutmailData;
import net.ibm.malamut.newsmail.SMTPAnswer;
import net.ibm.malamut.newsmail.Tools;
import net.ibm.malamut.newsmail.connections.AbstractConnection;
import net.ibm.malamut.newsmail.connections.ConnectionThread;
import net.ibm.malamut.newsmail.ui.ProgressBarPanel;

public class SMTPConnection
extends AbstractConnection {
    private ConnectionThread th;
    private String remoteDomain;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String checkAnswer(int n) throws IOException {
        String string = this.th.getLine();
        try {
            while (string.charAt(3) == '-') {
                string = this.th.getLine();
            }
        }
        catch (Exception exception) {
            throw new IOException("Received invalid reply from SMTP server.");
        }
        if (!string.startsWith(new Integer(n).toString())) {
            throw new IOException(string);
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean checkAnswer(int n, int n2) throws IOException {
        String string = this.th.getLine();
        try {
            while (string.charAt(3) == '-') {
                string = this.th.getLine();
            }
        }
        catch (Exception exception) {
            throw new IOException("Received invalid reply from SMTP server.");
        }
        if (string.startsWith(new Integer(n).toString())) return true;
        if (string.startsWith(new Integer(n2).toString())) return true;
        return false;
    }

    protected void doCancel(int n, int n2) throws IOException {
        this.th.cancel();
        this.doClose(n2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doClose(int n) throws IOException {
        this.th.prepareForClosing();
        try {
            this.th.writeCommand("quit");
            this.th.getLine();
        }
        catch (IOException iOException) {
        }
        this.th.close();
    }

    protected void doLogin(int n) throws IOException {
        String string = this.checkAnswer(220);
        this.remoteDomain = new SMTPAnswer(string).domain();
        this.th.writeCommand("HELO " + Tools.getLocalHostName());
        this.checkAnswer(250);
    }

    public boolean mail(String string, Vector vector, long l, Basis basis, ProgressBarPanel progressBarPanel, OutmailData outmailData) throws IOException {
        this.th.writeCommand("MAIL FROM:<" + string + ">");
        this.checkAnswer(250);
        Vector vector2 = new Vector();
        int n = 0;
        while (n < vector.size()) {
            this.th.writeCommand("RCPT TO:<" + vector.elementAt(n) + ">");
            if (!this.checkAnswer(250, 251)) {
                vector2.addElement(vector.elementAt(n));
            }
            ++n;
        }
        if (vector2.size() < vector.size()) {
            this.th.writeCommand("DATA");
            this.checkAnswer(354);
            MailDataReader mailDataReader = new MailDataReader(basis.repository(), l);
            BufferedReader bufferedReader = mailDataReader.getReader();
            this.th.writeText(bufferedReader, progressBarPanel);
            mailDataReader.close();
            this.checkAnswer(250);
        }
        if (vector2.size() > 0) {
            basis.outmailFailure(l, outmailData.fromHost, outmailData.from, vector2);
            if (vector2.size() == vector.size()) {
                throw new IOException("Mail could not be delivered to any recipient.");
            }
            Tools.log("Mail could not be delivered to all recipients");
            return false;
        }
        return true;
    }

    public SMTPConnection(String string, int n, int n2) {
        super(string, 25, n, n2);
        this.th = this.thread[0];
    }
}

