/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail.connections;

import java.io.IOException;
import java.net.Socket;
import net.ibm.malamut.newsmail.connections.ConnectionThread;

public abstract class AbstractConnection {
    protected final int NONE = 0;
    protected final int LOGGED_IN = 1;
    protected ConnectionThread[] thread;
    protected boolean[] ready;
    protected int[] status;
    private boolean closed = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cancel(int n) {
        int n2 = 0;
        while (n2 < this.ready.length) {
            try {
                this.doCancel(n, n2);
            }
            catch (IOException iOException) {
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        int n = 0;
        while (n < this.ready.length) {
            try {
                this.doClose(n);
            }
            catch (IOException iOException) {
            }
            ++n;
        }
    }

    protected abstract void doCancel(int var1, int var2) throws IOException;

    protected abstract void doClose(int var1) throws IOException;

    protected abstract void doLogin(int var1) throws IOException;

    public void login() throws IOException {
        int n = 0;
        while (n < this.ready.length) {
            this.doLogin(n);
            this.status[n] = 1;
            ++n;
        }
    }

    public AbstractConnection(String string, int n, int n2, int n3) {
        this(string, n, n2, n3, 1);
    }

    public AbstractConnection(String string, int n, int n2, int n3, int n4) {
        this.ready = new boolean[n4];
        this.thread = new ConnectionThread[n4];
        this.status = new int[n4];
        int n5 = 0;
        while (n5 < n4) {
            this.ready[n5] = false;
            this.status[n5] = 0;
            this.thread[n5] = new ConnectionThread(string, n, n2, n3);
            ++n5;
        }
    }

    public AbstractConnection(Socket socket, int n) {
        this.ready = new boolean[1];
        this.ready[0] = false;
        this.status = new int[1];
        this.status[0] = 0;
        this.thread = new ConnectionThread[1];
        this.thread[0] = new ConnectionThread(socket, n);
    }
}

