/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.InetAddress;
import java.util.Calendar;
import java.util.Random;
import net.ibm.malamut.newsmail.EchoWriter;
import net.ibm.malamut.newsmail.ErrorTools;
import net.ibm.malamut.newsmail.version.CommonConstants;

public class Tools {
    private static String hostname = null;
    private static BufferedWriter logWriter = new BufferedWriter(new OutputStreamWriter(System.err));
    private static long memoryUsed = 0L;

    public static void copyFile(File file, File file2) throws IOException {
        Tools.copyFile(file, file2, true);
    }

    public static void copyFile(File file, File file2, boolean bl) throws IOException {
        if (!file.exists() && !bl) {
            return;
        }
        int n = 32768;
        byte[] byArray = new byte[32768];
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        int n2 = fileInputStream.read(byArray);
        while (n2 > 0) {
            fileOutputStream.write(byArray, 0, n2);
            n2 = fileInputStream.read(byArray);
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    public static String fakeMsgid(long l, boolean bl) {
        String string = new Long(Math.abs(Calendar.getInstance().getTime().getTime())).toString();
        string = string + "." + new Long(Math.abs(new Random(l).nextLong())).toString();
        string = bl ? string + "@knm-MID-fill-in." + Tools.getLocalHostName() : string + "@knm." + Tools.getLocalHostName();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getLocalHostName() {
        if (hostname == null) {
            block4: {
                try {
                    hostname = InetAddress.getLocalHost().getHostName();
                }
                catch (Exception exception) {
                    if (!CommonConstants.debugL) break block4;
                    Tools.log("Warning: This machine sufferes from an invalid TCP/IP configuration.");
                    Tools.log("  Message returned by the Java Runtime System:");
                    Tools.log("  " + exception.getMessage());
                }
            }
            if (hostname == null || hostname.toLowerCase().equals("localhost") || hostname.equals("")) {
                hostname = "not-for-mail";
            }
        }
        return hostname;
    }

    public static BufferedWriter log() {
        return logWriter;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void log(String string) {
        try {
            logWriter.write(string);
            logWriter.newLine();
            logWriter.flush();
            return;
        }
        catch (IOException iOException) {
            System.err.println("An error occurred while trying to output information to the log file:");
            iOException.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void log(String string, Throwable throwable) {
        try {
            logWriter.write(string);
            logWriter.newLine();
            logWriter.write(ErrorTools.redirect(throwable));
            logWriter.newLine();
            logWriter.flush();
            BufferedWriter bufferedWriter = logWriter;
            if (logWriter instanceof EchoWriter) {
                bufferedWriter = ((EchoWriter)logWriter).getEchoWriter();
            }
            bufferedWriter.write("Full stack trace:");
            bufferedWriter.newLine();
            bufferedWriter.write(ErrorTools.redirectFully(throwable));
            bufferedWriter.newLine();
            bufferedWriter.flush();
            return;
        }
        catch (IOException iOException) {
            System.err.println("An error occurred while trying to output an error report to the log file:");
            iOException.printStackTrace();
            System.err.println("This is the error message we tried to log:");
            System.err.println(throwable.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void logPart(String string) {
        try {
            logWriter.write(string);
            logWriter.flush();
            return;
        }
        catch (IOException iOException) {
            System.err.println("An error occurred while trying to output information to the log file:");
            iOException.printStackTrace();
        }
    }

    public static void memoryAlert(String string) {
        Runtime.getRuntime().gc();
        long l = Runtime.getRuntime().totalMemory();
        long l2 = Runtime.getRuntime().freeMemory();
        if (l - l2 > memoryUsed) {
            memoryUsed = l - l2;
        }
        double d = (double)l2 / (double)l * 100.0;
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.setScale(1, 4);
        BigDecimal bigDecimal2 = new BigDecimal((double)l / 1024.0 / 1024.0);
        bigDecimal2 = bigDecimal2.setScale(1, 4);
        if (d < 50.0) {
            Tools.log(string + ", you have " + bigDecimal + "% of your memory free.");
            Tools.log("  (Your total JVM memory is currently " + bigDecimal2 + " MB .)");
        }
    }

    public static void memoryFullAlert(String string) {
        Runtime.getRuntime().gc();
        long l = Runtime.getRuntime().totalMemory();
        if (l > memoryUsed) {
            memoryUsed = l;
        }
        BigDecimal bigDecimal = new BigDecimal((double)l / 1024.0 / 1024.0);
        bigDecimal = bigDecimal.setScale(1, 4);
        Tools.log(string + ", you are out of memory!");
        Tools.log("  (Your total JVM memory is currently " + bigDecimal + " MB .)");
    }

    public static void memoryStatus() {
        Runtime.getRuntime().gc();
        long l = Runtime.getRuntime().totalMemory();
        double d = (double)memoryUsed / (double)l * 100.0;
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.setScale(1, 4);
        BigDecimal bigDecimal2 = new BigDecimal((double)l / 1024.0 / 1024.0);
        bigDecimal2 = bigDecimal2.setScale(1, 4);
        Tools.log("\n" + bigDecimal + "% or more of a total JVM memory of " + bigDecimal2 + " MB have been used.");
    }

    public static void setLogFile(String string, String string2) throws IOException {
        logWriter.flush();
        FileWriter fileWriter = new FileWriter(string, true);
        fileWriter.write(string2);
        fileWriter.flush();
        logWriter = new EchoWriter((Writer)new OutputStreamWriter(System.out), new BufferedWriter(fileWriter));
    }
}

