/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import net.ibm.malamut.newsmail.MailDataRepository;
import net.ibm.malamut.newsmail.Tools;

public final class MailDataWriter {
    private long file;
    private MailDataRepository repository;
    private BufferedWriter bw;
    private ByteArrayOutputStream bs;

    public final void close() throws IOException {
        this.bw.close();
        ((OutputStream)this.bs).close();
        this.repository.put(this.file, this.bs.toByteArray());
    }

    public final long file() {
        return this.file;
    }

    public final ByteArrayOutputStream getStream() {
        return this.bs;
    }

    public final BufferedWriter getWriter() {
        return this.bw;
    }

    public MailDataWriter(MailDataRepository mailDataRepository) {
        this.repository = mailDataRepository;
        this.file = mailDataRepository.basis().getNextArticleFile();
        if (mailDataRepository.exists(this.file)) {
            Tools.log("Internal error: tried to write to existing repository file.");
        }
        this.bs = new ByteArrayOutputStream();
        this.bw = new BufferedWriter(new OutputStreamWriter(this.bs));
    }

    public MailDataWriter(MailDataRepository mailDataRepository, long l) {
        this.repository = mailDataRepository;
        this.file = l;
        if (this.repository.exists(l)) {
            this.repository.delete(l);
        }
        this.bs = new ByteArrayOutputStream();
        this.bw = new BufferedWriter(new OutputStreamWriter(this.bs));
    }
}

