/*
 * Decompiled with CFR 0.152.
 */
package net.ibm.malamut.newsmail;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import net.ibm.malamut.newsmail.ActiveData;
import net.ibm.malamut.newsmail.ArticleData;
import net.ibm.malamut.newsmail.BasisConstants;
import net.ibm.malamut.newsmail.BasisFileFilter;
import net.ibm.malamut.newsmail.BasisShellInterface;
import net.ibm.malamut.newsmail.ConnectionData;
import net.ibm.malamut.newsmail.ExtendedConnectionInterruptor;
import net.ibm.malamut.newsmail.GenericServer;
import net.ibm.malamut.newsmail.GroupData;
import net.ibm.malamut.newsmail.MailDataReader;
import net.ibm.malamut.newsmail.MailDataRepository;
import net.ibm.malamut.newsmail.MailDataWriter;
import net.ibm.malamut.newsmail.NNTPServer;
import net.ibm.malamut.newsmail.OptionsData;
import net.ibm.malamut.newsmail.OutmailData;
import net.ibm.malamut.newsmail.POPServer;
import net.ibm.malamut.newsmail.POPUserData;
import net.ibm.malamut.newsmail.RFCAnalyzer;
import net.ibm.malamut.newsmail.SMTPServer;
import net.ibm.malamut.newsmail.StartStop;
import net.ibm.malamut.newsmail.TidyUpData;
import net.ibm.malamut.newsmail.Tools;
import net.ibm.malamut.newsmail.WindowData;
import net.ibm.malamut.newsmail.connections.AbstractConnection;
import net.ibm.malamut.newsmail.connections.NNTPControlConnection;
import net.ibm.malamut.newsmail.connections.NNTPDownloadConnection;
import net.ibm.malamut.newsmail.connections.POPConnection;
import net.ibm.malamut.newsmail.connections.SMTPConnection;
import net.ibm.malamut.newsmail.database.ConnectionBase;
import net.ibm.malamut.newsmail.database.GateBase;
import net.ibm.malamut.newsmail.database.GroupBase;
import net.ibm.malamut.newsmail.database.MsgidBase;
import net.ibm.malamut.newsmail.database.NewsserverBase;
import net.ibm.malamut.newsmail.database.OutgoingBase;
import net.ibm.malamut.newsmail.database.OutmailBase;
import net.ibm.malamut.newsmail.database.PopMailboxBase;
import net.ibm.malamut.newsmail.database.PopServerBase;
import net.ibm.malamut.newsmail.database.PopUserBase;
import net.ibm.malamut.newsmail.database.PopmailBase;
import net.ibm.malamut.newsmail.database.SmtpServerBase;
import net.ibm.malamut.newsmail.database.WindowBase;
import net.ibm.malamut.newsmail.gateways.JanusGate;
import net.ibm.malamut.newsmail.netcall.GatewayServer;
import net.ibm.malamut.newsmail.ui.CommProgressWindow;
import net.ibm.malamut.newsmail.ui.Shell;
import net.ibm.malamut.newsmail.version.CommonConstants;

public final class Basis
extends UnicastRemoteObject
implements BasisConstants,
BasisShellInterface,
ExtendedConnectionInterruptor {
    private String dataDir;
    private int readThreads;
    private int artRetries;
    private int timeout;
    private int connectionTimeout;
    private int serverTimeout;
    private boolean doBackup;
    private int failureAllowed;
    private int maxRepositoryFileSize;
    private MailDataRepository repository;
    private MailDataRepository prepack;
    private NewsserverBase newsserver;
    private SmtpServerBase smtpserver;
    private PopServerBase popserver;
    private GateBase gateways;
    private GroupBase groups;
    private MsgidBase msgid;
    private OutgoingBase outgoing;
    private OutmailBase outmail;
    private PopmailBase popmail;
    private WindowBase windowData;
    private long lastNumber;
    private boolean sendToAll;
    private boolean forwardAll;
    private boolean saveWindowPos;
    private boolean deleteWindowPos;
    private int defaultFont;
    private String configFileName;
    private String superuserAddress;
    private String superuserPassword;
    private FileOutputStream lock;
    private boolean doRelax;
    private Vector lockedPOPUserNames;
    private ConnectionBase connections;
    private final String separator;

    public final void addMsgid(String string, ArticleData articleData) {
        this.msgid.put(string, articleData);
    }

    public final void addNewsgroup(String string, String string2, boolean bl) throws IOException {
        string = string.toLowerCase();
        this.groups.add(string, string2);
        if (string2 != null) {
            if (!this.newsserver.exists(string2)) {
                throw new IOException("Internal Error: Newsserver '" + string2 + "' doesn't exist.");
            }
            Hashtable hashtable = this.newsserver.getActiveGroups(string2);
            if (!hashtable.containsKey(string)) {
                ActiveData activeData = new ActiveData();
                activeData.writeAllowed = bl;
                activeData.lastArticle = 0L;
                hashtable.put(string, activeData);
                this.newsserver.putActiveGroups(string2, hashtable);
            }
        }
    }

    public final void addToOutmail(long l, String string, String string2, Vector vector) {
        String string3;
        Hashtable hashtable = new Hashtable();
        Vector<String> vector2 = new Vector<String>();
        int n = vector.size();
        PopUserBase popUserBase = this.popserver.users();
        int n2 = 0;
        while (n2 < n) {
            string3 = (String)vector.elementAt(n2);
            if (string3.toLowerCase().trim().startsWith(this.superuserAddress.toLowerCase())) {
                this.popmail.newMail("postmaster", l);
            } else {
                Vector vector3 = popUserBase.usersForAddress(string3);
                int n3 = 0;
                while (n3 < vector3.size()) {
                    this.popmail.newMail((String)vector3.elementAt(n3), l);
                    ++n3;
                }
                if (vector3.size() <= 0) {
                    String string4 = this.getSMTPServerForPath(string3);
                    if (string4 == null) {
                        vector2.addElement("No route to path: " + string3);
                    } else if (hashtable.containsKey(string4)) {
                        ((Vector)hashtable.get(string4)).addElement(string3);
                    } else {
                        Vector<String> vector4 = new Vector<String>();
                        vector4.addElement(string3);
                        hashtable.put(string4, vector4);
                    }
                }
            }
            ++n2;
        }
        if (vector2.size() > 0) {
            this.outmailFailure(l, string, string2, vector2);
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string3 = (String)enumeration.nextElement();
            this.addToOutmail(l, string, string2, (Vector)hashtable.get(string3), string3);
        }
    }

    private final void addToOutmail(long l, String string, String string2, Vector vector, String string3) {
        Date date = Calendar.getInstance().getTime();
        OutmailData outmailData = new OutmailData();
        outmailData.date = Calendar.getInstance().getTime();
        outmailData.server = string3;
        outmailData.from = string2;
        outmailData.to = vector;
        outmailData.fromHost = string;
        this.outmail.add(outmailData, l);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void addToOutnews(String string, String string2) {
        if (string2 != null && !this.forwardAll) {
            return;
        }
        Vector vector = this.groups.isInGroups(string);
        Vector<String> vector2 = new Vector<String>();
        Vector vector3 = this.sendToAll ? this.newsserver.servers() : this.groups.serversForGroups(vector);
        int n = 0;
        while (n < vector3.size()) {
            String string3 = (String)vector3.elementAt(n);
            if (!string3.equals(string2)) {
                try {
                    Hashtable hashtable = this.newsserver.getActiveGroups(string3);
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        if (hashtable.containsKey(vector.elementAt(n2)) && ((ActiveData)hashtable.get(vector.elementAt((int)n2))).writeAllowed) {
                            vector2.addElement(string3);
                            n2 = vector.size();
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {
                    Tools.log("Database error:", exception);
                }
            }
            ++n;
        }
        if (vector2.size() > 0) {
            this.outgoing.put(string, vector2);
        }
    }

    public final boolean addToReplyPath(long l) throws IOException {
        boolean bl = false;
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        MailDataReader mailDataReader = new MailDataReader(this.repository, l);
        BufferedReader bufferedReader = mailDataReader.getReader();
        String string = bufferedReader.readLine();
        while (string != null) {
            bufferedWriter.write(string);
            bufferedWriter.newLine();
            string = bufferedReader.readLine();
        }
        bufferedWriter.close();
        mailDataReader.close();
        bufferedReader = new BufferedReader(new StringReader(stringWriter.toString()));
        MailDataWriter mailDataWriter = new MailDataWriter(this.repository, l);
        bufferedWriter = mailDataWriter.getWriter();
        string = bufferedReader.readLine();
        if (string == null) {
            string = "";
        }
        while (!string.equals("")) {
            if (string.startsWith("Path: ")) {
                bl = true;
                if (string.equals("Path: ")) {
                    bufferedWriter.write("Path: " + Tools.getLocalHostName());
                } else {
                    bufferedWriter.write("Path: " + Tools.getLocalHostName() + "!" + string.substring("Path: ".length()));
                }
                bufferedWriter.newLine();
            } else {
                bufferedWriter.write(string);
                bufferedWriter.newLine();
            }
            string = bufferedReader.readLine();
            if (string != null) continue;
            string = "";
        }
        if (!bl) {
            bufferedWriter.write("Path: " + Tools.getLocalHostName() + "!not-for-mail");
            bufferedWriter.newLine();
        }
        bufferedWriter.newLine();
        string = bufferedReader.readLine();
        while (string != null) {
            bufferedWriter.write(string);
            bufferedWriter.newLine();
            string = bufferedReader.readLine();
        }
        mailDataWriter.close();
        bufferedReader.close();
        return bl;
    }

    private final Vector analyzeAddress(String string) {
        int n;
        int n2;
        Vector<String> vector = new Vector<String>();
        do {
            int n3;
            int n4 = n2 = (n3 = string.lastIndexOf(46)) > (n = string.lastIndexOf(64)) ? n3 : n;
            if (n2 == -1) {
                if (string.length() > 0) {
                    vector.addElement(string);
                }
                return vector;
            }
            if (n2 == string.length() - 1) {
                vector.addElement("");
            } else {
                vector.addElement(string.substring(n2 + 1));
            }
            string = string.substring(0, n2);
        } while (n2 != n);
        vector.addElement("@");
        vector.addElement(string);
        return vector;
    }

    public final void changeXrefLine(long l, String string) throws IOException {
        boolean bl = false;
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        MailDataReader mailDataReader = new MailDataReader(this.repository, l);
        BufferedReader bufferedReader = mailDataReader.getReader();
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            bufferedWriter.write(string2);
            bufferedWriter.newLine();
            string2 = bufferedReader.readLine();
        }
        bufferedWriter.close();
        mailDataReader.close();
        bufferedReader = new BufferedReader(new StringReader(stringWriter.toString()));
        MailDataWriter mailDataWriter = new MailDataWriter(this.repository, l);
        bufferedWriter = mailDataWriter.getWriter();
        string2 = bufferedReader.readLine();
        if (string2 == null) {
            string2 = "";
        }
        while (!string2.equals("")) {
            if (!string2.toLowerCase().startsWith("xref: ")) {
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
            }
            if ((string2 = bufferedReader.readLine()) != null) continue;
            string2 = "";
        }
        if (!bl) {
            bufferedWriter.write(string);
            bufferedWriter.newLine();
        }
        bufferedWriter.newLine();
        string2 = bufferedReader.readLine();
        while (string2 != null) {
            bufferedWriter.write(string2);
            bufferedWriter.newLine();
            string2 = bufferedReader.readLine();
        }
        mailDataWriter.close();
        bufferedReader.close();
    }

    private final int compareDomains(Vector vector, Vector vector2) {
        int n = 0;
        while (vector.size() > n && vector2.size() > n) {
            if (!((String)vector.elementAt(n)).equals((String)vector2.elementAt(n))) {
                return n;
            }
            ++n;
        }
        return n;
    }

    public final void contactGate(CommProgressWindow commProgressWindow, String string) {
        this.gateways.object(string).contact(commProgressWindow);
        if (commProgressWindow.connectionData().getAbort() > 0) {
            commProgressWindow.connectionData().setAbort(10);
        }
    }

    public final void contactGates(CommProgressWindow commProgressWindow) throws RemoteException {
        int n = -1;
        if (commProgressWindow == null) {
            commProgressWindow = new CommProgressWindow(null, this, true, 3);
            n = this.gateways.size();
            commProgressWindow.all().setArea(0, n + 1);
            commProgressWindow.all().setValue(1);
        }
        Vector vector = this.gateways.names();
        int n2 = 0;
        while (n2 < vector.size()) {
            String string = (String)vector.elementAt(n2);
            commProgressWindow.all().setText("Sending mail to gateway: " + string);
            if (commProgressWindow.connectionData().getAbort() > 0) {
                this.contactGate(commProgressWindow, string);
            }
            commProgressWindow.all().increase();
            ++n2;
        }
        if (n > -1) {
            commProgressWindow.all().setText("Finished!");
            commProgressWindow.all().setValue(n + 1);
            commProgressWindow.dispose();
        }
    }

    private final void createConfigFile(String string) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
        this.dataDir = System.getProperty("user.home") + System.getProperty("file.separator") + ".knewsmaildata";
        File file = new File(this.dataDir);
        this.dataDir = file.getAbsolutePath() + System.getProperty("file.separator");
        file.mkdirs();
        this.lastNumber = 0L;
        this.saveLastFile(false);
        this.writeConfigFile();
    }

    public final void createGateway(String string, String string2) {
        if (this.gateways.exists(string)) {
            Shell.info("Create new Gateway", "A gateway with the title " + string + " already exists.");
            return;
        }
        this.gateways.create(string, string2);
    }

    public final void createNewsserver(String string, String string2) throws IOException {
        if (this.newsserver.titles().contains(string2)) {
            throw new IOException("There already exists a newsserver titled '" + string2 + "'.");
        }
        this.newsserver.create(string, string2);
    }

    public final void createPOPServer(String string, String string2) throws IOException {
        if (this.popserver.titles().contains(string2)) {
            throw new IOException("There already exists a pop server titled '" + string2 + "'.");
        }
        if (this.popserver.exists(string)) {
            return;
        }
        this.popserver.create(string, string2);
    }

    public final void createSMTPServer(String string, String string2) throws IOException {
        if (this.smtpserver.titles().contains(string2)) {
            throw new IOException("There already exists an smtp server titled '" + string2 + "'.");
        }
        if (this.smtpserver.exists(string)) {
            return;
        }
        this.smtpserver.create(string, string2);
    }

    private final void databaseLoadBackup() throws IOException {
        File file = new File(this.dataDir + "backup");
        if (!file.isDirectory()) {
            throw new IOException("There is no backup directory!");
        }
        String string = file.getAbsolutePath();
        if (!string.endsWith(this.separator)) {
            string = string + this.separator;
        }
        Tools.copyFile(new File(string + "last"), new File(this.dataDir + "last"));
        Tools.copyFile(new File(string + "newsserver"), new File(this.dataDir + "newsserver"));
        Tools.copyFile(new File(string + "smtpserver"), new File(this.dataDir + "smtpserver"));
        Tools.copyFile(new File(string + "popserver"), new File(this.dataDir + "popserver"));
        Tools.copyFile(new File(string + "gateways"), new File(this.dataDir + "gateways"));
        Tools.copyFile(new File(string + "groups2"), new File(this.dataDir + "groups2"));
        Tools.copyFile(new File(string + "msgid2"), new File(this.dataDir + "msgid2"));
        Tools.copyFile(new File(string + "outgoing"), new File(this.dataDir + "outgoing"));
        Tools.copyFile(new File(string + "popmail"), new File(this.dataDir + "popmail"));
        Tools.copyFile(new File(string + "outmail"), new File(this.dataDir + "outmail"));
        Tools.copyFile(new File(string + "winpos"), new File(this.dataDir + "winpos"), false);
        MailDataRepository.restore("mdr", string, this);
        MailDataRepository.restore("ppk", string, this);
        char[] cArray = new char[]{'a', 'n'};
        int n = 0;
        while (n < cArray.length) {
            String[] stringArray = file.list(new BasisFileFilter(cArray[n]));
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string2 = stringArray[n2];
                File file2 = new File(this.dataDir + string2);
                File file3 = new File(string + string2);
                Tools.copyFile(file3, file2);
                ++n2;
            }
            ++n;
        }
    }

    private final void databaseRead(boolean bl) throws IOException {
        this.newsserver = new NewsserverBase(this, "newsserver", !bl);
        this.smtpserver = new SmtpServerBase(this, "smtpserver", !bl);
        this.popserver = new PopServerBase(this, "popserver", !bl);
        this.gateways = new GateBase(this, "gateways", !bl);
        this.groups = new GroupBase(this, "groups2", !bl);
        this.msgid = new MsgidBase(this, "msgid2", !bl);
        this.outgoing = new OutgoingBase(this, "outgoing", !bl);
        this.popmail = new PopmailBase(this, "popmail", !bl);
        this.outmail = new OutmailBase(this, "outmail", !bl);
        this.windowData = new WindowBase(this, "winpos", !bl);
        this.repository = new MailDataRepository("mdr", this, this.maxRepositoryFileSize, bl);
        this.prepack = new MailDataRepository("ppk", this, this.maxRepositoryFileSize, bl);
    }

    private final void databaseSaveBackup(String string) throws IOException {
        File file = new File(this.dataDir + string);
        if (!file.exists()) {
            file.mkdir();
        }
        if (!file.isDirectory()) {
            throw new IOException("Can't create backup directory!");
        }
        String string2 = file.getAbsolutePath();
        if (!string2.endsWith(this.separator)) {
            string2 = string2 + this.separator;
        }
        Tools.copyFile(new File(this.dataDir + "last"), new File(string2 + "last"));
        Tools.copyFile(new File(this.dataDir + "newsserver"), new File(string2 + "newsserver"));
        Tools.copyFile(new File(this.dataDir + "smtpserver"), new File(string2 + "smtpserver"));
        Tools.copyFile(new File(this.dataDir + "popserver"), new File(string2 + "popserver"));
        Tools.copyFile(new File(this.dataDir + "gateways"), new File(string2 + "gateways"));
        Tools.copyFile(new File(this.dataDir + "groups2"), new File(string2 + "groups2"));
        Tools.copyFile(new File(this.dataDir + "msgid2"), new File(string2 + "msgid2"));
        Tools.copyFile(new File(this.dataDir + "outgoing"), new File(string2 + "outgoing"));
        Tools.copyFile(new File(this.dataDir + "popmail"), new File(string2 + "popmail"));
        Tools.copyFile(new File(this.dataDir + "outmail"), new File(string2 + "outmail"));
        Tools.copyFile(new File(this.dataDir + "winpos"), new File(string2 + "winpos"), false);
        MailDataRepository.backup("mdr", string2, this);
        MailDataRepository.backup("ppk", string2, this);
        File file2 = new File(this.dataDir);
        char[] cArray = new char[]{'a', 'n'};
        int n = 0;
        while (n < cArray.length) {
            String[] stringArray = file2.list(new BasisFileFilter(cArray[n]));
            int n2 = 0;
            while (n2 < stringArray.length) {
                String string3 = stringArray[n2];
                File file3 = new File(this.dataDir + string3);
                File file4 = new File(string2 + string3);
                Tools.copyFile(file3, file4);
                ++n2;
            }
            ++n;
        }
    }

    public final String dataDir() {
        return this.dataDir;
    }

    public final void deleteUnneededEmail(long l) {
        if (!(this.outmail.containsFile(l) || this.msgid.containsFile(l) || this.popmail.containsFile(l))) {
            this.repository.delete(l);
        }
    }

    public final void editGateway(String string, String string2) throws RemoteException {
        if (this.gateways.exists(string2)) {
            Shell.info("Edit Gateway", "A gateway with the title " + string2 + " already exists.");
            return;
        }
        if (!this.gateways.exists(string)) {
            Shell.info("Edit Gateway", "A gateway with the title " + string + " doesn't exist.");
            return;
        }
        this.gateways.rename(string2, string);
    }

    public final void editNewsserver(String string, String string2) throws IOException {
        if (this.newsserver.title(string).equals(string2)) {
            return;
        }
        if (this.newsserver.titles().contains(string2)) {
            throw new IOException("There already exists another newsserver titled '" + string2 + "'.");
        }
        this.newsserver.rename(string, string2);
    }

    public final void editPOPServer(String string, String string2) throws IOException {
        if (this.popserver.titles().contains(string2)) {
            throw new IOException("There already exists another pop server titled '" + string2 + "'.");
        }
        this.popserver.newTitle(string, string2);
    }

    public final void editPOPUser(String string, String string2, POPUserData pOPUserData, PopUserBase popUserBase) {
        this.popmail.changeUserName(string, string2);
        popUserBase.remove(string);
        popUserBase.addUser(string2, pOPUserData);
    }

    public final void editSMTPServer(String string, String string2) throws IOException {
        if (this.smtpserver.titles().contains(string2)) {
            throw new IOException("There already exists another smtp server titled '" + string2 + "'.");
        }
        this.smtpserver.newTitle(string, string2);
    }

    public final boolean existsMsgid(String string) {
        return this.msgid.exists(string);
    }

    public final boolean existsNewsgroup(String string) {
        return this.groups.exists(string.toLowerCase());
    }

    private final void extractNewsgroups(Vector vector, String string) {
        int n;
        String string2 = string;
        while ((n = string2.indexOf(44)) != -1) {
            String string3 = string2.substring(0, n).trim();
            string2 = string2.substring(n + 1);
            if (string3.equals("")) continue;
            vector.addElement(string3);
        }
        if (!(string2 = string2.trim()).equals("")) {
            vector.addElement(string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void finalize() throws Throwable {
        try {
            if (!this.doRelax) return;
            this.relax();
            return;
        }
        catch (IOException iOException) {
            Tools.log("An error occurred while saving the database", iOException);
        }
    }

    public final GateBase gates() {
        return this.gateways;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void gatewayHasMail(long l, Hashtable hashtable) {
        String string;
        String string2;
        Vector<Object> vector;
        Object object;
        if (hashtable.containsKey("To")) {
            object = hashtable.get("To");
            if (object instanceof Vector) {
                vector = (Vector)object;
            } else {
                vector = new Vector<Object>();
                vector.addElement(object);
            }
            string2 = Tools.getLocalHostName();
            string = (String)hashtable.get("From");
            if (hashtable.containsKey("X-ZC-" + "ERR") || hashtable.containsKey("X-ZC-" + "Stat")) {
                string = "";
            }
            this.addToOutmail(l, string2, string, vector);
        }
        if (!hashtable.containsKey("Newsgroups")) return;
        vector = this.getGroupsForArticle(l);
        object = new Vector();
        string2 = null;
        try {
            string2 = this.getMsgId(l, false, false);
        }
        catch (IOException iOException) {
            Tools.log("Unexpected Exception on Message-ID while sorting file No. " + l + " from gateway into newsserver database:", iOException);
        }
        if (this.msgid.exists(string2)) return;
        string = "Xref: " + Tools.getLocalHostName() + " ";
        int n = 0;
        while (n < vector.size()) {
            String string3 = (String)vector.elementAt(n);
            GroupData groupData = this.getGroupData(string3);
            if (groupData != null) {
                this.groups.sync().startWrite();
                ++groupData.lastArticle;
                groupData.articles.put(new Long(groupData.lastArticle), string2);
                this.groups.sync().endWrite();
                string = string + string3 + ":" + groupData.lastArticle;
            } else {
                ((Vector)object).addElement(string3);
            }
            ++n;
        }
        if (((Vector)object).size() > 0) {
            this.outnewsFailure(l, (String)hashtable.get("From"), (Vector)object, true);
        }
        ArticleData articleData = new ArticleData();
        articleData.file = l;
        articleData.received = Calendar.getInstance().getTime();
        this.addMsgid(string2, articleData);
        this.addToOutnews(string2, null);
        try {
            this.changeXrefLine(articleData.file, string);
            this.addToReplyPath(l);
            return;
        }
        catch (IOException iOException) {
            Tools.log("Unexpected Exception on modifying headers after sorting file No. " + l + " from gateway into newsserver database: ", iOException);
        }
    }

    public final Vector getExpired(Vector vector, Date date) {
        return this.msgid.getExpired(vector, date, this.groups);
    }

    public final long getFileFromMsgid(String string) {
        return this.msgid.get((String)string).file;
    }

    public final String[] getGatewayNames() {
        Vector vector = this.gateways.names();
        String[] stringArray = new String[this.gateways.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public final GroupData getGroupData(String string) {
        return this.groups.getData(string.toLowerCase());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Vector getGroupsForArticle(long l) {
        MailDataReader mailDataReader = null;
        Vector vector = new Vector();
        String string = ".";
        boolean bl = false;
        try {
            try {
                mailDataReader = new MailDataReader(this.repository, l);
                BufferedReader bufferedReader = mailDataReader.getReader();
                while (true) {
                    block12: {
                        block11: {
                            if (string == null) break block11;
                            if (!"".equals(string)) break block12;
                        }
                        Object var8_8 = null;
                        if (mailDataReader != null) return vector;
                        mailDataReader.close();
                        return vector;
                    }
                    string = bufferedReader.readLine();
                    if (string == null) {
                        throw new IOException();
                    }
                    if (string.startsWith("Newsgroups: ")) {
                        bl = true;
                        this.extractNewsgroups(vector, string.substring("Newsgroups: ".length()));
                        continue;
                    }
                    if (bl && (string.startsWith(" ") || string.startsWith("\t"))) {
                        this.extractNewsgroups(vector, string.substring(1));
                        continue;
                    }
                    bl = false;
                }
            }
            catch (IOException iOException) {
                Tools.log("File format error while scanning mail No. " + l + ":", iOException);
                Object var8_9 = null;
                if (mailDataReader != null) return vector;
                mailDataReader.close();
                return vector;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (mailDataReader != null) throw throwable;
            mailDataReader.close();
            throw throwable;
        }
    }

    public final synchronized long getLastArticleFile() {
        return this.lastNumber;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void getMails(CommProgressWindow commProgressWindow) throws RemoteException {
        int n = -1;
        if (commProgressWindow == null) {
            commProgressWindow = new CommProgressWindow(null, this, true, 2);
            n = this.popserver.size();
            commProgressWindow.all().setArea(0, n + 1);
            commProgressWindow.all().setValue(1);
        }
        Vector vector = this.popserver.servers();
        int n2 = 0;
        while (n2 < vector.size()) {
            String string = (String)vector.elementAt(n2);
            commProgressWindow.all().setText("Receiving mail from server: " + this.popserver.title(string));
            try {
                if (commProgressWindow.connectionData().getAbort() > 0) {
                    this.getMails(commProgressWindow, string);
                }
            }
            catch (IOException iOException) {
                Tools.log("No all mails could be retrieved from server '" + string + "'. Reason:", iOException);
                ++commProgressWindow.connectionData().errors;
            }
            commProgressWindow.all().increase();
            ++n2;
        }
        if (n > -1) {
            commProgressWindow.all().setText("Finished!");
            commProgressWindow.all().setValue(n + 1);
            commProgressWindow.dispose();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void getMails(CommProgressWindow commProgressWindow, String string) throws IllegalArgumentException, IOException {
        int n;
        if (!this.popserver.exists(string)) {
            throw new IllegalArgumentException("Unknown pop server: '" + string + "'");
        }
        PopUserBase popUserBase = this.popserver.users(string);
        boolean bl = false;
        if (commProgressWindow == null) {
            bl = true;
            commProgressWindow = new CommProgressWindow(null, this, false, 2);
            commProgressWindow.group().setTitle("Progress for User");
            commProgressWindow.group().setPartialEnabled(true);
            commProgressWindow.mail().setTitle("Progress for Mail");
            commProgressWindow.mail().setPartialEnabled(true);
        }
        if ((n = popUserBase.size()) > 0) {
            try {
                commProgressWindow.server().setText("Scanning mail for " + n + (n > 1 ? " users..." : "user..."));
                commProgressWindow.server().setArea(0, popUserBase.size() + 1);
                commProgressWindow.server().setValue(1);
                Vector vector = popUserBase.users();
                commProgressWindow.connectionData().receiveInterruptsFor(2, this);
                int n2 = 0;
                while (true) {
                    if (n2 >= vector.size()) {
                        Object var7_10 = null;
                        commProgressWindow.server().setText("Finished! ");
                        commProgressWindow.connectionData().receiveInterruptsFor(2, null);
                        commProgressWindow.group().setPartialEnabled(false);
                        commProgressWindow.mail().setPartialEnabled(false);
                        commProgressWindow.group().setText(" ");
                        commProgressWindow.mail().setText(" ");
                        commProgressWindow.group().setArea(0, 1);
                        commProgressWindow.mail().setArea(0, 1);
                        break;
                    }
                    try {
                        this.getMails(commProgressWindow, string, (String)vector.elementAt(n2));
                    }
                    catch (IOException iOException) {
                        int n3 = commProgressWindow.connectionData().getAbort();
                        if (n3 != 2) {
                            throw iOException;
                        }
                        commProgressWindow.connectionData().setAbort(10);
                        Tools.log("Download of Mailbox for user " + vector.elementAt(n2) + " on server " + string + " has been interrupted by the user.");
                    }
                    commProgressWindow.server().increase();
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                commProgressWindow.server().setText("Finished! ");
                commProgressWindow.connectionData().receiveInterruptsFor(2, null);
                commProgressWindow.group().setPartialEnabled(false);
                commProgressWindow.mail().setPartialEnabled(false);
                commProgressWindow.group().setText(" ");
                commProgressWindow.mail().setText(" ");
                commProgressWindow.group().setArea(0, 1);
                commProgressWindow.mail().setArea(0, 1);
                throw throwable;
            }
        }
        if (bl) {
            commProgressWindow.dispose();
        }
        if (commProgressWindow.connectionData().getAbort() > 0) {
            commProgressWindow.connectionData().setAbort(10);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void getMails(CommProgressWindow commProgressWindow, String string, String string2) throws IllegalArgumentException, IOException {
        if (!this.popserver.exists(string)) {
            throw new IllegalArgumentException("Unknown pop server: '" + string + "'");
        }
        PopUserBase popUserBase = this.popserver.users(string);
        if (!popUserBase.users().contains(string2)) {
            throw new IllegalArgumentException("User '" + string2 + "' has no mailbox on server '" + string + "'");
        }
        boolean bl = false;
        if (commProgressWindow == null) {
            bl = true;
            commProgressWindow = new CommProgressWindow(null, this, false, 2);
        }
        commProgressWindow.group().setPartialEnabled(true);
        commProgressWindow.mail().setPartialEnabled(true);
        POPConnection pOPConnection = null;
        boolean bl2 = true;
        block6: while (bl2) {
            Object var10_9;
            bl2 = false;
            commProgressWindow.group().setText("Connecting to server: " + string);
            POPConnection pOPConnection2 = new POPConnection(string, this.timeout, this.connectionTimeout, popUserBase.remoteName(string2), popUserBase.remotePass(string2), pOPConnection);
            this.connections.add(commProgressWindow.connectionData(), pOPConnection2);
            try {
                pOPConnection2.login();
                ++commProgressWindow.connectionData().contactedServers;
                commProgressWindow.group().setText("Querying data...");
                int n = pOPConnection2.scanMailbox();
                if (n > 0) {
                    commProgressWindow.group().setText("Receiving " + n + (n > 1 ? " mails..." : " mail..."));
                    commProgressWindow.group().setArea(0, n + 1);
                    commProgressWindow.group().setValue(1);
                }
                int n2 = 0;
                while (true) {
                    Object var16_13;
                    if (n2 >= n) {
                        var10_9 = null;
                        commProgressWindow.group().setText("Finished");
                        pOPConnection2.close();
                        this.connections.remove(pOPConnection2);
                        commProgressWindow.group().setPartialEnabled(false);
                        commProgressWindow.mail().setPartialEnabled(false);
                        if (!bl) continue block6;
                        commProgressWindow.dispose();
                        continue block6;
                    }
                    long l = this.getNextArticleFile();
                    commProgressWindow.connectionData().receiveInterruptsFor(3, this);
                    try {
                        try {
                            l = pOPConnection2.getMail(n2, l, commProgressWindow.mail(), popUserBase.address(string2), this);
                            var16_13 = null;
                            commProgressWindow.connectionData().receiveInterruptsFor(3, null);
                        }
                        catch (IOException iOException) {
                            if (commProgressWindow.connectionData().getAbort() != 3) {
                                throw iOException;
                            }
                            commProgressWindow.connectionData().setAbort(10);
                            Tools.log("Download of mail No." + n2 + " for user " + string2 + " on server " + string + " has been aborted by the user.");
                            pOPConnection2.close();
                            pOPConnection = pOPConnection2;
                            bl2 = true;
                            if (l > 0L && this.repository.exists(l)) {
                                this.repository.delete(l);
                            }
                            var16_13 = null;
                            commProgressWindow.connectionData().receiveInterruptsFor(3, null);
                            var10_9 = null;
                            commProgressWindow.group().setText("Finished");
                            pOPConnection2.close();
                            this.connections.remove(pOPConnection2);
                            commProgressWindow.group().setPartialEnabled(false);
                            commProgressWindow.mail().setPartialEnabled(false);
                            if (!bl) continue block6;
                            commProgressWindow.dispose();
                            continue block6;
                        }
                    }
                    catch (Throwable throwable) {
                        var16_13 = null;
                        commProgressWindow.connectionData().receiveInterruptsFor(3, null);
                        throw throwable;
                    }
                    ++commProgressWindow.connectionData().receivedMails;
                    if (l > 0L) {
                        Hashtable hashtable = RFCAnalyzer.analyzeRFC(this, l);
                        if (hashtable.containsKey("to")) {
                            Object object = RFCAnalyzer.rfcAddr2zc(this, hashtable.get("to"));
                            Vector<Object> vector = null;
                            if (object instanceof Vector) {
                                vector = (Vector<Object>)object;
                            } else {
                                vector = new Vector<Object>();
                                vector.addElement(object);
                            }
                            String string3 = this.superuserAddress.toLowerCase();
                            int n3 = 0;
                            while (n3 < vector.size()) {
                                if (((String)vector.elementAt(n3)).toLowerCase().trim().startsWith(string3)) {
                                    this.popmail.newMail("postmaster", l);
                                    break;
                                }
                                ++n3;
                            }
                        }
                        this.popmail.newMail(string2, l);
                        if (popUserBase.removeFromRemoteFor(string2)) {
                            pOPConnection2.deleteMail(n2, commProgressWindow.mail());
                        }
                        commProgressWindow.group().increase();
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                var10_9 = null;
                commProgressWindow.group().setText("Finished");
                pOPConnection2.close();
                this.connections.remove(pOPConnection2);
                commProgressWindow.group().setPartialEnabled(false);
                commProgressWindow.mail().setPartialEnabled(false);
                if (bl) {
                    commProgressWindow.dispose();
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final String getMsgId(long l, boolean bl, boolean bl2) throws IOException {
        Object object;
        String string = null;
        boolean bl3 = false;
        boolean bl4 = false;
        Hashtable hashtable = JanusGate.analyzeRFC(this, l);
        if (hashtable.containsKey("message-id")) {
            object = JanusGate.rfcMid2zc(hashtable.get("message-id"));
            if (!(object instanceof String)) throw new IOException("Multiple Message-ID header in mail No. '" + l + "'");
            string = (String)object;
        } else {
            bl3 = bl;
        }
        if (!hashtable.containsKey("date")) {
            bl4 = bl2;
        }
        if (bl3 || bl4) {
            object = new MailDataReader(this.repository, l);
            BufferedReader bufferedReader = ((MailDataReader)object).getReader();
            StringWriter stringWriter = new StringWriter();
            BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
            if (bl3) {
                string = Tools.fakeMsgid(this.lastNumber, true);
                bufferedWriter.write("Message-ID: <" + string + ">");
                bufferedWriter.newLine();
                Tools.log("Message-ID <" + string + "> given to message No. " + l);
            }
            if (bl4) {
                bufferedWriter.write("Date: " + RFCAnalyzer.rfcDate(Calendar.getInstance().getTime()));
                bufferedWriter.newLine();
                Tools.log("Today's date given to message No. " + l);
            }
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                string2 = bufferedReader.readLine();
            }
            bufferedWriter.close();
            ((MailDataReader)object).close();
            MailDataWriter mailDataWriter = new MailDataWriter(this.repository, l);
            bufferedWriter = mailDataWriter.getWriter();
            bufferedReader = new BufferedReader(new StringReader(stringWriter.toString()));
            string2 = bufferedReader.readLine();
            while (string2 != null) {
                bufferedWriter.write(string2);
                bufferedWriter.newLine();
                string2 = bufferedReader.readLine();
            }
            mailDataWriter.close();
            bufferedReader.close();
            return string;
        } else {
            if (string != null) return string;
            throw new IOException("No Message-ID header in mail No. '" + l + "'");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void getNews(CommProgressWindow commProgressWindow) throws RemoteException {
        int n = -1;
        if (commProgressWindow == null) {
            commProgressWindow = new CommProgressWindow(null, this, true, 1);
            n = this.newsserver.size();
            commProgressWindow.all().setArea(0, n + 1);
            commProgressWindow.all().setValue(1);
        }
        Vector vector = this.newsserver.servers();
        int n2 = 0;
        while (n2 < vector.size()) {
            String string = (String)vector.elementAt(n2);
            commProgressWindow.all().setText("Reading from newsserver: " + this.newsserver.title(string));
            try {
                if (commProgressWindow.connectionData().getAbort() > 0) {
                    this.getNews(commProgressWindow, string);
                }
            }
            catch (IOException iOException) {
                Tools.log("No all articles could be retrieved from server '" + string + "'. Reason:", iOException);
                ++commProgressWindow.connectionData().errors;
            }
            commProgressWindow.all().increase();
            ++n2;
        }
        if (n > -1) {
            commProgressWindow.all().setText("Finished!");
            commProgressWindow.all().setValue(n + 1);
            commProgressWindow.dispose();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void getNews(CommProgressWindow commProgressWindow, String string) throws IllegalArgumentException, IOException {
        if (!this.newsserver.exists(string)) {
            throw new IllegalArgumentException("Unknown news server: '" + string + "'");
        }
        Hashtable hashtable = this.newsserver.getActiveGroups(string);
        if (hashtable.size() == 0) {
            return;
        }
        boolean bl = false;
        if (commProgressWindow == null) {
            bl = true;
            commProgressWindow = new CommProgressWindow(null, this, false, 1);
        }
        Hashtable<String, StartStop> hashtable2 = new Hashtable<String, StartStop>();
        Enumeration enumeration = hashtable.keys();
        int n = hashtable.size();
        commProgressWindow.server().setText("Contacting server: " + string);
        commProgressWindow.server().setArea(0, n + 1);
        commProgressWindow.server().setValue(1);
        commProgressWindow.group().setTitle("Progress in Group");
        commProgressWindow.group().setPartialEnabled(true);
        NNTPControlConnection nNTPControlConnection = new NNTPControlConnection(string, this.timeout, this.connectionTimeout);
        AbstractConnection abstractConnection = null;
        this.connections.add(commProgressWindow.connectionData(), nNTPControlConnection);
        nNTPControlConnection.login();
        ++commProgressWindow.connectionData().contactedServers;
        try {
            block29: {
                int n2;
                long l = 0L;
                int n3 = 0;
                while (true) {
                    if (!enumeration.hasMoreElements()) {
                        enumeration = hashtable2.keys();
                        nNTPControlConnection.close();
                        this.connections.remove(nNTPControlConnection);
                        if (l > 0L) {
                            n2 = this.readThreads;
                            if ((long)n2 > l) {
                                n2 = (int)l;
                            }
                            commProgressWindow.server().setValue(0);
                        }
                        break block29;
                    }
                    String string2 = (String)enumeration.nextElement();
                    commProgressWindow.server().setText("Scanning group: " + string2);
                    StartStop startStop = nNTPControlConnection.jumpGroup(string2);
                    long l2 = ((ActiveData)hashtable.get((Object)string2)).lastArticle + 1L;
                    boolean bl2 = false;
                    if (l2 <= startStop.stop + 1L && l2 > startStop.start) {
                        startStop.start = l2;
                    } else if (l2 > 1L && l2 < startStop.start) {
                        bl2 = true;
                    }
                    if (startStop.start <= startStop.stop && (startStop.start != 0L || startStop.stop != 0L)) {
                        if (bl2) {
                            Tools.log("Article numbers in group '" + string2 + "' are inconsistent (" + l2 + "/" + startStop.start + "-" + startStop.stop + ")- regetting group.");
                        }
                        hashtable2.put(string2, startStop);
                        l += startStop.stop - startStop.start + 1L;
                        ++n3;
                    }
                    commProgressWindow.server().increase();
                }
                commProgressWindow.server().setText("Initializing " + n2 + " download thread" + (n2 > 1 ? "s..." : "..."));
                abstractConnection = new NNTPDownloadConnection(commProgressWindow.connectionData(), this, string, this.timeout, this.connectionTimeout, this.readThreads);
                this.connections.add(commProgressWindow.connectionData(), abstractConnection);
                abstractConnection.login();
                try {
                    commProgressWindow.connectionData().receiveInterruptsFor(2, this);
                    commProgressWindow.server().setArea(0, n3 + 1);
                    commProgressWindow.server().setValue(1);
                    while (true) {
                        block31: {
                            Enumeration enumeration2;
                            Hashtable hashtable3;
                            if (!enumeration.hasMoreElements()) {
                                Object var17_17 = null;
                                break;
                            }
                            String string3 = (String)enumeration.nextElement();
                            commProgressWindow.server().setText("Retrieving group: " + string3);
                            StartStop startStop = (StartStop)hashtable2.get(string3);
                            try {
                                this.retrieveArticles(commProgressWindow, (NNTPDownloadConnection)abstractConnection, string3, startStop);
                                ((ActiveData)hashtable.get((Object)string3)).lastArticle = startStop.stop;
                                break block31;
                            }
                            catch (IOException iOException) {
                                hashtable3 = ((NNTPDownloadConnection)abstractConnection).getUnfinishedArticles();
                                enumeration2 = hashtable3.keys();
                            }
                            while (true) {
                                if (!enumeration2.hasMoreElements()) {
                                    if (commProgressWindow.connectionData().getAbort() != 2) {
                                        throw iOException;
                                    }
                                    commProgressWindow.connectionData().setAbort(10);
                                    abstractConnection.close();
                                    this.connections.remove(abstractConnection);
                                    commProgressWindow.group().setText("Reconnecting...");
                                    abstractConnection = new NNTPDownloadConnection(commProgressWindow.connectionData(), this, string, this.timeout, this.connectionTimeout, this.readThreads);
                                    this.connections.add(commProgressWindow.connectionData(), abstractConnection);
                                    abstractConnection.login();
                                    break;
                                }
                                String string4 = enumeration2.nextElement().toString();
                                ActiveData activeData = (ActiveData)hashtable.get(string4);
                                long l3 = (Long)hashtable3.get(string4) - 1L;
                                if (activeData.lastArticle >= l3) continue;
                                activeData.lastArticle = l3;
                            }
                        }
                        commProgressWindow.server().increase();
                    }
                }
                catch (Throwable throwable) {
                    Object var17_18 = null;
                    this.newsserver.putActiveGroups(string, hashtable);
                    commProgressWindow.connectionData().receiveInterruptsFor(2, null);
                    throw throwable;
                }
                this.newsserver.putActiveGroups(string, hashtable);
                commProgressWindow.connectionData().receiveInterruptsFor(2, null);
                commProgressWindow.server().setText("Waiting for " + n2 + " download threads to close down...");
                ((NNTPDownloadConnection)abstractConnection).finish();
            }
            commProgressWindow.server().setText("Finished");
            Object var11_29 = null;
            if (nNTPControlConnection != null) {
                nNTPControlConnection.close();
                this.connections.remove(nNTPControlConnection);
            }
            if (abstractConnection != null) {
                abstractConnection.close();
                this.connections.remove(abstractConnection);
            }
            commProgressWindow.group().setPartialEnabled(false);
            commProgressWindow.group().setText(" ");
            commProgressWindow.group().setArea(0, 1);
        }
        catch (Throwable throwable) {
            Object var11_30 = null;
            if (nNTPControlConnection != null) {
                nNTPControlConnection.close();
                this.connections.remove(nNTPControlConnection);
            }
            if (abstractConnection != null) {
                abstractConnection.close();
                this.connections.remove(abstractConnection);
            }
            commProgressWindow.group().setPartialEnabled(false);
            commProgressWindow.group().setText(" ");
            commProgressWindow.group().setArea(0, 1);
            throw throwable;
        }
        if (bl) {
            commProgressWindow.dispose();
        }
        if (commProgressWindow.connectionData().getAbort() > 0) {
            commProgressWindow.connectionData().setAbort(10);
        }
    }

    public final String[] getNewsserverNames() {
        Vector vector = this.newsserver.titles();
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public final synchronized long getNextArticleFile() {
        return ++this.lastNumber;
    }

    public final String getNNTPServerForTitle(String string) {
        Vector vector = this.newsserver.servers();
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            if (string.equals(this.newsserver.title(string2))) {
                return string2;
            }
            ++n;
        }
        return null;
    }

    public final int getNumberOfArticles() {
        return this.msgid.size();
    }

    public final int getNumberOfPOPMails() {
        return this.popmail.numberOfMails();
    }

    public final int getNumberOfSMTPMails() {
        return this.outmail.size();
    }

    public final OptionsData getOptions() {
        OptionsData optionsData = new OptionsData();
        optionsData.readThreads = this.readThreads;
        optionsData.retries = this.artRetries;
        optionsData.timeout = this.timeout;
        optionsData.serverTimeout = this.serverTimeout;
        optionsData.connectionTimeout = this.connectionTimeout;
        optionsData.failureAllowed = this.failureAllowed;
        optionsData.maxRepositoryFileSize = this.maxRepositoryFileSize;
        optionsData.sendToAll = this.sendToAll;
        optionsData.forwardToAll = this.forwardAll;
        optionsData.saveWindowPos = this.saveWindowPos;
        optionsData.deleteWindowPos = this.deleteWindowPos;
        optionsData.dataDir = this.dataDir;
        optionsData.configFileName = this.configFileName;
        optionsData.defaultFont = this.defaultFont;
        optionsData.superuserAddress = this.superuserAddress;
        optionsData.superuserPassword = this.superuserPassword;
        optionsData.doBackup = this.doBackup;
        return optionsData;
    }

    public final PopMailboxBase getPOPMailboxForUser(String string) {
        return this.popmail.getMailbox(string);
    }

    public final String getPOPPassword(String string) {
        if (string.toLowerCase().equals("postmaster")) {
            return this.superuserPassword;
        }
        return this.popserver.password(string);
    }

    public final String getPOPServerForTitle(String string) {
        Vector vector = this.popserver.servers();
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            if (this.popserver.title(string2).equals(string)) {
                return string2;
            }
            ++n;
        }
        return null;
    }

    public final String[] getPOPServerNames() {
        Vector vector = this.popserver.servers();
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = this.popserver.title((String)vector.elementAt(n));
            ++n;
        }
        return stringArray;
    }

    public final int getServerTimeout() {
        return this.serverTimeout;
    }

    private final String getSMTPServerForPath(String string) {
        int n = string.indexOf(58);
        if (n != -1 && (n = (string = string.substring(0, n)).indexOf(44)) != -1) {
            string = string.substring(0, n);
        }
        Vector vector = this.analyzeAddress(string);
        String string2 = null;
        int n2 = -1;
        Vector vector2 = this.smtpserver.servers();
        int n3 = 0;
        while (n3 < vector2.size()) {
            String string3 = (String)vector2.elementAt(n3);
            int n4 = -1;
            Vector vector3 = this.smtpserver.getDomains(string3);
            if (vector3 == null) {
                n4 = 0;
            } else {
                int n5 = vector3.size();
                int n6 = 0;
                while (n6 < n5) {
                    int n7 = this.compareDomains(vector, this.analyzeAddress((String)vector3.elementAt(n6)));
                    if (n7 > 0 && n7 > n4) {
                        n4 = n7;
                    }
                    ++n6;
                }
            }
            if (n4 > n2) {
                n2 = n4;
                string2 = string3;
            }
            ++n3;
        }
        return string2;
    }

    public final String getSMTPServerForTitle(String string) {
        Vector vector = this.smtpserver.servers();
        int n = 0;
        while (n < vector.size()) {
            String string2 = (String)vector.elementAt(n);
            if (this.smtpserver.title(string2).equals(string)) {
                return string2;
            }
            ++n;
        }
        return null;
    }

    public final String[] getSMTPServerNames() {
        Vector vector = this.smtpserver.servers();
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = this.smtpserver.title((String)vector.elementAt(n));
            ++n;
        }
        return stringArray;
    }

    public final PopUserBase getUsersForPOPServers(String[] stringArray) {
        PopUserBase popUserBase = null;
        int n = 0;
        while (n < stringArray.length) {
            popUserBase = this.popserver.users(this.getPOPServerForTitle(stringArray[n])).uniteWith(popUserBase);
            ++n;
        }
        return popUserBase;
    }

    public final WindowData getWindowData(String string) {
        return this.windowData.get(string);
    }

    public final GroupBase groups() {
        return this.groups;
    }

    public final void interruptTransfer(ConnectionData connectionData, int n) {
        connectionData.setAbort(n);
        this.connections.cancel(connectionData);
    }

    public final boolean lockPOPUserName(String string) {
        Vector vector = this.lockedPOPUserNames;
        synchronized (vector) {
            if (!this.lockedPOPUserNames.contains(string)) {
                this.lockedPOPUserNames.addElement(string);
                boolean bl = true;
                Object var3_4 = null;
                return bl;
            }
        }
        return false;
    }

    public final MsgidBase msgid() {
        return this.msgid;
    }

    public final NewsserverBase newsserver() {
        return this.newsserver;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void outmailFailure(long l, String string, String string2, Vector vector) {
        if (string2.equals("")) {
            return;
        }
        long l2 = this.getNextArticleFile();
        try {
            MailDataReader mailDataReader = new MailDataReader(this.repository, l);
            MailDataWriter mailDataWriter = new MailDataWriter(this.repository, l2);
            BufferedReader bufferedReader = mailDataReader.getReader();
            BufferedWriter bufferedWriter = mailDataWriter.getWriter();
            bufferedWriter.write("From: " + this.superuserAddress + " (automatic error message)\r\n");
            bufferedWriter.write("X-ZC-ERR: The message could not be delivered to all recipients.\r\n");
            bufferedWriter.write("Message-ID: " + Tools.fakeMsgid(this.lastNumber, false) + "\r\n");
            bufferedWriter.write("Subject: Problems occurred delivering your mail\r\n");
            bufferedWriter.write("To: " + string2 + "\r\n\r\n");
            bufferedWriter.write("  This message was generated automatically by " + CommonConstants.title + ".\r\n\r\n");
            bufferedWriter.write("  Your message could not be delivered to all recipients.\r\n");
            bufferedWriter.write("  The error message text is:\r\n\r\n");
            int n = 0;
            while (true) {
                if (n >= vector.size()) {
                    bufferedWriter.write("  Unsent mail follows.\r\n\r\n");
                    bufferedWriter.flush();
                    mailDataWriter.getStream().write(this.repository.get(l));
                    mailDataReader.close();
                    mailDataWriter.close();
                    Vector<String> vector2 = new Vector<String>();
                    vector2.addElement(string2);
                    this.addToOutmail(l, Tools.getLocalHostName(), "", vector2);
                    return;
                }
                bufferedWriter.write((String)vector.elementAt(n));
                bufferedWriter.write("\r\n");
                ++n;
            }
        }
        catch (IOException iOException) {
            Tools.log("Tried to send back failed email, but an error occurred: ", iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void outnewsFailure(long l, String string, Vector vector, boolean bl) {
        if (string.equals("")) {
            return;
        }
        long l2 = this.getNextArticleFile();
        try {
            MailDataReader mailDataReader = new MailDataReader(this.repository, l);
            MailDataWriter mailDataWriter = new MailDataWriter(this.repository, l2);
            BufferedReader bufferedReader = mailDataReader.getReader();
            BufferedWriter bufferedWriter = mailDataWriter.getWriter();
            bufferedWriter.write("From: " + this.superuserAddress + " (automatic error message)\r\n");
            if (bl) {
                bufferedWriter.write("X-ZC-ERR: The message could not be delivered to all groups.\r\n");
            } else {
                bufferedWriter.write("X-ZC-ERR: The message could not be delivered.\r\n");
            }
            bufferedWriter.write("Message-ID: " + Tools.fakeMsgid(this.lastNumber, false) + "\r\n");
            bufferedWriter.write("Subject: Problems occurred delivering your article\r\n");
            bufferedWriter.write("To: " + string + "\r\n\r\n");
            bufferedWriter.write("  This message was generated automatically by " + CommonConstants.title + ".\r\n\r\n");
            if (bl) {
                bufferedWriter.write("  Your article could not be delivered to the following destination groups,\r\n");
            } else {
                bufferedWriter.write("  Your article could not be delivered. Reason: you are not allowed to post\r\n");
            }
            if (bl) {
                bufferedWriter.write("  since they are unknown to the system:\r\n\r\n");
            } else {
                bufferedWriter.write("  articles into these newsgroups:\r\n\r\n");
            }
            int n = 0;
            while (true) {
                if (n >= vector.size()) {
                    bufferedWriter.write("\r\n\r\n  Unsent article follows.\r\n\r\n");
                    bufferedWriter.flush();
                    mailDataWriter.getStream().write(this.repository.get(l));
                    mailDataReader.close();
                    mailDataWriter.close();
                    Vector<String> vector2 = new Vector<String>();
                    vector2.addElement(string);
                    this.addToOutmail(l2, Tools.getLocalHostName(), "", vector2);
                    return;
                }
                bufferedWriter.write((String)vector.elementAt(n));
                bufferedWriter.write("\r\n");
                ++n;
            }
        }
        catch (IOException iOException) {
            Tools.log("Tried to send back failed email, but an error occurred: ", iOException);
        }
    }

    public final PopServerBase popserver() {
        return this.popserver;
    }

    public final MailDataRepository prepack() {
        return this.prepack;
    }

    private final String pureAddress(String string) {
        int n = string.indexOf(40);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n - 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void putMail(CommProgressWindow commProgressWindow, SMTPConnection sMTPConnection, OutmailData outmailData, long l, int n) throws IOException {
        Object object;
        if (commProgressWindow == null) {
            throw new IOException("Internal error: Basis.putMail called without CommProgressWindow.");
        }
        String string = this.pureAddress(outmailData.from);
        Vector<String> vector = new Vector<String>(outmailData.to.size());
        int n2 = 0;
        while (n2 < outmailData.to.size()) {
            vector.addElement(this.pureAddress((String)outmailData.to.elementAt(n2)));
            ++n2;
        }
        n2 = string.indexOf(58);
        if (n2 != -1) {
            int n3 = 0;
            while (n3 < vector.size()) {
                object = (String)vector.elementAt(n3);
                n2 = ((String)object).indexOf(58);
                int n4 = ((String)object).indexOf(44);
                if (n4 != -1 && n4 < n2) {
                    n2 = n4;
                }
                if (n2 != -1) {
                    vector.setElementAt(((String)object).substring(n2 + 1), n3);
                }
                ++n3;
            }
            string = "@" + Tools.getLocalHostName() + "," + string;
        }
        Object var10_10 = null;
        object = new Vector();
        try {
            try {
                commProgressWindow.connectionData().receiveInterruptsFor(2, this);
                if (sMTPConnection == null) {
                    sMTPConnection = new SMTPConnection(outmailData.server, this.timeout, this.connectionTimeout);
                    sMTPConnection.login();
                    ++commProgressWindow.connectionData().contactedServers;
                }
                long l2 = this.repository.size(l);
                commProgressWindow.group().setText("Sending mail No." + n + " (" + l2 + " Bytes)...");
                commProgressWindow.group().setArea(0, (int)(l2 + 1L));
                boolean bl = true;
                commProgressWindow.group().setValue(1);
                if (!sMTPConnection.mail(string, vector, l, this, commProgressWindow.group(), outmailData)) {
                    ++commProgressWindow.connectionData().errors;
                }
                ++commProgressWindow.connectionData().sentMails;
                Object var13_17 = null;
                commProgressWindow.connectionData().receiveInterruptsFor(2, null);
                return;
            }
            catch (IOException iOException) {
                if (sMTPConnection == null) throw iOException;
                sMTPConnection.close();
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            commProgressWindow.connectionData().receiveInterruptsFor(2, null);
            throw throwable;
        }
    }

    public final void putMails(CommProgressWindow commProgressWindow) throws RemoteException {
        int n = -1;
        if (commProgressWindow == null) {
            commProgressWindow = new CommProgressWindow(null, this, true, 3);
            n = this.smtpserver.size();
            commProgressWindow.all().setArea(0, n + 1);
            commProgressWindow.all().setValue(1);
        }
        Vector vector = this.smtpserver.servers();
        int n2 = 0;
        while (n2 < vector.size()) {
            String string = (String)vector.elementAt(n2);
            commProgressWindow.all().setText("Sending mail to server: " + this.smtpserver.title(string));
            if (commProgressWindow.connectionData().getAbort() > 0) {
                this.putMails(commProgressWindow, string);
            }
            commProgressWindow.all().increase();
            ++n2;
        }
        if (n > -1) {
            commProgressWindow.all().setText("Finished!");
            commProgressWindow.all().setValue(n + 1);
            commProgressWindow.dispose();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void putMails(CommProgressWindow commProgressWindow, String string) throws RemoteException {
        int n;
        boolean bl = false;
        if (commProgressWindow == null) {
            bl = true;
            commProgressWindow = new CommProgressWindow(null, this, false, 3);
        }
        if ((n = this.outmail.size()) > 0) {
            commProgressWindow.server().setText("Working on " + n + (n > 1 ? " mails..." : " mail..."));
            commProgressWindow.server().setArea(0, n + 1);
            commProgressWindow.server().setValue(1);
            commProgressWindow.group().setTitle("Progress on Mail");
            commProgressWindow.group().setPartialEnabled(true);
            commProgressWindow.group().setText("Connecting to server: " + string);
            SMTPConnection sMTPConnection = new SMTPConnection(string, this.timeout, this.connectionTimeout);
            this.connections.add(commProgressWindow.connectionData(), sMTPConnection);
            try {
                sMTPConnection.login();
                ++commProgressWindow.connectionData().contactedServers;
                this.outmail.putMails(commProgressWindow, sMTPConnection, string);
            }
            catch (IOException iOException) {
                Tools.log("An error occurred while sending mails:", iOException);
                ++commProgressWindow.connectionData().errors;
            }
            commProgressWindow.server().setValue(n + 1);
            sMTPConnection.close();
            this.connections.remove(sMTPConnection);
        }
        commProgressWindow.group().setPartialEnabled(false);
        commProgressWindow.group().setText(" ");
        commProgressWindow.group().setArea(0, 1);
        if (bl) {
            commProgressWindow.dispose();
        }
        if (commProgressWindow.connectionData().getAbort() > 0) {
            commProgressWindow.connectionData().setAbort(10);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void putNews(CommProgressWindow commProgressWindow) throws RemoteException {
        int n = -1;
        if (commProgressWindow == null) {
            commProgressWindow = new CommProgressWindow(null, this, true, 1);
            n = this.newsserver.size();
            commProgressWindow.all().setArea(0, n + 1);
            commProgressWindow.all().setValue(1);
        }
        Vector vector = this.newsserver.servers();
        int n2 = 0;
        while (n2 < vector.size()) {
            String string = (String)vector.elementAt(n2);
            commProgressWindow.all().setText("Writing to newsserver: " + this.newsserver.title(string));
            if (commProgressWindow.connectionData().getAbort() > 0) {
                try {
                    this.putNews(commProgressWindow, string);
                }
                catch (IOException iOException) {
                    ++commProgressWindow.connectionData().errors;
                    Tools.log("Error occurred sending articles: ", iOException);
                }
            }
            commProgressWindow.all().increase();
            ++n2;
        }
        if (n > -1) {
            commProgressWindow.all().setText("Finished!");
            commProgressWindow.all().setValue(n + 1);
            commProgressWindow.dispose();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void putNews(CommProgressWindow commProgressWindow, String string) throws IOException {
        int n = this.outgoing.forServer(string);
        if (n == 0) {
            return;
        }
        boolean bl = false;
        if (commProgressWindow == null) {
            bl = true;
            commProgressWindow = new CommProgressWindow(null, this, false, 1);
        }
        commProgressWindow.server().setText("Working on " + n + (n == 1 ? " article..." : " articles..."));
        commProgressWindow.server().setArea(0, n + 1);
        commProgressWindow.server().setValue(1);
        commProgressWindow.group().setTitle("Progress on Article");
        commProgressWindow.group().setPartialEnabled(true);
        commProgressWindow.group().setText("Connecting to server: " + string);
        NNTPControlConnection nNTPControlConnection = new NNTPControlConnection(string, this.timeout, this.connectionTimeout);
        this.connections.add(commProgressWindow.connectionData(), nNTPControlConnection);
        try {
            nNTPControlConnection.login();
            ++commProgressWindow.connectionData().contactedServers;
            this.outgoing.putNews(commProgressWindow, string, nNTPControlConnection, this.sendToAll);
            Object var7_6 = null;
            nNTPControlConnection.close();
            this.connections.remove(nNTPControlConnection);
            commProgressWindow.group().setPartialEnabled(false);
            commProgressWindow.group().setText(" ");
            commProgressWindow.group().setArea(0, 1);
            commProgressWindow.server().setValue(n + 1);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            nNTPControlConnection.close();
            this.connections.remove(nNTPControlConnection);
            commProgressWindow.group().setPartialEnabled(false);
            commProgressWindow.group().setText(" ");
            commProgressWindow.group().setArea(0, 1);
            commProgressWindow.server().setValue(n + 1);
            throw throwable;
        }
        if (bl) {
            commProgressWindow.dispose();
        }
        if (commProgressWindow.connectionData().getAbort() > 0) {
            commProgressWindow.connectionData().setAbort(10);
        }
    }

    private final String readConfigLine(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        if (string == null) {
            throw new IOException("config file corrupt (too short)");
        }
        return string;
    }

    private final void readVersion0030(BufferedReader bufferedReader) throws IOException {
        this.dataDir = this.readConfigLine(bufferedReader);
        File file = new File(this.dataDir);
        if (!file.exists()) {
            throw new IOException("Data Directory does not exist!");
        }
        if (!file.isDirectory()) {
            throw new IOException("Data Directory is invalid!");
        }
        this.readThreads = new Integer(this.readConfigLine(bufferedReader));
        this.artRetries = new Integer(this.readConfigLine(bufferedReader));
        this.timeout = new Integer(this.readConfigLine(bufferedReader));
        this.failureAllowed = new Integer(this.readConfigLine(bufferedReader));
        this.maxRepositoryFileSize = new Integer(this.readConfigLine(bufferedReader));
        this.sendToAll = this.readConfigLine(bufferedReader).equals("y");
        this.forwardAll = this.readConfigLine(bufferedReader).equals("y");
        this.saveWindowPos = this.readConfigLine(bufferedReader).equals("y");
        this.deleteWindowPos = this.readConfigLine(bufferedReader).equals("y");
        this.defaultFont = new Integer(this.readConfigLine(bufferedReader));
        this.superuserAddress = this.readConfigLine(bufferedReader);
        this.superuserPassword = this.readConfigLine(bufferedReader);
        String string = bufferedReader.readLine();
        if (string != null) {
            throw new IOException("config file corrupt (too long)");
        }
    }

    private final void readVersion0031(BufferedReader bufferedReader) throws IOException {
        this.dataDir = this.readConfigLine(bufferedReader);
        File file = new File(this.dataDir);
        if (!file.exists()) {
            throw new IOException("Data Directory does not exist!");
        }
        if (!file.isDirectory()) {
            throw new IOException("Data Directory is invalid!");
        }
        this.readThreads = new Integer(this.readConfigLine(bufferedReader));
        this.artRetries = new Integer(this.readConfigLine(bufferedReader));
        this.timeout = new Integer(this.readConfigLine(bufferedReader));
        this.failureAllowed = new Integer(this.readConfigLine(bufferedReader));
        this.maxRepositoryFileSize = new Integer(this.readConfigLine(bufferedReader));
        this.sendToAll = this.readConfigLine(bufferedReader).equals("y");
        this.forwardAll = this.readConfigLine(bufferedReader).equals("y");
        this.saveWindowPos = this.readConfigLine(bufferedReader).equals("y");
        this.deleteWindowPos = this.readConfigLine(bufferedReader).equals("y");
        this.defaultFont = new Integer(this.readConfigLine(bufferedReader));
        this.superuserAddress = this.readConfigLine(bufferedReader);
        this.superuserPassword = this.readConfigLine(bufferedReader);
        this.connectionTimeout = new Integer(this.readConfigLine(bufferedReader));
        this.serverTimeout = new Integer(this.readConfigLine(bufferedReader));
        this.doBackup = this.readConfigLine(bufferedReader).equals("y");
        String string = bufferedReader.readLine();
        if (string != null) {
            throw new IOException("config file corrupt (too long)");
        }
    }

    public final void relax() throws IOException {
        this.relax(false, false);
    }

    public final void relax(boolean bl, boolean bl2) throws IOException {
        if (!bl2) {
            this.doRelax = false;
            Tools.memoryAlert("On shutdown");
        }
        if (bl) {
            Tools.logPart("Saving data...");
        } else {
            Tools.log("Saving data:");
        }
        if (!bl2) {
            this.gateways.relaxObjects();
        }
        this.msgid.save(!bl);
        this.groups.save(!bl);
        this.outgoing.save(!bl);
        this.outmail.save(!bl);
        this.popmail.save(!bl);
        this.newsserver.save(!bl);
        this.smtpserver.save(!bl);
        this.popserver.save(!bl);
        this.gateways.save(!bl);
        if (this.saveWindowPos) {
            this.windowData.save(!bl);
        }
        this.repository.relax(bl);
        this.prepack.relax(bl);
        this.saveLastFile(bl2);
        if (!bl2) {
            this.lock.close();
        }
        if (!bl) {
            System.out.print("...");
        }
        System.out.println("done!");
        if (!bl && !bl2) {
            Tools.memoryStatus();
        }
    }

    public final void removeArticle(String string) {
        this.msgid.removeArticle(string, this.groups);
    }

    public final void removeGateway(String string) throws IOException {
        if (string == null) {
            return;
        }
        this.gateways.remove(string);
    }

    public final void removeMailFromPopmail(Long l) {
        this.popmail.removeMail(l);
    }

    public final void removeNewsgroup(String string, String string2) throws IOException {
        if (string2 == null) {
            Vector vector = this.newsserver.servers();
            int n = 0;
            while (n < vector.size()) {
                this.removeNewsgroup(string, (String)vector.elementAt(n));
                ++n;
            }
            this.groups.remove(string);
        } else {
            Hashtable hashtable = this.newsserver.getActiveGroups(string2);
            if (hashtable.containsKey(string)) {
                hashtable.remove(string);
                this.newsserver.putActiveGroups(string2, hashtable);
            }
        }
    }

    public final void removeNewsserverByTitle(String string) throws IOException {
        String string2 = this.getNNTPServerForTitle(string);
        if (string2 == null) {
            return;
        }
        this.newsserver.remove(string2);
        this.groups.removeServer(string2);
    }

    public final void removePOPServerByTitle(String string) throws IOException {
        String string2 = this.getPOPServerForTitle(string);
        if (string2 == null) {
            return;
        }
        this.popserver.remove(string2);
        this.popmail.removeOrphanedUsers();
    }

    public final void removeSMTPServerByTitle(String string) throws IOException {
        String string2 = this.getSMTPServerForTitle(string);
        if (string2 == null) {
            return;
        }
        this.outmail.removeAllForServer(string2);
        this.smtpserver.remove(string2);
    }

    public final boolean removeUserFromPopmail(String string) {
        if (!this.popmail.containsUser(string)) {
            return false;
        }
        return this.popmail.removeUser(string);
    }

    public final MailDataRepository repository() {
        return this.repository;
    }

    private final void retrieveArticles(CommProgressWindow commProgressWindow, NNTPDownloadConnection nNTPDownloadConnection, String string, StartStop startStop) throws IOException {
        if (startStop.stop < startStop.start) {
            return;
        }
        if (commProgressWindow == null) {
            throw new IOException("This can't happen: entered retrieveArticles with progress=null.");
        }
        commProgressWindow.group().setPartialEnabled(true);
        commProgressWindow.group().setText("Reading " + (startStop.stop - startStop.start + 1L) + " article" + (startStop.stop == startStop.start ? "..." : "s..."));
        commProgressWindow.group().setArea(0, (int)(startStop.stop - startStop.start + 1L));
        nNTPDownloadConnection.jumpGroup(string);
        long l = startStop.start;
        while (l <= startStop.stop) {
            commProgressWindow.group().setValue((int)(l - startStop.start + 1L));
            nNTPDownloadConnection.getArticle(l);
            ++l;
        }
    }

    public final void saveHashtableFile(Hashtable hashtable, String string, boolean bl) throws IOException {
        if (bl) {
            Tools.logPart("..." + string);
        }
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.dataDir + string), 16384));
        objectOutputStream.writeObject(hashtable);
        objectOutputStream.close();
    }

    private final void saveLastFile(boolean bl) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(this.dataDir + "last"));
        objectOutputStream.writeObject(new Long(this.lastNumber));
        objectOutputStream.writeObject(new Boolean(bl));
        objectOutputStream.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Hashtable scanHashtableFile(String string, boolean bl) throws IOException {
        if (bl) {
            Tools.logPart("..." + string);
        }
        Hashtable hashtable = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.dataDir + string), 16384));
            hashtable = (Hashtable)objectInputStream.readObject();
            objectInputStream.close();
            return hashtable;
        }
        catch (IOException iOException) {
            return new Hashtable();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("Database error encountered reading file '" + this.dataDir + string + "'(Invalid Class)");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final boolean scanLastFile() throws IOException {
        boolean bl;
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(this.dataDir + "last"));
        try {
            try {
                this.lastNumber = (Long)objectInputStream.readObject();
                bl = (Boolean)objectInputStream.readObject();
                Object var3_3 = null;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            objectInputStream.close();
            throw throwable;
        }
        objectInputStream.close();
        return bl;
    }

    public final void setOptions(OptionsData optionsData) {
        this.readThreads = optionsData.readThreads;
        this.artRetries = optionsData.retries;
        this.timeout = optionsData.timeout;
        this.serverTimeout = optionsData.serverTimeout;
        this.connectionTimeout = optionsData.connectionTimeout;
        this.failureAllowed = optionsData.failureAllowed;
        this.maxRepositoryFileSize = optionsData.maxRepositoryFileSize;
        this.sendToAll = optionsData.sendToAll;
        this.forwardAll = optionsData.forwardToAll;
        this.saveWindowPos = optionsData.saveWindowPos;
        this.deleteWindowPos = optionsData.deleteWindowPos;
        this.dataDir = optionsData.dataDir;
        this.configFileName = optionsData.configFileName;
        this.defaultFont = optionsData.defaultFont;
        this.superuserAddress = optionsData.superuserAddress;
        this.superuserPassword = optionsData.superuserPassword;
        this.doBackup = optionsData.doBackup;
    }

    public final SmtpServerBase smtpserver() {
        return this.smtpserver;
    }

    public final Object startServer(int n) throws IOException {
        Object object = null;
        switch (n) {
            case 1: {
                object = new NNTPServer(this);
                break;
            }
            case 2: {
                object = new POPServer(this);
                break;
            }
            case 3: {
                object = new SMTPServer(this);
                break;
            }
            case 4: {
                object = new GatewayServer(this);
                break;
            }
        }
        if (n != 4) {
            ((GenericServer)object).start();
            if (!((GenericServer)object).initSucceeded()) {
                throw new IOException("Server couldn't be started!");
            }
        }
        return object;
    }

    public final String superuserAddress() {
        return this.superuserAddress;
    }

    public final TidyUpData tidyUp(File file) {
        TidyUpData tidyUpData = new TidyUpData();
        Object object = new Object();
        Hashtable hashtable = new Hashtable();
        this.groups.tidyUp(tidyUpData);
        Vector vector = this.outgoing.msgids();
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            if (!this.msgid.exists(string)) {
                this.outgoing.remove(string);
                ++tidyUpData.errors;
            } else if (!this.repository.exists(this.msgid.get((String)string).file)) {
                this.outgoing.remove(string);
            } else {
                this.outgoing.tidyUp(string, this.newsserver);
            }
            ++n;
        }
        this.msgid.tidyUp(this.groups, hashtable, tidyUpData);
        this.outmail.tidyUp(this.smtpserver, hashtable, tidyUpData);
        this.popmail.tidyUp(hashtable, tidyUpData);
        long l = 0L;
        Enumeration enumeration = this.repository.allFiles();
        while (enumeration.hasMoreElements()) {
            Long l2 = (Long)enumeration.nextElement();
            if (!hashtable.containsKey(l2)) {
                ++tidyUpData.orphaned;
                this.repository.backup(l2, file);
                this.repository.delete(l2);
            }
            if (l2 <= l) continue;
            l = l2;
        }
        if (l > this.lastNumber) {
            this.lastNumber = l;
            ++tidyUpData.errors;
        }
        return tidyUpData;
    }

    public final TidyUpData tidyUpPrepack(File file) {
        int n;
        Serializable serializable;
        TidyUpData tidyUpData = new TidyUpData();
        Vector vector = new Vector();
        Object object = new Object();
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        Vector vector2 = new Vector();
        Object object2 = this.prepack.allFiles();
        while (object2.hasMoreElements()) {
            vector2.addElement(object2.nextElement());
        }
        object2 = this.gateways.names();
        int n2 = 0;
        while (n2 < ((Vector)object2).size()) {
            serializable = this.gateways.object((String)((Vector)object2).elementAt(n2)).prepackFiles();
            int n3 = 0;
            while (n3 < ((Vector)serializable).size()) {
                vector.addElement(((Vector)serializable).elementAt(n3));
                ++n3;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < vector2.size()) {
            block10: {
                long l = (Long)vector2.elementAt(n2);
                n = 0;
                while (n < vector.size()) {
                    if ((Long)vector.elementAt(n) != l) {
                        ++n;
                        continue;
                    }
                    break block10;
                }
                hashtable.put(vector2.elementAt(n2), object);
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < vector.size()) {
            block11: {
                long l = (Long)vector.elementAt(n2);
                n = 0;
                while (n < vector2.size()) {
                    if ((Long)vector2.elementAt(n) != l) {
                        ++n;
                        continue;
                    }
                    break block11;
                }
                hashtable2.put(vector.elementAt(n2), object);
            }
            ++n2;
        }
        tidyUpData.orphaned = hashtable.size();
        tidyUpData.unavailable = hashtable2.size();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            serializable = (Long)enumeration.nextElement();
            this.prepack.backup((Long)serializable, file);
            this.prepack.delete((Long)serializable);
        }
        return tidyUpData;
    }

    public final void unlockPOPUserName(String string) {
        Vector vector = this.lockedPOPUserNames;
        synchronized (vector) {
            this.lockedPOPUserNames.removeElement(string);
        }
    }

    public final void writeConfigFile() throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.configFileName));
        bufferedWriter.write("Kroni's News & Mail - config file");
        bufferedWriter.newLine();
        bufferedWriter.write("00.31");
        bufferedWriter.newLine();
        bufferedWriter.write(this.dataDir);
        bufferedWriter.newLine();
        bufferedWriter.write(Integer.toString(this.readThreads));
        bufferedWriter.newLine();
        bufferedWriter.write(Integer.toString(this.artRetries));
        bufferedWriter.newLine();
        bufferedWriter.write(Integer.toString(this.timeout));
        bufferedWriter.newLine();
        bufferedWriter.write(Integer.toString(this.failureAllowed));
        bufferedWriter.newLine();
        bufferedWriter.write(Integer.toString(this.maxRepositoryFileSize));
        bufferedWriter.newLine();
        bufferedWriter.write(this.sendToAll ? "y" : "n");
        bufferedWriter.newLine();
        bufferedWriter.write(this.forwardAll ? "y" : "n");
        bufferedWriter.newLine();
        bufferedWriter.write(this.saveWindowPos ? "y" : "n");
        bufferedWriter.newLine();
        bufferedWriter.write(this.deleteWindowPos ? "y" : "n");
        bufferedWriter.newLine();
        bufferedWriter.write(Integer.toString(this.defaultFont));
        bufferedWriter.newLine();
        bufferedWriter.write(this.superuserAddress);
        bufferedWriter.newLine();
        bufferedWriter.write(this.superuserPassword);
        bufferedWriter.newLine();
        bufferedWriter.write(Integer.toString(this.connectionTimeout));
        bufferedWriter.newLine();
        bufferedWriter.write(Integer.toString(this.serverTimeout));
        bufferedWriter.newLine();
        bufferedWriter.write(this.doBackup ? "y" : "n");
        bufferedWriter.newLine();
        bufferedWriter.close();
    }

    public final void writeGroupList(String string, TreeNode treeNode) throws IOException {
        this.newsserver.writeGroupList(string, treeNode);
    }

    public Basis() throws IOException {
        this(false);
    }

    public Basis(String string) throws IOException {
        this(string, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Basis(String string, boolean bl) throws IOException {
        block33: {
            FileInputStream fileInputStream;
            this.readThreads = 3;
            this.artRetries = 3;
            this.timeout = 50;
            this.connectionTimeout = 25;
            this.serverTimeout = 60;
            this.doBackup = true;
            this.failureAllowed = 20;
            this.maxRepositoryFileSize = 0x2800000;
            this.lastNumber = 0L;
            this.sendToAll = true;
            this.forwardAll = false;
            this.defaultFont = 1;
            this.superuserAddress = "postmaster@some.domain";
            this.superuserPassword = "secret";
            this.doRelax = false;
            this.lockedPOPUserNames = new Vector();
            this.connections = new ConnectionBase();
            this.separator = System.getProperty("file.separator");
            boolean bl2 = false;
            this.configFileName = string;
            try {
                fileInputStream = new FileInputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (bl) {
                    throw new IOException("Config file not found: " + string);
                }
                this.createConfigFile(string);
                bl2 = true;
                try {
                    fileInputStream = new FileInputStream(string);
                }
                catch (FileNotFoundException fileNotFoundException2) {
                    throw new IOException(fileNotFoundException2.getMessage() + ": Couldn't make config file ('" + string + "').");
                }
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            String string2 = bufferedReader.readLine();
            if (!string2.equals("Kroni's News & Mail - config file")) {
                throw new IOException("'" + string + "' isn't a valid config file");
            }
            string2 = bufferedReader.readLine();
            if (string2.equals("00.30")) {
                this.readVersion0030(bufferedReader);
            } else {
                if (!string2.equals("00.31")) {
                    throw new IOException("config file '" + string + "' has unrecognized format '" + string2 + "'");
                }
                this.readVersion0031(bufferedReader);
            }
            bufferedReader.close();
            File file = new File(this.dataDir);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (this.deleteWindowPos) {
                this.deleteWindowPos = false;
                this.writeConfigFile();
                new File(this.dataDir + "winpos").delete();
            }
            Tools.setLogFile(this.dataDir + "knewsmail.log", "\n\n--->\n" + DateFormat.getDateTimeInstance().format(new Date()) + " : starting " + CommonConstants.title + "\n\n");
            if (bl) {
                Tools.logPart("\nScanning database...");
            } else {
                Tools.log("\nScanning database:");
            }
            this.lock = new FileOutputStream(this.dataDir + "lock");
            boolean bl3 = this.scanLastFile();
            if (bl3) {
                Tools.log("Database possibly corrupt! We'll try to go on...");
            }
            this.saveLastFile(true);
            try {
                Object object;
                this.databaseRead(bl);
                if (!bl) {
                    Tools.log("...done!");
                } else {
                    Tools.log("done!");
                }
                if (bl3) {
                    Tools.logPart("\nChecking database consistency...");
                    object = new TidyUpData();
                    int n = 0;
                    object = this.tidyUp(null);
                    n = (int)((long)n + ((TidyUpData)object).errors);
                    object = this.tidyUpPrepack(null);
                    n = (int)((long)n + ((TidyUpData)object).errors);
                    switch (n) {
                        case 0: {
                            Tools.log("ok!");
                            break;
                        }
                        case 1: {
                            Tools.log("one error fixed.");
                            break;
                        }
                        default: {
                            Tools.log(n + " errors fixed.");
                            break;
                        }
                    }
                }
                if (!this.doBackup || bl2) break block33;
                if (bl3) {
                    Tools.log("\nSince the database might still be corrupt, no backup is saved.");
                    break block33;
                }
                Tools.logPart("\nSaving a backup of the database...");
                try {
                    object = new File(this.dataDir + "backup");
                    String[] stringArray = ((File)object).list();
                    if (stringArray != null) {
                        int n = 0;
                        while (n < stringArray.length) {
                            new File((File)object, stringArray[n]).delete();
                            ++n;
                        }
                    }
                    this.databaseSaveBackup("backup");
                }
                catch (IOException iOException) {
                    Tools.log("\nAn error occurred saving the database; we'll ignore that.", iOException);
                }
                Tools.log("done!");
            }
            catch (IOException iOException) {
                Tools.log("\n\nThe database is corrupt:", iOException);
                try {
                    Tools.log("\nSaving the corrupt database for later analysis...");
                    this.databaseSaveBackup("corrupt");
                }
                catch (IOException iOException2) {
                    Tools.log("\nAn error occurred saving the corrupt database:", iOException2);
                    throw new IOException("It's too dangerous to go on without a database backup. Stopping.");
                }
                try {
                    Tools.log("\nLoading the backup...");
                    this.databaseLoadBackup();
                }
                catch (IOException iOException3) {
                    Tools.log("\nAn error occurred loading the backup:", iOException3);
                    Tools.log("Still trying to keep on...");
                }
                Tools.log("\nScanning the backup...");
                this.scanLastFile();
                this.databaseRead(bl);
                if (!bl) {
                    Tools.log("...done!");
                }
                Tools.log("done!");
            }
        }
        Tools.log("");
        Tools.memoryAlert("After initialization");
        this.doRelax = true;
    }

    public Basis(boolean bl) throws IOException {
        this(System.getProperty("user.home") + System.getProperty("file.separator") + ".knewsmail", bl);
    }
}

