/*
  OS2PopS to Weasel user/password data conversion utility

  by K.Yu.Boyandin (ralionmaster@geocities.com)

  Expects OS2POPS.Users file to be in the current directory

  Creates:
    Users.tni   - file to insert into [Users] section of Weasel.tni
    MkBoxes.cmd - batch file to create users' mailboxes
*/

Input_data = 'OS2POPS.Users'
Output_Tni = 'Users.tni'
Output_Cmd = 'MkBoxes.cmd'

Users_cnt = 0

If Stream( Input_data, 'c', 'query exists' ) <> '' Then Do
  If Stream( Input_data, 'c', 'open read' ) = 'READY:' Then Do
    Call Lineout Output_cmd, '@Echo off'
    Call Lineout Output_cmd, 'Rem Add the slash-terminated MailRoot path after = below'
    Call Lineout Output_cmd, 'Rem e.g. Set MAILROOT=D:\MyMail\root\'
    Call Lineout Output_cmd, 'Set MAILROOT=<insert path here>'
    Do While Lines( Input_data ) > 0
      IData = Linein( Input_data )
      If Pos( '*', IData ) <> 1 Then Do
        Parse Var IData '01'x UserID '01'x UserPass '01'x .
        Users_cnt = Users_cnt + 1
        Call Lineout Output_Tni, UserID||' '||UserPass
        Call Lineout Output_Cmd, 'Md %MAILROOT%\'||UserID
      End
    End
    Say Users_cnt 'users converted. Now perform the following:'
    Say '1. Edit' Output_Cmd 'file, to indicate valid MAILROOT value'
    Say '2. Create the MAILROOT and run' Output_Cmd 'to create mail boxes'
    Say '3. Insert contents of' Output_Tni 'after [Users] section of Weasel.tni'
    Say '4. Run LOADINI Weasel utility to update user data'
    Say 'Note: this Rexx utility actually *appends* data to both mentioned files.'
  End
  Else
    Say 'Cannot read OS2POPS.Users file...'
  Exit
End

Say 'OS2POPS.Users file must exist in the current directory.'

