/* 
* pipe.c
* 
* (c) 1994 by Jochen Friedrich <jochen@audio.ruessel.sub.org>.
*
*/ 

/*
 * The IBM CSet++ doesn't have pipe() and popen(), pclose() calls.
 * This module fixes this lack of important functions.
 */

#define INCL_DOSFILEMGR
#define INCL_DOSQUEUES
#include <os2.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdio.h>
#include <io.h>
#include <process.h>
#include "pipe.h"

int pipe(unsigned long fd[2])
{
  unsigned long status;

  if (DosCreatePipe(&(fd[0]),&(fd[1]),4096) < 0)
    return -1;
  if (DosQueryFHState(fd[0],&status) < 0)
    return -1;
  status |= OPEN_FLAGS_NOINHERIT;
  status &= 0x7f88;
  if (DosSetFHState(fd[0],status) < 0)
    return -1;
  if (DosQueryFHState(fd[1],&status) < 0)
    return -1;
  status |= OPEN_FLAGS_NOINHERIT;
  status &= 0x7f88;
  if (DosSetFHState(fd[1],status) < 0)
    return -1;
  _setmode(fd[0],O_BINARY);
  _setmode(fd[1],O_BINARY);
  return 0;
}

FILE *popen(char *cmd, char *mode)
{
  FILE *our_end;
  unsigned long fd[2], tempfd, dupfd;

  pipe(fd);
 
  if (mode[0]=='r')
  {
    our_end=fdopen(fd[0],mode);
    dupfd=1;
    tempfd=dup(dupfd);
    dup2(fd[1],dupfd);
    close(fd[1]);
  } else {
    our_end=fdopen(fd[1],mode);
    dupfd=0;
    tempfd=dup(dupfd);
    dup2(fd[0],dupfd);
    close(fd[0]);
  } /* endif */
 
  spawnlp(P_NOWAIT,getenv("COMSPEC"),getenv("COMSPEC"),"/c",cmd,NULL);
  dup2(dupfd,tempfd);
  close(tempfd);
  return our_end;
}

int pclose(FILE *pip)
{
  int i;

  fclose(pip);
  wait(&i);
  return 0;
}
