/* 
* batcher.c
* 
* (c) Paul Vixie <paul@vix.com>
*
* Ported to OS/2 and hacked to be useful for UUPC/Extended and IBM sendmail 
* by Jochen Friedrich <jochen@audio.ruessel.sub.org>.
* Please send bug reports for this port to me, not to the original author.
*
*/ 

/* batcher.c - batch up bsmtp traffic and send it on
 * vix 28mar91 [pseudocoded]
 * jof 07okt94 [ported to OS/2]
 */

/* this program creates output batches from "catbat" directories.  it will
 * read all the numbered-name files in a directory (all the ones it can open,
 * anyway) and append them to the stdin of a "uux" command (which it spawns).
 * files which are successfully sent to uux in this manner are deleted.
 */

/* deficiencies: needs parameterization; the batchdir, batch size, output
 * command and debugging options should all be command-line options.
 */

#define INCL_DOSFILEMGR
#define INCL_DOSQUEUES
#include <os2.h>
#include <direct.h>
#include <share.h>
#include <fcntl.h>
#include <io.h>
#include <process.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "sysexits.h"
#include "pipe.h"

#define	DEBUG	1
#if DEBUG > 0
#define	dprintf	if (debug) fprintf
#else
#define	dprintf	(void)
#endif

#define	MAXINPUTS	20
#define	MAXARGS		10
#define MAXHOSTNAMELEN 120
#define MAXPATHLEN	80

int	tr_batchlim =	100000;
char	*tr_cmd =	"uux.exe";
char	*protocol =	NULL;
int	tr_pid, tr_pid2;

int	bsmtp = 1;
int	cflag = 0;
int	gflag = 0;
int	debug = 0;

char	**Argv, **Envp;

main(argc, argv, envp)
	int argc;
	char **argv, **envp;
{
	Argv = argv;
	Envp = envp;

	while ((argc > 1) && *argv[1] == '-') {
		
		switch (argv[1][1]) {
			case 'x':
				debug = atoi(&argv[1][2]);
				dprintf(stderr, "debug=%d\n", debug);
				argc--, argv++;
				break;
			case 'l':
				tr_batchlim = atoi(&argv[1][2]);
				dprintf(stderr, "batch limit=%d\n", tr_batchlim);
				argc--, argv++;
				break;
			case 'c':
				cflag = 1;
				argc--, argv++;
				break;
			case 'g':
				gflag = 1;
				argc--, argv++;
				break;
			case 'p':
				bsmtp = 0;
				protocol = &argv[1][2];
				break;
			default:
				fprintf(stderr, "unknown option: %s\n",argv[1]);
				exit (EX_USAGE);
		}
	}

	if (argc == 3) {
			dosys(argv);
	} else {
		printf("usage: batcher [-c || -g] [-xdebuglevel] [-lbatchlimit] system spooldir");
		exit (EX_USAGE);
	}
	exit(EX_OK);
}

dosys(sys)
	char **sys;
{
	char		path[MAXPATHLEN];
	struct dirent	*d;
	int		input, output, batchno;
	register int	len, batchsize;
	int		inputs[MAXINPUTS], batches[MAXINPUTS], n_inputs;
	unsigned char	buf[BUFSIZ];
	HDIR		Findhandle;
	unsigned long	FindCount;
	FILEFINDBUF3	ffblk;
    
	dprintf(stderr, "dosys(%s)... considering\n", sys[1]);
	strcpy(path, sys[2]);
	if (chdir(path) < 0) {
		perror(path);
		exit(EX_UNAVAILABLE);
	}
	if (path[1] == ':') {
		if (_chdrive(toupper(path[0])-'A'+1) <0) {
			perror(path);
			exit(EX_UNAVAILABLE);
		}
	}

	dprintf(stderr, "dosys(%s)... reading %s\n", sys[1], path);

        FindCount=1;
        Findhandle=1;
	output = -1;
	n_inputs = 0;

	if(DosFindFirst("*", &Findhandle, 0, &ffblk,sizeof(ffblk),
                            &FindCount,FIL_STANDARD)) return ;
	do {
		if (ffblk.achName[0] == '.')
			continue;
		if (!isnumeric(ffblk.achName))
			continue;
		if (!(batchno = atoi(ffblk.achName)))
			continue;
		if ((input = sopen(ffblk.achName, O_RDONLY, SH_DENYRW, S_IREAD)) < 0)
			continue;

		dprintf(stderr, "dosys(%s)... found %s\n", sys[1], ffblk.achName);
		if (output == -1) {
			dprintf(stderr, "dosys(%s)... opening output\n", sys[1]);
			output = tr_open(sys[1]);
			batchsize = 0;
		}
		while ((len = read(input, buf, BUFSIZ)) > 0)
			if ((len = write(output, buf, len)) > 0)
				batchsize += len;
			else
				break;
		dprintf(stderr, "dosys(%s)... copied, fin len=%d\n", sys[1], len);
		if (len < 0) {
			/* read or write error, bail out. */
			perror("copying data");
/*			kill(tr_pid, SIGTERM); */
			close(output);
			wait(0);
			exit(EX_OSERR);
		}
		dprintf(stderr, "dosys(%s)... [%d](%d,%d) batchsize=%d\n", sys[1],
			n_inputs, input, batchno, batchsize);
		inputs[n_inputs] = input;
		batches[n_inputs] = batchno;
		if (++n_inputs >= MAXINPUTS || batchsize >= tr_batchlim) {
			dprintf(stderr, "dosys(%s)... closing output\n", sys[1]);
			tr_close(output);
			output = -1;
			batchsize = 0;
			purgeinputs(n_inputs, batches, inputs);
			n_inputs = 0;
		}
	} while (!DosFindNext(Findhandle,&ffblk,sizeof(ffblk),&FindCount));

	dprintf(stderr, "dosys(%s)... done, fin n_inputs=%d\n", sys[1], n_inputs);
	if (n_inputs) {
		tr_close(output);
		purgeinputs(n_inputs, batches, inputs);
	}
}

purgeinputs(n_inputs, batches, inputs)
	int n_inputs, batches[], inputs[];
{
	int i;

	for (i = 0;  i < n_inputs;  i++) {
		char batchname[MAXPATHLEN];

		sprintf(batchname, "%d", batches[i]);
		close(inputs[i]);
		unlink(batchname);
	}
}

int
tr_open(sys)
	char *sys;
{
	unsigned long p[2], tempfd, tempfd1, i, status;
	char *argv[MAXARGS];
	char *argv2[MAXARGS];
	char host[MAXPATHLEN];
	char **ap;

/* OS/2 PIPE routines */

	if (pipe(p) < 0) {
                perror("popen");
		exit(EX_OSERR);
        }

	tempfd=dup(0);
	dup2(p[0], 0);
        close(p[0]);

	i=0;
        argv[i++]= tr_cmd;
        argv[i++]= "-";
        argv[i++]= "-r";
#ifdef HACKED_UUX

        argv[i++]= "-B";
#endif
	argv[i++]= "-gM";
	if (gflag)
	        sprintf(host,"%s!rgsmtp",sys);
	else if (cflag)
	        sprintf(host,"%s!rcsmtp",sys);
	else if (!bsmtp)
		sprintf(host,"%s!%s",sys,protocol);
	else
	        sprintf(host,"%s!rsmtp",sys);

        argv[i++]= host;
        argv[i++]= NULL;

	tr_pid=spawnvp(P_NOWAIT,tr_cmd, argv);
	dup2(tempfd, 0);
        close(tempfd);

# if DEBUG > 0
	if (debug) {
		fprintf(stderr, "tr_open(), cmd=%s ( ", tr_cmd);
		for (ap = argv;  *ap;  ap++)
			fprintf(stderr, "%s ", *ap);
		fprintf(stderr, ")\n");
	}
# endif

	if (cflag || gflag) {
		tempfd=dup(0);
		tempfd1=dup(1);
		dup2(p[1],1);
		close(p[1]);
		_setmode(1,O_BINARY);
		if (pipe(p) < 0) {
        	        perror("popen");
			exit(EX_OSERR);
	        }

		tempfd=dup(0);
		dup2(p[0], 0);
		close(p[0]);
		if (gflag) {
			argv2[0]= "gzip.exe";
			argv2[1]= NULL;
			tr_cmd = "gzip.exe";
		} else {
			argv2[0]= "compress.exe";
			argv2[1]= NULL;
			tr_cmd = "compress.exe";
		}
		tr_pid2=spawnvp(P_NOWAIT,tr_cmd, argv2);
		dup2(tempfd, 0);
	        close(tempfd);
		dup2(tempfd1,1);	
		close(tempfd1);
# if DEBUG > 0
		if (debug) {
			fprintf(stderr, "tr_open(), cmd=%s ( ", argv2[0]);
			for (ap = argv2;  *ap;  ap++)
				fprintf(stderr, "%s ", *ap);
			fprintf(stderr, ")\n");
		}
# endif
	}

	if (bsmtp) {
		char cmd[MAXPATHLEN], hn[MAXHOSTNAMELEN];
		char *hostnm;
		if (hostnm=getenv("HOSTNAME"))
			strncpy(hn, hostnm, MAXHOSTNAMELEN);
		else strcpy(hn,"localhost");
		sprintf(cmd, "HELO %s\n", hn);
		write(p[1], cmd, strlen(cmd));
	}
	dprintf(stderr, "tr_open() about to return %d (tr_pid=%d)\n",
		p[1], tr_pid);
	if (tr_pid2)
		dprintf(stderr, "(tr_open(): tr_pid2=%d)\n", tr_pid2);
	return p[1];
}

tr_close(fd)
	int fd;
{
	int		pid, w, w1, w2;

	dprintf(stderr, "tr_close(%d)\n", fd);
	if (bsmtp) {
		if (write(fd, "QUIT\n", 5) < 0) {
			perror("write QUIT");
			exit(EX_OSERR);
		}
	}
	if (close(fd) < 0) {
		perror("output close");
		exit(EX_OSERR);
	}
	w1=0; w2=0;
	while ((pid = wait(&w)) > 0 && (tr_pid || tr_pid2)) {
		if (pid == tr_pid) {
			tr_pid=0;
			w1=w;
			dprintf(stderr, "process 1 pid %d ended.\n",pid);
		} else if (pid == tr_pid2) {
			tr_pid2=0;
			w2=w;
			dprintf(stderr, "process 2 pid %d ended.\n",pid);
		} else
			fprintf(stderr, "%s: strange... wanted pid %d, got pid %d\n",
				tr_pid, pid);
	}
	if (tr_pid || tr_pid2) {
		perror("wait");
		exit(EX_OSERR);
	}
	if (WEXITSTATUS(w1)) {
		fprintf(stderr, "%s:  command %s exited with stat %d sig %d \n",
			Argv[0], tr_cmd, WEXITSTATUS(w1), WTERMSIG(w1));
		exit(EX_OSERR);
	}
	if (WEXITSTATUS(w2)) {
		fprintf(stderr, "%s:  command %s exited with stat %d sig %d \n",
			Argv[0], tr_cmd, WEXITSTATUS(w2), WTERMSIG(w2));
		exit(EX_OSERR);
	}
}

isnumeric(s)
	register char *s;
{
	register char c;

	if (!*s)
		return 0;

	while (c = *s++) {
		if (!isdigit(c))
			return 0;
	}

	return 1;
}
