/*
 * popStatus.java
 * Copyright (c) 1996 John Thomas  jthomas@cruzio.com
 *      All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for commercial or non-commercial purposes
 * is hereby granted provided that this copyright notice
 * appears in all copies.
 *
 */

/**
 *Class: popStatus
 *
 * <p>
 *
 * Class that holds the information returned from a pop request
 * <p>
 * This is required so that the POP class can be thread safe
 *
 * @author      John Thomas
 * <a href="mailto:jthomas@cruzio.com>jthomas@cruzio.com</a>
 * @version     1.1 ( March 1996 )
 *
 */

package jthomas.pop ;

public
class popStatus   {


        boolean _OK=false;  // True if last command returned +OK

        String  _Response;      // Set to initial response from server

        String[] _Responses= new String[0]; // Set to last multiline response.

//----------------------------------------------------------
/**
 *Method: Responses()
 *  <p>
 *  Return the multi-line output from a command
 *
 */
//----------------------------------------------------------

public String[]
Responses() {
        return _Responses;
}

//----------------------------------------------------------
/**
 *Method: Response()
 *  <p>
 *  Return the initial status line output from a command
 *
 */
//----------------------------------------------------------

public String
Response() {
        return _Response;
}

//----------------------------------------------------------
/**
 *Method: OK()
 *  <p>
 *  Return the completion status (+OK true or -ERR false) from
 *  the last command issued to the server.
 *
 */
//----------------------------------------------------------

public boolean
OK() {
        return _OK;
}
//-------------------------------------------------------
} // end of Class popStatus


