/*
	MR/2 ICE - MSGUTIL.CMD

	Copyright (c) 1996, Nick Knight
	All Rights Reserved.

	Author: 	Nick Knight
	Created:	03/03/96
	Usage:		msgutil subcommand MessageFile
	Purpose:	msgutil.cmd allows for special processing of message
				files.	It is called from within MR/2 ICE, passed a
				subcommand based on the Fkey used to invoke it (F1 == 1,
				F12 = 12) and the current message file name.
	US Mail:	Nick Knight, PO Box 22366, Beachwood, Ohio 44122
	Fidonet:	1:157/2 or 1:/157/200
	Internet:	nick@secant.com
	Compuserve: 76066,1240
	BBS:		Private messages on Nerd's Nook (216) 356-1772 or 1872

** Major Update: 04/16/96, gutted/rewritten using wonderful examples by:
   
   Author.........:  Jason Gottschalk, Internet: os2@tir.com
   Date Written...:  March 15, 1996

*/
/*
$MENUMAP
	1:Detach files using external utilities
	2:Edit the file with E.EXE
	3:View embedded HTML via Web Browser
$END
*/

/* USER SELECTABLE OPTIONS */

/* if set to 0, Ctrl-F1 will NOT attempt to load viewer */
EnableMimeViewers = 1	   

Editor = 'e'
Browser = 'netscape.exe'
BitmapViewer = 'ib.exe'
AviViewer = 'vb.exe'
WavPlayer = 'ab.exe'
INFViewer = 'view.exe'
MPGViewer = 'pmmpeg.exe'

env = 'OS2ENVIRONMENT'    /* Access environment init variables */

/**********************************************************************/
/**   Parameter Section - Message Information Passed from MR/2 ICE	 **/
/**********************************************************************/
/* The section below is COMMENTED OUT to save resources.  If you	  */
/* wish to use one or more of these variables, just uncomment them	  */
/**********************************************************************/
/*

Subject 	= value("MR2I.SUBJECT",,env)
ReplyTo 	= value("MR2I.REPLYTO",,env)
ToName		= value("MR2I.TO",,env)
FromName	= value("MR2I.FROM",,env)
MessageID	= value("MR2I.MESSAGE-ID",,env)
InReplyTo	= value("MR2I.IN-REPLY-TO",,env)
Editor		= value("MR2I.EDITOR",,env)
SerialNumber= value("MR2I.SERIALNUMBER",,env)
CurrLine	= value("MR2I.CURRENTLINE",,env)
CurrColumn	= value("MR2I.CURRENTCOLUMN",,env)

Browser 	= value("MR2I.BROWSER",,env)
FTPClient	= value("MR2I.FTPCLIENT",,env)
CurrentWord = value("MR2I.CURRENTWORD",,env)
Account 	= value("MR2I.ACCOUNT",,env)
Version 	= value("MR2I.VERSION",,env)

MarkedBlock = value("MR2I.CURRENTBLOCK",,env)
*/

/*
   NOTE that if markedBlock = "@rexx$txt.tmp", then the block was
   too big to pass in the environment, and it was instead saved to
   the file "rexx@txt.tmp".
*/	 

/**********************************************************************/


Signal on Syntax		/* Setup event handlers */
Signal on Halt
Signal on Novalue
					   
					   /* Include OS/2 Rexx utilities */

if RxFuncQuery('SysLoadFuncs') then
   do
	  call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
	  call SysLoadFuncs
   end


						   /* Run through some standard setup */

'@echo off'               /* turn off display of OS/2 commands */
crlf='0d0a'x              /* Set Carriage Return with LineFeed */


parse value SysCurPos() with row col   /* Get current cursor position */

CMDLineArgs = translate(arg(1)) 	   /* Snag everything from the command line */

esc  = '1b'x    /* ESC character */
P = esc'[35m'   /* ANSI.SYS-control for purple foreground */
r = esc'[31m'   /* ANSI.SYS-control for red foreground */
g = esc'[32m'   /* ANSI.SYS-control for green foreground */
y = esc'[33m'   /* ANSI.SYS-control for yellow foreground */
cy = esc'[36m'  /* ANSI.SYS-control for cyan foreground */
wh = esc'[0m'   /* ANSI.SYS-control for resetting attributes to normal */
bl = esc'[5m'   /* ANSI.SYS-control for blinking */
hl = esc'[1m'   /* ANSI.SYS-control for highlight */


FKey = 0
FHandled = 0

parse value CMDLineArgs with FKey filename

select
  when FKey = 1 then
  do
	nop
  end
  
  when FKey = 2 then
  do
	nop
  end

  when FKey = 3 then
  do
	nop
  end
  
  when FKey = 4 then
  do
	nop
  end
  
  when FKey = 5 then
  do
	nop
  end
  when FKey = 6 then
  do
	nop
  end
  when FKey = 7 then
  do
	MessageID	= value("MR2I.FIRSTREFERENCE",,env)
	browser' "http://search.dejanews.com/dnquery.xp?search=thread&filter=&svcclass=dnserver&threaded=1&recnum='MessageID'#1/1"'
	fHandled = 1
  end
  when FKey = 8 then
  do
	From = value("MR2I.FROM",,env)
	browser' "http://search.dejanews.com/profile.xp?author='From'"'
	fHandled = 1
  end
  when FKey = 10 then
  do
	MessageID = value("MR2I.MESSAGE-ID",,env)
	browser' "http://search.dejanews.com/dnquery.xp?search=thread&filter=&svcclass=dnserver&threaded=1&recnum='MessageID'#1/1"'
	fHandled = 1
/*	  
	Subject 	= value("MR2I.SUBJECT",,env)
	From = value("MR2I.FROM",,env)
	browser' "http://search.dejanews.com/dnquery.xp?query=~a+'From'+%26+~s+'Subject'"'
	fHandled = 1
*/	
  end
  when FKey = 11 then
  do
	nop
  end
  when FKey = 12 then
  do
	nop
  end

  otherwise do
	say 'Invalid Function Key passed by MR/2: 'FKey
	exit
  end
end

if fHandled == 0 then
	call 'msgutil.cmd' FKey Filename

exit

Syntax:
   Say 'A SYNTAX condition was raised on line' sigl'!'
   Say '  The error number is' rc', which means "'Errortext(rc)'"'
   problem_line = sigl
   Signal Abnormal_End

Halt:
   Say 'A Halt condition was raised on line' sigl'!'
   problem_line = sigl
   Signal Abnormal_End

Novalue:
   Say 'Novalue Condition raised on line' sigl'!'
   Say '  The variable which caused it is' Condition('Description')
   problem_line = sigl
   Signal Abnormal_End

Abnormal_End:
   Say '  That line is "'Sourceline(problem_line)'"'
   Say '  You can now debug if you want to.'
   Trace ?R
   Nop

Exit

