extproc perl5 -x
#!perl

# Copyright 1993, D. Brent Chapman.  See the Majordomo license agreement
#     for usage rights.
#
# $Source: /sources/cvsrepos/majordomo/contrib/archive2.pl,v $
# $Revision: 1.2.4.3 $
# $Date: 1995/01/02 19:31:38 $
# $Author: rouilj $
# $State: Exp $
#
# $Locker:  $
#
# archive -f <archive> {-u|-a} [-d|-m|-y] [file ...]
# 	-f <archive> REQUIRED; specifies base file name for archive
# 	-u	Input is a UNIX archive (separated by "From " lines) to split
# 	-a	Input is a message to append to archive
# 	-d	Archive file is <archive>.YYMMDD
# 	-m	Archive file is <archive>.YYMM
# 	-y	Archive file is <archive>.YY
# Exactly one of "-u" or "-a" must be specified.
# At most one of "-d", "-m", or "-y" may be specified; if none is
#   specified, archive name is simply <archive>
# 
# An example of using "archive" to split an existing UNIX-style archive
# named "my-list.archive" into by-day archive files named "my-list.YYMMDD":
# 
# 	archive -f my-list -d -u my-list.archive
# 
# A sample /etc/aliases file entry to use "archive" add each incoming message
# to a "my-list.YYMM" file in the "/usr/local/mail/lists/my-list.archive"
# directory:
# 
# 	my-list-archive: "|/usr/local/mail/majordomo/wrapper archive
# 		-f /usr/local/mail/lists/my-list.archive/my-list
# 		-m -a"

print "Executing ARCHIVE.CMD\n";
$os2debug = 1;

# set our path explicitly
#$ENV{'PATH'} = "/bin:/usr/bin:/usr/ucb";

# What shall we use for temporary files?

$tmp = "e:/tmp/archive.$$";

#Tell the work who we are The use of the mj prefix is a bit
# too soon since it isn't config file cognisent, but that should
# come along in the 1.91 patch I guess.

$main'program_name = 'mj_archive';

# Read and execute the .cf file

print "Loading majordomo.cf\n" if $os2debug>0;

$cf = $ENV{"MAJORDOMO_CF"} || "d:/majordomo/bin/majordomo.cf";
if ($ARGV[0] eq "-C") {
    $cf = $ARGV[1];
    shift(@ARGV); 
    shift(@ARGV); 
}
if (! -r $cf) {
    die("$cf not readable; stopped");
}
eval(`type "$cf"`);

print "Loading perl libraries...\n" if $os2debug>0;


# All these should be in the standard PERL library
unshift(@INC, $homedir);
require "ctime.pl";		# To get MoY definitions for month abbrevs
require "majordomo_version.pl";	# What version of Majordomo is this?
require "majordomo.pl";		# all sorts of general-purpose Majordomo subs
require "shlock.pl";		# NNTP-style file locking

# Here's where the fun begins...

require "getopts.pl";

print "Checking command line options...\n" if $os2debug>0;

$m = 1;
foreach (@ctime'MoY) {
    $MoY{$_} = $m++;
}

$usage = "Usage: $0 -f <file> {-u|-a} [-d|-m|-y] [file ...]";

print "Getting Options...\n" if $os2debug>0;

&Getopts("f:uadmy") || die("$usage\nStopped");

if (!defined($opt_f)) {
    print STDERR "'-f <list>' required\n$usage\n";
    exit 1;
}

print "Checking for archive_dirs variable ...\n" if $os2debug>0;

if (!defined(@archive_dirs)) {
    &abort("\@archive_dirs not defined in majordomo.cf! Aborting.\n");
}

print "Checking -f option for absolute path...\n" if $os2debug>0;

#
#if($opt_f !~ m#^/#) {
#    print STDERR "-f <list>: list must be absolute path.\n";
#    exit 1;
#}
#


($dirname, $basename) = ($opt_f =~ m#(.*)/([^/]*)#);

print "Files: ($dirname) ($basename)\n" if $os2debug>0;

undef $valid_dir;
foreach $dir (@archive_dirs) {
    if ($dir eq $dirname) {
        $valid_dir = $dir;	
        last;
    }
}

if (!$valid_dir) {
    print "Invalid Archive Directory! Aborting...\n" if $os2debug>0;
    &abort("Invalid archive directory.  Aborting. ($valid_dir)\n");
}

if (defined($opt_a)) { $mutex++; }
if (defined($opt_u)) { $mutex++; }
if ($mutex != 1) {
    print STDERR "Either '-a' or '-u' required\n$usage\n";
    exit 2;
}

print "Done with error checking...Beginning mutex\n" if $os2debug>0;

$mutex = 0;

if (defined($opt_d)) { $mutex++; }
if (defined($opt_m)) { $mutex++; }
if (defined($opt_y)) { $mutex++; }
if ($mutex > 1) {
    print STDERR "Only one of '-d', '-m', or '-y' allowed\n$usage\n";
    exit 3;
}

if (defined($opt_a)) {
    ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = 
	localtime(time);
    &open_archive(FILE, $year, $mon + 1, $mday);
}

print "Openning archive file and beginning copying...\n" if $os2debug>0;

while (<>) {
    if (/^From\s/) {
	if (/^From\s+\S+\s+(Sun|Mon|Tue|Wed|Thu|Fri|Sat)\s+(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s+\d\d?\s+\d\d?:\d\d:\d\d\s+\d{2,4}\s*$/i) {
	    if (defined($opt_u)) {
		if (defined($is_open)) {
		    print FILE "\n";
		    &lclose(FILE);
		}
		&open_archive_unix(FILE, $_);
	    }
	    print FILE "$_";
	} else {
	    print FILE ">$_";
	}
    } else {
	print FILE $_;
    }
}

print "Done with file copy, closing FILE.\n" if $os2debug>0;

print FILE "\n";
#&lclose(FILE);

print "Done!\n" if $os2debug>0;
exit 0 ;

sub open_archive_unix {
    local($FH) = shift;
    local($from) = shift;
    local($junk, $addr, $dow, $moy, $dom, $time, $year, @rest);

    ($junk, $addr, $dow, $moy, $dom, $time, $year, @rest) = split(/\s+/,$from);
    &open_archive($FH, $year % 100, $MoY{$moy}, $mday);
}

sub open_archive {
    local($FH) = shift;
    local($year) = shift;
    local($mon) = shift;
    local($mday) = shift;
    local($suffix);
    local($inode1,$inode2,$dev1,$dev2);

# Original code supplied by: Paul Phillips <paulp@primus.COM>
#  modified by rouilj to handle the case where the file doesn't exist
#  and added ALGORITHM comments and analysis for people to verify my
#  thought processes.

    if (defined($opt_y)) {
	$suffix = sprintf(".%02d", $year % 100);
    }
    if (defined($opt_m)) {
	$suffix = sprintf(".%02d%02d", $year % 100, $mon);
    }
    if (defined($opt_d)) {
	$suffix = sprintf(".%02d%02d%02d", $year % 100, $mon, $mday);
    }

# 1 ALGORITHM if the file exists, make sure its not a symbolic link
# then get the inode and device info from the same stat structure
# that was used to find out if it was a link.

#    if(-l "$valid_dir/$basename$suffix") {
#        &abort("Cannot append to a symlink! Aborting.\n");
#    } else {
#        # if this file doesn't exist (e.g. a new archive file for the
#        # first of the month), then these values may
#        # be undef.
#        ($dev1,$inode1) = (lstat(_))[0..1];
#    }

# 2 ALGORITHM: open the file in append mode so we don't clobber the file we are
# opening.

    &lopen($FH, ">>", "$valid_dir/$basename$suffix") || 
	die("Can't append to $valid_dir/$basename$suffix: $!");

# 3 ALGORITHM: if the file didn't exist originally, it should now, so
# perform the same checks as was done if the file existed.

#    if ( !defined($dev1) && !defined($inode1) ) {
#       if(-l "$valid_dir/$basename$suffix") {
#          &abort("New file is symlink, Cannot append to a symlink!Abort.\n");
#        } else {
#          # this file now has to exist
#          ($dev1,$inode1) = (lstat(_))[0..1];
#        }
#    }

# 4 ALGORITHM: get the device and inode info from the open filehandle

#    local(*FH) = $FH;
#    ($dev2, $inode2) = (lstat(FH))[0..1];
    
# 5 ALGORITHM: compare the info.

#    if($inode1 != $inode2) {# Verify symlink was not slipped in
#        &abort("Filename does not match filehandle!
#                    Inode1=$inode1 Inode2=$inode2, Aborting.\n");
#    }

#    if($dev1 != $dev2) {
#        &abort("Filename does not match filehandle!
#                    Dev1=$dev1 Dev2=$dev2, Aborting.\n");
#    }

#6 ALGORITHM: succeed only if the file pointed to by the name and the file
#   opened are the same.

    $is_open = 1;

# analysis:
# If the link is put in before point 1, the -l test will cause exit.
# If the link is put in between 1 and 2, the correct file info will be in 
#    $dev1 and $inode1, so it will fail when comparing that info to the
#    filehandle info at step 5.
# If the file doesn't exist at step 1, step 3 will catch any attempt to
#    substitute a link between step 1 and step 2. Either it will see the link,
#    or it will get the device and inode numbers for the local file witch will
#    fail when we reach step 5.

}
