/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPResponseListener;
import netscape.ldap.client.JDAPMessage;

class LDAPSearchListener
extends LDAPResponseListener {
    private Vector searchResults = new Vector();
    private int lastRetrieved = -1;

    LDAPSearchListener(LDAPConnection lDAPConnection) {
        super(lDAPConnection);
    }

    synchronized void addSearchResult(JDAPMessage jDAPMessage) {
        this.searchResults.addElement(jDAPMessage);
        this.notifyAll();
    }

    Enumeration getSearchResults() {
        return this.searchResults.elements();
    }

    int getCount() {
        return this.searchResults.size();
    }

    void reset() {
        super.reset();
        if (this.searchResults != null) {
            this.searchResults.removeAllElements();
        }
    }

    synchronized JDAPMessage nextResult() {
        while (this.lastRetrieved >= this.searchResults.size() - 1) {
            if (this.isResponseReceived()) {
                this.searchResults.removeAllElements();
                return null;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ++this.lastRetrieved;
        JDAPMessage jDAPMessage = (JDAPMessage)this.searchResults.elementAt(this.lastRetrieved);
        this.searchResults.setElementAt(null, this.lastRetrieved);
        return jDAPMessage;
    }
}

