/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.ConnectLDAPThread;
import innoval.mailer.JstreetLdapSearch;
import innoval.mailer.JstreetLdapServer;
import innoval.mailer.MsgBox;
import innoval.mailer.Profile;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;

public class JstreetLdap
extends Dialog
implements ItemListener,
KeyListener,
ActionListener {
    static final int DEFAULT_PORT = 389;
    static final String SAVE_NAME = new String("JstreetLDAP");
    static final String SERVERS = new String("Servers");
    static final String SERVER = new String("ServerName");
    static final String PORT = new String("ServerPort");
    static final String USERID = new String("Userid");
    static final String PASSWORD = new String("Password");
    static final String FIRSTNAME = new String("FirstName");
    static final String LASTNAME = new String("LastName");
    static final String UNIT = new String("Unit");
    static final String ORG = new String("Organization");
    static final String COUNTRY = new String("Country");
    static final String MAXSEARCH = new String("MaxSearch");
    private Frame frame = null;
    private jstreet Jstreet = null;
    private TextField toField = null;
    private Profile profile = null;
    private Label text = null;
    private Checkbox checkPw = null;
    private Vector serverVector = null;
    private Choice serverchoice = null;
    public ConnectLDAPThread thread = null;
    private Button okButton;
    private Button cancelButton;
    private TextField server;
    private TextField port;
    private TextField userid;
    private TextField password;

    public JstreetLdap(Frame frame, TextField toField, Profile profile, jstreet Jstreet) {
        super(frame, "Connect to a Directory Server", true);
        this.frame = frame;
        this.toField = toField;
        this.profile = profile;
        this.Jstreet = Jstreet;
        this.serverVector = this.loadServers();
        this.initWindow();
        this.enableEvents(64L);
        this.show();
    }

    public void initWindow() {
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 1, 5, 20, 5, 20, 5, 20, 20, 5, 20, 20, 5};
        int[] columnWidths = new int[]{5, 60, 5, 60, 5, 50, 160, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        Label label = new Label("Server Name", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        con.gridwidth = 3;
        grid.setConstraints(label, con);
        label = new Label("Port Number", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 4;
        con.gridwidth = 3;
        grid.setConstraints(label, con);
        label = new Label("Userid (optional)", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 6;
        con.gridwidth = 3;
        grid.setConstraints(label, con);
        label = new Label("Password (optional)", 2);
        this.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 8;
        con.gridwidth = 3;
        grid.setConstraints(label, con);
        this.server = new TextField();
        this.server.addKeyListener(this);
        this.add(this.server);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 1;
        con.gridwidth = 2;
        grid.setConstraints(this.server, con);
        if (this.serverVector.size() > 1) {
            this.serverchoice = new Choice();
            this.serverchoice.addItemListener(this);
            for (int i = 0; i < this.serverVector.size(); ++i) {
                this.serverchoice.add(((JstreetLdapServer)this.serverVector.elementAt(i)).getServer());
            }
            this.add(this.serverchoice);
            jstreet.reset(con);
            con.gridx = 5;
            con.gridy = 2;
            con.gridwidth = 2;
            grid.setConstraints(this.serverchoice, con);
        }
        this.port = new TextField("389");
        this.port.addKeyListener(this);
        this.add(this.port);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 4;
        grid.setConstraints(this.port, con);
        this.userid = new TextField();
        this.userid.addKeyListener(this);
        this.add(this.userid);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 6;
        con.gridwidth = 2;
        grid.setConstraints(this.userid, con);
        this.password = new TextField();
        this.password.addKeyListener(this);
        this.add(this.password);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 8;
        con.gridwidth = 2;
        grid.setConstraints(this.password, con);
        this.checkPw = new Checkbox("Save Password", false);
        this.checkPw.addKeyListener(this);
        this.add(this.checkPw);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 9;
        con.gridwidth = 2;
        grid.setConstraints(this.checkPw, con);
        this.text = new Label("");
        this.add(this.text);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 11;
        con.gridwidth = 6;
        grid.setConstraints(this.text, con);
        this.okButton = new Button("OK");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        this.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 12;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        this.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 12;
        grid.setConstraints(this.cancelButton, con);
        this.loadDefaultValues();
        this.setLayout(grid);
        this.pack();
        this.setResizable(false);
        jstreet.centerDialog(this, null);
    }

    private void loadDefaultValues() {
        if (this.serverVector.size() > 0) {
            if (this.serverchoice != null) {
                this.selectChoice(0);
            } else {
                JstreetLdapServer serv = (JstreetLdapServer)this.serverVector.elementAt(0);
                ((TextComponent)this.server).setText(serv.getServer());
                ((TextComponent)this.port).setText(String.valueOf("").concat(String.valueOf(serv.getPort())));
                ((TextComponent)this.userid).setText(serv.getUserid());
                ((TextComponent)this.password).setText(serv.getPassword());
                this.checkPw.setState(serv.getSave());
            }
        }
    }

    private void selectChoice(int i) {
        if (i >= 0 && i < this.serverVector.size()) {
            JstreetLdapServer serv = (JstreetLdapServer)this.serverVector.elementAt(i);
            this.serverchoice.select(i);
            ((TextComponent)this.server).setText(serv.getServer());
            ((TextComponent)this.port).setText(String.valueOf("").concat(String.valueOf(serv.getPort())));
            ((TextComponent)this.userid).setText(serv.getUserid());
            ((TextComponent)this.password).setText(serv.getPassword());
            this.checkPw.setState(serv.getSave());
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.serverchoice) {
            int i = this.serverchoice.getSelectedIndex();
            this.selectChoice(i);
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            String serv = this.server.getText().trim();
            if (serv.length() == 0) {
                MsgBox msg = new MsgBox(this.frame, "Please enter a directory server name.");
                this.server.requestFocus();
            } else {
                this.enableDialog(this, false);
                this.text.setText("Connecting to server...");
                this.thread = new ConnectLDAPThread(this);
                this.thread.start();
            }
        } else if (e.getSource() == this.cancelButton) {
            this.closeWindow();
        }
    }

    public void enableDialog(Container cont, boolean val) {
        Component ccomp = null;
        for (int i = 0; i < cont.getComponentCount(); ++i) {
            ccomp = cont.getComponent(i);
            if (ccomp instanceof Container) {
                this.enableDialog((Container)ccomp, val);
            }
            if (ccomp == this.cancelButton || ccomp == this.text) continue;
            ccomp.setEnabled(val);
        }
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.closeWindow();
        } else {
            super.processWindowEvent(evt);
        }
    }

    public void closeWindow() {
        try {
            if (this.thread != null) {
                this.thread.stop();
            }
            this.dispose();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private Vector loadServers() {
        Vector<JstreetLdapServer> vector = new Vector<JstreetLdapServer>();
        String text = this.profile.ReadString(SAVE_NAME, SERVERS, "").trim();
        String therest = "";
        String server = "";
        while (text.length() > 0) {
            int spot = text.indexOf(59);
            if (spot > 0) {
                server = new String(text.substring(0, spot).trim());
                text = new String(text.substring(spot + 1).trim());
            } else {
                server = new String(text);
                text = new String("");
            }
            if ((therest = this.profile.ReadString(SAVE_NAME, server, "", 1).trim()).length() <= 0) continue;
            vector.addElement(new JstreetLdapServer(server, therest));
        }
        return vector;
    }

    private void readServer() {
        String server = this.server.getText().trim();
        String userid = this.userid.getText().trim();
        String password = this.password.getText().trim();
        int port = 389;
        try {
            port = Integer.valueOf(this.port.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.addServer(server, userid, password, port, this.checkPw.getState());
    }

    private void addServer(String server, String userid, String password, int port, boolean save) {
        boolean found = false;
        JstreetLdapServer serv = null;
        for (int i = 0; i < this.serverVector.size(); ++i) {
            serv = (JstreetLdapServer)this.serverVector.elementAt(i);
            if (!serv.equals(server)) continue;
            found = true;
            serv.setUserid(userid);
            serv.setPassword(password);
            serv.setPort(port);
            serv.setSave(save);
            if (i == 0) break;
            this.serverVector.removeElementAt(i);
            this.serverVector.insertElementAt(serv, 0);
            break;
        }
        if (!found) {
            this.serverVector.insertElementAt(new JstreetLdapServer(server, userid, password, port, this.checkPw.getState()), 0);
        }
    }

    private void saveServers() {
        StringBuffer sb = new StringBuffer(1024);
        JstreetLdapServer serv = null;
        String text = "";
        int max = this.serverVector.size();
        if (max > 15) {
            max = 15;
        }
        for (int i = 0; i < max; ++i) {
            serv = (JstreetLdapServer)this.serverVector.elementAt(i);
            if (i == 0) {
                sb.append(serv.getServer());
            } else {
                sb.append(String.valueOf(";").concat(String.valueOf(serv.getServer())));
            }
            this.profile.WriteString(SAVE_NAME, serv.getServer(), serv.toString(), 2);
        }
        this.profile.WriteString(SAVE_NAME, SERVERS, sb.toString(), true);
    }

    public void connect() {
        String serv = this.server.getText().trim();
        String pport = this.port.getText().trim();
        int tport = 0;
        if (pport.length() == 0) {
            pport = new String("389");
        }
        try {
            tport = Integer.valueOf(pport);
        }
        catch (NumberFormatException ex) {
            tport = 389;
        }
        try {
            LDAPConnection ld = new LDAPConnection();
            ld.connect(serv, tport);
            this.text.setText("Authenticating...");
            ld.authenticate(this.userid.getText().trim(), this.password.getText().trim());
            this.readServer();
            this.saveServers();
            JstreetLdapSearch search = new JstreetLdapSearch(this.frame, this.Jstreet, this.toField, ld, this.profile, serv, String.valueOf(String.valueOf("Search Directory [").concat(String.valueOf(serv))).concat(String.valueOf("]")));
            ld.disconnect();
            this.dispose();
        }
        catch (LDAPException ex) {
            MsgBox msg = null;
            switch (ex.getLDAPResultCode()) {
                case 32: {
                    msg = new MsgBox(this.frame, "The specified user does not exist.");
                    this.userid.requestFocus();
                    break;
                }
                case 49: {
                    msg = new MsgBox(this.frame, "Invalid password.");
                    this.password.requestFocus();
                    break;
                }
                default: {
                    msg = new MsgBox(this.frame, ex.toString());
                }
            }
            this.text.setText("Connection failed.");
            this.enableDialog(this, true);
        }
    }
}

