/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.AddrBook;
import innoval.mailer.Address;
import innoval.mailer.GetNickname;
import innoval.mailer.ImportColumn;
import innoval.mailer.Last15;
import innoval.mailer.LoadAllThread;
import innoval.mailer.LoadOneThread;
import innoval.mailer.MsgBox;
import innoval.mailer.PopFileReader;
import innoval.mailer.jstreet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;

public class ImportAddressBook
extends Dialog
implements ActionListener,
KeyListener {
    static final int CHECK_GEN = 0;
    static final int CHECK_SOME = 1;
    static final int CHECK_ALL = 2;
    private int columns = 0;
    private int totalRecords = 0;
    private int currentRecord = 0;
    private Checkbox checkGen = null;
    private Checkbox checkSome = null;
    private Checkbox checkPrompt = null;
    public LoadOneThread oneThread = null;
    public LoadAllThread allThread = null;
    public Frame frame = null;
    public AddrBook addrbook = null;
    private File file = null;
    private Vector importVector = null;
    private Label textLabel = null;
    private PopFileReader fin = null;
    private Button okButton = null;
    private Button cancelButton = null;
    private Button skipButton = null;
    private Button oneButton = null;

    ImportAddressBook(Frame frame, AddrBook addrbook) {
        super(frame, "Import a Delimited File", true);
        this.frame = frame;
        this.addrbook = addrbook;
        this.file = this.getFile(frame);
        if (this.file != null && !this.file.exists()) {
            this.file = null;
            MsgBox msgBox = new MsgBox(frame, "The specified file was not found.");
        }
        if (this.file != null) {
            this.setTitle(String.valueOf(String.valueOf(String.valueOf(this.getTitle()).concat(String.valueOf(" ["))).concat(String.valueOf(this.file.getAbsolutePath()))).concat(String.valueOf("]")));
            if (this.initDialog()) {
                this.show();
            } else {
                this.dispose();
            }
        } else {
            this.dispose();
        }
    }

    private File getFile(Frame frame) {
        File file = null;
        FileDialog filedialog = new FileDialog(frame, "Load a Delimited File", 0);
        filedialog.show();
        if (filedialog.getFile() != null) {
            file = new File(filedialog.getDirectory(), filedialog.getFile());
        }
        return file;
    }

    private boolean initDialog() {
        boolean ret_code = true;
        this.setLayout(new BorderLayout(0, 0));
        Panel panel = new Panel();
        panel.setLayout(null);
        this.textLabel = new Label("");
        ret_code = this.setupScrollPanel(panel);
        ScrollPane pane = new ScrollPane();
        pane.add(panel);
        this.add("Center", pane);
        panel = new Panel();
        this.add("South", panel);
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 20, 20, 5, 20, 5};
        int[] columnWidths = new int[]{5, 80, 5, 80, 5, 120, 5, 120, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        panel.add(this.textLabel);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        con.gridwidth = 3;
        grid.setConstraints(this.textLabel, con);
        CheckboxGroup group = new CheckboxGroup();
        this.checkGen = new Checkbox("Automatically assign nicknames", false, group);
        panel.add(this.checkGen);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 1;
        con.gridwidth = 4;
        grid.setConstraints(this.checkGen, con);
        this.checkSome = new Checkbox("Prompt when nickname does not exist or is not unique", true, group);
        panel.add(this.checkSome);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 2;
        con.gridwidth = 4;
        grid.setConstraints(this.checkSome, con);
        this.checkPrompt = new Checkbox("Prompt for all nicknames", false, group);
        panel.add(this.checkPrompt);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 3;
        con.gridwidth = 4;
        grid.setConstraints(this.checkPrompt, con);
        this.okButton = new Button("Import All");
        this.okButton.addActionListener(this);
        this.okButton.addKeyListener(this);
        panel.add(this.okButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 5;
        grid.setConstraints(this.okButton, con);
        this.cancelButton = new Button("Close");
        this.cancelButton.addActionListener(this);
        this.cancelButton.addKeyListener(this);
        panel.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 5;
        grid.setConstraints(this.cancelButton, con);
        this.oneButton = new Button("Import This Record");
        this.oneButton.addActionListener(this);
        this.oneButton.addKeyListener(this);
        panel.add(this.oneButton);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 5;
        grid.setConstraints(this.oneButton, con);
        this.skipButton = new Button("Skip This Record");
        this.skipButton.addActionListener(this);
        this.skipButton.addKeyListener(this);
        panel.add(this.skipButton);
        jstreet.reset(con);
        con.gridx = 7;
        con.gridy = 5;
        grid.setConstraints(this.skipButton, con);
        panel.setLayout(grid);
        this.pack();
        ((Component)this).setSize(this.getSize().width, 450);
        this.setResizable(false);
        jstreet.centerDialog(this, this.frame);
        this.enableEvents(64L);
        return ret_code;
    }

    public boolean setupScrollPanel(Panel panel) {
        boolean ret_code = false;
        PopFileReader in = new PopFileReader();
        int cnt = 0;
        String text = "";
        if (in.open(this.file)) {
            do {
                if ((text = in.lineIn()) == null || text.trim().length() <= 0) continue;
                if (cnt == 0) {
                    this.importVector = new Vector();
                    Vector vector = this.parseRecord(text);
                    for (int i = 0; i < vector.size(); ++i) {
                        ++this.columns;
                        ImportColumn col = new ImportColumn(this.columns, (String)vector.elementAt(i));
                        col.addTo(panel);
                        this.importVector.addElement(col);
                    }
                }
                ++cnt;
            } while (text != null);
            in.close();
            this.totalRecords = cnt;
            if (cnt == 0) {
                MsgBox msgBox = new MsgBox(this.addrbook, "The specified delimited file contained no usable records.");
            } else {
                this.currentRecord = 1;
                this.textLabel.setText(String.valueOf(String.valueOf("Record [1] of [").concat(String.valueOf(this.totalRecords))).concat(String.valueOf("]")));
                ret_code = true;
            }
        } else {
            MsgBox msgBox = new MsgBox(this.addrbook, "The specified delimited file could not be opened.");
        }
        return ret_code;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            Button evt = this.okButton;
            if (e.getSource() == this.cancelButton) {
                evt = this.cancelButton;
            }
            ActionEvent ae = new ActionEvent(evt, 1001, "");
            this.actionPerformed(ae);
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.allThread = new LoadAllThread(this);
            this.allThread.start();
        } else if (e.getSource() == this.oneButton) {
            this.oneThread = new LoadOneThread(this);
            this.oneThread.start();
        } else if (e.getSource() == this.skipButton) {
            this.jumpOneRecord(true);
        } else if (e.getSource() == this.cancelButton) {
            this.close();
        }
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.close();
        } else {
            super.processWindowEvent(evt);
        }
    }

    public void setEnabled(boolean val) {
        for (int i = 0; i < this.importVector.size(); ++i) {
            ((ImportColumn)this.importVector.elementAt(i)).setEnabled(val);
        }
        this.okButton.setEnabled(val);
        this.oneButton.setEnabled(val);
        this.skipButton.setEnabled(val);
    }

    public void close() {
        boolean go = true;
        if (this.oneThread != null || this.allThread != null) {
            MsgBox msg = new MsgBox((Container)this.addrbook, "Stop importing addresses?", 3);
            if (msg.ret_code != 0) {
                go = false;
            }
        }
        if (go) {
            if (this.oneThread != null) {
                this.oneThread.setStop(true);
            }
            if (this.allThread != null) {
                this.allThread.setStop(true);
            }
            if (this.fin != null) {
                this.fin.close();
                this.fin = null;
            }
            ((Component)this).setVisible(false);
            this.addrbook.toFront();
            this.addrbook.requestFocus();
            try {
                this.dispose();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    private boolean openImportFile() {
        boolean ret_code = false;
        if (this.fin == null) {
            if (this.file.exists()) {
                this.fin = new PopFileReader();
                if (!this.fin.open(this.file)) {
                    MsgBox msg = new MsgBox(this.addrbook, "Error opening the specified delimited file.");
                    this.fin = null;
                } else {
                    String rec1 = "";
                    while (rec1 != null && rec1.trim().length() == 0) {
                        rec1 = this.fin.lineIn();
                    }
                    if (rec1 == null) {
                        this.fin.close();
                        this.fin = null;
                        MsgBox msgBox = new MsgBox(this.addrbook, "No none blank records were found in the specified delimited file.");
                    }
                }
            } else {
                MsgBox msgBox = new MsgBox(this.addrbook, "The specified delimited file was not found.");
            }
        }
        if (this.fin != null) {
            ret_code = true;
        }
        return ret_code;
    }

    public boolean jumpOneRecord(boolean prompt) {
        boolean ret_code = false;
        String text = "";
        if (this.openImportFile()) {
            while (!ret_code && text != null) {
                text = this.fin.lineIn();
                if (text != null) {
                    if (text.trim().length() <= 0) continue;
                    ++this.currentRecord;
                    this.loadNewRecord(text);
                    ret_code = true;
                    continue;
                }
                if (!prompt) continue;
                MsgBox msgBox = new MsgBox(this.addrbook, "End of file reached.");
            }
        }
        return ret_code;
    }

    private void loadNewRecord(String rec) {
        Vector vector = this.parseRecord(rec);
        String text = "";
        ImportColumn col = null;
        for (int i = 0; i < this.importVector.size(); ++i) {
            text = i < vector.size() ? (String)vector.elementAt(i) : new String("");
            col = (ImportColumn)this.importVector.elementAt(i);
            col.setText(text);
        }
        this.textLabel.setText(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Record [").concat(String.valueOf(this.currentRecord))).concat(String.valueOf("] of ["))).concat(String.valueOf(this.totalRecords))).concat(String.valueOf("]")));
    }

    public boolean loadOneRecord(LoadOneThread thread) {
        boolean ret_code = true;
        if (!thread.getStop()) {
            Address addr = new Address();
            ImportColumn col = null;
            boolean go = false;
            for (int i = 0; i < this.importVector.size(); ++i) {
                col = (ImportColumn)this.importVector.elementAt(i);
                if (col.getType() != 2) continue;
                addr.fullname = addr.fullname.length() > 0 ? new String(String.valueOf(String.valueOf(addr.fullname).concat(String.valueOf(" "))).concat(String.valueOf(col.getText()))) : new String(String.valueOf(addr.fullname).concat(String.valueOf(col.getText())));
            }
            for (int i = 0; i < this.importVector.size(); ++i) {
                col = (ImportColumn)this.importVector.elementAt(i);
                if (col.getType() != 3) continue;
                addr.fullname = addr.fullname.length() > 0 ? new String(String.valueOf(String.valueOf(addr.fullname).concat(String.valueOf(" "))).concat(String.valueOf(col.getText()))) : new String(String.valueOf(addr.fullname).concat(String.valueOf(col.getText())));
            }
            block13: for (int i = 0; i < this.importVector.size(); ++i) {
                col = (ImportColumn)this.importVector.elementAt(i);
                if (col.getType() != 0) {
                    go = true;
                }
                switch (col.getType()) {
                    case 1: {
                        if (addr.nickname.length() > 0) {
                            addr.nickname = new String(String.valueOf(String.valueOf(addr.nickname).concat(String.valueOf(" "))).concat(String.valueOf(col.getText())));
                            continue block13;
                        }
                        addr.nickname = new String(String.valueOf(addr.nickname).concat(String.valueOf(col.getText())));
                        continue block13;
                    }
                    case 4: {
                        if (addr.fullname.length() > 0) {
                            addr.fullname = new String(String.valueOf(String.valueOf(addr.fullname).concat(String.valueOf(" "))).concat(String.valueOf(col.getText())));
                            continue block13;
                        }
                        addr.fullname = new String(String.valueOf(addr.fullname).concat(String.valueOf(col.getText())));
                        continue block13;
                    }
                    case 5: {
                        if (addr.email.length() > 0) {
                            addr.email = new String(String.valueOf(String.valueOf(addr.email).concat(String.valueOf(" "))).concat(String.valueOf(col.getText())));
                            continue block13;
                        }
                        addr.email = new String(String.valueOf(addr.email).concat(String.valueOf(col.getText())));
                        continue block13;
                    }
                    case 6: {
                        if (addr.phone.length() > 0) {
                            addr.phone = new String(String.valueOf(String.valueOf(addr.phone).concat(String.valueOf(" "))).concat(String.valueOf(col.getText())));
                            continue block13;
                        }
                        addr.phone = new String(String.valueOf(addr.phone).concat(String.valueOf(col.getText())));
                        continue block13;
                    }
                    case 7: {
                        if (addr.fax.length() > 0) {
                            addr.fax = new String(String.valueOf(String.valueOf(addr.fax).concat(String.valueOf(" "))).concat(String.valueOf(col.getText())));
                            continue block13;
                        }
                        addr.fax = new String(String.valueOf(addr.fax).concat(String.valueOf(col.getText())));
                        continue block13;
                    }
                    case 8: {
                        if (addr.org.length() > 0) {
                            addr.org = new String(String.valueOf(String.valueOf(addr.org).concat(String.valueOf(" "))).concat(String.valueOf(col.getText())));
                            continue block13;
                        }
                        addr.org = new String(String.valueOf(addr.org).concat(String.valueOf(col.getText())));
                        continue block13;
                    }
                    case 9: {
                        if (addr.title.length() > 0) {
                            addr.title = new String(String.valueOf(String.valueOf(addr.title).concat(String.valueOf(" "))).concat(String.valueOf(col.getText())));
                            continue block13;
                        }
                        addr.title = new String(String.valueOf(addr.title).concat(String.valueOf(col.getText())));
                        continue block13;
                    }
                    case 10: {
                        if (addr.postal.length() > 0) {
                            addr.postal = new String(String.valueOf(String.valueOf(addr.postal).concat(String.valueOf(" "))).concat(String.valueOf(col.getText())));
                            continue block13;
                        }
                        addr.postal = new String(String.valueOf(addr.postal).concat(String.valueOf(col.getText())));
                        continue block13;
                    }
                    case 11: {
                        addr.notes = addr.notes.length() > 0 ? new String(String.valueOf(String.valueOf(addr.notes).concat(String.valueOf(" "))).concat(String.valueOf(col.getText()))) : new String(String.valueOf(addr.notes).concat(String.valueOf(col.getText())));
                    }
                }
            }
            if (go && !thread.getStop()) {
                if (this.getNickname(addr) && !thread.getStop()) {
                    this.addrbook.addAddress(addr);
                } else {
                    ret_code = false;
                }
            }
        }
        return ret_code;
    }

    private boolean getNickname(Address addr) {
        boolean ret_code = true;
        int check = 0;
        addr.nickname = ImportAddressBook.removeSpaces(addr.nickname);
        if (this.checkGen.getState()) {
            if (addr.nickname.length() == 0 && addr.fullname.length() > 0) {
                StringTokenizer st = new StringTokenizer(addr.fullname);
                addr.nickname = new String(st.nextToken());
                if (st.hasMoreTokens()) {
                    addr.nickname = new String(addr.nickname.concat(st.nextToken().substring(0, 1)));
                }
            }
            addr.nickname = ImportAddressBook.removeSpaces(addr.nickname);
            check = 0;
        } else {
            check = this.checkSome.getState() ? 1 : 2;
        }
        switch (check) {
            case 0: {
                int cnt = 0;
                boolean quit = false;
                if (addr.nickname.length() == 0) {
                    addr.nickname = new String("person");
                }
                String nick = new String(addr.nickname);
                while (!quit) {
                    if (!this.addrbook.getAddressBook().checkNickname(addr.nickname)) {
                        quit = true;
                        continue;
                    }
                    addr.nickname = new String(String.valueOf(String.valueOf(String.valueOf(nick).concat(String.valueOf("("))).concat(String.valueOf(++cnt))).concat(String.valueOf(")")));
                }
                break;
            }
            case 1: {
                if (addr.nickname.length() != 0 && !this.addrbook.getAddressBook().checkNickname(addr.nickname)) break;
                GetNickname getnick = new GetNickname(this.frame, this.addrbook, addr);
                if (getnick.getReturn()) {
                    addr.nickname = new String(getnick.getText());
                    break;
                }
                ret_code = false;
                break;
            }
            case 2: {
                GetNickname getnick = new GetNickname(this.frame, this.addrbook, addr);
                if (getnick.getReturn()) {
                    addr.nickname = new String(getnick.getText());
                    break;
                }
                ret_code = false;
                break;
            }
        }
        return ret_code;
    }

    public static String removeSpaces(String text) {
        char[] tchar = text.toCharArray();
        char[] pchar = text.toCharArray();
        int len = 0;
        for (int i = 0; i < tchar.length; ++i) {
            if (tchar[i] == ' ') continue;
            pchar[len++] = tchar[i];
        }
        return new String(pchar, 0, len);
    }

    public Vector parseRecord(String text) {
        Vector<String> vector = null;
        if (text.indexOf(9) >= 0) {
            vector = new Vector<String>();
            int spot = -1;
            int spot1 = 0;
            do {
                if ((spot = spot < 0 ? text.indexOf(9) : text.indexOf(9, spot1)) >= 0) {
                    vector.addElement(text.substring(spot1, spot).trim());
                } else {
                    vector.addElement(text.substring(spot1).trim());
                }
                spot1 = spot + 1;
            } while (spot >= 0);
        } else {
            vector = Last15.parseAddresses(text);
        }
        return vector;
    }
}

