/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.FolderItem;
import innoval.mailer.JstreetAudioClip;
import innoval.mailer.PictureWindow;
import innoval.mailer.jstreet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;

public class HandleAttachFile
extends Dialog
implements ActionListener {
    static final String IMAGE_FILES = new String("gif jpg jpeg");
    private Frame frame = null;
    private jstreet parent = null;
    private File file = null;
    private Label fileLabel = null;
    private Label sizeLabel = null;
    private Button storeButton = null;
    private Button viewButton = null;
    private Button playButton = null;
    private Button printButton = null;
    private Button cancelButton = null;
    private PictureWindow pwin = null;

    HandleAttachFile(Frame frame, jstreet parent, File dir, String fn) {
        super(frame, "Attachment Processor", true);
        this.frame = frame;
        this.parent = parent;
        if (fn.startsWith("Attachment: ")) {
            fn = new String(fn.substring(12));
        }
        this.file = new File(dir, fn);
        this.initWindow();
        this.show();
    }

    private void initWindow() {
        Panel panel = new Panel();
        this.setTitle(String.valueOf(String.valueOf("Attachment Processor [").concat(String.valueOf(this.file.getName()))).concat(String.valueOf("]")));
        this.enableEvents(64L);
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 20, 10, 20, 5};
        int[] columnWidths = new int[]{5, 60, 5, 60, 5, 60, 5, 60, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        Label label = new Label("Attached file:", 2);
        label.setForeground(Color.blue);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        con.gridwidth = 3;
        grid.setConstraints(label, con);
        label = new Label("File Size:", 2);
        label.setForeground(Color.blue);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 2;
        con.gridwidth = 3;
        grid.setConstraints(label, con);
        this.fileLabel = new Label(this.file.getName());
        this.fileLabel.setForeground(Color.black);
        panel.add(this.fileLabel);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 1;
        con.gridwidth = 3;
        grid.setConstraints(this.fileLabel, con);
        this.sizeLabel = new Label(String.valueOf(String.valueOf("").concat(String.valueOf(this.file.length()))).concat(String.valueOf(" bytes")));
        this.sizeLabel.setForeground(Color.black);
        panel.add(this.sizeLabel);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 2;
        con.gridwidth = 3;
        grid.setConstraints(this.sizeLabel, con);
        this.storeButton = new Button("Store");
        this.storeButton.addActionListener(this);
        panel.add(this.storeButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 4;
        grid.setConstraints(this.storeButton, con);
        if (this.isPlayableFile(this.file.getName().toLowerCase())) {
            this.playButton = new Button("Play");
            this.playButton.addActionListener(this);
            panel.add(this.playButton);
            jstreet.reset(con);
            con.gridx = 3;
            con.gridy = 4;
            grid.setConstraints(this.playButton, con);
        } else {
            this.viewButton = new Button("View");
            this.viewButton.addActionListener(this);
            this.viewButton.setEnabled(this.isViewableFile(this.file.getName().toLowerCase()));
            panel.add(this.viewButton);
            jstreet.reset(con);
            con.gridx = 3;
            con.gridy = 4;
            grid.setConstraints(this.viewButton, con);
        }
        this.printButton = new Button("Print");
        this.printButton.addActionListener(this);
        this.printButton.setEnabled(false);
        panel.add(this.printButton);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 4;
        grid.setConstraints(this.printButton, con);
        this.cancelButton = new Button("Cancel");
        this.cancelButton.addActionListener(this);
        panel.add(this.cancelButton);
        jstreet.reset(con);
        con.gridx = 7;
        con.gridy = 4;
        grid.setConstraints(this.cancelButton, con);
        panel.setLayout(grid);
        this.setLayout(new BorderLayout());
        this.add("North", panel);
        if (this.viewButton != null && this.viewButton.isEnabled()) {
            this.pwin = new PictureWindow(null);
            this.pwin.setPreferredSize(200, 200);
            this.add("Center", this.pwin);
            this.setResizable(true);
        }
        this.pack();
        if (this.viewButton != null && !this.viewButton.isEnabled()) {
            this.setResizable(false);
        }
        jstreet.centerDialog(this, this.frame);
    }

    public boolean isViewableFile(String fn) {
        String ext;
        boolean ret_code = false;
        int spot = fn.lastIndexOf(46);
        if (spot >= 0 && IMAGE_FILES.indexOf(ext = fn.substring(spot + 1).trim()) >= 0) {
            ret_code = true;
        }
        return ret_code;
    }

    public boolean isPlayableFile(String fn) {
        String ext;
        boolean ret_code = false;
        int spot = fn.lastIndexOf(46);
        if (spot >= 0 && (ext = fn.substring(spot + 1).trim()).equals("au")) {
            ret_code = true;
        }
        return ret_code;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.storeButton) {
            FileDialog filedialog = new FileDialog(this.frame, "Store an Attachment", 1);
            filedialog.setFile(this.file.getName());
            filedialog.show();
            String tfile = filedialog.getFile();
            if (tfile != null) {
                tfile = new String(this.setFileExtension(tfile, this.file.getName()));
                File outfile = new File(filedialog.getDirectory(), tfile);
                FolderItem.CopyFile(this.frame, this.file, outfile);
            }
        } else if (e.getSource() == this.viewButton) {
            this.pwin.loadFile(this.file);
            this.printButton.setEnabled(true);
        } else if (e.getSource() == this.playButton) {
            try {
                JstreetAudioClip clip = new JstreetAudioClip(this.file.getAbsolutePath());
                clip.play();
            }
            catch (IOException er) {
                System.out.println(String.valueOf("Error: ").concat(String.valueOf(er)));
            }
        } else if (e.getSource() == this.printButton) {
            if (!this.pwin.isLoaded()) {
                this.pwin.loadFile(this.file);
                this.pwin.print();
            }
        } else if (e.getSource() == this.cancelButton) {
            this.dispose();
        }
    }

    public String setFileExtension(String nfile, String ofile) {
        String ext = null;
        int spot = nfile.lastIndexOf(nfile);
        if (ofile.lastIndexOf(46) > 0) {
            if (spot >= 0) {
                ext = new String(nfile.substring(spot + 1).trim());
            }
            if (ext == null || ext.length() == 0) {
                ext = new String(ofile.substring(ofile.lastIndexOf(46) + 1));
                if (!nfile.endsWith(".")) {
                    nfile = new String(String.valueOf(nfile).concat(String.valueOf(".")));
                }
                nfile = new String(String.valueOf(nfile).concat(String.valueOf(ext)));
            }
        }
        return nfile;
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.closeWindow();
        } else {
            super.processWindowEvent(evt);
        }
    }

    public void closeWindow() {
        ((Component)this).setVisible(false);
        this.dispose();
        this.frame.toFront();
    }
}

