/*
 * Decompiled with CFR 0.152.
 */
package innoval.mailer;

import innoval.mailer.BrowserSpyThread;
import innoval.mailer.jstreet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.beans.Beans;
import java.util.Hashtable;
import java.util.Properties;
import sunw.hotjava.bean.BrowserHistoryEvent;
import sunw.hotjava.bean.BrowserHistoryListener;
import sunw.hotjava.bean.HotJavaBrowserBean;
import sunw.hotjava.bean.HotJavaDocumentStack;

public class BrowserHotFrame
extends Frame
implements KeyListener,
ActionListener,
BrowserHistoryListener {
    private int WINCX = 600;
    private int WINCY = 400;
    private MenuBar menu;
    private Menu menuFile;
    public HotJavaBrowserBean browser = null;
    private HotJavaDocumentStack stack = null;
    private MenuItem IDM_FILE_PRINT;
    private TextField urlField;
    private BrowserSpyThread thread;
    private Button nextButton;
    private Button backButton;
    private Button reloadButton;
    private Button stopButton;

    public BrowserHotFrame() {
        this.initWindow();
        this.thread = new BrowserSpyThread(this);
        this.thread.start();
        this.setWindowTitle("");
        this.enableEvents(64L);
    }

    public void setUrl(String url) {
        this.browser.setDocumentString(url);
        ((TextComponent)this.urlField).setText(url);
        this.setWindowTitle(url);
    }

    public void setUrlText(String url) {
        ((TextComponent)this.urlField).setText(url);
        this.setWindowTitle(url);
    }

    public void setWindowTitle(String url) {
        if (this.browser.getDocumentTitle() == null) {
            this.setTitle(String.valueOf(String.valueOf("Hot Java [").concat(String.valueOf(url))).concat(String.valueOf("]")));
        } else {
            this.setTitle(String.valueOf(String.valueOf("Hot Java [").concat(String.valueOf(this.browser.getDocumentTitle()))).concat(String.valueOf("]")));
        }
    }

    private void initWindow() {
        this.setupMenu();
        Dimension dim = this.getToolkit().getScreenSize();
        this.WINCX = dim.width * 3 / 4;
        this.WINCY = dim.height * 3 / 4;
        ((Component)this).setSize(this.getInsets().left + this.getInsets().right + this.WINCX, this.getInsets().top + this.getInsets().bottom + this.WINCY);
        ((Component)this).setLocation((dim.width - this.getSize().width) / 2, (dim.height - this.getSize().height) / 2);
        Properties props = System.getProperties();
        ((Hashtable)props).put("hotjava.docstack.contents.depth", "10");
        ((Hashtable)props).put("hotjava.docstack.logical.depth", "10");
        ((Hashtable)props).put("hotjava.hide.security.warning", "true");
        System.setProperties(props);
        Panel panel = this.setupTopPanel();
        this.add("North", panel);
        try {
            this.browser = (HotJavaBrowserBean)Beans.instantiate(null, "sunw.hotjava.bean.HotJavaBrowserBean");
            this.add("Center", (Component)this.browser);
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        try {
            this.stack = (HotJavaDocumentStack)Beans.instantiate(null, "sunw.hotjava.bean.HotJavaDocumentStack");
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        if (this.browser != null && this.stack != null) {
            this.browser.addBrowserHistoryListener((BrowserHistoryListener)this);
            this.stack.addBrowserHistoryListener((BrowserHistoryListener)this);
        }
    }

    Panel setupTopPanel() {
        Panel panel = new Panel();
        Label label = null;
        panel.setBackground(Color.lightGray);
        GridBagLayout grid = new GridBagLayout();
        int[] rowHeights = new int[]{5, 20, 5, 20, 5};
        int[] columnWidths = new int[]{5, 60, 5, 60, 5, 60, 5, 60, 60, 5};
        double[] rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        double[] columnWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 10.0, 0.0};
        grid.rowHeights = rowHeights;
        grid.columnWidths = columnWidths;
        grid.rowWeights = rowWeights;
        grid.columnWeights = columnWeights;
        GridBagConstraints con = new GridBagConstraints();
        this.backButton = new Button("Previous");
        this.backButton.addActionListener(this);
        panel.add(this.backButton);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 1;
        grid.setConstraints(this.backButton, con);
        this.nextButton = new Button("Next");
        this.nextButton.addActionListener(this);
        panel.add(this.nextButton);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 1;
        grid.setConstraints(this.nextButton, con);
        this.reloadButton = new Button("Reload");
        this.reloadButton.addActionListener(this);
        panel.add(this.reloadButton);
        jstreet.reset(con);
        con.gridx = 5;
        con.gridy = 1;
        grid.setConstraints(this.reloadButton, con);
        this.stopButton = new Button("Stop");
        this.stopButton.addActionListener(this);
        panel.add(this.stopButton);
        jstreet.reset(con);
        con.gridx = 7;
        con.gridy = 1;
        grid.setConstraints(this.stopButton, con);
        label = new Label("Url:", 2);
        panel.add(label);
        jstreet.reset(con);
        con.gridx = 1;
        con.gridy = 3;
        grid.setConstraints(label, con);
        this.urlField = new TextField();
        this.urlField.addKeyListener(this);
        panel.add(this.urlField);
        jstreet.reset(con);
        con.gridx = 3;
        con.gridy = 3;
        con.gridwidth = 6;
        grid.setConstraints(this.urlField, con);
        panel.setLayout(grid);
        return panel;
    }

    private void setupMenu() {
        this.menu = new MenuBar();
        this.menuFile = new Menu("File");
        this.IDM_FILE_PRINT = new MenuItem("Print");
        this.IDM_FILE_PRINT.addActionListener(this);
        this.menuFile.add(this.IDM_FILE_PRINT);
        this.menu.add(this.menuFile);
        this.setMenuBar(this.menu);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.IDM_FILE_PRINT) {
            this.browser.print();
        } else if (e.getSource() == this.stopButton) {
            this.browser.stop();
        } else if (e.getSource() == this.reloadButton) {
            this.browser.reload();
        } else if (e.getSource() == this.backButton) {
            if (this.stack.isPreviousAvailable()) {
                this.stack.previousDocument();
            }
        } else if (e.getSource() == this.nextButton && this.stack.isNextAvailable()) {
            this.stack.nextDocument();
        }
    }

    public void processWindowEvent(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.Close();
        } else {
            super.processWindowEvent(evt);
        }
    }

    public void Close() {
        if (this.thread != null) {
            this.thread.setStop(true);
        }
        try {
            this.dispose();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void executeHistoryCommand(BrowserHistoryEvent e) {
        if (e.getSource() == this.browser) {
            this.stack.executeHistoryCommand(e);
        } else if (e.getSource() == this.stack) {
            this.browser.executeHistoryCommand(e);
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (e.getSource() == this.urlField && e.getKeyCode() == 10) {
            this.setUrl(this.urlField.getText().trim());
        }
    }

    public void keyTyped(KeyEvent e) {
    }
}

