/*
 * Decompiled with CFR 0.152.
 */
package innoval.mail;

import innoval.mail.Imap4Cmd;
import innoval.mail.Imap4Connect;
import innoval.mail.Imap4Exception;
import innoval.mail.Imap4FileWriter;
import innoval.mail.Imap4Folder;
import innoval.mail.Imap4Logon;
import innoval.mail.Imap4ResponseThread;
import java.awt.Label;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.Vector;

public class Imap4 {
    static final int IMAP4_PORT = 143;
    static final int CONNECT_TIME = 120;
    static final int IDLE_TIME = 60;
    static int connectTime = 120;
    static int idleTime = 60;
    protected Vector openCmds = new Vector();
    protected Vector hostCmds = new Vector();
    private Imap4ResponseThread respThread = null;
    private boolean debug = false;
    private boolean noop = true;
    private File debugFile = null;
    private Label label = null;
    private Socket socket = null;
    private String separator = null;
    private String server;
    private String userid;
    private String password;
    private int port = 143;
    private int cmdIndex = 0;

    public void setServer(String server) {
        this.server = new String(server);
    }

    public void setUserid(String userid) {
        this.userid = new String(userid);
    }

    public void setPassword(String password) {
        this.password = new String(password);
    }

    public void setPort(String port) {
        try {
            this.port = Integer.valueOf(port);
        }
        catch (NumberFormatException e) {
            this.port = 143;
        }
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setConnectTime(int connectTime) {
        Imap4.connectTime = connectTime;
    }

    public void setIdleTime(int idleTime) {
        Imap4.idleTime = idleTime;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setNoop(boolean noop) {
        this.noop = noop;
    }

    public void setDebugFile(File debugFile) {
        this.debugFile = debugFile;
        this.debug = true;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    protected void setSocket(Socket socket) {
        this.socket = socket;
    }

    protected Socket getSocket() {
        return this.socket;
    }

    public String getServer() {
        return this.server;
    }

    public String getUserid() {
        return this.userid;
    }

    public String getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    public static int getConnectTime() {
        return connectTime;
    }

    public static int getIdleTime() {
        return idleTime;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public boolean getNoop() {
        return this.noop;
    }

    public Label getLabel() {
        return this.label;
    }

    protected void setText(String text) {
        if (this.label != null) {
            this.label.setText(text);
        }
    }

    protected String getText() {
        String text = "";
        if (this.label != null) {
            text = this.label.getText();
        }
        return text;
    }

    protected void setDebugText(String text) {
        if (this.debug) {
            if (this.debugFile != null) {
                Imap4FileWriter in = new Imap4FileWriter();
                if (in.openAppend(this.debugFile)) {
                    in.lineOut(String.valueOf("\n").concat(String.valueOf(text)));
                    in.close();
                }
            } else {
                System.out.println(text);
            }
        }
    }

    protected void setException(String text) {
        if (this.debug) {
            this.setDebugText(text);
        } else {
            System.out.println(text);
        }
    }

    public boolean open() throws Imap4Exception {
        Imap4Connect connect;
        boolean ret_code = false;
        Imap4Logon logon = new Imap4Logon(this);
        if (logon.canProceed() && (connect = new Imap4Connect(this)).connect()) {
            this.startResponseThread();
            ret_code = logon.logonToServer();
            if (!ret_code) {
                this.closeResponseThread();
            }
        }
        return ret_code;
    }

    public boolean close() throws Imap4Exception {
        boolean ret_code = false;
        this.setText("Closing server connection...");
        Imap4Cmd cmd = this.issueCmd("LOGOUT");
        if (cmd.getResult() != 1) {
            throw new Imap4Exception(cmd.getResponse());
        }
        ret_code = true;
        this.setText("Connection closed.");
        this.closeResponseThread();
        return ret_code;
    }

    public String getSeparator() throws Imap4Exception {
        if (this.separator == null) {
            this.setText("Retrieving separator...");
            Imap4Cmd cmd = this.issueCmd("LIST \"\" \"INBOX\"");
            if (cmd.getResult() == 1) {
                String text = cmd.get(0);
                int spot = text.toLowerCase().indexOf("nil");
                if (spot < 0 && (spot = text.indexOf(34)) > 0) {
                    if ((spot = (text = new String(text.substring(spot + 1).trim())).indexOf(34)) > 0) {
                        text = new String(text.substring(0, spot));
                    }
                    this.separator = new String(text);
                }
            } else {
                throw new Imap4Exception(cmd.getResponse());
            }
        }
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = new String(separator.replace('\"', ' ').trim());
    }

    public Imap4Folder[] getFolders() throws Imap4Exception {
        Imap4Folder[] folder = null;
        this.setText("Reading the list of folders...");
        Imap4Cmd cmd = this.issueCmd("LIST \"\" \"%\"");
        if (cmd.getResult() == 1) {
            int cnt = 0;
            folder = new Imap4Folder[cmd.getSize()];
            for (int i = 0; i < cmd.getSize(); ++i) {
                if (!cmd.get(i).toUpperCase().startsWith("* LIST ")) continue;
                folder[cnt++] = new Imap4Folder(this, cmd.get(i));
            }
        } else {
            throw new Imap4Exception(cmd.getResponse());
        }
        Imap4Folder.sortFolders(folder);
        return folder;
    }

    public Imap4Folder getAllFolders() throws Imap4Exception {
        return this.getAllFolders("");
    }

    public Imap4Folder getAllFolders(String maildir) throws Imap4Exception {
        Imap4Folder root = null;
        this.setText("Reading the list of folders...");
        Imap4Cmd cmd = this.issueCmd(String.valueOf(String.valueOf("LIST \"").concat(String.valueOf(maildir))).concat(String.valueOf("\" \"*\"")));
        if (cmd.getResult() == 1) {
            boolean cnt = false;
            Vector list = this.scrubFolderList(cmd);
            root = new Imap4Folder(this);
            for (int i = 0; i < list.size(); ++i) {
                root.parseFolderLine(this.getSeparator(), (String)list.elementAt(i));
            }
        } else {
            throw new Imap4Exception(cmd.getResponse());
        }
        return root;
    }

    private Vector scrubFolderList(Imap4Cmd cmd) {
        Vector<String> vector = new Vector<String>();
        String txt = null;
        boolean cnt = false;
        for (int i = 0; i < cmd.getSize(); ++i) {
            txt = cmd.get(i);
            if (!txt.toUpperCase().startsWith("* LIST (")) continue;
            vector.addElement(this.formatFolderItem(cmd.get(i)));
        }
        this.sortFolders(vector);
        return vector;
    }

    private String formatFolderItem(String item) {
        String text = null;
        String flags = null;
        int spot = item.indexOf(40);
        int spot1 = item.indexOf(41);
        flags = new String(item.substring(spot, spot1 + 1));
        spot = (item = new String(item.substring(spot1 + 1).trim())).toLowerCase().indexOf("nil");
        if (spot >= 0) {
            spot = item.indexOf(32);
            if (spot > 0) {
                text = new String(item.substring(spot + 1).trim());
            }
        } else {
            spot = item.substring(1).indexOf(34);
            if (spot > 0) {
                if (this.separator == null) {
                    this.setSeparator(item.substring(1, spot + 1));
                }
                text = new String(String.valueOf(String.valueOf(item.substring(spot + 2).replace('\"', ' ').trim()).concat(String.valueOf(" "))).concat(String.valueOf(flags)));
            } else {
                text = new String(item);
            }
        }
        return text;
    }

    private void sortFolders(Vector vector) {
        boolean unsorted = false;
        String obj1 = null;
        String obj2 = null;
        if (vector != null) {
            do {
                unsorted = false;
                for (int j = 0; j < vector.size() - 1; ++j) {
                    obj1 = (String)vector.elementAt(j);
                    if (obj1.compareTo(obj2 = (String)vector.elementAt(j + 1)) <= 0) continue;
                    vector.setElementAt(obj2, j);
                    vector.setElementAt(obj1, j + 1);
                    unsorted = true;
                }
            } while (unsorted);
        }
    }

    public Imap4Folder createFolder(String name) throws Imap4Exception {
        Imap4Folder folder = null;
        this.setText(String.valueOf(String.valueOf("Creating folder [").concat(String.valueOf(name))).concat(String.valueOf("]...")));
        Imap4Cmd cmd = this.issueCmd(String.valueOf(String.valueOf("CREATE \"").concat(String.valueOf(name))).concat(String.valueOf("\"")));
        if (cmd.getResult() != 1) {
            throw new Imap4Exception(cmd.getResponse());
        }
        folder = new Imap4Folder(this, "", name);
        this.setText(String.valueOf(String.valueOf("Folder [").concat(String.valueOf(name))).concat(String.valueOf("] was created successfully.")));
        return folder;
    }

    public Imap4Cmd lsub(String[] parms) throws Imap4Exception {
        Imap4Cmd cmd = null;
        if (parms != null && parms.length > 0) {
            this.setText("Getting subscribed...");
            StringBuffer sb = new StringBuffer(1024);
            for (int i = 0; i < parms.length; ++i) {
                if (i == 0) {
                    sb.append(String.valueOf(String.valueOf("\"").concat(String.valueOf(parms[i]))).concat(String.valueOf("\"")));
                    continue;
                }
                sb.append(String.valueOf(String.valueOf(",\"").concat(String.valueOf(parms[i]))).concat(String.valueOf("\"")));
            }
            cmd = this.issueCmd(String.valueOf("LSUB ").concat(String.valueOf(sb.toString())));
            if (cmd.getResult() != 1) {
                this.setText("LSUB failed.");
                throw new Imap4Exception(cmd.getResponse());
            }
        } else {
            throw new Imap4Exception("LSUB Error: No reference names were specified.");
        }
        this.setText("LSUB completed successfully.");
        return cmd;
    }

    public Imap4Cmd list(String reference, String mailbox) throws Imap4Exception {
        Imap4Cmd cmd = null;
        if (reference != null && mailbox != null) {
            this.setText("Executing LIST command...");
            cmd = this.issueCmd(String.valueOf(String.valueOf(String.valueOf(String.valueOf("LIST \"").concat(String.valueOf(reference))).concat(String.valueOf("\" \""))).concat(String.valueOf(mailbox))).concat(String.valueOf("\"")));
            if (cmd.getResult() != 1) {
                this.setText("LIST failed.");
                throw new Imap4Exception(cmd.getResponse());
            }
        } else {
            throw new Imap4Exception("LIST Error: Reference value or mailbox value is null.");
        }
        this.setText("LIST completed successfully.");
        return cmd;
    }

    public synchronized Imap4Cmd issueCmd(String text) {
        Imap4Cmd cmd = new Imap4Cmd(this.genCmdNumber());
        DataOutputStream out = null;
        String cmdText = new String(String.valueOf(String.valueOf(cmd.getCmdID()).concat(String.valueOf(" "))).concat(String.valueOf(text)));
        if (this.socket != null) {
            try {
                out = new DataOutputStream(this.socket.getOutputStream());
                if (this.noop) {
                    this.issueNoopCommand();
                }
                this.setDebugText(cmdText);
                this.openCmds.addElement(cmd);
                out.writeBytes(String.valueOf(cmdText).concat(String.valueOf("\r\n")));
                this.monitorCmd(cmd);
            }
            catch (IOException e) {
                this.setException(e.toString());
            }
        } else {
            this.setException("IMAP4 Command issued while not connected.");
        }
        return cmd;
    }

    public synchronized Imap4Cmd issueNoopCommand() {
        Imap4Cmd cmd = new Imap4Cmd(this.genCmdNumber());
        DataOutputStream out = null;
        String cmdText = new String(String.valueOf(cmd.getCmdID()).concat(String.valueOf(" NOOP")));
        if (this.socket != null) {
            try {
                out = new DataOutputStream(this.socket.getOutputStream());
                this.setDebugText(cmdText);
                this.openCmds.addElement(cmd);
                out.writeBytes(String.valueOf(cmdText).concat(String.valueOf("\r\n")));
                this.monitorCmd(cmd);
            }
            catch (IOException e) {
                this.setException(e.toString());
            }
        } else {
            this.setException("IMAP4 Command issued while not connected.");
        }
        return cmd;
    }

    private String genCmdNumber() {
        String text = new String(String.valueOf("J").concat(String.valueOf(Imap4.pad(++this.cmdIndex, '0', 5))));
        return text;
    }

    private static String pad(int val, char tchar, int len) {
        String text = new String(String.valueOf("").concat(String.valueOf(val)));
        while (text.length() < len) {
            text = new String(String.valueOf(tchar).concat(String.valueOf(text)));
        }
        return text;
    }

    private void monitorCmd(Imap4Cmd cmd) {
        boolean done = false;
        int cnt = Imap4.getIdleTime() * 4;
        int recs = 0;
        for (int i = 0; cmd.getStatus() != 1 && i < cnt; ++i) {
            if (recs != cmd.getSize()) {
                i = 0;
                recs = cmd.getSize();
            }
            this.Sleep(250L);
        }
        if (cmd.getStatus() != 1) {
            cmd.setStatus(2);
        }
    }

    private void Sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            System.out.println("Sleeping interrupted...");
        }
    }

    private void startResponseThread() {
        this.respThread = new Imap4ResponseThread(this);
        this.respThread.start();
    }

    private void closeResponseThread() {
        if (this.respThread != null) {
            this.respThread.stop();
            this.respThread = null;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                this.setException(e.toString());
            }
            this.socket = null;
        }
    }
}

