import java.io.*;
import java.net.*;
import java.util.*;

public class dmachine
{

 public static final String VERSION="0.8";
 public static final String NAME="Download Machine";
 public static final String COPYRIGHT="Copyright (c) 1999-2000 Radim Kolar. Open Source Software; There is NO warranty.\n"+
 "See the GNU General Public Licence version 2 or later for copying conditions.";

 // public static final String TMPDIR="tmp";
 
 public static InetAddress http_proxyserver;
 public static int         http_proxyport;
 public static boolean     http_proxydefined;
 public static int	   http_resume;

 public static InetAddress  ftp_proxyserver;
 public static int          ftp_proxyport;
 public static boolean      ftp_proxydefined;
 public static int	    ftp_resume;

 public static String queue_files[];
 public static long queue_files_lastmod[];
 
 public static String download_dir;
 public static String tmp_dir;
 
 public static boolean case_sensitive;
 
 public static short threads,retry,uretry;  
 public static int timeout;
 public static long qchecktime,reptime;

 public static String auto_prefix,auto_suffix;

 public static String log_fatal;
 public static String log_ok;
 
 // system data
 public static Hashtable files; /* for fast search by name */
 public static Vector queue;
 public static int qhead;
 
 public static ThreadGroup runners;
  
 public static final void main(String argv[]) throws IOException
 {
  // print copyright
  System.out.println(NAME+" "+VERSION+"\n"+COPYRIGHT+"\n");

  // sysinit
  files=new Hashtable();
  queue=new Vector();
  qhead=-1;
  queue_files=new String[0];
  queue_files_lastmod=new long[0];
  auto_prefix=auto_suffix="";
  runners=new ThreadGroup(NAME+"-workers");

  // cfginit
  defaultinit();
  configure("dmachine.cnf");
  watchQueue();
 }

 private static final void watchQueue()
 {
  boolean empty=false;
  while(true)
  {
   // check queue files
   for(int i=queue_files.length-1;i>=0;i--)
   {
    File q;
    q=new File(queue_files[i]);
    
    if( !q.isFile() || !q.canRead() ) { queue_files_lastmod[i]=0;continue;}
    if(q.lastModified()!=queue_files_lastmod[i])
    {
      parseQueue(q);
      queue_files_lastmod[i]=q.lastModified();
    }
   }
      
   if(!startThreads())
     { 
       if(!empty) { System.out.println("[QUEUE] Download Machine is idle.");empty=true;}
     }
    else empty=false;
     
   try
   {
     Thread.sleep(qchecktime);
   }
   catch(InterruptedException intr)
    {
     System.out.println("[YUP!] GOT INTR, QueueWatch ended.");
     break;
    }
  }
 
 } /* watchQueue */
 private static final void defaultinit()
 {
  /* init to defaults */
  ftp_proxydefined=http_proxydefined=false;
  addQueueFile("queue");
  download_dir="files";
  tmp_dir="files"+File.separatorChar+"tmp";
  case_sensitive=true;
  threads=2; retry=12;uretry=3;
  timeout=60*3*1000;
  qchecktime=20L*1000L;
  reptime=45L*1000L;
 }
 
 private static final void configure(String cfgfile) throws IOException
 {
  DataInputStream dis=new DataInputStream(new BufferedInputStream(
                        new FileInputStream(cfgfile) ) );
  int lineno=0;                        
  String line,token;
  StringTokenizer st;                        
  while ( (line = dis.readLine()) != null)
  {
          lineno++;
          if(line.startsWith("#")) continue;
	  st=new StringTokenizer(line);
          if(st.hasMoreTokens()==false) continue;
          token=st.nextToken();
          token=token.toLowerCase();
          try
          {
           if(token.equals("http_proxy")) 
	       try
	        {
                  http_proxyserver=InetAddress.getByName(st.nextToken());
                  http_proxyport=Integer.valueOf(st.nextToken()).intValue();
                  http_proxydefined=true;
		}
		catch (UnknownHostException hnf) 
		{
		  System.err.println("[CONFIG_ERROR] "+cfgfile+":"+lineno+" http_proxy "+hnf.getMessage()+":Host not found.");
		}
		finally
		 {  continue; }
          else                                      
          if(token.equals("ftp_proxy")) 
	    try
	    {
             ftp_proxyserver=InetAddress.getByName(st.nextToken());
             ftp_proxyport=Integer.valueOf(st.nextToken()).intValue();
             ftp_proxydefined=true;
	     }
	     catch (java.net.UnknownHostException hnf) {
		  System.err.println("[CONFIG_ERROR] "+cfgfile+":"+lineno+" ftp_proxy "+hnf.getMessage()+":Host not found.");
	     }
	     finally
	      { continue; }
	  else
          if(token.equals("ftp_proxy_resume")) 
	    {
             ftp_resume=decoderesumekw(st.nextToken());
	    }
	  else
          if(token.equals("http_proxy_resume")) 
	    {
             http_resume=decoderesumekw(st.nextToken());
	    }
          else                                      
          if(token.equals("queue_file")) 
                                      { 
				        addQueueFile(st.nextToken());
                                        continue;
                                      }
	  else			      
          if(token.equals("auto_prefix")) 
                                      { 
				        auto_prefix=st.nextToken();
                                        continue;
				      }
          else                        
          if(token.equals("log_fatal")
	  || token.equals("fatal_log")
	  ) 
                                      { 
				        log_fatal=st.nextToken();
                                        continue;
                                      }
          else
          if(token.equals("log_ok")) 
                                      { 
				        log_ok=st.nextToken();
                                        continue;
                                      }
          else
          if(token.equals("auto_suffix")) 
                                      { 
				        auto_suffix=st.nextToken();
                                        continue;
                                      }
          else                                      
          if(token.equals("download_directory")) 
                                      {  
                                         download_dir=st.nextToken();
                                         if(download_dir.endsWith(File.separator)) download_dir=download_dir.substring(0,download_dir.length()-1);
                                         new File(download_dir).mkdirs();
                                         continue;
                                       }
	  else                                       
          if(token.equals("temporary_directory")) 
                                      {  
                                         tmp_dir=st.nextToken();
                                         if(tmp_dir.endsWith(File.separator)) tmp_dir=tmp_dir.substring(0,tmp_dir.length()-1);
                                         new File(tmp_dir).mkdirs();
                                         continue;
                                      }
                                       
          else                                      
          if(token.equals("case_sensitive_filenames")) {
          				                   char c=(char)Integer.valueOf(st.nextToken()).intValue();
                                                           if(c==1) case_sensitive=true; else case_sensitive=false;
                                                           continue;
                                                      }
                                                      
          else                                      
          if(token.equals("download_threads")) {           // Java 1.0.X doesn't have Short class, using Integer
          				                   threads=(short)Integer.valueOf(st.nextToken()).intValue();
                                                           continue;
                                                      }

          else                                      
          if(token.equals("file_retry_count")) {           // Java 1.0.X doesn't have Short class, using Integer
          				                   retry=(short)Integer.valueOf(st.nextToken()).intValue();
                                                           continue;
                                                      }

          else                                      
          if(token.equals("url_retry_count")) {           // Java 1.0.X doesn't have Short class, using Integer
          				                   uretry=(short)Integer.valueOf(st.nextToken()).intValue();
                                                           continue;
                                                      }
                                                      
          else                                      
          if(token.equals("download_timeout")) {           // Java 1.0.X doesn't have Short class, using Integer
          				                   timeout=1000*Integer.valueOf(st.nextToken()).intValue();
                                                           continue;
                                                      }

          else                                      
          if(token.equals("report_time")) {                // Java 1.0.X doesn't have Short class, using Integer
          				                   reptime=1000*Integer.valueOf(st.nextToken()).intValue();
                                                           continue;
                                                      }
                                                      
          else                                      
          if(token.equals("queue_check_time")) {           // Java 1.0.X doesn't have Short class, using Integer
          				                   qchecktime=1000L*Integer.valueOf(st.nextToken()).intValue();
                                                           continue;
                                                      }
                                                                                                                                                                                                        
          else                                      
          System.err.println("[CONFIG_ERROR] "+cfgfile+":"+lineno+" Unknown keyword: "+token);
          
          }
          catch (NoSuchElementException nse)
           { System.err.println("[CONFIG_ERROR] "+cfgfile+":"+lineno+" Missing arguent(s).");
             continue;}                                     
  }                      
  dis.close();                        
 

 }
 
 private final static void parseQueue(File q)
 {
  try
  {
  DataInputStream dis=new DataInputStream(new BufferedInputStream(
                        new FileInputStream(q) ) );
  String line;
  int lineno=0;             
  URL url;          
  System.out.println("[QUEUE] Loading queue file: "+q);
  while ( (line = dis.readLine()) != null)
  {
          lineno++;
          if(line.startsWith("#")) continue;
          try
          {
	   StringTokenizer st=new StringTokenizer(line);
           line=st.nextToken();
	   if(line.indexOf("://")==-1)
	   {
	     line=line.toLowerCase();
	     if(line.equals("referer"))
	     {
	       String f1,f2;
	       f1=st.nextToken();
	       f2=st.nextToken();
               downloadfactory.addReferer(f1,f2);
	       continue;
	     }else if(line.equals("end")) break;
            System.out.println("[QUEUE] Bad command '"+line+"' at line "+lineno);
	    continue;
	   }

          }
          catch(NoSuchElementException kurva) {continue;}
          try
          {
            String fn;
            qfile qf;
	    fn=null;
	    if(line.indexOf('#')>-1)
	     {
	      int z=line.indexOf('#');
	      fn=line.substring(z+1);
	      line=line.substring(0,z);
	     }
            url=new URL(line);
	    if(fn==null) fn=getFilename(url.getFile());
            if(fn!=null && fn.length()!=0)
             {
	       if(!case_sensitive) fn=fn.toLowerCase();
             } else fn=line;
             
            qf=(qfile)files.get(fn);
            if(qf==null)
             {
              System.out.println("[QUEUE] New file "+fn+" added. url="+line);
              qf=new qfile(fn,line);
              files.put(fn,qf);
              queue.addElement(qf);
             } else
              qf.addURL(line);
              
            // System.out.println("URL="+url+" filename="+fn);
          }
          catch (MalformedURLException grr)
           {
            System.out.println("[QUEUE] Bad URL="+line+" at line "+lineno);continue;
           }
  }  
  dis.close();  
  }
  catch (IOException grrr) {}
  // startThreads();
 } /* parse_queue */
 
 /* vraci true pokud je DM aktivni */
private final static synchronized boolean startThreads()
{
 int ac=runners.activeCount();
 boolean active=false;
 if(ac>0) active=true;
 if(ac>=threads) return true;
 
 boolean rotated=false;
 int qs=queue.size();
 if(qs==0) return active; // empty queue
 while(true)
 {
  qhead++;
  if(qhead>=qs)
  {
   if(rotated) return active;
     else
   {qhead=0;rotated=true;}
  }
   
  qfile qf;
  qf=(qfile)queue.elementAt(qhead);
  if(!qf.needsDownload()) continue;
  // start it up!
  active=true;
  Thread t;
  t=new Thread(runners,qf);
  // qf.downloader=t;
  t.start();
  Thread.yield();
  ac++;
  if(ac>=threads) return true;
 }
} 

public final static String getFilename(String fileurl)
{
   /* new code (from smart cache) */
   
   byte v[];
   int j=fileurl.length();
   
   v=new byte[j];
   fileurl.getBytes(0,j,v,0);
   loop1:for(int zz=0;zz<j;zz++)
    {
      switch(v[zz])
      {
        case 0x3b: // ;
        case 0x3a: // :
        case 0x3d: // =
        case 0x3f: // ?
	case 0x7c: // |
         //  case 0x23: // # - je jiz odstranen
	 
           return null; // je to dotaz!
      }
    }
      
    /* novy kod - konec! */
   if(fileurl.length()<2) return "";
   j=fileurl.lastIndexOf('/',j);
   int i=fileurl.indexOf('~');
   if (i!=-1 && j<i) return "";
    else 
     return fileurl.substring(j+1); // soubor
}

public synchronized static void log_fatal(String msg)
{
 System.out.println("[FATAL_ERR] "+msg);
 if(log_fatal==null) return;
 try
 {
  DataOutputStream dos=new DataOutputStream(new BufferedOutputStream(new FileOutputStream(log_fatal,true)));
  dos.writeBytes(new Date().toString());
  dos.writeBytes(" ");
  dos.writeBytes(msg);
  dos.writeBytes("\n");
  dos.close();
}
catch (IOException i)
 {
  log_fatal=null;
 }
}
 
private final static void addQueueFile(String name)
{
 if(name==null || name.length()==0) return;
 for(int i=queue_files.length-1;i>=0;i--)
  if(queue_files[i].equals(name)) return;
  
 queue_files=util.addStringToArray(name,queue_files);
 queue_files_lastmod=util.incLongArraySize(queue_files_lastmod);
}

private final static int decoderesumekw(String kw)
{
 int res=downloadfactory.RESUME_UNKNOWN;
 kw=kw.toLowerCase();
 if(kw.equals("none")|| kw.equals("normal")|| kw.equals("standard"))
  res=downloadfactory.RESUME_NONE;
 else 
 if(kw.equals("pragma")|| kw.equals("nocache"))
  res=downloadfactory.RESUME_NOCACHE;
 else
 if(kw.equals("direct"))
  res=downloadfactory.RESUME_DIRECT;
 else
   System.err.println("[CONFIG_ERROR] Unknown resume option "+kw);
   
 return res;

}

}
