/* WIDE AREA INFORMATION SERVER SOFTWARE:
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.

   5.29.90	Harry Morris, morris@think.com
*/

#ifndef sockets_h
#define sockets_h

#define IBMTCP /* Change file to reflect differences of ibm's tcpip for os/2. */

#include "cdialect.h"
#include "cutil.h"

#ifndef THINK_C
#ifndef M_XENIX

#ifdef IBMTCP
#include <types.h>
#include <sys\ioctl.h>
#include <nerrno.h>
#include <netdb.h>
#include <netinet\in.h>
#include <netlib.h>
#include <sys\socket.h>
#include <utils.h>
#else
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#endif /* IBMTCP */
#endif /* M_XENIX */
#endif /* THINK_C */

/*---------------------------------------------------------------------------*/

#ifdef __cplusplus
/* declare these as C style functions */
extern "C"
	{
#endif /* def __cplusplus */

void open_server _AP((long port,long* socket,long size));
void accept_client_connection _AP((long socket,FILE** file));
void close_client_connection _AP((FILE* file));
void close_server _AP((long socket));
#ifdef IBMTCP
long connect_to_server _AP((char* host_name,long port));
#else
FILE *connect_to_server _AP((char* host_name,long port));
#endif
void close_connection_to_server _AP((FILE* file));

#ifdef __cplusplus
	}
#endif /* def __cplusplus */

/*---------------------------------------------------------------------------*/

#endif
