#define INCL_WIN
#define INCL_PM
#define INCL_GPI
#define INCL_WINHELP

#ifndef IBMTCP
#define IBMTCP
#define INCL_DOSFILEMGR
#define INCL_WINDIALOGS
#endif

#define INCL_DOSPROCESS  /* Needed for calls to DosExecPgm */
#define INCL_DOSSESMGR	 /* Needed for calls to DosStartSession. */
#define INCL_DOSFILEMGR  /* Needed for calls to DosQueryCurrentDir and Disk.*/

#define MAX_MAX_DOCS 1024
#define MAX_FEEDBACK 12  /* Maximum number of relevance feedback docs per src. */

#include <os2.h>
#include <stdlib.h>
#include <stdio.h.>
#include <string.h>

#include "win.h"
#include "cutil.h"
#include "futil.h"
#include "panic.h"
#include "sockets.h"
#include "zprot.h"    /* Needed for SearchResponseAPDU */
#include "wprot.h"    /* Needed for WAISSearchResponse definition. */
#include "wmessage.h" /* Needed for HEADER_LENGTH definition. */
#include "ui.h"

#define CHARS_PER_PAGE 10000 /* number of chars retrieved in each request */
#ifdef IBMTCP
#define MAX_MESSAGE_LEN 30000 /* long's only up to 32767 in 16-bit world. */
#else
#define MAX_MESSAGE_LEN 100000
#endif
#define NEW_DOC_FILENAME "new_doc.tmp"
#define DEFAULT_VIEWER "epm.exe"

struct source
{
  char version[STR_LEN];
  char ip_address[STR_LEN];
  char ip_name[STR_LEN];
  char tcp_port[STR_LEN];
  char database_name[STR_LEN];
  char cost[STR_LEN];
  char cost_unit[STR_LEN];
  char maintainer[STR_LEN];
  char description[LARGE_STR_LEN];
  char filename[STR_LEN];
  LONG selected;
  DocObj *(rfdocs[MAX_FEEDBACK + 1]);
  char rfheadlines[MAX_FEEDBACK + 1][128];
};

HMQ hmq;
HWND	hwndFrame;
HWND	hwndClient;
HWND	hwndDocuments;
HWND	hwndResults;
HWND	hwndSources;
HWND	hwndQuery;
HWND	hwndStatus;
HWND	hwndSearch;
HWND	hwndSrcbut;
HWND	hwndSourceList;
HWND	hwndEditSource;
HWND	hwndDelok;
MENUITEM	mi;
HAB	hab;
long sources_loaded = FALSE;

PFNWP OrigQueryWP;
PFNWP OrigViewerWP;
PFNWP OrigResultsWP;
PFNWP OrigSourcesWP;
long EditSrcReturn;

struct source *sources[MAX_SOURCES + 1];
struct source *sel_source = (struct source *) NULL;

char viewers[6][2][64];

long message_length = MAX_MESSAGE_LEN; /* Used to get message length */
char* request_message = NULL; /* arbitrary message limit */
char* response_message = NULL; /* arbitrary message limit */
char* doc_request_message = NULL; /* arbitrary message limit */
char* doc_response_message = NULL; /* arbitrary message limit */
long Max_Docs = 40;
SearchResponseAPDU *query_responses[MAX_SOURCES];
long headline_order[MAX_MAX_DOCS + 1][2]; /* Ordering of hits. */
DocObj *feedback_docs[MAX_FEEDBACK * MAX_SOURCES + 1]; /* Ptr's to feedback docs. */
long delok = FALSE;
char delfilename[128];

/*short ioint = 1;
short *iptr = &ioint;*/

/*char UserInfo[500];*/

#ifdef IBMTCP
long connection; /* Current connection to server. */
#else
FILE *connection; /* Current connection to server. */
#endif

/* Prototypes */
void SendToStatus(char *str, SHORT reset);
void SendToResults(char *str);
long load_source(char *filename, struct source *psrc);
void Wdisplay_search_response();/*SearchResponseAPDU *response,
			      struct source *src);*/

CHAR szStatus[STR_LEN]; /* String for formatting status and other messages. */

#ifdef IBMTCP
char* log_file_name;
FILE* logfile = (FILE *) NULL;

void delete_source(long index, HWND hwnd)
{
  sprintf(delfilename, "%s.src", sources[index]->filename);
  hwndDelok = WinDlgBox(HWND_DESKTOP, hwnd, (PFNWP)DlgDelokWP, (HMODULE)NULL,
		IDD_DELOK, NULL);
  if(delok == FALSE) return;
  remove(delfilename);
  s_free(sources[index]); sources[index] = NULL;
}

void compress_sources()
{
  long loop, loop2;
  for(loop = 0; loop < MAX_SOURCES - 1; loop++)
    if(sources[loop] == NULL)
    {
      for(loop2 = loop + 1; loop2 < MAX_SOURCES; loop2++)
	if(sources[loop2] != NULL)
	{
	  sources[loop] = sources[loop2];
	  sources[loop2] = NULL;
	  break;
	}
    }
}

long generate_feedback_list()
{
  long loop, loop2, count;

  count = 0;
  for(loop = 0; loop < MAX_SOURCES; loop++)
  {
    if(sources[loop] == NULL) break;
    for(loop2 = 0; loop2 < MAX_FEEDBACK; loop2++)
    {
      feedback_docs[count] = sources[loop]->rfdocs[loop2];
      if(feedback_docs[count] == NULL) break;
      count++;
    }
  }
  feedback_docs[count] = NULL;
  if(count >= (MAX_SOURCES * MAX_FEEDBACK))
  {
    SendToStatus("Max feedback documents reached, ignoring the rest.", 0);
    return(FALSE);
  }
  return(TRUE);
}

void list_feedback()
{
  long loop, loop2, first;
  char temp[256];

  WinSendMsg(hwndDocuments, LM_DELETEALL, NULL, NULL);
  for(loop = 0; loop < MAX_SOURCES; loop++) /* List selected Feedback. */
  {
    if(sources[loop] == NULL) break;
    for(loop2 = 0; loop2 < MAX_FEEDBACK; loop2++)
    {
      if(sources[loop]->rfdocs[loop2] == NULL) break;
      if(sources[loop]->selected == TRUE)
	WinSendMsg(hwndDocuments, LM_INSERTITEM, MPFROMSHORT(LIT_END),
		   (MPARAM)(PSZ) sources[loop]->rfheadlines[loop2]);
    }
  }
  first = TRUE;
  for(loop = 0; loop < MAX_SOURCES; loop++) /* List selected Feedback. */
  {
    if(sources[loop] == NULL) break;
    for(loop2 = 0; loop2 < MAX_FEEDBACK; loop2++)
    {
      if(sources[loop]->rfdocs[loop2] == NULL) break;
      if(sources[loop]->selected == FALSE)
      {
	if(first == TRUE)
	{
	  WinSendMsg(hwndDocuments, LM_INSERTITEM, MPFROMSHORT(LIT_END),
		   (MPARAM)(PSZ) "These documents may be ignored:");
	  first = FALSE;
	}
	sprintf(temp, ".....%s", sources[loop]->rfheadlines[loop2]);
	WinSendMsg(hwndDocuments, LM_INSERTITEM, MPFROMSHORT(LIT_END),
		   (MPARAM)(PSZ) temp);
      }
    }
  }
}

char *remsrc(char *buf) /* Remove ".src" tail of string. */
{
  static char temp[256];
  char *ptr;

  strcpy(temp, buf);
  if((ptr = strstr(temp, ".src")) == NULL)
    if((ptr = strstr(temp, ".SRC")) == NULL)
      return(buf);
		      /* Find field location. */
  *ptr = '\0';
  return(temp);
}

void list_selsrc()
{
  long loop;

  WinSendMsg(hwndSources, LM_DELETEALL, NULL, NULL);
  for(loop = 0; loop < MAX_SOURCES; loop++)
    if(sources[loop] != (struct source *) NULL)
      if(sources[loop]->selected == TRUE)
	WinSendMsg(hwndSources, LM_INSERTITEM, MPFROMSHORT(LIT_END),
		   (MPARAM)(PSZ) remsrc(sources[loop]->filename));
}

char *lchars(char *buf, long numchars)
{ /* Return a pointer to the last n characters of this string.	*/
  long loop;

  for(loop = 0; buf[loop] != '\0'; loop++) {}
  if(loop < numchars) return(buf);
  else return(&(buf[loop - numchars]));
}

long already_taken(long srcnum, long headernum)
{
  int loop;

  for(loop = 0; loop < MAX_MAX_DOCS; loop++)
  {
    if(headline_order[loop][0] == -1) break;
    if(headline_order[loop][0] == srcnum)
      if(headline_order[loop][1] == headernum)
	return(TRUE);
  }
  return(FALSE);
}

long highest_score(long *src_num, long *headernum)
{
  long loop, loop2;
  long greater_than = -1;
  WAISSearchResponse *info;

  for(loop = 0; loop < MAX_SOURCES; loop++)
  {
    if(query_responses[loop] == NULL) break;
    if((LONG) query_responses[loop]->NumberOfRecordsReturned == 0)
      continue;
    if(query_responses[loop]->DatabaseDiagnosticRecords != 0)
    {
      info = (WAISSearchResponse *)
	     query_responses[loop]->DatabaseDiagnosticRecords;

      if(info->DocHeaders != 0) /* If zero, not docs, just diagnostics. */
	for(loop2 = 0; info->DocHeaders[loop2] != 0; loop2++)
	{
	  if(info->DocHeaders[loop2]->Score > greater_than)
	    if(already_taken(loop, loop2) == FALSE)
	    {
	      greater_than = info->DocHeaders[loop2]->Score;
	      *src_num = loop; *headernum = loop2;
	    }
	}
    }
  }
  return(greater_than);
}

void compute_headline_ordering()
{
  long loop;
  long srcnum, headernum;

  headline_order[0][0] = -1;
  for(loop = 0; loop < MAX_MAX_DOCS; loop++)
  {
    if(highest_score(&srcnum, &headernum) == -1) break;
    headline_order[loop][0] = srcnum; headline_order[loop][1] = headernum;
    headline_order[loop + 1][0] = -1;
  }
}

void init_responses()
{
  long loop;
  for(loop = 0; loop < MAX_SOURCES; loop++) query_responses[loop] = NULL;
}

void gethostname(char *hostname, long mx_chars)
{
  long ipnum;
/*  long loop;
  struct hostent *hostp;*/

  ipnum = gethostid();
/*  hostp = gethostbyaddr((char * _Seg16) ipnum, 4, AF_INET);
  sprintf(hostname, "%s", hostp->h_name);*/
  sprintf(hostname, "%ld.%ld.%ld.%ld", (ipnum & 0xFF000000) >> 24,
	  (ipnum & 0xFF0000) >> 16, (ipnum & 0xFF00) >> 8, (ipnum & 0xFF));
/*  if((hostp = gethostent()) == (struct hostent *) NULL)
  {
    strncpy(hostname, "Unknown", mx_chars);
  }
  else
  {
    loop = (hostp->h_length > mx_chars) ? mx_chars : hostp->h_length;
    strncpy(hostname, hostp->h_name, loop);
  }*/
}
#endif /* IBM TCP */

struct source *find_nth_selected_source(USHORT index)
{
  USHORT loop, count;

  count = 0;
  for(loop = 0; loop < MAX_SOURCES; loop++)
    if(sources[loop] != (struct source *) NULL)
      if(sources[loop]->selected == TRUE)
	if(count == index) return(sources[loop]);
	else count++;
  return((struct source *) NULL);
}

void unselect_all_sources()
{
  USHORT loop, count;

  count = 0;
  for(loop = 0; loop < MAX_SOURCES; loop++)
    if(sources[loop] != (struct source *) NULL)
      sources[loop]->selected = FALSE;
}

void unselect_nth_selected_source(USHORT index)
{
  struct source *src;

  src = find_nth_selected_source(index);
  if(src != (struct source *) NULL) src->selected = FALSE;
  else
  {
    sprintf(szStatus, "Error: cannot find %dth source.", index);
    SendToStatus(szStatus, 0);
  }
}

void remove_trailing_quotes(char *str)
{
  LONG loop;
  char last = ' ';

  for(loop = 0; loop < LARGE_STR_LEN; loop++)
  {
    if(str[loop] == '\0') break;
    if(str[loop] == '"')
      if(last != '\\')
      {
	str[loop] = '\0';
	break;
      }
    last = str[loop];
  }
}

LONG get_field(char *src, char *field, char *target)
{
  char format_str[STR_LEN];
  char large_buffer[LARGE_STR_LEN];
  char *ptr, *ptr2;

  if((ptr = strstr(src, field)) == NULL) return(FALSE);
		      /* Find field location. */
  sprintf(format_str, "%s %%s", field);
		      /* Set up format string to find string after field. */
  if(sscanf(ptr, format_str, large_buffer) != 1) return(FALSE);
		      /* Find 1st string following field. */
  if(large_buffer[0] != '"')	/* If not a quoted field, we're done. */
  {
    strcpy(target, large_buffer);
    return(TRUE);
  }
  ptr2 = strstr(ptr, "\"");
  strcpy(large_buffer, ptr2);
  remove_trailing_quotes(&(large_buffer[1])); /* Cut off everything after 2nd quote. */
  strcpy(target, &(large_buffer[1])); /* We're done again. */
  return(TRUE);
}

LONG new_source()
{
  LONG loop;
  struct source *psrc;

  for(loop = 0; loop < MAX_SOURCES; loop++)
    if(sources[loop] == (struct source *) NULL) break;
  if(loop >= MAX_SOURCES)
  {
    WinMessageBox(HWND_DESKTOP, hwndFrame,
	      (PSZ) "Maximum number of sources in use.",
	      "Cannot Add a Source", MBID_MSGBOXID, MB_OK);
    return(FALSE);
  }
  psrc = (struct source *) s_malloc(sizeof(struct source));
  sources[loop] = psrc;
  strcpy(psrc->version, "3"); strcpy(psrc->ip_address, "");
  strcpy(psrc->tcp_port, "210"); strcpy(psrc->ip_name, "");
  strcpy(psrc->database_name, "New Database"); strcpy(psrc->cost, "0.00");
  strcpy(psrc->cost_unit, ":free"); strcpy(psrc->maintainer, "?");
  strcpy(psrc->filename, "new-src"); strcpy(psrc->description, "New");
  psrc->selected = FALSE;
  sel_source = psrc;
  return(TRUE);
}

void load_sources()
{
  LONG loop, loop2;
  struct source *psrc, *psrc2;
  HDIR hdir = HDIR_SYSTEM;	/* Directory Handle. */
  char filename[STR_LEN];
#ifdef IBMTCP
  APIRET result;
  FILEFINDBUF3 findbuf;	/* Structure containing search results. */
  ULONG usSearchCount = 1;/* # of files to be retrieved, returns # found. */
#else
  LONG result;
  FILEFINDBUF findbuf;	/* Structure containing search results. */
  USHORT usSearchCount = 1;/* # of files to be retrieved, returns # found. */
#endif

  SendToStatus("loading sources . . .", 0);
  for(loop = 0; loop < MAX_SOURCES; loop++) /* Initialize sources to null. */
    sources[loop] = (struct source *) NULL;
  if(sources[0] != (struct source *) NULL) SendToStatus("bad nulls", 0);
#ifdef IBMTCP
  hdir = 0x0001;
  result = DosFindFirst("*.src", &hdir, 0, (PVOID) &findbuf,
	       sizeof(findbuf),
	       &usSearchCount, FIL_STANDARD);	/* Locate all the .src files	*/
#else
  result = DosFindFirst("*.src", &hdir, FILE_NORMAL, &findbuf,
	       sizeof(findbuf),
	       &usSearchCount, 0L);	/* Locate all the .src files	*/
#endif
  sprintf(szStatus, "No .src files found in current directory.%ld", result);
  if(result != 0) SendToStatus(szStatus, 0);
  loop = 0;
  while(result == 0)	/* Successful searches, keep going. */
  {
    if(loop >= MAX_SOURCES) break;
    if(usSearchCount <= 0) break;
    psrc = (struct source *) s_malloc(sizeof(struct source));

    strcpy(filename, findbuf.achName);
    strcpy(psrc->filename, remsrc(filename)); /* Store the filename for saving. */
    sprintf(szStatus, "Loading '%s'.", filename);
    SendToStatus(szStatus, 0);
    if(load_source(filename, psrc) == 0) /* File load failed. */
    {
      sprintf(szStatus, "Bad file format in '%s'.", filename);
      SendToStatus(szStatus, 0);
      s_free(psrc);
      result = DosFindNext(hdir, &findbuf, sizeof(findbuf), &usSearchCount);
      loop++;
      continue;
    }
    for(loop2 = 0; loop2 < MAX_SOURCES; loop2++)
    {
      if(sources[loop2] == NULL)
      {
	break;
      }
      if(stricmp(psrc->filename, sources[loop2]->filename) < 0)
      {
	psrc2 = sources[loop2]; sources[loop2] = psrc; psrc = psrc2;
      }
    }
    sources[loop2] = psrc;
    result = DosFindNext(hdir, &findbuf, sizeof(findbuf), &usSearchCount);
    loop++;
  }
}

long load_source(char *filename, struct source *psrc)
{
  FILE *fp;
  LONG loop;
  int chtemp;
  char buffer[MAX_SRC_LEN];

  if((fp = fopen(filename, "r")) == (FILE *) NULL)
  {
    sprintf(szStatus, "Error opening file '%s'.", filename);
    SendToStatus(szStatus, 0);
    return(FALSE);
  }
  loop = 0;   /* Load entire file into a single string. */
  while((chtemp = fgetc(fp)) != EOF)
  {
    if(chtemp > 32) buffer[loop] = (char) chtemp;
    else buffer[loop] = ' ';   /* Convert CR and LF to space. */
    loop++;
    if(loop >= (MAX_SRC_LEN -1)) break;
  }
  buffer[loop] = '\0';
  fclose(fp);

  if(get_field(buffer, ":version", psrc->version) == FALSE)
    strcpy(psrc->version, "?");
  if(get_field(buffer, ":ip-address", psrc->ip_address) == FALSE)
    strcpy(psrc->ip_address, "Unknown");
  if(get_field(buffer, ":ip-name", psrc->ip_name) == FALSE) return(FALSE);
  if(get_field(buffer, ":tcp-port", psrc->tcp_port) == FALSE) return(FALSE);
  if(get_field(buffer, ":database-name", psrc->database_name) == FALSE) return(FALSE);
  if(get_field(buffer, ":cost", psrc->cost) == FALSE)
    strcpy(psrc->cost, "?");
  if(get_field(buffer, ":cost-unit", psrc->cost_unit) == FALSE)
    strcpy(psrc->cost_unit, "?");
  if(get_field(buffer, ":maintainer", psrc->maintainer) == FALSE)
    strcpy(psrc->maintainer, "Unknown");
  if(get_field(buffer, ":description", psrc->description) == FALSE)
    strcpy(psrc->description, "None");
  psrc->selected = FALSE;
  psrc->rfdocs[0] = NULL;
  strcpy(&(psrc->rfheadlines[0][0]), "none");
  fclose(fp);
  return(TRUE);
}

void write_source(struct source *src)
{
  FILE *fp;
  LONG loop;
  int chtemp;
  char buffer[MAX_SRC_LEN];

  sprintf(buffer, "%s.src", src->filename);
  if((fp = fopen(buffer, "w")) == (FILE *) NULL)
  {
    sprintf(szStatus, "Error opening file '%s' to write.", buffer);
    WinMessageBox(HWND_DESKTOP, hwndFrame,
     "Did you specifiy a filename that was too long?",
     szStatus, MBID_MSGBOXID, MB_OK);
    SendToStatus(szStatus, 0);
    return;
  }
  fprintf(fp,
"(:source\n   :version %s\n   :ip-address \"%s\"\n   :ip-name \"%s\"\n\
   :tcp-port %s\n   :database-name \"%s\"\n   :cost %s\n   :cost-unit %s\n\
   :maintainer \"%s\"\n	:description\n\"%s\"\n);",
	  src->version, src->ip_address, src->ip_name, src->tcp_port,
	  src->database_name, src->cost, src->cost_unit, src->maintainer,
	  src->description);
  fclose(fp);
}

void SendToStatus(char *str, SHORT reset)
{		    /* Send a string to the status window for display. */
  if(reset) WinSendMsg(hwndStatus, LM_DELETEALL, NULL, NULL);
  WinSendMsg(hwndStatus, LM_INSERTITEM, MPFROMSHORT(0), (MPARAM)(PSZ) str);/* Post the message. */
  WinSendMsg(hwndStatus, LM_SETTOPINDEX, MPFROMSHORT(0), NULL);/* Scroll to bottom of list. */
}

void SendToResults(char *str)
{		    /* Send a string to the status window for display. */
  WinSendMsg(hwndResults, LM_INSERTITEM, MPFROMSHORT(LIT_END),
	     (MPARAM)(PSZ) str);/* Post the message. */
}

MRESULT EXPENTRY SourcesWP(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
  if(msg == WM_BUTTON1DBLCLK)
  {
/*     SendToStatus("Double click in sources", 0);*/
    WinSendMsg(hwndFrame, WM_COMMAND, MPFROMSHORT(IDM_NOUSESOURCE), NULL);
    return((MRESULT) TRUE); /* Ignore key up messages. */
  }
  else
    return((*OrigSourcesWP)(hwnd, msg, mp1, mp2)); /* Otherwise process. */
}

MRESULT EXPENTRY ResultsWP(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
  if(msg == WM_BUTTON1DBLCLK)
  {
/*    SendToStatus("Double click in results", 0);*/
    WinSendMsg(hwndFrame, WM_COMMAND, MPFROMSHORT(IDM_DISPLAYDOC), NULL);
    return((MRESULT) TRUE); /* Ignore key up messages. */
  }
  else
    return((*OrigResultsWP)(hwnd, msg, mp1, mp2)); /* Otherwise process. */
}

MRESULT EXPENTRY QueryWP(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
  if(msg == WM_CHAR)  /* If the enter key was pressed, do a search. */
    if((0xFF & SHORT1FROMMP(mp2)) == 0xD)
    {
      if(!(SHORT1FROMMP(mp1) & KC_KEYUP))
      {      /* Act when key comes up to prevent repeat searches, no longer true. */
	WinPostMsg(hwndFrame, WM_COMMAND, (MPARAM) IDD_SEARCH, (MPARAM) NULL);
	return((MRESULT) TRUE);	/* Message had been handled. */
      }
      else return((MRESULT) TRUE);	/* Ignore key up messages. */
    }
  return((*OrigQueryWP)(hwnd, msg, mp1, mp2)); /* Otherwise process. */
}

char *format_doc_length(LONG len)
{		  /* Return a nice string with document length.*/
  static char str[32];

  if((len >> 30) >= 1) sprintf(str, "large"); /* 32 bits, can't do GBytes.*/
  else
    if((len >> 21) >= 1) sprintf(str, "%04ldm", (len >> 20));
    else
      if((len >> 11) >= 1) sprintf(str, "%04ldk", (len >> 10));
      else sprintf(str, "%04ld  ", len);
  return(str);
}


void WshowDiags(diagnosticRecord **d) /* Show diagnostic records. */
{
  long i;

  for (i = 0; d[i] != (diagnosticRecord *) NULL; i++)
  {
    if (d[i]->ADDINFO != NULL)
    {
      sprintf(szStatus, "Code: %s, %s", d[i]->DIAG, d[i] ->ADDINFO);
      WinMessageBox(HWND_DESKTOP, hwndFrame, szStatus,
	      "Problem with a Source:", MBID_MSGBOXID, MB_OK);
/*	SendToResults(szStatus);*/
    }
  }
}

void Wdisplay_document(WAISSearchResponse *query_info, LONG document_number,
		       struct source *src)
{
  WAISSearchResponse *retrieval_info;
  SearchResponseAPDU *retrieval_response;
  LONG count;
  long request_buffer_length;	/* how of the request is left */
  long is_source = FALSE;
  char *type;
  FILE *fp = NULL;
  long running_total = 0;
  long last_chunk = 0;
  char UserInfo[500];

  if(query_info->DocHeaders[document_number - 1]->Types == (char **) NULL)
    type = s_strdup("TEXT");
  else
  {
    type = s_strdup(query_info->DocHeaders[document_number - 1]->Types[0]);
    sprintf(szStatus, "type is '%s'",
	    query_info->DocHeaders[document_number - 1]->Types[0]);
    SendToStatus(szStatus, 0);
    if(stricmp("WSRC", type) == 0) is_source = TRUE;
  }
  if((stricmp(type, "TEXT") == 0) || (stricmp(type, "WSRC") == 0))
    fp = fopen(NEW_DOC_FILENAME, "w");
  else
    fp = fopen(NEW_DOC_FILENAME, "wb");
  if(fp == NULL)
  {
    sprintf(szStatus, "Cannot open temp file '%s'.", NEW_DOC_FILENAME);
    SendToStatus(szStatus, 0); return;
  }

  sprintf(szStatus, "Connecting to Server '%s'.", src->ip_name);
  SendToStatus(szStatus, 0);
  if(src->ip_name[0] == '\0')
    connection = connect_to_server(src->ip_address, atol(src->tcp_port));
  else
    connection = connect_to_server(src->ip_name, atol(src->tcp_port));
/*  connection = connect_to_server(src->ip_name, atol(src->tcp_port));*/
  if(connection == (long) NULL)
  {
    SendToStatus("Unable to connect to Server.", 0); return;
  }
  SendToStatus("Initiating Connection . . .", 0);
  gethostname(szStatus, 80);
  sprintf(UserInfo, "waissearch %s, from host: %s", VERSION, szStatus);
/*  SendToStatus(UserInfo, 0);*/
  if((message_length =
      init_connection(request_message, response_message,
		      message_length, connection, UserInfo)) <= 0)
  {
    sprintf(szStatus, "Error opening connection to %s via service %s.",
	    src->ip_name, src->tcp_port);
    SendToStatus(szStatus, 0);
    return;
  }
  SendToStatus("Connection open, sending query . . .", 0);


  /* we must retrieve the document in parts since it might be very long*/
  for(count = 0;
      (query_info->DocHeaders[document_number - 1]->DocumentLength == 0) ||
      (count * CHARS_PER_PAGE <
	      query_info->DocHeaders[document_number - 1]->DocumentLength);
      count++)
  {
/*    sprintf(szStatus,
	    "count %ld len %ld mlen %ld, req_msg %ld q_info %ld docid %ld",
	    count,
	    query_info->DocHeaders[document_number - 1]->DocumentLength,
	    message_length, (long) request_message, (long) query_info,
	    (long) query_info->DocHeaders[document_number - 1]->DocumentID);
    SendToStatus(szStatus, 0);
    sprintf(szStatus,
	    "req_msg %ld res_msg %ld doc_req_msg %ld doc_res_msg %ld",
	    (long) request_message, (long) response_message,
	    (long) doc_request_message, (long) doc_response_message);
    SendToStatus(szStatus, 0);
    SendToStatus("Generating APDU . . .", 0); */
    request_buffer_length = message_length;
    if(0 ==
       generate_retrieval_apdu(doc_request_message + HEADER_LENGTH,
	 &request_buffer_length,
	 query_info->DocHeaders[document_number - 1]->DocumentID,
	 (long)CT_byte, (long)(count * CHARS_PER_PAGE),
	(long)((query_info->DocHeaders[document_number - 1]->DocumentLength ?
		 MIN((count + 1) * CHARS_PER_PAGE,
		 query_info->DocHeaders[document_number - 1]->DocumentLength):
		(count + 1) * CHARS_PER_PAGE)),
	type, src->database_name))
    {
      sprintf(szStatus, "Error generating retrieval APDU: request too long");
      SendToStatus(szStatus, 0);
      if(fp != NULL) fclose(fp);
      return;
    }

    if(running_total == 0)
    {
      sprintf(szStatus, "Bytes Received: %ld", running_total);
      SendToStatus(szStatus, 0);
    }
/*    SendToStatus("Interpreting Message . . .", 0);*/
    if(0 == (last_chunk =
       interpret_message(doc_request_message,
			 message_length - request_buffer_length,
			 doc_response_message, message_length,
			 connection, false)))
    {
      SendToStatus("Interpret message failed during doc retrieval", 0);
      if(connection != (long) NULL)
      {
	SendToStatus("Bad Connection . . .", 0);
	soclose(connection);
	if(src->ip_name[0] == '\0')
	  connection = connect_to_server(src->ip_address, atol(src->tcp_port));
	else
	  connection = connect_to_server(src->ip_name, atol(src->tcp_port));
	if(connection == (long) NULL)
	{
	  sprintf(szStatus, "Error opening connection to %s via service %s.",
		  src->ip_address, src->tcp_port); SendToStatus(szStatus, 0);
	  if(fp != NULL) fclose(fp);
	  return;
	}
	if(0 ==
	   interpret_message(doc_request_message,
			     message_length - request_buffer_length,
			     doc_response_message, message_length, connection,
			     false))
	{
	  sprintf(szStatus, "really couldn't deliver message");
	  SendToStatus(szStatus, 0); break;
	}
      }
      else
      {
	sprintf(szStatus, "Error deliverring message");
	SendToStatus(szStatus,0);
	if(fp != NULL) fclose(fp);
	return;
      }
    }
    running_total += last_chunk;
    sprintf(szStatus, "Bytes Received: %ld", running_total);
    SendToStatus(szStatus, 0);
/*    SendToStatus("readSearchREsponse . . .", 0);*/
    readSearchResponseAPDU(&retrieval_response,
			   doc_response_message + HEADER_LENGTH);
    if(NULL ==
       ((WAISSearchResponse *)retrieval_response->DatabaseDiagnosticRecords)->Text)
    {
      sprintf(szStatus, "No text was returned"); SendToStatus(szStatus, 0);
      break;
    }

    if(stricmp(type, "TEXT") == 0)
      fprintf(fp, "Headline: %s\n",
	    trim_junk(query_info->DocHeaders[document_number - 1]->Headline));

    Wdisplay_text_record_completely(fp, type,
		     ((WAISSearchResponse *)
		      retrieval_response->DatabaseDiagnosticRecords)->Text[0],
		     false);
    if(((WAISSearchResponse *)retrieval_response->DatabaseDiagnosticRecords)->Diagnostics !=
	NULL)
    {
/*	showDiags(((WAISSearchResponse *)retrieval_response->DatabaseDiagnosticRecords)->Diagnostics);*/
      break;
    }
    freeWAISSearchResponse(retrieval_response->DatabaseDiagnosticRecords);
    freeSearchResponseAPDU(retrieval_response);
  }
  soclose(connection);
  if(fp != NULL) fclose(fp);
  SendToStatus("Running program.", 0);
  if(is_source == TRUE)
  {
    struct source *psrc;
    long loop;

    for(loop = 0; loop < MAX_SOURCES; loop++) if(sources[loop] == NULL) break;
    if(loop >= MAX_SOURCES)
    {
      WinMessageBox(HWND_DESKTOP, hwndFrame, "Maximum Source Limit Reached",
	"Cannot Load Retrieved Source", MBID_MSGBOXID, MB_OK);
      return;
    }
/*    WinMessageBox(HWND_DESKTOP, hwndFrame,
      "Save out this file with a \".src\" extension.",
      "Note: This is a New Source Descriptor", MBID_MSGBOXID, MB_OK);*/
    psrc = (struct source *) s_malloc(sizeof(struct source));
    sprintf(szStatus, "Loading source from '%s'.", NEW_DOC_FILENAME);
    SendToStatus(szStatus, 0);
    if(load_source(NEW_DOC_FILENAME, psrc) == 0) /* File load failed. */
    {
      WinMessageBox(HWND_DESKTOP, hwndFrame, "Bad Source Format",
	"Cannot Load Retrieved Source", MBID_MSGBOXID, MB_OK);
      return;
    }
    strcpy(psrc->filename, "new-src");
    sel_source = psrc;
    hwndEditSource = WinDlgBox(HWND_DESKTOP, hwndFrame,
				       (PFNWP)DlgEditSrcWP, (HMODULE)NULL,
				       IDD_EDITSOURCE, NULL);
    if(EditSrcReturn == TRUE)
    {
      sources[loop] = psrc;
      if(hwndSourceList != ((HWND) NULL))
	WinSendMsg(hwndSourceList, WM_CLOSE, NULL, NULL);
      hwndSourceList = WinLoadDlg(HWND_DESKTOP, HWND_DESKTOP,
				(PFNWP)DlgSourceWP, (HMODULE)NULL,
				IDD_SOURCEMENU, NULL);
    }
  }
  else
  {
    char view_prog[64];
    STARTDATA StartData;
    ULONG SessID;
    PID PID;
    UCHAR PgmTitle[40];
    UCHAR PgmName[80];
    UCHAR ObjBuff[100];
    RESULTCODES rtn_codes;
    APIRET rc;
    ULONG DriveNumber;
    ULONG LogicalDriveNumber;
    UCHAR DirPath[256];
    ULONG DirPathLen = 256;
    UCHAR current_temp_path[256];

    sprintf(szStatus,"Document type is '%s'.", type);
    SendToStatus(szStatus, 0);
    determine_viewer_program(type, view_prog);
    sprintf(szStatus,"Calling '%s'.", view_prog);
    SendToStatus(szStatus, 0);

    DosQueryCurrentDisk(&DriveNumber, &LogicalDriveNumber);
    DosQueryCurrentDir(DriveNumber, DirPath, &DirPathLen);
    sprintf(current_temp_path, "%c:\\%s\\%s", ((char) ('A' + DriveNumber -1)),
	    DirPath, NEW_DOC_FILENAME);
    SendToStatus(current_temp_path, 0);

    StartData.Length = sizeof(STARTDATA);
/*    StartData.Related = SSF_RELATED_CHILD;*/
    StartData.Related = SSF_RELATED_INDEPENDENT;
/*    StartData.FgBg = SSF_FGBG_BACK; */
    StartData.FgBg = SSF_FGBG_FORE;
    StartData.TraceOpt = SSF_TRACEOPT_NONE;
    strcpy(PgmTitle, "OS2WAIS Client Viewer -- Launching Window");
/*    StartData.PgmTitle = PgmTitle;*/
    StartData.PgmTitle = NULL;
    strcpy(PgmName, view_prog);
    StartData.PgmName = PgmName;
    StartData.PgmInputs = current_temp_path;
    StartData.TermQ = 0;
    StartData.Environment = 0;
    StartData.InheritOpt = SSF_INHERTOPT_SHELL;
/*    StartData.InheritOpt = SSF_INHERTOPT_PARENT;*/
    StartData.SessionType = SSF_TYPE_DEFAULT;
/*    StartData.SessionType = SSF_TYPE_FULLSCREEN;*/
    StartData.IconFile = 0;
    StartData.PgmHandle = 0;
    StartData.PgmControl = SSF_CONTROL_VISIBLE;
    StartData.InitXPos = 30; StartData.InitYPos = 40;
    StartData.InitXSize = 200; StartData.InitYSize = 140;
    StartData.Reserved = 0;
    StartData.ObjectBuffer = ObjBuff;
    StartData.ObjectBuffLen = 100;
    rc = DosStartSession(&StartData, &SessID, &PID);
    if(rc == 0)
    {
	sprintf(szStatus, "termination code %d, rtn code %d",
	      rtn_codes.codeTerminate, rtn_codes.codeResult);
      SendToStatus(szStatus, 0);
    }
    else
    {
      sprintf(szStatus, "Document Viewer launch failed.  Error number %ld", rc);
	      SendToStatus(szStatus, 0);
      return;
    }
  }
  SendToStatus("Viewer Launched . . . ", 0);
}

/* modified from tracy shen's version in wutil.c
 * displays either a text record of a set of headlines.
 */
void Wdisplay_search_response()/*SearchResponseAPDU *response,
			      struct source *src)*/
{
  WAISSearchResponse  *info;
  LONG continue_viewing;
  LONG i, k;

  for(i = 0; i < MAX_MAX_DOCS; i++)
  {
    if(headline_order[i][0] == -1) break; /* We're done. */
    info = (WAISSearchResponse *)
	   query_responses[headline_order[i][0]]->DatabaseDiagnosticRecords;
    if(info == 0) continue; /* This search produced no hits, move on Douglas. */
    k = headline_order[i][1];
    sprintf(szStatus, "%04ld %s %s",
		(info->DocHeaders[k]->Score),
		format_doc_length(info->DocHeaders[k]->DocumentLength),
		trim_junk(info->DocHeaders[k]->Headline));
    SendToResults(szStatus);
  }

  for(i = 0; i < MAX_SOURCES; i++)
  {
    if(query_responses[i] == NULL) break;
    info = (WAISSearchResponse *)
	   query_responses[i]->DatabaseDiagnosticRecords;
    if(info->Diagnostics != (struct diagnosticRecord **) NULL)
      WshowDiags(info->Diagnostics);
  }
/*  if(response->DatabaseDiagnosticRecords != 0)
  {
    info = (WAISSearchResponse *)response->DatabaseDiagnosticRecords;
    i = 0;
    continue_viewing = 1; 


    if(info->DocHeaders != 0)
    {
      k = 0;
      while((continue_viewing == 1) && (info->DocHeaders[k] != 0))
      {
	i++;
	k++;
      }
    }

/*    if(((long) info->ShortHeaders) > 0L)
    {
      sprintf(szStatus, "Number of Short Headers: %ld", info->ShortHeaders);
      SendToResults(szStatus);
    }
    if ( info->ShortHeaders != 0 ) {
      k =0;
      while ( (continue_viewing == 1) && info->ShortHeaders[k] != 0 ) {
	i++;
	sprintf(szStatus, "    ShortHeader record %2ld, (can't display)", i);
	SendToResults(szStatus);
      }
    }
    if ( info->LongHeaders != 0 ) {
      k =0;
      while ( (continue_viewing == 1) && (info->LongHeaders[k] != 0) ) {
	i++;
	sprintf(szStatus, "    Longheader record %2d, (cant display) ", i);
	SendToResults(szStatus);
      }
    }
    if ( info->Text != 0 ) {
      k =0;
      while ( (continue_viewing == 1) && (info->Text[k] != 0) ) {
	i++;
	sprintf(szStatus, "\n    Text record %2ld, ", i);
	SendToResults(szStatus);
	display_text_record_completely( info->Text[k++], false);
      }
    }

    if ( info->Headlines != 0 ) {
      k =0;
      while ( (continue_viewing ==1) && (info->Headlines[k] != 0) ) {
	i++;
	sprintf(szStatus, "    headline record %2d, (cannot display) ", i);
	SendToResults(szStatus);
      }
    }
    if ( info->Codes != 0 ) {
      k =0;
      while ( (continue_viewing ==1) && (info->Codes[k] != 0) ) {
	i++;
	sprintf(szStatus, "    code record %2d, (dont knowhow to display) ",
		i);
	SendToResults(szStatus);
      }
    }
*/
}

int main(int argc, char *argv[])
{
  char szTitle[64];
  char szAbout[16];
  QMSG qmsg;
  HWND hwndSysMenu;
  HWND hwndSysSubMenu;
  RECTL rectl;

  ULONG flCreate = FCF_SYSMENU | FCF_TITLEBAR | FCF_MENU | FCF_MINMAX |
	      FCF_SHELLPOSITION | FCF_TASKLIST | FCF_ICON | FCF_ACCELTABLE |
	      FCF_SCREENALIGN | FCF_SIZEBORDER;


  if((hab = WinInitialize(0)) == ((HAB) NULL))
  {
    fprintf(stderr, "Can't initialize windows, something's broken.\n");
    exit(0);
  }
  if((hmq = WinCreateMsgQueue(hab, 0)) == ((HMQ) NULL)) /* 10 isn't enough. */
  {
    WinTerminate(hab);
    fprintf(stderr, "Can't create message queue, probably not enough memory.\n");
    exit(1);
  }

  WinLoadString(hab, (HMODULE)NULL, (USHORT)IDS_TITLE, sizeof(szTitle),
		(PSZ)szTitle);
  WinLoadString(hab, (HMODULE)NULL, (USHORT)IDS_ABOUT, sizeof(szAbout),
		(PSZ)szAbout);
  if(!WinRegisterClass(hab, (PSZ) szTitle, (PFNWP) MainWndProc,
		CS_SIZEREDRAW, (USHORT) 0)) return(0);
  hwndFrame = WinCreateStdWindow(HWND_DESKTOP, WS_VISIBLE, &flCreate,
				 (PSZ)szTitle, (PSZ)szTitle, 0L,
				 (HMODULE)NULL, ID_MAIN, &hwndClient);
  WinSetFocus(HWND_DESKTOP, hwndQuery); /* Make hwndQuery the initial focus. */
  WinSetWindowText(WinWindowFromID(hwndFrame, FID_TITLEBAR), (PSZ)szTitle);
  hwndSysMenu = WinWindowFromID(hwndFrame, FID_SYSMENU);

  mi.id = (ULONG) WinSendMsg(hwndSysMenu, MM_ITEMIDFROMPOSITION, 0L, 0L);
  WinSendMsg(hwndSysMenu, MM_QUERYITEM, MPFROM2SHORT(mi.id, FALSE) , (PMENUITEM)&mi);
  hwndSysSubMenu = mi.hwndSubMenu;
  mi.iPosition = MIT_END;
  mi.afStyle = MIS_SEPARATOR;
  mi.afAttribute = (USHORT) NULL;
  mi.id = (USHORT) NULL;
  mi.hwndSubMenu = (ULONG)NULL;
  mi.hItem = (ULONG)NULL;
  WinSendMsg(hwndSysSubMenu, MM_INSERTITEM, (PMENUITEM)&mi, NULL);
  mi.afStyle = MIS_TEXT;
  mi.id = IDM_ABOUT;
  WinSendMsg(hwndSysSubMenu, MM_INSERTITEM, (PMENUITEM) &mi, (PSZ) szAbout);
  WinShowWindow(hwndFrame, TRUE);

  load_viewers();
  init_responses(); /* Clear query_responses and headline_order. */

/*  request_message = (char*)s_malloc((size_t)message_length * sizeof(char));*/
  request_message = (char*) s_malloc((size_t)
		  (((long) HEADER_LENGTH) + message_length) * sizeof(char));
  response_message = (char*) s_malloc((size_t)
		  (((long) HEADER_LENGTH) + message_length) * sizeof(char));
/*  doc_request_message = (char*)s_malloc((size_t)message_length * sizeof(char));*/
  doc_request_message = (char*) s_malloc((size_t)
		  (((long) HEADER_LENGTH) + message_length) * sizeof(char));
  doc_response_message = (char*) s_malloc((size_t)
		  (((long) HEADER_LENGTH) + message_length) * sizeof(char));

/*  WinSendMsg(hwndFrame, WM_COMMAND, MPFROMSHORT(IDM_ABOUT), NULL);*/
  while(WinGetMsg(hab, (PQMSG) &qmsg, (HWND) NULL, 0, 0))  /* Std Win loop. */
    WinDispatchMsg(hab, (PQMSG) &qmsg);

  WinDestroyWindow(hwndFrame);	/* Shut down windows. */
  WinDestroyMsgQueue(hmq);
  WinTerminate(hab);
}

MRESULT EXPENTRY MainWndProc (HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
  RECTL rectl;
  HPS hps;
  HWND hwndMenu;
  LONG loop;

  switch(msg)
  {
    case WM_ERASEBACKGROUND:
      return((MRESULT) TRUE);
      break;
    case WM_CREATE:
      hwndStatus = WinCreateWindow(hwnd, WC_LISTBOX, (PSZ) NULL, WS_VISIBLE,
		0, 0, 0, 0, (HWND) NULL, HWND_TOP, IDD_STATUS, NULL, NULL);
      SendToStatus("Status messages will appear here.", 0); /* Initialize window string. */

      hwndDocuments = WinCreateWindow(hwnd, WC_LISTBOX, (PSZ)NULL,
			WS_VISIBLE, 0, 0, 0, 0, hwnd, HWND_TOP,
			IDD_DOCUMENTS, NULL, NULL);
      hwndResults = WinCreateWindow(hwnd, WC_LISTBOX, (PSZ) NULL,
		      WS_VISIBLE | LS_HORZSCROLL,
		 0, 0, 0, 0, (HWND) NULL, HWND_TOP, IDD_RESULTS, NULL, NULL);
      OrigResultsWP = WinSubclassWindow(hwndResults, (PFNWP) ResultsWP);

      hwndSources = WinCreateWindow(hwnd, WC_LISTBOX, (PSZ)NULL,
		       WS_VISIBLE /*| LS_HORZSCROLL*/ /* | LS_MULTIPLESEL */,
		       0, 0, 0, 0, hwnd, HWND_TOP, IDD_SOURCES, NULL, NULL);
      OrigSourcesWP = WinSubclassWindow(hwndSources, (PFNWP) SourcesWP);

      hwndQuery = WinCreateWindow(hwnd, WC_MLE, (PSZ)NULL,
		    WS_VISIBLE | MLS_BORDER | MLS_WORDWRAP | MLS_VSCROLL,
		    0, 0, 0, 0, hwnd, HWND_TOP, IDD_QUERY, NULL, NULL);
      OrigQueryWP = WinSubclassWindow(hwndQuery, (PFNWP) QueryWP);

      hwndSearch = WinCreateWindow(hwnd, WC_BUTTON, "Search",
		     BS_PUSHBUTTON | WS_VISIBLE | BS_DEFAULT,
		     0, 0, 0, 0, hwnd, HWND_TOP, IDD_SEARCH, NULL, NULL) ;
      hwndSrcbut = WinCreateWindow(hwnd, WC_BUTTON, "Sources",
		     BS_PUSHBUTTON | WS_VISIBLE,
		     0, 0, 0, 0, hwnd, HWND_TOP, IDD_SRCBUT, NULL, NULL) ;
      break;
    case WM_PAINT:
    {
      SHORT xw, yh;
      CHAR szSt[128];
      POINTL pt;

      /*WinInvalidateRegion(hwndClient, NULL, FALSE);*/
      WinInvalidateRegion(hwnd, (HRGN) NULL, TRUE);
      hps = WinBeginPaint(hwnd, (HPS) NULL, &rectl);
      WinFillRect(hps, (PRECTL) &rectl, (LONG) CLR_WHITE);
      GpiSetColor(hps, CLR_BROWN);

      xw = (SHORT) (rectl.xRight); /* Get screen dimensions. */
      yh = (SHORT) (rectl.yTop);/* reclt's are LONG's, covert to short.*/

      pt.x = 5; pt.y = 5;
      strcpy(szSt, "Status:");
      GpiCharStringAt(hps, &pt, (LONG) strlen(szSt), szSt);

      pt.x = 5; pt.y = yh - 15;
      strcpy(szSt, "Tell me about:");
      GpiCharStringAt(hps, &pt, (LONG) strlen(szSt), szSt);

      pt.x = 5; pt.y = yh - 170;
      strcpy(szSt, "Score Size  HEADLINES");
      GpiCharStringAt(hps, &pt, (LONG) strlen(szSt), szSt);

      pt.x = 5; pt.y = yh - 85;
      strcpy(szSt, "Similar to:");
      GpiCharStringAt(hps, &pt, (LONG) strlen(szSt), szSt);

      pt.x = xw / 2; pt.y = yh - 85;
      strcpy(szSt, "Look in these Sources:");
      GpiCharStringAt(hps, &pt, (LONG) strlen(szSt), szSt);

      WinEndPaint(hps);
      break;
    }
/*    case WM_BUTTON1DBLCLK:
    {
      RECTL rectl;
      POINTL ptl;
      LONG index;
      CHAR string[21];

      ptl.x = (LONG) SHORT1FROMMP(mp1);
      ptl.y = (LONG) SHORT2FROMMP(mp1);

      WinQueryWindowRect(hwndResults, (PRECTL) &rectl);
      if(WinPtInRect(hab, &rectl, &ptl) )
      {
/*	SendToStatus("click in results", 0);*/
	WinSendMsg(hwnd, WM_COMMAND, MPFROMSHORT(IDM_DISPLAYDOC), NULL);

	  /*index = (LONG) WinSendMsg(hwndQuestions, LM_QUERYSELECTION,
				     MPFROMSHORT((SHORT )LIT_FIRST),
				     MPFROMP((PSZ)0L) ) ;
                WinSendMsg(hwndQuestions, LM_QUERYITEMTEXT,
			   MPFROM2SHORT( (SHORT) index, (SHORT)20),

			   MPFROMP( (PSZ) string) ) ;

                WinSendMsg(hwndQuery, EM_CLEAR, NULL, NULL) ;
                WinSetWindowText(hwndQuery, (PSZ)string) ;
 
               WinSendMsg(hwndSources, LM_DELETEALL, NULL, NULL) ;
               WinSendMsg(hwndSources, LM_INSERTITEM,
                                                                MPFROMSHORT((SHORT)LIT_SORTASCENDING),
                                                                MPFROMP((PSZ)string) ) ;

		WinAlarm(HWND_DESKTOP,WA_ERROR	) ; *
      }
    }*/
    break;
/*case WM_MINMAXFRAME:
        {
        PSWP    pswp ;
        RECTL  rectl ;
        pswp = PVOIDFROMMP(mp1) ;

	if(hwndSourceList != ((HWND) NULL)) {
                WinQueryWindowRect(hwndSourceList, (PRECTL)&rectl) ;

#ifdef IBMTCP
		if(pswp->width == 1287)
#else
		if(pswp->fs == 1287)
#endif
		       { WinSetWindowPos(hwndSourceList, HWND_TOP,(SHORT) rectl.xLeft, (SHORT)rectl.yBottom,
                                                                (SHORT) (rectl.xRight-rectl.xLeft),(SHORT) (rectl.yTop-rectl.yBottom), SWP_MINIMIZE) ;
                         WinShowWindow(hwndSourceList, FALSE) ;  }

                else
		       { WinSetWindowPos(hwndSourceList, HWND_TOP,(SHORT) rectl.xLeft,(SHORT) rectl.yBottom,
                                                                (SHORT) (rectl.xRight-rectl.xLeft),(SHORT) (rectl.yTop-rectl.yBottom), SWP_RESTORE) ;
                         WinShowWindow(hwndSourceList, TRUE) ; }
        }

        WinDefWindowProc(hwnd, msg, mp1, mp2) ;
break ;
        }
*/
    case WM_SIZE:  /* Now we define the window locations and sizes. */
    {
      SHORT x, y, width, height, xw, yh;

      WinQueryWindowRect(hwnd, (PRECTL) &rectl); /* Get size of client win.*/
      xw = (SHORT) (rectl.xRight); /* Get screen dimensions. */
      yh = (SHORT) (rectl.yTop);/* reclt's are LONG's, covert to short.*/

      x = 70; width = xw - 75;
      y = 1; height = 30;
      WinSetWindowPos(hwndStatus, HWND_TOP, x, y, width, height,
		      SWP_SIZE|SWP_MOVE|SWP_ZORDER|SWP_SHOW);

      x = 5; width = xw - 95;
/*	y = yh * 3 / 4 + 11; height = yh / 4 - 26;*/
      y = yh - 70; height = 50;
      WinSetWindowPos(hwndQuery, HWND_TOP, x, y, width, height,
		      SWP_SIZE|SWP_MOVE|SWP_ZORDER|SWP_SHOW);
      x = 5; width = xw - 10;
/*	y = 26; height = yh / 2 - 26;*/
      y = 26; height = yh - 200;
      WinSetWindowPos(hwndResults, HWND_TOP, x, y, width, height,
		      SWP_SIZE|SWP_MOVE|SWP_ZORDER|SWP_SHOW);

      x = 5; width = xw /2 - 15;
/*	y = yh / 2 + 14; height = yh / 4 - 16;*/
      y = yh - 151; height = 60;
      WinSetWindowPos(hwndDocuments, HWND_TOP, x, y, width, height,
		      SWP_SIZE|SWP_MOVE|SWP_ZORDER|SWP_SHOW);
      x = xw / 2; width = xw /2 - 5;
/*	y = yh / 2 + 14; height = yh / 4 - 16;*/
      y = yh - 151; height = 60;
      WinSetWindowPos(hwndSources, HWND_TOP, x, y, width, height,
		      SWP_SIZE|SWP_MOVE|SWP_ZORDER|SWP_SHOW);
      x = xw - 83; width = 80;
      y = yh - 40; height = 30;
      WinSetWindowPos(hwndSearch, HWND_TOP, x, y, width, height,
		      SWP_SIZE|SWP_MOVE|SWP_ZORDER|SWP_SHOW);
      x = xw - 88; width = 85;
      y = yh - 80; height = 30;
      WinSetWindowPos(hwndSrcbut, HWND_TOP, x, y, width, height,
		      SWP_SIZE|SWP_MOVE|SWP_ZORDER|SWP_SHOW);
      break;
    }
/*    case WM_CHAR:
      SendToStatus("Key pressed.", 0);
      return(TRUE);
      break; */
    case WM_COMMAND:
      switch(LOUSHORT(mp1))
      {
	case IDM_ABOUT:
	  WinDlgBox(HWND_DESKTOP, hwnd, (PFNWP)DlgAboutWP, (HMODULE)NULL,
		    IDD_ABOUT, NULL);
	  break;

        case IDM_HELPINDEX: /* Julie's help stuff */
        {
        CHAR     LoadError[100] ;
        PSZ     Args ;
        PSZ     Envs ;
        RESULTCODES     ReturnCodes ;
        APIRET  rc ;

           Args = "view.exe\0os2wais.inf\0" ;
           Envs = NULL ;

        rc =    DosExecPgm( LoadError,
                                                sizeof(LoadError),
                                                EXEC_ASYNC,
                                                Args,
                                                Envs,
                                                &ReturnCodes,
                                                "view.exe") ;

        if(rc!=0)  /* couldn't load the help program */
        {
                printf("Unable to open Help File 'WAIS.INF'") ;
        }
        break ;
        } /* end case IDM_HELPINDEX */


        

	case IDM_DOCVIEW:
	{
	  hwndEditSource = WinDlgBox(HWND_DESKTOP, hwnd,
				(PFNWP)DlgViewersWP, (HMODULE)NULL,
				IDD_VIEWERS, NULL);
	  break;
	}
	case IDM_NEWSOURCE:
	  if(new_source() != TRUE) break;
	  hwndEditSource = WinDlgBox(HWND_DESKTOP, hwnd,
				       (PFNWP)DlgEditSrcWP, (HMODULE)NULL,
				       IDD_EDITSOURCE, NULL);
	  if(EditSrcReturn == FALSE)
	  {
	    for(loop = 0; loop < MAX_SOURCES; loop++)
	      if(sources[loop] == sel_source)
	      {
		s_free(sources[loop]);
		sources[loop] = NULL; sel_source = NULL;
	      }
	    compress_sources();
	  }
	  if(hwndSourceList != ((HWND) NULL))
	    WinSendMsg(hwndSourceList, WM_CLOSE, NULL, NULL);
	  hwndSourceList = WinLoadDlg(HWND_DESKTOP, HWND_DESKTOP,
				(PFNWP)DlgSourceWP, (HMODULE)NULL,
				IDD_SOURCEMENU, NULL);
	  break;
	case IDM_LISTSOURCES:
	  if(sources_loaded == FALSE)
	  {
	    load_sources(); sources_loaded = TRUE;
	  }
	  if(hwndSourceList != ((HWND) NULL))
	    WinSendMsg(hwndSourceList, WM_CLOSE, NULL, NULL);
	  hwndSourceList = WinLoadDlg(HWND_DESKTOP, HWND_DESKTOP,
				(PFNWP)DlgSourceWP, (HMODULE)NULL,
				IDD_SOURCEMENU, NULL);
	  WinSetFocus(HWND_DESKTOP, hwndSourceList);
	  break;
	case IDM_DISPLAYDOC:
	{
	  LONG index;
	  struct source *src;

	  index = (LONG) WinSendMsg(hwndResults,
		    LM_QUERYSELECTION, MPFROMSHORT(LIT_FIRST), NULL);
	  if(index == (LONG) LIT_NONE)
	  {
	    WinMessageBox(HWND_DESKTOP, hwndFrame,
"No document has been selected.\nClick on a headline first to select it.",
	      "Cannot Display a Document", MBID_MSGBOXID, MB_OK);
	    break;
	  }
/*	  sprintf(szStatus, "You selected %ld.", (LONG) index); SendToStatus(szStatus, 0);*/
	  src = find_nth_selected_source(headline_order[index][0]);
	  if(src != NULL)
	  {
	    Wdisplay_document((WAISSearchResponse *)
((query_responses[headline_order[index][0]])->DatabaseDiagnosticRecords),
			      ((headline_order[index][1]) + 1), src);
	  }
	  break;
	}
	case IDM_USEDOC:
	{
	  long loop, loop2, index, size;
	  struct source *src;
	  WAISSearchResponse *info;
	  any *anydocid;
	  char *newstr, *bytes;

	  index = (LONG) WinSendMsg(hwndResults,
		    LM_QUERYSELECTION, MPFROMSHORT(LIT_FIRST), NULL);
	  if(index == (LONG) LIT_NONE)
	  {
	    WinMessageBox(HWND_DESKTOP, hwndFrame,
"No document has been selected.\nClick on a headline first to select it.",
"Cannot Use a Document for Relevance Feedback", MBID_MSGBOXID, MB_OK);
	    break;
	  }
/*	  sprintf(szStatus, "You selected %ld.", (LONG) index); SendToStatus(szStatus, 0);*/
	  src = find_nth_selected_source(headline_order[index][0]);
	  if(src == NULL)
	  {
	    SendToStatus("Invalid source used.", 0); break;
	  }
/*	  src = sources[headline_order[index][0]];*/
	  for(loop = 0; loop < MAX_FEEDBACK; loop++)
	    if(src->rfdocs[loop] == NULL) break;
	  if(loop == MAX_FEEDBACK)
	  {
	    SendToStatus(
	      "Too many relevance feedback docs to add another one.", 0);
	    break;
	  }
	  info = (WAISSearchResponse *)
	    query_responses[headline_order[index][0]]->
	      DatabaseDiagnosticRecords;

	  size = info->DocHeaders[headline_order[index][1]]->DocumentID->size;
	  bytes = (char *)
		info->DocHeaders[headline_order[index][1]]->DocumentID->bytes;
	  newstr = (char *) s_malloc((size_t) size);
	  for(loop2 = 0; loop2 <= size; loop2++) newstr[loop2] = bytes[loop2];
	  anydocid = makeAny(size, newstr);
/*	      info->DocHeaders[headline_order[index][1]]->DocumentID->size,
	      info->DocHeaders[headline_order[index][1]]->DocumentID->bytes);*/
	  src->rfdocs[loop] = makeDocObjUsingWholeDocument(
	    anydocid,
	    s_strdup(info->DocHeaders[headline_order[index][1]]->Types[0]));
	  sprintf(src->rfheadlines[loop], "%s:%s",
	    lchars(remsrc(src->filename), 20),
	    trim_junk(info->DocHeaders[headline_order[index][1]]->Headline));
	  list_feedback();
	  break;
	}
	case IDM_NOUSEDOC:
	{
	  long loop, loop2, loop3, index, count;

	  index = (LONG) WinSendMsg(hwndDocuments,
		    LM_QUERYSELECTION, MPFROMSHORT(LIT_FIRST), NULL);
	  if(index == (LONG) LIT_NONE)
	  {
	    WinMessageBox(HWND_DESKTOP, hwndFrame,
"No relevance feedback document has been selected.\nClick on a document first to select one.",
"Cannot Remove a Document for Relevance Feedback", MBID_MSGBOXID, MB_OK);
	    break;
	  }
/*	  sprintf(szStatus, "You selected %ld.", (LONG) index); SendToStatus(szStatus, 0);*/
	  count = 0;
	  for(loop = 0; loop < MAX_SOURCES; loop++)
	  {
	    if(sources[loop] == NULL) break;
	    for(loop2 = 0; loop2 < MAX_FEEDBACK; loop2++)
	    {
	      if(sources[loop]->rfdocs[loop2] == NULL) break;
	      if(sources[loop]->selected == TRUE)
	      {
		if(count == index)
		{
		  for(loop3 = loop2; loop3 < MAX_FEEDBACK; loop3++)
		  {
		    sources[loop]->rfdocs[loop3] =
		      sources[loop]->rfdocs[loop3 + 1];
		    strcpy(sources[loop]->rfheadlines[loop3],
		      sources[loop]->rfheadlines[loop3 + 1]);
		  }
		  break;
		}
		count++;
	      }
	    }
	  }
	  count++; /* Skip over single line description. */
	  for(loop = 0; loop < MAX_SOURCES; loop++)
	  {
	    if(sources[loop] == NULL) break;
	    for(loop2 = 0; loop2 < MAX_FEEDBACK; loop2++)
	    {
	      if(sources[loop]->rfdocs[loop2] == NULL) break;
	      if(sources[loop]->selected == FALSE)
	      {
		if(count == index)
		{
		  for(loop3 = loop2; loop3 < MAX_FEEDBACK; loop3++)
		  {
		    sources[loop]->rfdocs[loop3] =
		      sources[loop]->rfdocs[loop3 + 1];
		    strcpy(sources[loop]->rfheadlines[loop3],
		      sources[loop]->rfheadlines[loop3 + 1]);
		  }
		  break;
		}
		count++;
	      }
	    }
	  }
	  list_feedback();
	  break;
	}
	case IDM_EDITSOURCE:
	{
	  LONG index;

	  index = (LONG) WinSendDlgItemMsg(hwndSourceList, IDD_LB_SOURCEMENU,
		    LM_QUERYSELECTION, MPFROMSHORT(LIT_FIRST), NULL);
	  if((index == (LONG) LIT_NONE) || (hwndSourceList == (HWND) NULL))
	  {
	    WinMessageBox(HWND_DESKTOP, hwndFrame,
"No sources have been selected.\nList sources and select one first.\n\
Do you want to list sources?",
	      "Cannot Edit a Source", MBID_MSGBOXID, MB_OKCANCEL);
	    break;
	  }
	  sel_source = sources[index];
/*  This code doesn't work with a single selected item window.
	  index = (LONG) WinSendDlgItemMsg(hwndSourceList, IDD_LB_SOURCEMENU,
			     LM_QUERYSELECTION, MPFROMSHORT(index), NULL);
	  if(index != (LONG) LIT_NONE)
	  {
	    WinMessageBox(HWND_DESKTOP, hwndFrame,
	      (PSZ) "Multiple sources have been selected.\nList sources (^L) and select just one.",
	      "Cannot Edit a Source", MBID_MSGBOXID, MB_OK);
	    break;
	  }
*/
	  hwndEditSource = WinDlgBox(HWND_DESKTOP, hwnd,
				(PFNWP)DlgEditSrcWP, (HMODULE)NULL,
				IDD_EDITSOURCE, NULL);
	  break;
	}
	case IDM_USESOURCE: /* Add selected sources to to-use list. */
	{
	  LONG loop, index;

	  index = (LONG) WinSendDlgItemMsg(hwndSourceList, IDD_LB_SOURCEMENU,
		    LM_QUERYSELECTION, MPFROMSHORT(LIT_FIRST), NULL);
	  if((index == (LONG) LIT_NONE) || (hwndSourceList == (HWND) NULL))
	  {
	    WinMessageBox(HWND_DESKTOP, hwndFrame,
	      (PSZ) "No sources have been selected.\nList sources (^L) and select one first.",
	      "Cannot Use a Source", MBID_MSGBOXID, MB_OK);
	    break;
	  }
	  sources[index]->selected = TRUE;
/*  This is now a single selection listbox, this command hangs.
	  while((index = (LONG) WinSendDlgItemMsg(hwndSourceList, 
			     IDD_LB_SOURCEMENU, LM_QUERYSELECTION,
			     MPFROMSHORT((SHORT) index), NULL)) != LIT_NONE)
	    sources[index]->selected = TRUE;
*/
	  list_selsrc();
	  WinSendMsg(hwndResults, LM_DELETEALL, NULL, NULL); /* Clear results. */
	  list_feedback();  /* Update feedback selected/unselected. */
	  break;
	}
	case IDM_NOUSESOURCE: /* Remove selected sources from to-use list. */
	{
	  USHORT count;
	  LONG index, loop;

	  index = (LONG) WinSendMsg(hwndSources, LM_QUERYSELECTION,
			     MPFROMSHORT(LIT_FIRST), NULL); /* Get selections. */
	  if(index == (LONG) LIT_NONE)
	  {
	    WinMessageBox(HWND_DESKTOP, hwndFrame,
	      (PSZ) "No sources have been selected.\nSelect one from the \"Look in these Sources\" window.",
	      "Cannot Stop Using a Source", MBID_MSGBOXID, MB_OK);
	    break;
	  }
	  unselect_nth_selected_source((USHORT) index); count = 1;
/*  This window only has single selection.  This code doesn't work.
	  while((index = (LONG) WinSendMsg(hwndSources, LM_QUERYSELECTION,
				    MPFROMSHORT((SHORT) index), NULL)) != LIT_NONE)
	  {
	    unselect_nth_selected_source(((SHORT) index) - (SHORT) count); count++;
	  }
*/
	  list_selsrc();
	  WinSendMsg(hwndResults, LM_DELETEALL, NULL, NULL); /* Clear results. */
	  list_feedback();  /* Update feedback selected/unselected. */
	  break;
	}
	case IDM_FLUSHSOURCES: /* Remove all sources from to-use list. */
	{
          unselect_all_sources();
	  list_selsrc();
	  WinSendMsg(hwndResults, LM_DELETEALL, NULL, NULL); /* Clear results. */
	  list_feedback();  /* Update feedback selected/unselected. */
	  break;
	}
	case IDD_SRCBUT:
	{
	  WinSendMsg(hwndFrame, WM_COMMAND, MPFROMSHORT(IDM_LISTSOURCES), NULL);
	  break;
	}
	case IDD_SEARCH:
	{
	  char query_text[128];
	  long bufLen, rbufLen;
	  struct source *src;
	  char UserInfo[500];
	  long src_count;

	  if(WinQueryWindowText(hwndQuery, 128, query_text) == 0)
	  {
	    SendToStatus("Cannot search, no text has been entered.", 0);
	    break;
	  }
	  if(find_nth_selected_source(0) == (struct source *) NULL)
	  {
	    SendToStatus("Cannot search, no sources have been specified.",0);
	    break;
	  }

	  sprintf(szStatus, "Searching on \"%s\".", query_text);
	  SendToStatus(szStatus, 1);
	  if(generate_feedback_list() == FALSE) break;
	  for(src_count = 0; src_count < MAX_SOURCES; src_count++)
	  {
	    if(query_responses[src_count] != NULL)
	    {
	      freeWAISSearchResponse(query_responses[src_count]->DatabaseDiagnosticRecords);
	      freeSearchResponseAPDU(query_responses[src_count]);
	      query_responses[src_count] = NULL;
	    }
	    if((src = find_nth_selected_source(src_count)) == NULL) break;
	    sprintf(szStatus, "Connecting to Server '%s'.", src->ip_name);
	    SendToStatus(szStatus, 0);
	    if(src->ip_name[0] == '\0')
	      connection = connect_to_server(src->ip_address, atol(src->tcp_port));
	    else
	      connection = connect_to_server(src->ip_name, atol(src->tcp_port));
/*	    ioctl(connection, FIONBIO, (char * _Seg16) iptr, 0); /* Set non-blocking io. */
	    if(connection == (long) NULL)
	    {
	      SendToStatus("Unable to connect to Server.", 0); break;
	    }
	    SendToStatus("Initiating Connection . . .", 0);
	    gethostname(szStatus, 80);
	    sprintf(UserInfo, "waissearch %s, from host: %s",
		    VERSION, szStatus);
/*	    SendToStatus(UserInfo, 0);*/
	    if((message_length =
		init_connection(request_message, response_message,
			       message_length, connection, UserInfo)) <= 0)
	    {
	      sprintf(szStatus,
		      "Error opening connection to %s via service %s.",
		      src->ip_name, src->tcp_port);
	      SendToStatus(szStatus, 0);
	      break;
	    }
	    bufLen = message_length;
	    SendToStatus("Connection open, sending query . . .", 0);
	    generate_search_apdu(request_message + HEADER_LENGTH, &bufLen,
		       query_text, src->database_name, feedback_docs, Max_Docs);
	    SendToStatus("Waiting for server to send data . . .", 0);
	    rbufLen = interpret_message(request_message,
				    message_length - bufLen, response_message,
				    message_length, connection, false);
	    SendToStatus("Reading Search Response.", 0);
	    readSearchResponseAPDU(&(query_responses[src_count]),
				   response_message + HEADER_LENGTH);
	    if(query_responses[src_count]->NumberOfRecordsReturned == Max_Docs)
	      sprintf(szStatus, "Number of responses maxed out at %ld.",
		  (LONG) query_responses[src_count]->NumberOfRecordsReturned);
	    else
	      sprintf(szStatus, "Number of responses: %ld.",
		     (LONG) query_responses[src_count]->NumberOfRecordsReturned);
	    SendToStatus(szStatus, 0);
	    soclose(connection);
	  }
	  compute_headline_ordering();
	  WinSendMsg(hwndResults, LM_DELETEALL, NULL, NULL);
	  Wdisplay_search_response();
	  break;
	}
		case IDD_HALT:
                        WinAlarm(HWND_DESKTOP,WA_NOTE) ;
                break ;
         }
 break ;



default: 
        return(WinDefWindowProc(hwnd, msg, mp1,mp2) ) ;

 }


 return(0L) ;
}


/*-------------------------------------------------*/
/* "About" Dialog Box procedure */
/*-------------------------------------------------*/

MRESULT EXPENTRY DlgAboutWP(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
  switch(msg)
  {
    case WM_COMMAND:
	switch(SHORT1FROMMP(mp1))
	{
	  case DID_OK:
	    WinDismissDlg(hwnd, TRUE);
	    break;
	}
	break;
    default:
      return(WinDefDlgProc(hwnd, msg, mp1, mp2));
      break;
  }
  return(FALSE);
}

MRESULT EXPENTRY DlgDelokWP(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
  switch(msg)
  {
    case WM_COMMAND:
      switch(SHORT1FROMMP(mp1))
      {
	case DID_OK:
	  delok = TRUE;
	  WinDismissDlg(hwnd, FALSE);
	  break;
	case DID_CANCEL:
	  delok = FALSE;
	  WinDismissDlg(hwnd, FALSE);
	  break;
      }
      break;
    case WM_INITDLG:
    {
      WinSendDlgItemMsg(hwnd, IDD_LB_DELFILENAME, LM_DELETEALL, NULL, NULL);
      WinSendDlgItemMsg(hwnd, IDD_LB_DELFILENAME, LM_INSERTITEM,
			MPFROMSHORT(LIT_END), (MPARAM)(PSZ) delfilename);
      return((MRESULT) TRUE);
      break;
    }
    case WM_CLOSE:
      WinDestroyWindow(hwnd);
      break;
    default:
      return(WinDefDlgProc(hwnd, msg, mp1, mp2));
      break;
  }
}
MRESULT EXPENTRY DlgSourceWP(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
  switch(msg)
  {
    case WM_BUTTON1DBLCLK:
    {
/*	SendToStatus("Double click in sources.", 0);*/
      WinSendMsg(hwndFrame, WM_COMMAND, MPFROMSHORT(IDM_USESOURCE), NULL);
      WinSetFocus(HWND_DESKTOP, hwndQuery);
      break;
    }
    case WM_COMMAND:
      switch(SHORT1FROMMP(mp1))
      {
	case SRCBUT_DELETE:
	{
	  LONG loop, index;

	  index = (LONG) WinSendDlgItemMsg(hwndSourceList, IDD_LB_SOURCEMENU,
		    LM_QUERYSELECTION, MPFROMSHORT(LIT_FIRST), NULL);
	  if((index == (LONG) LIT_NONE) || (hwndSourceList == (HWND) NULL))
	  {
	    WinMessageBox(HWND_DESKTOP, hwndFrame,
	      (PSZ) "No sources have been selected.\nList sources (^L) and select one first.",
	      "Cannot Delete a Source", MBID_MSGBOXID, MB_OK);
	    break;
	  }
	  delete_source(index, hwndSourceList);
/*  This listbox only allow single selections now.  This loop goes infinite. 
	  while((index = (LONG) WinSendDlgItemMsg(hwndSourceList,
			     IDD_LB_SOURCEMENU, LM_QUERYSELECTION,
			     MPFROMSHORT((SHORT) index), NULL)) != LIT_NONE)
	    delete_source(index, hwndSourceList);
*/
	  compress_sources();

	  WinSendDlgItemMsg(hwnd, IDD_LB_SOURCEMENU, LM_DELETEALL, NULL, NULL);
	  for(loop = 0; loop < MAX_SOURCES; loop++)
	    if(sources[loop] != (struct source *) NULL)
	      WinSendDlgItemMsg(hwnd, IDD_LB_SOURCEMENU, LM_INSERTITEM,
				MPFROMSHORT(LIT_END),
			       (MPARAM)(PSZ) remsrc(sources[loop]->filename));
	  break;
	}
	case SRCBUT_OK:
	  WinSendMsg(hwndFrame, WM_COMMAND, MPFROMSHORT(IDM_USESOURCE), NULL);
	  WinSetFocus(HWND_DESKTOP, hwndQuery);
	  break;
	case SRCBUT_EDIT:
	  WinSendMsg(hwndFrame, WM_COMMAND, MPFROMSHORT(IDM_EDITSOURCE), NULL);
	  break;
	case SRCBUT_CANCEL:
	  WinDismissDlg(hwnd, FALSE);
	  hwndSourceList = (HWND) NULL;
	  break;
      }
      break;
    case WM_INITDLG:
    {
      LONG loop;

      WinSendMsg(hwndSourceList, LM_DELETEALL, NULL, NULL);
      for(loop = 0; loop < MAX_SOURCES; loop++)
	if(sources[loop] != (struct source *) NULL)
	  WinSendDlgItemMsg(hwnd, IDD_LB_SOURCEMENU, LM_INSERTITEM,
		     MPFROMSHORT(LIT_END),
		     (MPARAM)(PSZ) remsrc(sources[loop]->filename));
      return((MRESULT) TRUE);
      break;
    }
    case WM_CLOSE:
	WinDestroyWindow(hwnd);
	hwndSourceList = (HWND) NULL;
      break;
    default:
      return(WinDefDlgProc(hwnd, msg, mp1, mp2));
  }
}

void write_mle_entry(HWND hwnd, long idd, char *field)
{
  char buffer[LARGE_STR_LEN];
  long count;
  IPT charnum;

  WinSendDlgItemMsg(hwnd, idd, MLM_SETIMPORTEXPORT,
		    MPFROMP(buffer), MPFROMLONG((LONG) LARGE_STR_LEN));
  count = (LONG) WinSendDlgItemMsg(hwnd, idd, MLM_QUERYTEXTLENGTH,
				   NULL, NULL);
  buffer[count] = '\0';
  charnum = 0;
  WinSendDlgItemMsg(hwnd, idd, MLM_EXPORT, &charnum, &count);
/*  sprintf(szStatus, "count %ld, chold %ld text '%s'", count, (LONG) charnum, buffer);
  SendToStatus(szStatus, 0L);*/
  strcpy(field, buffer);
}

MRESULT EXPENTRY ViewerWP(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
  if(msg == WM_CHAR)  /* If the enter key was pressed, ignore it. */
  {
    if((0xFF & SHORT1FROMMP(mp2)) == 0xD)
      return((MRESULT) TRUE);
    if((0xFF & SHORT1FROMMP(mp2)) == 0x9)
      return((MRESULT) TRUE);
  }
  return((*OrigViewerWP)(hwnd, msg, mp1, mp2)); /* Otherwise process. */
}

MRESULT EXPENTRY DlgEditSrcWP(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
  switch(msg)
  {
    case WM_COMMAND:
      switch(SHORT1FROMMP(mp1))
      {
	case DID_OK:
	  write_mle_entry(hwnd, IDD_MLE_VERSION, sel_source->version);
	  write_mle_entry(hwnd, IDD_MLE_IPADDRESS, sel_source->ip_address);
	  write_mle_entry(hwnd, IDD_MLE_IPNAME, sel_source->ip_name);
	  write_mle_entry(hwnd, IDD_MLE_TCPPORT, sel_source->tcp_port);
	  write_mle_entry(hwnd, IDD_MLE_DBNAME, sel_source->database_name);
	  write_mle_entry(hwnd, IDD_MLE_COST, sel_source->cost);
	  write_mle_entry(hwnd, IDD_MLE_COSTUNIT, sel_source->cost_unit);
	  write_mle_entry(hwnd, IDD_MLE_MAINTAINER, sel_source->maintainer);
	  write_mle_entry(hwnd, IDD_MLE_DESCRIPTION, sel_source->description);
	  write_mle_entry(hwnd, IDD_MLE_FILENAME, sel_source->filename);
	  write_source(sel_source);
	  EditSrcReturn = TRUE;
	  WinDismissDlg(hwnd, FALSE);
	  break;
	case DID_CANCEL:
	  EditSrcReturn = FALSE;
	  WinDismissDlg(hwnd, FALSE);
	  break;
      }
      break;
    case WM_INITDLG:
    {
      long count;
      IPT charnum;

      OrigViewerWP = WinSubclassWindow(WinWindowFromID(hwnd, IDD_MLE_VERSION),
				       (PFNWP) ViewerWP);
      WinSendDlgItemMsg(hwnd, IDD_MLE_VERSION, MLM_INSERT,
			sel_source->version, NULL);
      OrigViewerWP = WinSubclassWindow(
		WinWindowFromID(hwnd, IDD_MLE_IPADDRESS), (PFNWP) ViewerWP);
      WinSendDlgItemMsg(hwnd, IDD_MLE_IPADDRESS, MLM_INSERT,
			sel_source->ip_address, NULL);
      OrigViewerWP = WinSubclassWindow(
		WinWindowFromID(hwnd, IDD_MLE_IPNAME), (PFNWP) ViewerWP);
      WinSendDlgItemMsg(hwnd, IDD_MLE_IPNAME, MLM_INSERT,
			sel_source->ip_name, NULL);
      OrigViewerWP = WinSubclassWindow(
		WinWindowFromID(hwnd, IDD_MLE_TCPPORT), (PFNWP) ViewerWP);
      WinSendDlgItemMsg(hwnd, IDD_MLE_TCPPORT, MLM_INSERT,
			sel_source->tcp_port, NULL);
      OrigViewerWP = WinSubclassWindow(
		WinWindowFromID(hwnd, IDD_MLE_DBNAME), (PFNWP) ViewerWP);
      WinSendDlgItemMsg(hwnd, IDD_MLE_DBNAME, MLM_INSERT,
			sel_source->database_name, NULL);
      OrigViewerWP = WinSubclassWindow(
		WinWindowFromID(hwnd, IDD_MLE_COST), (PFNWP) ViewerWP);
      WinSendDlgItemMsg(hwnd, IDD_MLE_COST, MLM_INSERT,
			sel_source->cost, NULL);
      OrigViewerWP = WinSubclassWindow(
		WinWindowFromID(hwnd, IDD_MLE_COSTUNIT), (PFNWP) ViewerWP);
      WinSendDlgItemMsg(hwnd, IDD_MLE_COSTUNIT, MLM_INSERT,
			sel_source->cost_unit, NULL);
      OrigViewerWP = WinSubclassWindow(
		WinWindowFromID(hwnd, IDD_MLE_MAINTAINER), (PFNWP) ViewerWP);
      WinSendDlgItemMsg(hwnd, IDD_MLE_MAINTAINER, MLM_INSERT,
			sel_source->maintainer, NULL);
      OrigViewerWP = WinSubclassWindow(
		WinWindowFromID(hwnd, IDD_MLE_DESCRIPTION), (PFNWP) ViewerWP);
      WinSendDlgItemMsg(hwnd, IDD_MLE_DESCRIPTION, MLM_SETTEXTLIMIT,
			MPFROMLONG((LONG) LARGE_STR_LEN), NULL);
      WinSendDlgItemMsg(hwnd, IDD_MLE_DESCRIPTION, MLM_INSERT,
			sel_source->description, NULL);
      OrigViewerWP = WinSubclassWindow(
		WinWindowFromID(hwnd, IDD_MLE_FILENAME), (PFNWP) ViewerWP);
      WinSendDlgItemMsg(hwnd, IDD_MLE_FILENAME, MLM_INSERT,
			sel_source->filename, NULL);
      WinSetFocus(HWND_DESKTOP, hwnd);

      return((MRESULT) TRUE);
      break;
    }
    default:
      return(WinDefDlgProc(hwnd, msg, mp1, mp2));
      break;
  }
}

void load_viewers()
{
  long loop;
  FILE *fp;

  for(loop = 0; loop < 6; loop++)
  {
    strcpy(&(viewers[loop][0][0]), "none");
    strcpy(&(viewers[loop][1][0]), "none");
  }

  if((fp = fopen("viewers.txt", "r")) == NULL) return;

  for(loop = 0; loop < 6; loop++)
    fscanf(fp, " %s %s", &(viewers[loop][0][0]), &(viewers[loop][1][0]));
  fclose(fp);
}

void write_viewers()
{
  long loop;
  FILE *fp;

  if((fp = fopen("viewers.txt", "w")) == NULL) return;

  for(loop = 0; loop < 6; loop++)
    fprintf(fp, " %s %s\n", &(viewers[loop][0][0]), &(viewers[loop][1][0]));
  fclose(fp);
}

void determine_viewer_program(char *type, char *view_prog)
{
  long loop;

  for(loop = 0; loop < 6; loop++)
  {
    if(stricmp(&(viewers[loop][0][0]), type) == 0)
    {
      if(stricmp(&(viewers[loop][1][0]), "none") == 0)
	strcpy(view_prog, DEFAULT_VIEWER);
      else strcpy(view_prog, &(viewers[loop][1][0]));
      return;
    }
  }
  strcpy(view_prog, DEFAULT_VIEWER);
}

MRESULT EXPENTRY DlgViewersWP(HWND hwnd, USHORT msg, MPARAM mp1, MPARAM mp2)
{
  switch(msg)
  {
    case WM_COMMAND:
      switch(SHORT1FROMMP(mp1))
      {
	case DID_OK:
	  write_mle_entry(hwnd, IDD_MLE_T1, &(viewers[0][0][0]));
	  write_mle_entry(hwnd, IDD_MLE_V1, &(viewers[0][1][0]));
	  write_mle_entry(hwnd, IDD_MLE_T2, &(viewers[1][0][0]));
	  write_mle_entry(hwnd, IDD_MLE_V2, &(viewers[1][1][0]));
	  write_mle_entry(hwnd, IDD_MLE_T3, &(viewers[2][0][0]));
	  write_mle_entry(hwnd, IDD_MLE_V3, &(viewers[2][1][0]));
	  write_mle_entry(hwnd, IDD_MLE_T4, &(viewers[3][0][0]));
	  write_mle_entry(hwnd, IDD_MLE_V4, &(viewers[3][1][0]));
	  write_mle_entry(hwnd, IDD_MLE_T5, &(viewers[4][0][0]));
	  write_mle_entry(hwnd, IDD_MLE_V5, &(viewers[4][1][0]));
	  write_mle_entry(hwnd, IDD_MLE_T6, &(viewers[5][0][0]));
	  write_mle_entry(hwnd, IDD_MLE_V6, &(viewers[5][1][0]));
	  write_viewers();
	  WinDismissDlg(hwnd, FALSE);
	  break;
	case DID_CANCEL:
	  WinDismissDlg(hwnd, FALSE);
	  break;
      }
      break;
    case WM_INITDLG:
    {
      long count;
      IPT charnum;

      OrigViewerWP = WinSubclassWindow(WinWindowFromID(hwnd, IDD_MLE_T1),
				       (PFNWP) ViewerWP);
      OrigViewerWP = WinSubclassWindow(WinWindowFromID(hwnd, IDD_MLE_V1),
				       (PFNWP) ViewerWP);
      OrigViewerWP = WinSubclassWindow(WinWindowFromID(hwnd, IDD_MLE_T2),
				       (PFNWP) ViewerWP);
      OrigViewerWP = WinSubclassWindow(WinWindowFromID(hwnd, IDD_MLE_V2),
				       (PFNWP) ViewerWP);
      OrigViewerWP = WinSubclassWindow(WinWindowFromID(hwnd, IDD_MLE_T3),
				       (PFNWP) ViewerWP);
      OrigViewerWP = WinSubclassWindow(WinWindowFromID(hwnd, IDD_MLE_V3),
				       (PFNWP) ViewerWP);
      OrigViewerWP = WinSubclassWindow(WinWindowFromID(hwnd, IDD_MLE_T4),
				       (PFNWP) ViewerWP);
      OrigViewerWP = WinSubclassWindow(WinWindowFromID(hwnd, IDD_MLE_V4),
				       (PFNWP) ViewerWP);
      OrigViewerWP = WinSubclassWindow(WinWindowFromID(hwnd, IDD_MLE_T5),
				       (PFNWP) ViewerWP);
      OrigViewerWP = WinSubclassWindow(WinWindowFromID(hwnd, IDD_MLE_V5),
				       (PFNWP) ViewerWP);
      OrigViewerWP = WinSubclassWindow(WinWindowFromID(hwnd, IDD_MLE_T6),
				       (PFNWP) ViewerWP);
      OrigViewerWP = WinSubclassWindow(WinWindowFromID(hwnd, IDD_MLE_V6),
				       (PFNWP) ViewerWP);

      WinSendDlgItemMsg(hwnd, IDD_MLE_T1, MLM_INSERT,
			&(viewers[0][0][0]), NULL);
      WinSendDlgItemMsg(hwnd, IDD_MLE_V1, MLM_INSERT,
			&(viewers[0][1][0]), NULL);
      WinSendDlgItemMsg(hwnd, IDD_MLE_T2, MLM_INSERT,
			&(viewers[1][0][0]), NULL);
      WinSendDlgItemMsg(hwnd, IDD_MLE_V2, MLM_INSERT,
			&(viewers[1][1][0]), NULL);
      WinSendDlgItemMsg(hwnd, IDD_MLE_T3, MLM_INSERT,
			&(viewers[2][0][0]), NULL);
      WinSendDlgItemMsg(hwnd, IDD_MLE_V3, MLM_INSERT,
			&(viewers[2][1][0]), NULL);
      WinSendDlgItemMsg(hwnd, IDD_MLE_T4, MLM_INSERT,
			&(viewers[3][0][0]), NULL);
      WinSendDlgItemMsg(hwnd, IDD_MLE_V4, MLM_INSERT,
			&(viewers[3][1][0]), NULL);
      WinSendDlgItemMsg(hwnd, IDD_MLE_T5, MLM_INSERT,
			&(viewers[4][0][0]), NULL);
      WinSendDlgItemMsg(hwnd, IDD_MLE_V5, MLM_INSERT,
			&(viewers[4][1][0]), NULL);
      WinSendDlgItemMsg(hwnd, IDD_MLE_T6, MLM_INSERT,
			&(viewers[5][0][0]), NULL);
      WinSendDlgItemMsg(hwnd, IDD_MLE_V6, MLM_INSERT,
			&(viewers[5][1][0]), NULL);
      WinSetFocus(HWND_DESKTOP, hwnd);

      return((MRESULT) TRUE);
      break;
    }
    default:
      return(WinDefDlgProc(hwnd, msg, mp1, mp2));
      break;
  }
}
