/* WIDE AREA INFORMATION SERVER SOFTWARE
   No guarantees or restrictions.  See the readme file for the full standard
   disclaimer.  
  
   3.26.90	Harry Morris, morris@think.com
   4.11.90  HWM - generalized conditional includes (see c-dialect.h)
*/

#ifndef _H_C_util_
#define _H_C_util_

#include "cdialect.h"

#include <stdio.h>   /* this used to be wrapped in an ifndef NULL,
			but messed up on some gcc's */
#ifdef THINKC
#include <time.h>
#else
#include <time.h>
#endif

#define MAX_FILENAME_LEN 255

#ifdef ANSI_LIKE
#ifndef EXIT_SUCCESS /* only include it if not already included */
#include <stdlib.h> /* this is a shame */
#endif /* ndef EXIT_SUCCESS */
#else	
#include "ustubs.h"
#endif /* else */

/*----------------------------------------------------------------------*/
/* types and constants */

#ifndef boolean
#define boolean	unsigned long
#endif /* ndef boolean */ 

#ifndef THINK_C
#ifndef Boolean
#define Boolean	boolean
#endif /* ndef Boolean */ 
#endif /* ndef THINK_C */

#ifndef true
#define true 	(boolean)1L
#endif /* ndef true */

#ifndef false
#define false 	(boolean)0L   /* used to be (!true), but broke 
				 some compilers */
#endif /* ndef false */

#ifndef TRUE
#define TRUE	true
#endif /* ndef TRUE */

#ifndef FALSE
#define FALSE	false
#endif /* ndef FALSE */

#ifndef NULL
#define NULL	0L
#endif /* ndef NULL */

/*----------------------------------------------------------------------*/
/* Fast string macros - warning don't pass NULL to these! */

#define STREQ(s1,s2) ((*(s1)==*(s2)) && !strcmp(s1,s2))
#define STRNCMP(s1,s2,n) \
    ((*(s1)==*(s2)) ? strncmp(s1,s2,n) : (*(s1) - *(s2)))

/*----------------------------------------------------------------------*/
/* convenience */

#define nl() printf("\n")

/*----------------------------------------------------------------------*/
/* functions */

#ifdef __cplusplus
/* declare these as C style functions */
extern "C"
	{
#endif /* def __cplusplus */

/* enhanced memory handling functions - don't call them directly, use the
   macros below */
void	fs_checkPtr _AP((void* ptr));
void*	fs_malloc _AP((size_t size));
void*	fs_realloc _AP((void* ptr,size_t size));
void	fs_free _AP((void* ptr));
char* 	fs_strncat _AP((char* dst,char* src,size_t maxToAdd,size_t maxTotal));

/* macros for memory functions.  call these in your program.  */
#define s_checkPtr(ptr) 	fs_checkPtr(ptr)
#define s_malloc(size)	      	fs_malloc(size)
#define s_realloc(ptr,size)	fs_realloc((ptr),(size))
#define s_free(ptr)		{ fs_free((char*)ptr); ptr = NULL; }
#define s_strncat(dst,src,maxToAdd,maxTotal)	fs_strncat((dst),(src),(maxToAdd),(maxTotal))

char* 	s_strdup _AP((char* s));

char*	strtokf _AP((char* s1,long (*isDelimiter)(long c))); 

#define IS_DELIMITER	1
#define	NOT_DELIMITER	!IS_DELIMITER

#ifdef ANSI_LIKE	/* use ansi */
long		cprintf _AP((boolean print,char* format,...));
#else /* use K & R */
long		cprintf _AP(());
#endif

#ifdef ANSI_LIKE	/* use ansi */
void		waislog _AP((char* format,...));
#else /* use K & R */
#ifdef BSD

#define waislog printf("\n%d: %s ", getpid(), printable_time()); printf

#else
void		waislog _AP(());
#endif /* BSD */
#endif /* ANSI_LIKE */
/* waislog priorities and messages */
/* this is backwards because of how wais_log_level works. */
#define WLOG_HIGH	1
#define WLOG_MEDIUM 	5
#define WLOG_LOW	9

#define WLOG_CONNECT	1
#define WLOG_CLOSE	2
#define WLOG_SEARCH	3
#define WLOG_RESULTS	4
#define WLOG_RETRIEVE	5
#define WLOG_INDEX	6
#define WLOG_INFO	100
#define WLOG_ERROR	-1
#define WLOG_WARNING	-2


void 	warn _AP((char* message));

boolean substrcmp _AP((char *string1, char *string2));
#ifndef MAX
#define MAX(x,y) (((x) > (y)) ? (x) : (y))
#endif
#ifndef MIN
#define MIN(x,y) (((x) < (y)) ? (x) : (y))
#endif
#define ABS(x) (((x) < 0) ? (-(x)) : (x))

char *printable_time _AP((void));

char char_downcase _AP((unsigned long ch));
char *string_downcase _AP((char* w));


char *next_arg _AP((int *argc, char ***argv));
char *peek_arg _AP((int *argc, char ***argv));

void		beFriendly _AP((void));

#ifdef __cplusplus
	}
#endif /* def __cplusplus */

/*----------------------------------------------------------------------*/

#endif /* ndef _H_C_util_ */

