/*==================================================================+
|                                                                   |
|  IBM Confidential                                                 |
|  Copyright (c) IBM Corporation 1992,1996.                         |
|  Property of IBM Corporation.                                     |
|  All Rights Reserved.                                             |
|                                                                   |
|  Origins 30 (IBM)                                                 |
|                                                                   |
+==================================================================*/
/* External API definitions for THESEUS2, level 0:
     Level 0 has:
       1. Initialization.
       2. Things that are common to all modes of operation.
       3. System Working Set computations.
*/

/******************************************************************************/
/* Handle0 definitions:                                                       */
/******************************************************************************/
#ifndef T2HANDLE0_defined
  typedef unsigned long T2HANDLE0;
  #define T2HANDLE0_defined
#endif

/******************************************************************************/
/* Initialization definitions:                                                */
/******************************************************************************/
/* Following is prototype of the error "call-back" routine which must be
   implemented by the caller of the level 0 functions.  */
#ifndef error_handler0_defined
#ifdef __IBMC__
  typedef void (* EXPENTRY ERROR_HANDLER0) (T2HANDLE0 t2handle0, ULONG error_code, ULONG p1, ULONG p2);
#else
  typedef void (EXPENTRY *ERROR_HANDLER0) (T2HANDLE0 t2handle0, ULONG error_code, ULONG p1, ULONG p2);
#endif
#endif
  /* The errors returned are (printf's used by THESEUS2 are included):
     error_code p1      p2      explanation
                            Following are returned by "read_linear":
          1     linear  n/a     The starting address (linear) has no page table.
                                printf( ">>> Linear address: no Page Table, linear=%0.8X.\n", p1);
          2     linear  length  The ending address (linear+length-1) has no page table.
                                printf( ">>> Linear address+length: no Page Table, linear=%0.8X, length=%0.8X.\n", p1, p2);
          3     linear  n/a     The page at the starting address is not present.
                                printf( ">>> Linear address: page not present, linear=%0.8X.\n", p1);
          4     linear  length  The page at the ending address (linear+length-1) is not present.
                                printf( ">>> Linear address+Length: page not present, linear=%0.8X, length=%0.8X.\n", p1, p2);
          5     linear  length  The address+length is greater than 32 bits.
                                printf( ">>> Linear address+Length: > 32 bits, linear=%0.8X, length=%0.8X.\n", p1, p2);
                            Following is from "working set" initialization:
          6     linear  n/a     The header for the System Arena was not located.
                                The value found is returned, but is not valid.
                                System Working Set cannot be measured.
                                printf( "SystemArenaHeaderLinear = %0.8X.\n", p1);
                                printf( "SystemArenaHeaderLinear was not properly located.\n");
                                printf( "System Working Set cannot be measured.\n");
          ?                     Unknown error
                                printf( "unknown error to error_handler0: error_code=%i, p1=%i, p2=%i.\n", error_code, p1, p2);
  */

ULONG EXPENTRY T2Initialize0( ULONG          *ulDDVersion,
                              ERROR_HANDLER0  error_handler0);
  /* Return code values: */
  #define Theseus2OK            0
  #define Theseus2NoDD          1
  #define Theseus2WrongDD       2
  #define Theseus2BadPTDA       3
  #define Theseus2NoMte         4
VOID EXPENTRY T2Terminate0( VOID );

/******************************************************************************/
/* Handle0 definitions (continued):                                           */
/******************************************************************************/
T2HANDLE0 EXPENTRY T2GetHandle0( ERROR_HANDLER0 error_handler0);
VOID      EXPENTRY T2ReleaseHandle0( T2HANDLE0 *t2handle0);

/******************************************************************************/
/* Free, Idle, and Locked Memory definitions:                                 */
/******************************************************************************/
/* Function definitions: */
VOID EXPENTRY T2FreeMemory( T2HANDLE0 t2handle0,
                            PULONG    freeRam,   /* # of bytes free. */
                            PULONG    idleRam,   /* # of bytes idle. */
                            PULONG    dirtyRam,  /* # of bytes dirty. */
                            PULONG    LLockRam,  /* # of bytes locked long-term. */
                            PULONG    SLockRam,  /* # of bytes locked short-term. */
                            PULONG    BLockRam); /* # of bytes locked BOTH short- & long-term. */

/******************************************************************************/
/* SWAPPER.DAT analysis definitions:                                          */
/******************************************************************************/
/* Function definitions: */
VOID EXPENTRY T2AnalyzeSwapper( T2HANDLE0 t2handle0,
                                PULONG    SwapUsed,  /* Count of used disk frames in SWAPPER.DAT */
                                PULONG    SwapFree); /* Count of free disk frames in SWAPPER.DAT */

/******************************************************************************/
/* Process List definitions:                                                  */
/******************************************************************************/
/* Constants: */
        /* Maximum # of processes which are allowed. */
        /* (This is the maximum allowed by OS/2 2.0.) */
#define MaxProcesses 4096
        /* Maximum length of a process name (excluding the trailing NULL). */
        /* This is a THESEUS restriction, not a system restriction. */
#define MaxProcessNameLength 8

/* Structure definitions: */
struct  _ProcessTableElement {
        USHORT  ptdaPID;        /* PID of this process        */
        USHORT  pidParent;      /* PID of parent              */
        USHORT  cThreads;       /* # of threads found         */
        CHAR    processName [MaxProcessNameLength+1];/* name of the process */
        };
typedef struct _ProcessTableElement PROCESS_TABLE_ELEMENT;
struct  _ProcessTable {
        PROCESS_TABLE_ELEMENT ProcessTable [MaxProcesses];
        };
typedef struct _ProcessTable T2PROCESS_TABLE;

/* Function definitions: */
ULONG EXPENTRY T2FindProcesses( T2HANDLE0         t2handle0,
                                T2PROCESS_TABLE **ProcessTable);

/******************************************************************************/
/* RAM List definitions:                                                      */
/******************************************************************************/
/* Structure definitions: */
struct  _ProcessRamElement {
        USHORT  ptdaPID;        /* PID of this process               */
        ULONG   ulPrivate;      /* Private RAM for this process      */
        ULONG   ulShared;       /* Owned-shared RAM for this process */
        CHAR    processName [MaxProcessNameLength+2];/* name of the process */
        };
typedef struct _ProcessRamElement PROCESS_RAM_ELEMENT;
struct  _RamTable {
        PROCESS_RAM_ELEMENT RamTable [MaxProcesses];
        };
typedef struct _RamTable T2RAM_TABLE;

/* Function definitions: */
ULONG EXPENTRY T2RamUseByProcess( T2HANDLE0     t2handle0,
                                  T2RAM_TABLE **RamTable,
                                  PULONG        FreeRam);

/******************************************************************************/
/* Working Set definitions:                                                   */
/******************************************************************************/
#ifndef WS_HANDLE0_defined
  typedef unsigned long WS_HANDLE0;
  #define WS_HANDLE0_defined
#endif
/* Return code definitions: */
#define T2WS_OK              0
#define T2WS_InUse           1
#define T2WS_SystemBeingDone 2
#define T2WS_InvalidHandle   3
#define T2WS_BadArena        4
#define T2WS_PidNotFound     5

/* Function definitions: */
ULONG EXPENTRY T2WSStart( T2HANDLE0   t2handle0,
                          WS_HANDLE0 *ws_handle0,
                          USHORT      ulPID);
  /* Return values are: T2WS_OK, T2WS_InUse, T2WS_SystemBeingDone,
                        T2WS_BadArena, T2WS_PidNotFound. */

ULONG EXPENTRY T2WSSystemTick( WS_HANDLE0 ws_handle0,
                               int        iIntervalsForWS,
                               PULONG     ulNow,
                               PULONG     ulWS,
                               PULONG     ulAccessed,
                               PULONG     ulFree,
                               PULONG     ulIdle,
                               PULONG     ulProcessesUsed,
                               PULONG     ulProcessCount,
                               PULONG     ulResident,
                               PULONG     ulTotalRam);
  /* Return values are: T2WS_OK or T2WS_InvalidHandle. */

ULONG EXPENTRY T2WSProcessTick( WS_HANDLE0 ws_handle0,
                                int        iIntervalsForWS,
                                PULONG     ulNow,
                                PULONG     ulWS,
                                PULONG     ulAccessed,
                                PULONG     ulTotalRam,
                                PULONG     ulSysNow );
ULONG EXPENTRY T2WSProcessTick2( WS_HANDLE0 ws_handle0,
                                 int        iIntervalsForWS,
                                 PULONG     ulNow,
                                 PULONG     ulWS,
                                 PULONG     ulAccessed,
                                 PULONG     ulDllNow,
                                 PULONG     ulDllWS,
                                 PULONG     ulDllAccessed,
                                 PULONG     ulTotalRam,
                                 PULONG     ulSysNow );
  /* Return values are: T2WS_OK, T2WS_InvalidHandle, or T2WS_PidNotFound. */

ULONG EXPENTRY T2WSStop( WS_HANDLE0 *ws_handle0,
                         BOOL       fCollectOne,
                         PINT       iIntervals,
                         PULONG     ulMinimum,
                         PULONG     ulRecommended,
                         PULONG     ulAccessed);
ULONG EXPENTRY T2WSStop2( WS_HANDLE0 *ws_handle0,
                          BOOL       fCollectOne,
                          PINT       iIntervals,
                          PULONG     ulMinimum,
                          PULONG     ulRecommended,
                          PULONG     ulAccessed,
                          PULONG     ulDllMinimum,
                          PULONG     ulDllRecommended,
                          PULONG     ulDllAccessed);
  /* Return values are: T2WS_OK or T2WS_InvalidHandle. */

BOOL  EXPENTRY T2WSCheck( USHORT ulPidToCheck);
  /* Return values are:
     TRUE  = Working set data can be requested for the process or system.
     FALSE = Working set data cannot be requested for the process or system. */
