/* Small hardware monitor for the Asus P2L97 mainboard
 *   OS/2-EMX
 *
 *   bjorn@mork.no
 */

#include "p2l97.h"
#include "version.h"

void fanprint(char *title, short tick, short fandiv)
{
  if (tick!=255)
    printf("%s %d RPM\n", title, LM78_RPM(tick,fandiv));
}

void main()
{
  int i;

  printf("LM78 monitor for ASUS mainboards\nVersion %s\n\n",VERSION);
  LM78_INIT;
  if (LM78_EXIST)
  {
    fanprint("\tChassis fan\t:", LM78_READ(LM78_FAN1), LM78_FANDIV1);
    fanprint("\tCPU fan\t\t:", LM78_READ(LM78_FAN2), LM78_FANDIV2);
    fanprint("\tPower fan\t:", LM78_READ(LM78_FAN3), LM78_FANDIV3);
    i = LM78_READ(LM78_TEMP);
    printf("\n\tMB temperature\t:%3dC/%3dF\n", i, i*9/5+32 );
    printf("\n\tVcore voltage\t:%6.1f V\n", P2L97_VCORE);
    printf("\t+3.3V voltage\t:%6.1f V\n", P2L97_3_3V);
    printf("\t+5V   voltage\t:%6.1f V\n", P2L97_5V);
    printf("\t+12V  voltage\t:%6.1f V\n", P2L97_12V);
    printf("\t-12V  voltage\t:%6.1f V\n", P2L97_M12V);
    printf("\t-5V   voltage\t:%6.1f V\n", P2L97_M5V);
  }
  else printf("\nERROR: Cannot find an LM78 at port %#hx\n", LM78_BASE );
}
