/*
 *  Project: NICE/2
 *
 *  By Sharon Dagan <idagan@il.ibm.com>
 *
 *  $Id: nice.h,v 1.1 1998/12/16 16:04:35 sdagan Exp sdagan $
 *  $Date: 1998/12/16 16:04:35 $
 *
 **/

#ifndef _NICE_H_
#define _NICE_H_


#define INCL_DOS
#include <os2.h>


/*
 *  Function: NiceSetPriority
 *  Parameters:
 *      pid (input)     - PID of the process
 *      tid (input)     - TID of the thread. If TID is 0, all threads within the
 *                        given PID will be altered. TID > 0 is valid for PM
 *                        processes only
 *      ulClass (input) - Priority class (See OS/2's DosSetPriority)
 *                        0  PRTYC_NOCHANGE          no change, leave as is
 *                        1  PRTYC_IDLETIME          idle-time
 *                        2  PRTYC_REGULAR           regular
 *                        3  PRTYC_TIMECRITICAL      time critical
 *                        4  PRTYC_FOREGROUNDSERVER  server
 *
 *      lDelta (input)  - This value must range from -31 (PRTYD_MINIMUM) to +31
 *                        (PRTYD_MAXIMUM).
 *  Returns:
 *      rc = 0  - successful
 *      rc != 0 - some error
 *
 **/

APIRET NiceSetPriority( PID pid,
                        TID tid,
                        ULONG ulClass,
                        LONG  lDelta );


/*
 *  Function: NiceStatus
 *  Parameters: none
 *  Returns:
 *      rc = 0 - NICE/2 engine is not running
 *      rc > 0 - NICE/2 engine is running under the PID = rc
 *
 **/

APIRET NiceStatus( VOID );


#endif
