/* REXX: lower.cmd */

/* Author:  Kai Uwe Rommel <rommel@ars.muc.de>
 * Created: Nov-01-1994
 *
 * Options -f and -x contributed on Nov-24-1994 by Frank Luderer 
 * <luderer@texas.inf-gr.htw-zittau.de>
 *
 * $Id: lower.cmd,v 1.2 1994/12/16 08:09:08 rommel Exp $
 * $Revision: 1.2 $
 */

/*
 * $Log: lower.cmd,v $
 * Revision 1.2  1994/12/16 08:09:08  rommel
 * added contribution of -f and -x by Frank Luderer
 *
 * Revision 1.1  1994/11/18 09:58:25  rommel
 * Initial revision
 * 
 */

Call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
Call SysLoadFuncs

Arg args

If args='' Then Do
  Say
  Say 'Usage: lower [-slu] <arg> ...'
  Say
  Say '       -s  include subdirectories'
  Say '       -q  do not print progress messages'
  Say
  Say '       -l  translate to lower case (default)'
  Say '       -u  translate to upper case instead'
  Say '       -f  translate first letter to upper case'
  Say
  Say '       -x  only deal with directory names'
  Say
  Say 'Options can be intermixed with arguments.'
  Exit
End

option = ''
type = 'L'
echo = 'V'
selection = 'O'

Do i=1 To Words(args)

  opt = Word(args, i)

  Select
    When Left(opt, 2) = '-Q' | Left(opt, 2) = '/Q' Then
      echo = 'Q'
    When Left(opt, 2) = '-S' | Left(opt, 2) = '/S' Then
      option = 'S'
    When Left(opt, 2) = '-L' | Left(opt, 2) = '/L' Then
      type = 'L'
    When Left(opt, 2) = '-U' | Left(opt, 2) = '/U' Then
      type = 'U'
    When Left(opt, 2) = '-F' | Left(opt, 2) = '/F' Then
      type = 'F'
    When Left(opt, 2) = '-X' | Left(opt, 2) = '/X' Then
      selection = 'DO'
    Otherwise
      Call dirs opt, option, type, echo, selection
  End

End

Exit

dirs: Procedure 
  Arg pattern, option, type, echo, selection

  Call files pattern, type, selection
  
  If option = 'S' Then Do

    Call SysFileTree '*', 'dir', 'DO'option
  
    Do i=1 To dir.0
      
      If echo = 'V' Then
	Say 'Processing: 'dir.i
    
      If option = 'S' then
	Call files dir.i'\'pattern, type, selection

    End 
    
  End 

Return

files: Procedure
  Arg pattern, type, selection
  
  Call SysFileTree pattern, 'file', selection
    
  Do i=1 To file.0
    
    base = FileSpec('Name', file.i);
    
    Select
      When type = 'L' Then
	new = Translate(base, XRange('a', 'z'), XRange('A', 'Z'))
      When type = 'U' Then
	new = Translate(base)
      When type = 'F' Then
	new = Insert(Translate(Left(base, 1)),,
                     Translate(Right(base, Length(Base)-1),,
	                       XRange('a', 'z'), XRange('A', 'Z')))
    End

    If new \= base Then
      '@rename "'file.i'" "'new'"' 
  
  End

Return

/* end of lower.cmd */
