
import NET.ibm.malamut.transformator.*;
/**
 * This class provides a command line interface to run Kroni's Codepage Transformator
 * 
 */
class Run {

/**
 * Main entry point for the command line Interface
 * @param args java.lang.String[] command line parameters
 */
public static void main(String args[]) {

	String inputFile = null;
	String outputFile = null;
	String inputEncoding = null;
	String outputEncoding = null;

	switch (args.length) {
		case 4:  if (!args[3].equals("-")) outputFile = args[3];
		case 3:  if (!args[2].equals("-")) outputEncoding = args[2];
		case 2:  if (!args[1].equals("-")) inputFile = args[1];
		case 1:  if (args[0].equals("?") || args[0].equals("-?")) usage();
		         if (!args[0].equals("-")) inputEncoding = args[0];
		case 0:  break;
		default: usage();
	}	

	Transformator t = new Transformator ();	
	try {
		t.read (inputFile, inputEncoding);
		t.write (outputFile, outputEncoding);
	} catch (Exception e) {
		System.err.println ("\nException occurred:");
		System.err.println (e.getMessage());
		e.printStackTrace ();
		System.exit (1);
	}	
	
	System.exit (0);
}
/**
 * Prints as message on how to use to command line interface
 */
public static void usage () {
	System.out.println ();
	System.out.println ("usage: java Run [inCode] [inFile] [outCode] [outFile]");
	System.out.println ("usage: java Shell [inCode] [inFile] [outCode] [outFile]");
	System.out.println ("  where: inCode  = character encoding for input");
	System.out.println ("         inFile  = input file name");
	System.out.println ("         outCode = character encoding for output");
	System.out.println ("         outFile = output file name");
	System.out.println ("  defaults are the current platform's default encoding");
	System.out.println ("    for inCode/outCode and stdin/stdout for inFile/outFile");
	System.out.println ("  the minus sign (-) on any argument activates the default");
	System.out.println ("    for the corresponding argument");
	System.out.println ("  examples for character encoding:");
	System.out.println ("    iso-8859-1   (Latin-1)");
	System.out.println ("    Cp1250       (IBM Codepage 1250 = Windows East Europe)");
	System.out.println ("  some encodings are not available on all platforms");
	System.out.println ();
	System.exit(0);
}
}