
package NET.ibm.malamut.transformator.ui;

import java.awt.*;
/**
 * A panel which contains lines of text.
 * 
 */
public class TextPanel extends Panel {
	GridBagLayout gl = new GridBagLayout();
	GridBagConstraints gc = new GridBagConstraints();
	int line = 0;
	final int TABSIZE = 8;

/**
 * The only constructor.
 */
public TextPanel() {
	super();
	gc.anchor = GridBagConstraints.WEST;
	setLayout (gl);
}
/**
 * Adds a single line to the panel.
 * @param s java.lang.String
 */
public void addLine (String s) {

	StringBuffer sb = new StringBuffer ();
	int i;
	while ((i = s.indexOf ('\t')) >= 0) {
		if (i>0)
			sb.append (s.substring(0,i));
		for (int j=0; j<TABSIZE; j++)
			sb.append (' ');
		if (i<s.length())
			s = s.substring (i+1);
		else
			s = "";
	}	
	sb.append (s);
	Label l = new Label (sb.toString());
	gc.gridy = line++;
	gl.setConstraints (l, gc);
	add (l);
}
/**
 * Sets the panel's text.
 * @param s java.lang.String
 */
public void setText (String s) {
	removeAll ();
	int i;
	String nl = System.getProperty ("line.separator");
	try {
		while ((i = s.indexOf (nl)) >= 0) {
			addLine (s.substring(0,i));
			s = s.substring (i+nl.length());  // will throw exception if \n was last element
		}	
	} catch (IndexOutOfBoundsException e) {
		return;
	}
	addLine (s);	
}
}