
package NET.ibm.malamut.transformator.ui;

import java.awt.*;
import NET.ibm.malamut.transformator.*;
/**
 * This class creates the main window of Kroni's Codepage Transformator.
 * 
 */
public class ShellWindow extends Frame {
	String inputFile;
	String outputFile;
	String inputEncoding;
	String outputEncoding;
	
	CheckboxGroup cg1;
	Checkbox cb11;
	Checkbox cb12;
	TextField t1;
	Button b1;
	
	CheckboxGroup cg2;
	Checkbox cb21;
	Checkbox cb22;
	TextField t2;
	Button b2;
	
	CheckboxGroup cg3;
	Checkbox cb31;
	Checkbox cb32;
	TextField t3;
	Button b3;
	
	CheckboxGroup cg4;
	Checkbox cb41;
	Checkbox cb42;
	TextField t4;
	Button b4;

/**
 * The constructor that is actually used by the Shell class.
 * @param inputFile java.lang.String
 * @param outputFile java.lang.String
 * @param inputEncoding java.lang.String
 * @param outputEncoding java.lang.String
 */
public ShellWindow (String inputFile, String outputFile, String inputEncoding, String outputEncoding) {
	super ("Kroni's Codepage Transformator");
	this.inputFile = inputFile;
	this.outputFile = outputFile;
	this.inputEncoding = inputEncoding;
	this.outputEncoding = outputEncoding;

	GridBagLayout mg = new GridBagLayout ();	
	setLayout (mg);
	GridBagConstraints c = new GridBagConstraints ();
	GridBagConstraints c2 = new GridBagConstraints ();
	
	// Input file dialog part
	Panel p1 = new Panel ();
	GridBagLayout g1 = new GridBagLayout ();
	p1.setLayout (g1);

	//  label
	c.gridx = 0; c.gridy = 0; c.gridwidth = GridBagConstraints.REMAINDER; c.anchor = GridBagConstraints.WEST;
	Label l1 = new Label ("Input File");
	g1.setConstraints (l1, c);
	p1.add (l1);
	//  empty room lefthand	
	c.gridx = 0; c.gridy = 1; c.gridheight = GridBagConstraints.REMAINDER;
	c.gridwidth = 1; c.ipadx = 3;
	Panel pp1 = new Panel ();
	g1.setConstraints (pp1, c);
	p1.add (pp1);

	//  checkboxes
	cg1 = new CheckboxGroup ();
	if (inputFile == null) {
		cb11 = new Checkbox ("Standard Input", true, cg1);
		cb12 = new Checkbox ("Specified File:", false, cg1);
	} else {
		cb11 = new Checkbox ("Standard Input", false, cg1);
		cb12 = new Checkbox ("Specified File:", true, cg1);
	}				
	c.gridx = 1; c.gridheight = 1; c.ipadx = 0; c.gridwidth = GridBagConstraints.REMAINDER;
	g1.setConstraints (cb11, c);
	p1.add (cb11);
	c.gridy = 2; c.gridwidth = 1;
	g1.setConstraints (cb12, c);
	p1.add (cb12);

	//  file name text field
	if (inputFile == null)
		t1 = new TextField (30);
	else
		t1 = new TextField (inputFile, 30);
	c.gridx = 2;
	g1.setConstraints (t1, c);
	p1.add (t1);
	t1.addFocusListener (new CheckboxFocusGainer (cb12));
	//  file name choose button
	b1 = new Button ("Choose...");
	c.gridx = 3;
	g1.setConstraints (b1, c);
	p1.add (b1);
	b1.addActionListener (new ChooseFileNameListener (this, cb12, t1, true));
			
	//  empty room at bottom
	c.gridx = 0; c.gridy = 4; c.gridwidth = GridBagConstraints.REMAINDER;
	c.ipady = 3;
	pp1 = new Panel ();
	g1.setConstraints (pp1, c);
	p1.add (pp1);
	
	// add this part
	c2.anchor = GridBagConstraints.WEST;
	mg.setConstraints (p1, c2);
	add (p1);
	
	// Output file dialog part
	p1 = new Panel ();
	g1 = new GridBagLayout ();
	p1.setLayout (g1);

	//  label
	c.gridx = 0; c.gridy = 0; c.gridwidth = GridBagConstraints.REMAINDER; c.anchor = GridBagConstraints.WEST;
	l1 = new Label ("Output File");
	g1.setConstraints (l1, c);
	p1.add (l1);
	//  empty room lefthand	
	c.gridx = 0; c.gridy = 1; c.gridheight = GridBagConstraints.REMAINDER;
	c.gridwidth = 1; c.ipadx = 3;
	pp1 = new Panel ();
	g1.setConstraints (pp1, c);
	p1.add (pp1);

	//  checkboxes
	cg2 = new CheckboxGroup ();
	if (outputFile == null) {
		cb21 = new Checkbox ("Standard Output", true, cg2);
		cb22 = new Checkbox ("Specified File:", false, cg2);
	} else {	
		cb21 = new Checkbox ("Standard Output", false, cg2);
		cb22 = new Checkbox ("Specified File:", true, cg2);
	}	
	c.gridx = 1; c.gridheight = 1; c.ipadx = 0; c.gridwidth = GridBagConstraints.REMAINDER;
	g1.setConstraints (cb21, c);
	p1.add (cb21);
	c.gridy = 2; c.gridwidth = 1;
	g1.setConstraints (cb22, c);
	p1.add (cb22);

	//  file name text field
	if (outputFile == null)
		t2 = new TextField (30);
	else
		t2 = new TextField (outputFile, 30);
	c.gridx = 2;
	g1.setConstraints (t2, c);
	p1.add (t2);
	t2.addFocusListener (new CheckboxFocusGainer (cb22));
	//  file name choose button
	b2 = new Button ("Choose...");
	c.gridx = 3;
	g1.setConstraints (b2, c);
	p1.add (b2);
	b2.addActionListener (new ChooseFileNameListener (this, cb22, t2, false));
			
	//  empty room at bottom
	c.gridx = 0; c.gridy = 4; c.gridwidth = GridBagConstraints.REMAINDER;
	c.ipady = 3;
	pp1 = new Panel ();
	g1.setConstraints (pp1, c);
	p1.add (pp1);
	
	// add this part
	c2.gridy = 1;
	mg.setConstraints (p1, c2);
	add (p1);
	
	// Input encoding dialog part
	p1 = new Panel ();
	g1 = new GridBagLayout ();
	p1.setLayout (g1);

	//  label
	c.gridx = 0; c.gridy = 0; c.gridwidth = GridBagConstraints.REMAINDER; c.anchor = GridBagConstraints.WEST;
	l1 = new Label ("Input Encoding");
	g1.setConstraints (l1, c);
	p1.add (l1);
	//  empty room lefthand	
	c.gridx = 0; c.gridy = 1; c.gridheight = GridBagConstraints.REMAINDER;
	c.gridwidth = 1; c.ipadx = 3;
	pp1 = new Panel ();
	g1.setConstraints (pp1, c);
	p1.add (pp1);

	//  checkboxes
	cg3 = new CheckboxGroup ();
	if (inputEncoding == null) {
		cb31 = new Checkbox ("System Default: "+new java.io.InputStreamReader(System.in).getEncoding(), true, cg3);
		cb32 = new Checkbox ("Other:", false, cg3);
	} else {	
		cb31 = new Checkbox ("System Default: "+new java.io.InputStreamReader(System.in).getEncoding(), false, cg3);
		cb32 = new Checkbox ("Other:", true, cg3);
	}	
	c.gridx = 1; c.gridheight = 1; c.ipadx = 0; c.gridwidth = GridBagConstraints.REMAINDER;
	g1.setConstraints (cb31, c);
	p1.add (cb31);
	c.gridy = 2; c.gridwidth = 1;
	g1.setConstraints (cb32, c);
	p1.add (cb32);

	//  file name text field
	if (inputEncoding == null)
		t3 = new TextField (12);
	else
		t3 = new TextField (inputEncoding, 12);
	c.gridx = 2;
	g1.setConstraints (t3, c);
	p1.add (t3);
	t3.addFocusListener (new CheckboxFocusGainer (cb32));
	//  file name choose button
	b3 = new Button ("Choose...");
	c.gridx = 3;
	g1.setConstraints (b3, c);
	p1.add (b3);
	b3.addActionListener (new ChooseEncodingListener (cb32, t3));
			
	//  empty room at bottom
	c.gridx = 0; c.gridy = 4; c.gridwidth = GridBagConstraints.REMAINDER;
	c.ipady = 3;
	pp1 = new Panel ();
	g1.setConstraints (pp1, c);
	p1.add (pp1);
	
	// add this part
	c2.gridy = 2;
	mg.setConstraints (p1, c2);
	add (p1);
	
	// Output encoding dialog part
	p1 = new Panel ();
	g1 = new GridBagLayout ();
	p1.setLayout (g1);

	//  label
	c.gridx = 0; c.gridy = 0; c.gridwidth = GridBagConstraints.REMAINDER; c.anchor = GridBagConstraints.WEST;
	l1 = new Label ("Output Encoding");
	g1.setConstraints (l1, c);
	p1.add (l1);
	//  empty room lefthand	
	c.gridx = 0; c.gridy = 1; c.gridheight = GridBagConstraints.REMAINDER;
	c.gridwidth = 1; c.ipadx = 3;
	pp1 = new Panel ();
	g1.setConstraints (pp1, c);
	p1.add (pp1);

	//  checkboxes
	cg4 = new CheckboxGroup ();
	if (outputEncoding == null) {
		cb41 = new Checkbox ("System Default: "+new java.io.OutputStreamWriter(System.out).getEncoding(), true, cg4);
		cb42 = new Checkbox ("Other:", false, cg4);
	} else {	
		cb41 = new Checkbox ("System Default: "+new java.io.OutputStreamWriter(System.out).getEncoding(), false, cg4);
		cb42 = new Checkbox ("Other:", true, cg4);
	}	
	c.gridx = 1; c.gridheight = 1; c.ipadx = 0; c.gridwidth = GridBagConstraints.REMAINDER;
	g1.setConstraints (cb41, c);
	p1.add (cb41);
	c.gridy = 2; c.gridwidth = 1;
	g1.setConstraints (cb42, c);
	p1.add (cb42);

	//  file name text field
	if (outputEncoding == null)
		t4 = new TextField (12);
	else
		t4 = new TextField (outputEncoding, 12);
	c.gridx = 2;
	g1.setConstraints (t4, c);
	p1.add (t4);
	t4.addFocusListener (new CheckboxFocusGainer (cb42));
	//  file name choose button
	b4 = new Button ("Choose...");
	c.gridx = 3;
	g1.setConstraints (b4, c);
	p1.add (b4);
	b4.addActionListener (new ChooseEncodingListener (cb42, t4));
			
	//  empty room at bottom
	c.gridx = 0; c.gridy = 4; c.gridwidth = GridBagConstraints.REMAINDER;
	c.ipady = 3;
	pp1 = new Panel ();
	g1.setConstraints (pp1, c);
	p1.add (pp1);
	
	// add this part
	c2.gridy = 3;
	mg.setConstraints (p1, c2);
	add (p1);
	
	Panel b = new Panel ();
	b.setLayout (new FlowLayout ());
	Button bOk = new Button ("OK");
	b.add (bOk);
	bOk.addActionListener (new OkButtonListener(this));
	Button bQuit = new Button ("Quit");
	b.add (bQuit);
	bQuit.addActionListener (new QuitButtonListener());
	
	// add the buttons
	c2.gridy = 4;
	mg.setConstraints (b, c2);
	add (b);
	
	pack ();
	setSize (getPreferredSize ());
	
	addWindowListener (new ExitWindowAdapter());
	
	
}
/**
 * Here the actual transformation of the text file takes place.
 */
public void doTransformation () {
	
	if (cb11.getState())
		inputFile = null;
	else
		inputFile = t1.getText();
		
	if (cb21.getState())
		outputFile = null;
	else
		outputFile = t2.getText();
		
	if (cb31.getState())
		inputEncoding = null;
	else	
		inputEncoding = t3.getText();
		
	if (cb41.getState())
		outputEncoding = null;
	else	
		outputEncoding = t4.getText();
		
	Transformator t = new Transformator ();
	try {
		t.read (inputFile, inputEncoding);
		t.write (outputFile, outputEncoding);
	} catch (Exception e) {
		ErrorBox eb = new ErrorBox (e);
		eb.show ();
	}	
	
}
}