
package NET.ibm.malamut.transformator.ui;

import java.awt.*;
/**
 * A list which appears broader than usual when being packed.
 * 
 */
public class BroadList extends List {
	static final int MINWIDTH = 300;

/**
 * Forwarding constructor.
 */
public BroadList() {
	super();
}
/**
 * Forwarding constructor.
 * @param rows int
 */
public BroadList(int rows) {
	super(rows);
}
/**
 * Forwarding constructor.
 * @param rows int
 * @param multipleMode boolean
 */
public BroadList(int rows, boolean multipleMode) {
	super(rows, multipleMode);
}
/**
 * The preferred size is at least MINWIDTH.
 * @return Dimension
 */
public Dimension getPreferredSize () {
	Dimension d = super.getPreferredSize ();
	if (d.width<MINWIDTH)
		d.width = MINWIDTH;
	return d;
}
}