/* FILEJET Installation                           */
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs
say center('Ŀ', 79, ' ');
say center('         FILEJET Installation        ', 79, ' ');
say center('                                     ', 79, ' ');
say center('', 79, ' ');
say ''

CurDir = Directory()
parse SOURCE cmdd
cmdd = word(cmdd,3)
SrcDrv = left(cmdd, length(cmdd)-length('install.cmd')-1)

Dstdrv = 'C:'           /* default value */
SeachRep = 0

SeachAgain:
InnF=Srcdrv'\INSTALL.CMD'

if stream(InnF,'C','query exists') \= "" then signal FoundSrcDrv

SeachRep = SeachRep + 1

select
   when SeachRep=1 then do
        Srcdrv = CurDir
        signal SeachAgain
        end
   when SeachRep=2 then do
        DrvLetter = 'A'
        Srcdrv = DrvLetter':\'
        signal SeachAgain
        end
    otherwise nop
end

if DrvLetter \= 'Z' then do
    DrvLetter= D2C(C2D(DrvLetter)+1)
    Srcdrv = DrvLetter':\'
    signal SeachAgain
end

Srcdrv='A:'
signal NotFoundSrcDrv

FoundSrcDrv:

target_directory = 'C:\FILEJET'

signal StartInstall

/********************/
/* Ask the User     */
/********************/

askagain:
StartInstall:
RESUME:
say ' Sourcedrive              :' Srcdrv
say ' Target Path              :' target_directory
say ''
say ' Is this correct  ? (Y/N) : Y'
pull answer
if answer = 'N' then signal askdrives

source_drive = left(Srcdrv, 2)
drive_info = SysDriveInfo(source_drive)
parse var drive_info . . . label
/* if label \= 'FILEJET' then */
    do
       stream_name = stream(source_drive||'FJ2.EXE', 'c', 'query exists')
       if stream_name = '' then
       do
          say 'Error, wrong installation directory';
          exit
        end
    end
say ''
new_directory = directory(target_directory);
if new_directory \= target_directory then
    do
       say ''
       say '.. creating directory ' target_directory
       rc = SysMkDir(target_directory);
       if rc \= 0 then
           do
              if rc \= 5 then
               do
                say 'Abort, error creating directory ' target_directory rc
                exit
               end
              else
               do
                say 'Error creating directory ' target_directory
               end
           end
       else
        do
          say 'Directory ' target_directory ' created';
        end
       new_directory = directory(target_directory);
       new_directory = translate(new_directory);
       target_directory = translate(target_directory);
    end
if new_directory = target_directory then
   do
       say '.. Copying FILEJET-files  to  ' target_directory '...';
       '@ECHO OFF'
       'COPY ' Srcdrv'\FEATURES.DOC' target_directory '1>NUL 2>&1'
       'COPY ' Srcdrv'\FILE_ID.DIZ' target_directory '1>NUL 2>&1'
       'COPY ' Srcdrv'\FILEJET.*' target_directory '1>NUL 2>&1'
       'COPY ' Srcdrv'\FJ*.*' target_directory '1>NUL 2>&1'
       'COPY ' Srcdrv'\FJ.*' target_directory '1>NUL 2>&1'
       'COPY ' Srcdrv'\INSTALL.CMD' target_directory '1>NUL 2>&1'
       'COPY ' Srcdrv'\PACKING.LST' target_directory '1>NUL 2>&1'
       'COPY ' Srcdrv'\README' target_directory '1>NUL 2>&1'
       'COPY ' Srcdrv'\REGISTER.DOC' target_directory '1>NUL 2>&1'
       'COPY ' Srcdrv'\WARRANTY.DOC' target_directory '1>NUL 2>&1'
       '@ECHO ON'
   end
   else do
           say 'Error copying files to  ' target_directory
           exit
    end
say '.. Creating FILEJET Objekt  '
location = '<WP_DESKTOP>'
title    = 'FILEJET_733'
class    = 'WPProgram'
progtype = 'PROGTYPE=PM;'
exename  = 'EXENAME='||target_directory||'\FJ2.EXE;'
workdir  = 'WORKDIR='||target_directory||';'
objectid = '<FILEJET>;'
open     = 'OPEN=DEFAULT;'
setup    = exename||workdir||objectid||open
rc = SysCreateObject(class, title, location, setup, 'R')
if rc \= 1 then
    do
       say 'Error creating FILEJET object ';
       exit
    end

/********************************************************************/
/* Seach for OS2 system path in PATH environement                   */
/********************************************************************/

Path = value('PATH',,'OS2ENVIRONMENT')
if Path = '' then signal ENDSEARCH

ntmp = pos(':\OS2;', Path)
if ntmp = 0 then signal ENDSEARCH

Dstdrv=substr(Path, ntmp-1,2)

/*****************************************************************************/
/*                 Checking the default values                               */
/*****************************************************************************/
                                               /* checking source      */
if stream(Srcdrv'\FJ2.EXE', 'C', 'query exists') = "" then signal RESUME

NewDir=directory(Dstdrv'\')

InnF=Dstdrv'\CONFIG.FJ'
OutF=Dstdrv'\CONFIG.SYS'
stmp = 'SET FILEJET='target_directory

say '.. Copying ' OutF  ' to ' InnF
'@ECHO OFF'
'copy 'OutF' 'InnF' >nul'
'del 'OutF
'@ECHO ON'

found = 0

say '.. Working  ' OutF 'aktualize ' stmp
do until lines(InnF) = 0
    InStr = linein(InnF)
    if pos('SET FILEJET=', InStr) > 0   then  do
        found = 1
     call lineout OutF, stmp
    end
    else do
     call lineout OutF, InStr
    end
end
if found = 0 then do
     call lineout OutF, stmp
end

call stream OutF, 'c', 'close'
call stream InnF, 'c', 'close'

signal endinst

askdrives:
/************/
do forever
   rc=CharOut(,"Enter Sourcedrive  (f.ex. A): ");
   input = '';
   Do While (Pos('0A'x, input)=0);
      input=input||CharIn(,,1);
   End;
   input = c2x(input)
   input = delstr(input, (length(input)-3))
   input = x2c(input)
   Drvletter = input
   if Drvletter \= '' then leave
end
  Srcdrv = Drvletter':'

do forever
   rc=CharOut(,"Enter the complete destination path (f.ex.: C:\FILEJET ): ");
   input = '';
   Do While (Pos('0A'x, input)=0);
      input=input||CharIn(,,1);
   End;
   input = c2x(input)
   input = delstr(input, (length(input)-3))
   input = x2c(input)
   target_directory = input
   if target_directory \= '' then leave
end

signal askagain


endinst:
exit

