######################################################################
#
#  FILSPLIT v1.0 - Yet another file splitter/unsplitter
#
#  Module   : FILSPLIT.MK
#  Info     : Watcom Makefile
#  Author   : Bernd Giesen
#  Compiler : Watcom C/C++ v10.6
#
#  Copyright (c) 1999 Bernd Giesen. All rights reserved.
#
#
######################################################################
#
#  History:
#
#  281199 - Created
#  111299 - Fix in DOS_CC_OPTS
#  121299 - 'clean' target improved
#
######################################################################

PROG=filsplt
PROGOBJ=filsplit

DOAUTOBUILDCOUNT=1

.EXTENSIONS:
.EXTENSIONS: .obj .obn .obo .c

!ifeq DOAUTOBUILDCOUNT 1
!ifdef __OS2__
AUTOBUILDCNT=obuildct.exe
!else ifdef __NT__
AUTOBUILDCNT=nbuildct.exe
!else ifdef __MSDOS__
AUTOBUILDCNT=dbuildct.exe
!endif

.AFTER
    $(AUTOBUILDCNT) $^:buildcnt.h
!endif

# ----- Usage --------------------------------------------------------------

usage: .SYMBOLIC
        @echo ...........
        @echo ...........
        @echo To generate the targets for specific environments type:
        @echo wmake -f filsplit.mak dos
        @echo wmake -f filsplit.mak winnt
        @echo wmake -f filsplit.mak os2
        @echo wmake -f filsplit.mak all (make all targets)
        @echo ...........
        @echo ...........

# ----- Windows NT (and WIN32s) compiler options ----------------------------

WNT_CC=wcc386
WNT_LINK=wlink

!ifdef DEBUG
WNT_CC_OPTS=/bt=nt /d2 /zq /od /w4 /i=$(%WATCOM)\H;$(%WATCOM)\H\NT
WNT_LINK_OPTS=d ALL SYS nt libpath .;$(%WATCOM)\LIB386;$(%WATCOM)\LIB386\NT
!else
WNT_CC_OPTS=/bt=nt /zq /otexan /i=$(%WATCOM)\H;$(%WATCOM)\H\NT
WNT_LINK_OPTS=SYS nt libpath .;$(%WATCOM)\LIB386;$(%WATCOM)\LIB386\NT
!endif

.c.obn: .AUTODEPEND
        $(WNT_CC) $(WNT_CC_OPTS) -fo=$[*.obn $<

# ----- OS/2 compiler options -----------------------------------------------

OS2_CC=wcc386
OS2_LINK=wlink

!ifdef DEBUG
OS2_CC_OPTS=/bt=OS2 /d2 /zq /od /w4 /i=$(%WATCOM)\H;$(%WATCOM)\H\OS2
OS2_LINK_OPTS=d ALL SYSTEM os2v2 libpath .;$(%WATCOM)\LIB386;$(%WATCOM)\LIB386\OS2
!else
OS2_CC_OPTS=/bt=OS2 /zq /otexan /i=$(%WATCOM)\H;$(%WATCOM)\H\OS2
OS2_LINK_OPTS=SYSTEM os2v2 libpath .;$(%WATCOM)\LIB386;$(%WATCOM)\LIB386\OS2
!endif

.c.obo: .AUTODEPEND
        $(OS2_CC) $(OS2_CC_OPTS) -fo=$[*.obo $<

# ----- OS/2 compiler options -----------------------------------------------

DOS_CC=wcc
DOS_LINK=wlink

!ifdef DEBUG
DOS_CC_OPTS=/bt=DOS /d2 /zq /ms /od /w4 /i=$(%WATCOM)\H
DOS_LINK_OPTS=d ALL SYSTEM dos libpath .;$(%WATCOM)\LIB286;$(%WATCOM)\LIB286\DOS
!else
DOS_CC_OPTS=/bt=DOS /zq /ms /otexan /i=$(%WATCOM)\H
DOS_LINK_OPTS=SYSTEM dos libpath .;$(%WATCOM)\LIB286;$(%WATCOM)\LIB286\DOS
!endif

.c.obj: .AUTODEPEND
        $(DOS_CC) $(DOS_CC_OPTS) -fo=$[*.obj $<

# ----- Windows NT (and WIN32s) ---------------------------------------------

winnt: n$(PROG).exe .SYMBOLIC

n$(PROG).exe: $(PROGOBJ).obn
  $(WNT_LINK) $(WNT_LINK_OPTS) N n$(PROG) F $(PROGOBJ).obn $(WNT_OBJS)

# ----- OS/2 ----------------------------------------------------------------

os2: o$(PROG).exe .SYMBOLIC

o$(PROG).exe: $(PROGOBJ).obo
  $(OS2_LINK) $(OS2_LINK_OPTS) N o$(PROG).exe F $(PROGOBJ).obo $(OS2_OBJS)

# ----- DOS -----------------------------------------------------------------

dos: d$(PROG).exe .SYMBOLIC

d$(PROG).exe: $(PROGOBJ).obj
  $(DOS_LINK) $(DOS_LINK_OPTS) N d$(PROG).exe F $(PROGOBJ).obj $(DOS_OBJS)

# ----- Clean ---------------------------------------------------------------

clean: .SYMBOLIC
  @if exist $(PROGOBJ).ob? @del $(PROGOBJ).ob?
  @if exist ?$(PROG).exe @del ?$(PROG).exe

# ----- All targets ---------------------------------------------------------

all: o$(PROG).exe n$(PROG).exe d$(PROG).exe .SYMBOLIC

