/**********************************************************************
 *
 *  FILSPLIT v1.0 - Yet another file splitter/unsplitter
 *
 *  Module   : FILSPLIT.H
 *  Info     : Main module (Header)
 *  Author   : Bernd Giesen
 *  Compiler : Watcom C/C++ v10.6
 *             Gnu C/C++ v2.7.2.3 (Linux)
 *
 *  Copyright (c) 1999 Bernd Giesen. All rights reserved.
 *
 **********************************************************************
 *
 *  History:
 *
 *  271199 - Created
 *  041299 - adapted to run under Linux
 *  121299 - MAX_PATH_LEN introduced
 *  131299 - v1.04: version number changed
 *
 **********************************************************************/

#if !defined _FILESPLIT_H
#define _FILESPLIT_H

#if defined __OS2__

  #define INCL_DOSPROCESS
  #include <os2.h>
  #define OS_VER  "OS/2"
  #define bool BOOL

#elif defined __NT__

  #include <windows.h>
  #define OS_VER  "Win9x/NT"
  #define bool BOOL

#elif defined __linux__

  #define __LINUX__
  #define stricmp strcasecmp
  #define strnicmp strncasecmp
  #define strcmpi strcasecmp
  #define strncmpi strncasecmp
  #define OS_VER  "Linux"
  #include <termios.h>
  #include <unistd.h>
  typedef unsigned int bool;
#else

  #define __DOS__
  #define OS_VER  "DOS"
  typedef unsigned int bool;

  #if defined __WATCOMC__
    #include <i86.h>
  #else
    #include <dos.h>
  #endif

#endif

#define MAX_PATH_LEN  260

#if !defined false
  #define false 0
#endif

#if !defined true
  #define true  !false
#endif

#define VERSION "v1.04"
#endif /* _FILESPLIT_H */







